# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._container_registry_management_client_enums import *


class Actor(msrest.serialization.Model):
    """The agent that initiated the event. For most situations, this could be from the authorization context of the request.

    :ivar name: The subject or username associated with the request context that generated the
     event.
    :vartype name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The subject or username associated with the request context that generated the
         event.
        :paramtype name: str
        """
        super(Actor, self).__init__(**kwargs)
        self.name = name


class CallbackConfig(msrest.serialization.Model):
    """The configuration of service URI and custom headers for the webhook.

    All required parameters must be populated in order to send to Azure.

    :ivar service_uri: Required. The service URI for the webhook to post notifications.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    """

    _validation = {
        'service_uri': {'required': True},
    }

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'customHeaders', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        service_uri: str,
        custom_headers: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword service_uri: Required. The service URI for the webhook to post notifications.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        """
        super(CallbackConfig, self).__init__(**kwargs)
        self.service_uri = service_uri
        self.custom_headers = custom_headers


class EventInfo(msrest.serialization.Model):
    """The basic information of an event.

    :ivar id: The event ID.
    :vartype id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The event ID.
        :paramtype id: str
        """
        super(EventInfo, self).__init__(**kwargs)
        self.id = id


class Event(EventInfo):
    """The event for a webhook.

    :ivar id: The event ID.
    :vartype id: str
    :ivar event_request_message: The event request message sent to the service URI.
    :vartype event_request_message:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventRequestMessage
    :ivar event_response_message: The event response message received from the service URI.
    :vartype event_response_message:
     ~azure.mgmt.containerregistry.v2019_05_01.models.EventResponseMessage
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'event_request_message': {'key': 'eventRequestMessage', 'type': 'EventRequestMessage'},
        'event_response_message': {'key': 'eventResponseMessage', 'type': 'EventResponseMessage'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        event_request_message: Optional["EventRequestMessage"] = None,
        event_response_message: Optional["EventResponseMessage"] = None,
        **kwargs
    ):
        """
        :keyword id: The event ID.
        :paramtype id: str
        :keyword event_request_message: The event request message sent to the service URI.
        :paramtype event_request_message:
         ~azure.mgmt.containerregistry.v2019_05_01.models.EventRequestMessage
        :keyword event_response_message: The event response message received from the service URI.
        :paramtype event_response_message:
         ~azure.mgmt.containerregistry.v2019_05_01.models.EventResponseMessage
        """
        super(Event, self).__init__(id=id, **kwargs)
        self.event_request_message = event_request_message
        self.event_response_message = event_response_message


class EventContent(msrest.serialization.Model):
    """The content of the event request message.

    :ivar id: The event ID.
    :vartype id: str
    :ivar timestamp: The time at which the event occurred.
    :vartype timestamp: ~datetime.datetime
    :ivar action: The action that encompasses the provided event.
    :vartype action: str
    :ivar target: The target of the event.
    :vartype target: ~azure.mgmt.containerregistry.v2019_05_01.models.Target
    :ivar request: The request that generated the event.
    :vartype request: ~azure.mgmt.containerregistry.v2019_05_01.models.Request
    :ivar actor: The agent that initiated the event. For most situations, this could be from the
     authorization context of the request.
    :vartype actor: ~azure.mgmt.containerregistry.v2019_05_01.models.Actor
    :ivar source: The registry node that generated the event. Put differently, while the actor
     initiates the event, the source generates it.
    :vartype source: ~azure.mgmt.containerregistry.v2019_05_01.models.Source
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'action': {'key': 'action', 'type': 'str'},
        'target': {'key': 'target', 'type': 'Target'},
        'request': {'key': 'request', 'type': 'Request'},
        'actor': {'key': 'actor', 'type': 'Actor'},
        'source': {'key': 'source', 'type': 'Source'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        timestamp: Optional[datetime.datetime] = None,
        action: Optional[str] = None,
        target: Optional["Target"] = None,
        request: Optional["Request"] = None,
        actor: Optional["Actor"] = None,
        source: Optional["Source"] = None,
        **kwargs
    ):
        """
        :keyword id: The event ID.
        :paramtype id: str
        :keyword timestamp: The time at which the event occurred.
        :paramtype timestamp: ~datetime.datetime
        :keyword action: The action that encompasses the provided event.
        :paramtype action: str
        :keyword target: The target of the event.
        :paramtype target: ~azure.mgmt.containerregistry.v2019_05_01.models.Target
        :keyword request: The request that generated the event.
        :paramtype request: ~azure.mgmt.containerregistry.v2019_05_01.models.Request
        :keyword actor: The agent that initiated the event. For most situations, this could be from the
         authorization context of the request.
        :paramtype actor: ~azure.mgmt.containerregistry.v2019_05_01.models.Actor
        :keyword source: The registry node that generated the event. Put differently, while the actor
         initiates the event, the source generates it.
        :paramtype source: ~azure.mgmt.containerregistry.v2019_05_01.models.Source
        """
        super(EventContent, self).__init__(**kwargs)
        self.id = id
        self.timestamp = timestamp
        self.action = action
        self.target = target
        self.request = request
        self.actor = actor
        self.source = source


class EventListResult(msrest.serialization.Model):
    """The result of a request to list events for a webhook.

    :ivar value: The list of events. Since this list may be incomplete, the nextLink field should
     be used to request the next list of events.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Event]
    :ivar next_link: The URI that can be used to request the next list of events.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Event]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Event"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of events. Since this list may be incomplete, the nextLink field
         should be used to request the next list of events.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Event]
        :keyword next_link: The URI that can be used to request the next list of events.
        :paramtype next_link: str
        """
        super(EventListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventRequestMessage(msrest.serialization.Model):
    """The event request message sent to the service URI.

    :ivar content: The content of the event request message.
    :vartype content: ~azure.mgmt.containerregistry.v2019_05_01.models.EventContent
    :ivar headers: The headers of the event request message.
    :vartype headers: dict[str, str]
    :ivar method: The HTTP method used to send the event request message.
    :vartype method: str
    :ivar request_uri: The URI used to send the event request message.
    :vartype request_uri: str
    :ivar version: The HTTP message version.
    :vartype version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'EventContent'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'method': {'key': 'method', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content: Optional["EventContent"] = None,
        headers: Optional[Dict[str, str]] = None,
        method: Optional[str] = None,
        request_uri: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword content: The content of the event request message.
        :paramtype content: ~azure.mgmt.containerregistry.v2019_05_01.models.EventContent
        :keyword headers: The headers of the event request message.
        :paramtype headers: dict[str, str]
        :keyword method: The HTTP method used to send the event request message.
        :paramtype method: str
        :keyword request_uri: The URI used to send the event request message.
        :paramtype request_uri: str
        :keyword version: The HTTP message version.
        :paramtype version: str
        """
        super(EventRequestMessage, self).__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.method = method
        self.request_uri = request_uri
        self.version = version


class EventResponseMessage(msrest.serialization.Model):
    """The event response message received from the service URI.

    :ivar content: The content of the event response message.
    :vartype content: str
    :ivar headers: The headers of the event response message.
    :vartype headers: dict[str, str]
    :ivar reason_phrase: The reason phrase of the event response message.
    :vartype reason_phrase: str
    :ivar status_code: The status code of the event response message.
    :vartype status_code: str
    :ivar version: The HTTP message version.
    :vartype version: str
    """

    _attribute_map = {
        'content': {'key': 'content', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{str}'},
        'reason_phrase': {'key': 'reasonPhrase', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        content: Optional[str] = None,
        headers: Optional[Dict[str, str]] = None,
        reason_phrase: Optional[str] = None,
        status_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword content: The content of the event response message.
        :paramtype content: str
        :keyword headers: The headers of the event response message.
        :paramtype headers: dict[str, str]
        :keyword reason_phrase: The reason phrase of the event response message.
        :paramtype reason_phrase: str
        :keyword status_code: The status code of the event response message.
        :paramtype status_code: str
        :keyword version: The HTTP message version.
        :paramtype version: str
        """
        super(EventResponseMessage, self).__init__(**kwargs)
        self.content = content
        self.headers = headers
        self.reason_phrase = reason_phrase
        self.status_code = status_code
        self.version = version


class ImportImageParameters(msrest.serialization.Model):
    """ImportImageParameters.

    All required parameters must be populated in order to send to Azure.

    :ivar source: Required. The source of the image.
    :vartype source: ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSource
    :ivar target_tags: List of strings of the form repo[:tag]. When tag is omitted the source will
     be used (or 'latest' if source tag is also omitted).
    :vartype target_tags: list[str]
    :ivar untagged_target_repositories: List of strings of repository names to do a manifest only
     copy. No tag will be created.
    :vartype untagged_target_repositories: list[str]
    :ivar mode: When Force, any existing target tags will be overwritten. When NoForce, any
     existing target tags will fail the operation before any copying begins. Possible values
     include: "NoForce", "Force". Default value: "NoForce".
    :vartype mode: str or ~azure.mgmt.containerregistry.v2019_05_01.models.ImportMode
    """

    _validation = {
        'source': {'required': True},
    }

    _attribute_map = {
        'source': {'key': 'source', 'type': 'ImportSource'},
        'target_tags': {'key': 'targetTags', 'type': '[str]'},
        'untagged_target_repositories': {'key': 'untaggedTargetRepositories', 'type': '[str]'},
        'mode': {'key': 'mode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source: "ImportSource",
        target_tags: Optional[List[str]] = None,
        untagged_target_repositories: Optional[List[str]] = None,
        mode: Optional[Union[str, "ImportMode"]] = "NoForce",
        **kwargs
    ):
        """
        :keyword source: Required. The source of the image.
        :paramtype source: ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSource
        :keyword target_tags: List of strings of the form repo[:tag]. When tag is omitted the source
         will be used (or 'latest' if source tag is also omitted).
        :paramtype target_tags: list[str]
        :keyword untagged_target_repositories: List of strings of repository names to do a manifest
         only copy. No tag will be created.
        :paramtype untagged_target_repositories: list[str]
        :keyword mode: When Force, any existing target tags will be overwritten. When NoForce, any
         existing target tags will fail the operation before any copying begins. Possible values
         include: "NoForce", "Force". Default value: "NoForce".
        :paramtype mode: str or ~azure.mgmt.containerregistry.v2019_05_01.models.ImportMode
        """
        super(ImportImageParameters, self).__init__(**kwargs)
        self.source = source
        self.target_tags = target_tags
        self.untagged_target_repositories = untagged_target_repositories
        self.mode = mode


class ImportSource(msrest.serialization.Model):
    """ImportSource.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_id: The resource identifier of the source Azure Container Registry.
    :vartype resource_id: str
    :ivar registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
    :vartype registry_uri: str
    :ivar credentials: Credentials used when importing from a registry uri.
    :vartype credentials: ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSourceCredentials
    :ivar source_image: Required. Repository name of the source image.
     Specify an image by repository ('hello-world'). This will use the 'latest' tag.
     Specify an image by tag ('hello-world:latest').
     Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
    :vartype source_image: str
    """

    _validation = {
        'source_image': {'required': True},
    }

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'registry_uri': {'key': 'registryUri', 'type': 'str'},
        'credentials': {'key': 'credentials', 'type': 'ImportSourceCredentials'},
        'source_image': {'key': 'sourceImage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_image: str,
        resource_id: Optional[str] = None,
        registry_uri: Optional[str] = None,
        credentials: Optional["ImportSourceCredentials"] = None,
        **kwargs
    ):
        """
        :keyword resource_id: The resource identifier of the source Azure Container Registry.
        :paramtype resource_id: str
        :keyword registry_uri: The address of the source registry (e.g. 'mcr.microsoft.com').
        :paramtype registry_uri: str
        :keyword credentials: Credentials used when importing from a registry uri.
        :paramtype credentials:
         ~azure.mgmt.containerregistry.v2019_05_01.models.ImportSourceCredentials
        :keyword source_image: Required. Repository name of the source image.
         Specify an image by repository ('hello-world'). This will use the 'latest' tag.
         Specify an image by tag ('hello-world:latest').
         Specify an image by sha256-based manifest digest ('hello-world@sha256:abc123').
        :paramtype source_image: str
        """
        super(ImportSource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.registry_uri = registry_uri
        self.credentials = credentials
        self.source_image = source_image


class ImportSourceCredentials(msrest.serialization.Model):
    """ImportSourceCredentials.

    All required parameters must be populated in order to send to Azure.

    :ivar username: The username to authenticate with the source registry.
    :vartype username: str
    :ivar password: Required. The password used to authenticate with the source registry.
    :vartype password: str
    """

    _validation = {
        'password': {'required': True},
    }

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        password: str,
        username: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword username: The username to authenticate with the source registry.
        :paramtype username: str
        :keyword password: Required. The password used to authenticate with the source registry.
        :paramtype password: str
        """
        super(ImportSourceCredentials, self).__init__(**kwargs)
        self.username = username
        self.password = password


class IPRule(msrest.serialization.Model):
    """IP rule with specific IP or IP range in CIDR format.

    All required parameters must be populated in order to send to Azure.

    :ivar action: The action of IP ACL rule. Possible values include: "Allow".
    :vartype action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Action
    :ivar ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
     address is allowed.
    :vartype ip_address_or_range: str
    """

    _validation = {
        'ip_address_or_range': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'ip_address_or_range': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_address_or_range: str,
        action: Optional[Union[str, "Action"]] = None,
        **kwargs
    ):
        """
        :keyword action: The action of IP ACL rule. Possible values include: "Allow".
        :paramtype action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Action
        :keyword ip_address_or_range: Required. Specifies the IP or IP range in CIDR format. Only IPV4
         address is allowed.
        :paramtype ip_address_or_range: str
        """
        super(IPRule, self).__init__(**kwargs)
        self.action = action
        self.ip_address_or_range = ip_address_or_range


class NetworkRuleSet(msrest.serialization.Model):
    """The network rule set for a container registry.

    All required parameters must be populated in order to send to Azure.

    :ivar default_action: Required. The default action of allow or deny when no other rules match.
     Possible values include: "Allow", "Deny". Default value: "Allow".
    :vartype default_action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.DefaultAction
    :ivar virtual_network_rules: The virtual network rules.
    :vartype virtual_network_rules:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.VirtualNetworkRule]
    :ivar ip_rules: The IP ACL rules.
    :vartype ip_rules: list[~azure.mgmt.containerregistry.v2019_05_01.models.IPRule]
    """

    _validation = {
        'default_action': {'required': True},
    }

    _attribute_map = {
        'default_action': {'key': 'defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'virtualNetworkRules', 'type': '[VirtualNetworkRule]'},
        'ip_rules': {'key': 'ipRules', 'type': '[IPRule]'},
    }

    def __init__(
        self,
        *,
        default_action: Union[str, "DefaultAction"] = "Allow",
        virtual_network_rules: Optional[List["VirtualNetworkRule"]] = None,
        ip_rules: Optional[List["IPRule"]] = None,
        **kwargs
    ):
        """
        :keyword default_action: Required. The default action of allow or deny when no other rules
         match. Possible values include: "Allow", "Deny". Default value: "Allow".
        :paramtype default_action: str or
         ~azure.mgmt.containerregistry.v2019_05_01.models.DefaultAction
        :keyword virtual_network_rules: The virtual network rules.
        :paramtype virtual_network_rules:
         list[~azure.mgmt.containerregistry.v2019_05_01.models.VirtualNetworkRule]
        :keyword ip_rules: The IP ACL rules.
        :paramtype ip_rules: list[~azure.mgmt.containerregistry.v2019_05_01.models.IPRule]
        """
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.default_action = default_action
        self.virtual_network_rules = virtual_network_rules
        self.ip_rules = ip_rules


class OperationDefinition(msrest.serialization.Model):
    """The definition of a container registry operation.

    :ivar origin: The origin information of the container registry operation.
    :vartype origin: str
    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The display information for the container registry operation.
    :vartype display: ~azure.mgmt.containerregistry.v2019_05_01.models.OperationDisplayDefinition
    :ivar service_specification: The definition of Azure Monitoring service.
    :vartype service_specification:
     ~azure.mgmt.containerregistry.v2019_05_01.models.OperationServiceSpecificationDefinition
    """

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayDefinition'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'OperationServiceSpecificationDefinition'},
    }

    def __init__(
        self,
        *,
        origin: Optional[str] = None,
        name: Optional[str] = None,
        display: Optional["OperationDisplayDefinition"] = None,
        service_specification: Optional["OperationServiceSpecificationDefinition"] = None,
        **kwargs
    ):
        """
        :keyword origin: The origin information of the container registry operation.
        :paramtype origin: str
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The display information for the container registry operation.
        :paramtype display: ~azure.mgmt.containerregistry.v2019_05_01.models.OperationDisplayDefinition
        :keyword service_specification: The definition of Azure Monitoring service.
        :paramtype service_specification:
         ~azure.mgmt.containerregistry.v2019_05_01.models.OperationServiceSpecificationDefinition
        """
        super(OperationDefinition, self).__init__(**kwargs)
        self.origin = origin
        self.name = name
        self.display = display
        self.service_specification = service_specification


class OperationDisplayDefinition(msrest.serialization.Model):
    """The display information for a container registry operation.

    :ivar provider: The resource provider name: Microsoft.ContainerRegistry.
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword provider: The resource provider name: Microsoft.ContainerRegistry.
        :paramtype provider: str
        :keyword resource: The resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation that users can perform.
        :paramtype operation: str
        :keyword description: The description for the operation.
        :paramtype description: str
        """
        super(OperationDisplayDefinition, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(msrest.serialization.Model):
    """The result of a request to list container registry operations.

    :ivar value: The list of container registry operations. Since this list may be incomplete, the
     nextLink field should be used to request the next list of operations.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationDefinition]
    :ivar next_link: The URI that can be used to request the next list of container registry
     operations.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OperationDefinition]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["OperationDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of container registry operations. Since this list may be incomplete,
         the nextLink field should be used to request the next list of operations.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationDefinition]
        :keyword next_link: The URI that can be used to request the next list of container registry
         operations.
        :paramtype next_link: str
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationMetricSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring metric.

    :ivar name: Metric name.
    :vartype name: str
    :ivar display_name: Metric display name.
    :vartype display_name: str
    :ivar display_description: Metric description.
    :vartype display_description: str
    :ivar unit: Metric unit.
    :vartype unit: str
    :ivar aggregation_type: Metric aggregation type.
    :vartype aggregation_type: str
    :ivar internal_metric_name: Internal metric name.
    :vartype internal_metric_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        internal_metric_name: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Metric name.
        :paramtype name: str
        :keyword display_name: Metric display name.
        :paramtype display_name: str
        :keyword display_description: Metric description.
        :paramtype display_description: str
        :keyword unit: Metric unit.
        :paramtype unit: str
        :keyword aggregation_type: Metric aggregation type.
        :paramtype aggregation_type: str
        :keyword internal_metric_name: Internal metric name.
        :paramtype internal_metric_name: str
        """
        super(OperationMetricSpecificationDefinition, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.internal_metric_name = internal_metric_name


class OperationServiceSpecificationDefinition(msrest.serialization.Model):
    """The definition of Azure Monitoring list.

    :ivar metric_specifications: A list of Azure Monitoring metrics definition.
    :vartype metric_specifications:
     list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationMetricSpecificationDefinition]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationMetricSpecificationDefinition]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["OperationMetricSpecificationDefinition"]] = None,
        **kwargs
    ):
        """
        :keyword metric_specifications: A list of Azure Monitoring metrics definition.
        :paramtype metric_specifications:
         list[~azure.mgmt.containerregistry.v2019_05_01.models.OperationMetricSpecificationDefinition]
        """
        super(OperationServiceSpecificationDefinition, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Policies(msrest.serialization.Model):
    """The policies for a container registry.

    :ivar quarantine_policy: The quarantine policy for a container registry.
    :vartype quarantine_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.QuarantinePolicy
    :ivar trust_policy: The content trust policy for a container registry.
    :vartype trust_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicy
    :ivar retention_policy: The retention policy for a container registry.
    :vartype retention_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.RetentionPolicy
    """

    _attribute_map = {
        'quarantine_policy': {'key': 'quarantinePolicy', 'type': 'QuarantinePolicy'},
        'trust_policy': {'key': 'trustPolicy', 'type': 'TrustPolicy'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        *,
        quarantine_policy: Optional["QuarantinePolicy"] = None,
        trust_policy: Optional["TrustPolicy"] = None,
        retention_policy: Optional["RetentionPolicy"] = None,
        **kwargs
    ):
        """
        :keyword quarantine_policy: The quarantine policy for a container registry.
        :paramtype quarantine_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.QuarantinePolicy
        :keyword trust_policy: The content trust policy for a container registry.
        :paramtype trust_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicy
        :keyword retention_policy: The retention policy for a container registry.
        :paramtype retention_policy: ~azure.mgmt.containerregistry.v2019_05_01.models.RetentionPolicy
        """
        super(Policies, self).__init__(**kwargs)
        self.quarantine_policy = quarantine_policy
        self.trust_policy = trust_policy
        self.retention_policy = retention_policy


class QuarantinePolicy(msrest.serialization.Model):
    """The quarantine policy for a container registry.

    :ivar status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PolicyStatus"]] = None,
        **kwargs
    ):
        """
        :keyword status: The value that indicates whether the policy is enabled or not. Possible values
         include: "enabled", "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
        """
        super(QuarantinePolicy, self).__init__(**kwargs)
        self.status = status


class RegenerateCredentialParameters(msrest.serialization.Model):
    """The parameters used to regenerate the login credential.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Specifies name of the password which should be regenerated -- password or
     password2. Possible values include: "password", "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "PasswordName"],
        **kwargs
    ):
        """
        :keyword name: Required. Specifies name of the password which should be regenerated -- password
         or password2. Possible values include: "password", "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
        """
        super(RegenerateCredentialParameters, self).__init__(**kwargs)
        self.name = name


class Resource(msrest.serialization.Model):
    """An Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The location of the resource. This cannot be changed after the
         resource is created.
        :paramtype location: str
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class Registry(Resource):
    """An object that represents a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar sku: Required. The SKU of the container registry.
    :vartype sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
    :ivar login_server: The URL that can be used to log into the container registry.
    :vartype login_server: str
    :ivar creation_date: The creation date of the container registry in ISO8601 format.
    :vartype creation_date: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the container registry at the time the
     operation was called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded",
     "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar status: The status of the container registry at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2019_05_01.models.Status
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar storage_account: The properties of the storage account for the container registry. Only
     applicable to Classic SKU.
    :vartype storage_account:
     ~azure.mgmt.containerregistry.v2019_05_01.models.StorageAccountProperties
    :ivar network_rule_set: The network rule set for a container registry.
    :vartype network_rule_set: ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
    :ivar policies: The policies for a container registry.
    :vartype policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
        'login_server': {'readonly': True},
        'creation_date': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'login_server': {'key': 'properties.loginServer', 'type': 'str'},
        'creation_date': {'key': 'properties.creationDate', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccountProperties'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "Sku",
        tags: Optional[Dict[str, str]] = None,
        admin_user_enabled: Optional[bool] = False,
        storage_account: Optional["StorageAccountProperties"] = None,
        network_rule_set: Optional["NetworkRuleSet"] = None,
        policies: Optional["Policies"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The location of the resource. This cannot be changed after the
         resource is created.
        :paramtype location: str
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword sku: Required. The SKU of the container registry.
        :paramtype sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword storage_account: The properties of the storage account for the container registry.
         Only applicable to Classic SKU.
        :paramtype storage_account:
         ~azure.mgmt.containerregistry.v2019_05_01.models.StorageAccountProperties
        :keyword network_rule_set: The network rule set for a container registry.
        :paramtype network_rule_set: ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
        :keyword policies: The policies for a container registry.
        :paramtype policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
        """
        super(Registry, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.login_server = None
        self.creation_date = None
        self.provisioning_state = None
        self.status = None
        self.admin_user_enabled = admin_user_enabled
        self.storage_account = storage_account
        self.network_rule_set = network_rule_set
        self.policies = policies


class RegistryListCredentialsResult(msrest.serialization.Model):
    """The response from the ListCredentials operation.

    :ivar username: The username for a container registry.
    :vartype username: str
    :ivar passwords: The list of passwords for a container registry.
    :vartype passwords: list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryPassword]
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[RegistryPassword]'},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        passwords: Optional[List["RegistryPassword"]] = None,
        **kwargs
    ):
        """
        :keyword username: The username for a container registry.
        :paramtype username: str
        :keyword passwords: The list of passwords for a container registry.
        :paramtype passwords: list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryPassword]
        """
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.username = username
        self.passwords = passwords


class RegistryListResult(msrest.serialization.Model):
    """The result of a request to list container registries.

    :ivar value: The list of container registries. Since this list may be incomplete, the nextLink
     field should be used to request the next list of container registries.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Registry]
    :ivar next_link: The URI that can be used to request the next list of container registries.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Registry]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Registry"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of container registries. Since this list may be incomplete, the
         nextLink field should be used to request the next list of container registries.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Registry]
        :keyword next_link: The URI that can be used to request the next list of container registries.
        :paramtype next_link: str
        """
        super(RegistryListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RegistryNameCheckRequest(msrest.serialization.Model):
    """A request to check whether a container registry name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the container registry.
    :vartype name: str
    :ivar type: The resource type of the container registry. This field must be set to
     'Microsoft.ContainerRegistry/registries'. Has constant value:
     "Microsoft.ContainerRegistry/registries".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 5, 'pattern': r'^[a-zA-Z0-9]*$'},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.ContainerRegistry/registries"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the container registry.
        :paramtype name: str
        """
        super(RegistryNameCheckRequest, self).__init__(**kwargs)
        self.name = name


class RegistryNameStatus(msrest.serialization.Model):
    """The result of a request to check the availability of a container registry name.

    :ivar name_available: The value that indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: If any, the reason that the name is not available.
    :vartype reason: str
    :ivar message: If any, the error message that provides more detail for the reason that the name
     is not available.
    :vartype message: str
    """

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name_available: The value that indicates whether the name is available.
        :paramtype name_available: bool
        :keyword reason: If any, the reason that the name is not available.
        :paramtype reason: str
        :keyword message: If any, the error message that provides more detail for the reason that the
         name is not available.
        :paramtype message: str
        """
        super(RegistryNameStatus, self).__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class RegistryPassword(msrest.serialization.Model):
    """The login password for the container registry.

    :ivar name: The password name. Possible values include: "password", "password2".
    :vartype name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
    :ivar value: The password value.
    :vartype value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "PasswordName"]] = None,
        value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The password name. Possible values include: "password", "password2".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PasswordName
        :keyword value: The password value.
        :paramtype value: str
        """
        super(RegistryPassword, self).__init__(**kwargs)
        self.name = name
        self.value = value


class RegistryUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a container registry.

    :ivar tags: A set of tags. The tags for the container registry.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU of the container registry.
    :vartype sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
    :ivar admin_user_enabled: The value that indicates whether the admin user is enabled.
    :vartype admin_user_enabled: bool
    :ivar network_rule_set: The network rule set for a container registry.
    :vartype network_rule_set: ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
    :ivar policies: The policies for a container registry.
    :vartype policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'admin_user_enabled': {'key': 'properties.adminUserEnabled', 'type': 'bool'},
        'network_rule_set': {'key': 'properties.networkRuleSet', 'type': 'NetworkRuleSet'},
        'policies': {'key': 'properties.policies', 'type': 'Policies'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        admin_user_enabled: Optional[bool] = None,
        network_rule_set: Optional["NetworkRuleSet"] = None,
        policies: Optional["Policies"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The tags for the container registry.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU of the container registry.
        :paramtype sku: ~azure.mgmt.containerregistry.v2019_05_01.models.Sku
        :keyword admin_user_enabled: The value that indicates whether the admin user is enabled.
        :paramtype admin_user_enabled: bool
        :keyword network_rule_set: The network rule set for a container registry.
        :paramtype network_rule_set: ~azure.mgmt.containerregistry.v2019_05_01.models.NetworkRuleSet
        :keyword policies: The policies for a container registry.
        :paramtype policies: ~azure.mgmt.containerregistry.v2019_05_01.models.Policies
        """
        super(RegistryUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.admin_user_enabled = admin_user_enabled
        self.network_rule_set = network_rule_set
        self.policies = policies


class RegistryUsage(msrest.serialization.Model):
    """The quota usage for a container registry.

    :ivar name: The name of the usage.
    :vartype name: str
    :ivar limit: The limit of the usage.
    :vartype limit: long
    :ivar current_value: The current value of the usage.
    :vartype current_value: long
    :ivar unit: The unit of measurement. Possible values include: "Count", "Bytes".
    :vartype unit: str or ~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsageUnit
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        limit: Optional[int] = None,
        current_value: Optional[int] = None,
        unit: Optional[Union[str, "RegistryUsageUnit"]] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the usage.
        :paramtype name: str
        :keyword limit: The limit of the usage.
        :paramtype limit: long
        :keyword current_value: The current value of the usage.
        :paramtype current_value: long
        :keyword unit: The unit of measurement. Possible values include: "Count", "Bytes".
        :paramtype unit: str or ~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsageUnit
        """
        super(RegistryUsage, self).__init__(**kwargs)
        self.name = name
        self.limit = limit
        self.current_value = current_value
        self.unit = unit


class RegistryUsageListResult(msrest.serialization.Model):
    """The result of a request to get container registry quota usages.

    :ivar value: The list of container registry quota usages.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsage]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegistryUsage]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RegistryUsage"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of container registry quota usages.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.RegistryUsage]
        """
        super(RegistryUsageListResult, self).__init__(**kwargs)
        self.value = value


class Replication(Resource):
    """An object that represents a replication for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the replication at the time the operation
     was called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    :ivar status: The status of the replication at the time the operation was called.
    :vartype status: ~azure.mgmt.containerregistry.v2019_05_01.models.Status
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'Status'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The location of the resource. This cannot be changed after the
         resource is created.
        :paramtype location: str
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super(Replication, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.status = None


class ReplicationListResult(msrest.serialization.Model):
    """The result of a request to list replications for a container registry.

    :ivar value: The list of replications. Since this list may be incomplete, the nextLink field
     should be used to request the next list of replications.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Replication]
    :ivar next_link: The URI that can be used to request the next list of replications.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Replication]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Replication"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of replications. Since this list may be incomplete, the nextLink field
         should be used to request the next list of replications.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Replication]
        :keyword next_link: The URI that can be used to request the next list of replications.
        :paramtype next_link: str
        """
        super(ReplicationListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ReplicationUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a replication.

    :ivar tags: A set of tags. The tags for the replication.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The tags for the replication.
        :paramtype tags: dict[str, str]
        """
        super(ReplicationUpdateParameters, self).__init__(**kwargs)
        self.tags = tags


class Request(msrest.serialization.Model):
    """The request that generated the event.

    :ivar id: The ID of the request that initiated the event.
    :vartype id: str
    :ivar addr: The IP or hostname and possibly port of the client connection that initiated the
     event. This is the RemoteAddr from the standard http request.
    :vartype addr: str
    :ivar host: The externally accessible hostname of the registry instance, as specified by the
     http host header on incoming requests.
    :vartype host: str
    :ivar method: The request method that generated the event.
    :vartype method: str
    :ivar useragent: The user agent header of the request.
    :vartype useragent: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'addr': {'key': 'addr', 'type': 'str'},
        'host': {'key': 'host', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'useragent': {'key': 'useragent', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        addr: Optional[str] = None,
        host: Optional[str] = None,
        method: Optional[str] = None,
        useragent: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: The ID of the request that initiated the event.
        :paramtype id: str
        :keyword addr: The IP or hostname and possibly port of the client connection that initiated the
         event. This is the RemoteAddr from the standard http request.
        :paramtype addr: str
        :keyword host: The externally accessible hostname of the registry instance, as specified by the
         http host header on incoming requests.
        :paramtype host: str
        :keyword method: The request method that generated the event.
        :paramtype method: str
        :keyword useragent: The user agent header of the request.
        :paramtype useragent: str
        """
        super(Request, self).__init__(**kwargs)
        self.id = id
        self.addr = addr
        self.host = host
        self.method = method
        self.useragent = useragent


class RetentionPolicy(msrest.serialization.Model):
    """The retention policy for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar days: The number of days to retain an untagged manifest after which it gets purged.
    :vartype days: int
    :ivar last_updated_time: The timestamp when the policy was last updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _validation = {
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'days': {'key': 'days', 'type': 'int'},
        'last_updated_time': {'key': 'lastUpdatedTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        days: Optional[int] = 7,
        status: Optional[Union[str, "PolicyStatus"]] = None,
        **kwargs
    ):
        """
        :keyword days: The number of days to retain an untagged manifest after which it gets purged.
        :paramtype days: int
        :keyword status: The value that indicates whether the policy is enabled or not. Possible values
         include: "enabled", "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
        """
        super(RetentionPolicy, self).__init__(**kwargs)
        self.days = days
        self.last_updated_time = None
        self.status = status


class Sku(msrest.serialization.Model):
    """The SKU of a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The SKU name of the container registry. Required for registry creation.
     Possible values include: "Classic", "Basic", "Standard", "Premium".
    :vartype name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.SkuName
    :ivar tier: The SKU tier based on the SKU name. Possible values include: "Classic", "Basic",
     "Standard", "Premium".
    :vartype tier: str or ~azure.mgmt.containerregistry.v2019_05_01.models.SkuTier
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "SkuName"],
        **kwargs
    ):
        """
        :keyword name: Required. The SKU name of the container registry. Required for registry
         creation. Possible values include: "Classic", "Basic", "Standard", "Premium".
        :paramtype name: str or ~azure.mgmt.containerregistry.v2019_05_01.models.SkuName
        """
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class Source(msrest.serialization.Model):
    """The registry node that generated the event. Put differently, while the actor initiates the event, the source generates it.

    :ivar addr: The IP or hostname and the port of the registry node that generated the event.
     Generally, this will be resolved by os.Hostname() along with the running port.
    :vartype addr: str
    :ivar instance_id: The running instance of an application. Changes after each restart.
    :vartype instance_id: str
    """

    _attribute_map = {
        'addr': {'key': 'addr', 'type': 'str'},
        'instance_id': {'key': 'instanceID', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        addr: Optional[str] = None,
        instance_id: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword addr: The IP or hostname and the port of the registry node that generated the event.
         Generally, this will be resolved by os.Hostname() along with the running port.
        :paramtype addr: str
        :keyword instance_id: The running instance of an application. Changes after each restart.
        :paramtype instance_id: str
        """
        super(Source, self).__init__(**kwargs)
        self.addr = addr
        self.instance_id = instance_id


class Status(msrest.serialization.Model):
    """The status of an Azure resource at the time the operation was called.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar display_status: The short label for the status.
    :vartype display_status: str
    :ivar message: The detailed message for the status, including alerts and error messages.
    :vartype message: str
    :ivar timestamp: The timestamp when the status was changed to the current value.
    :vartype timestamp: ~datetime.datetime
    """

    _validation = {
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'timestamp': {'readonly': True},
    }

    _attribute_map = {
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Status, self).__init__(**kwargs)
        self.display_status = None
        self.message = None
        self.timestamp = None


class StorageAccountProperties(msrest.serialization.Model):
    """The properties of a storage account for a container registry. Only applicable to Classic SKU.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Required. The resource ID of the storage account.
    :vartype id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        **kwargs
    ):
        """
        :keyword id: Required. The resource ID of the storage account.
        :paramtype id: str
        """
        super(StorageAccountProperties, self).__init__(**kwargs)
        self.id = id


class Target(msrest.serialization.Model):
    """The target of the event.

    :ivar media_type: The MIME type of the referenced object.
    :vartype media_type: str
    :ivar size: The number of bytes of the content. Same as Length field.
    :vartype size: long
    :ivar digest: The digest of the content, as defined by the Registry V2 HTTP API Specification.
    :vartype digest: str
    :ivar length: The number of bytes of the content. Same as Size field.
    :vartype length: long
    :ivar repository: The repository name.
    :vartype repository: str
    :ivar url: The direct URL to the content.
    :vartype url: str
    :ivar tag: The tag name.
    :vartype tag: str
    :ivar name: The name of the artifact.
    :vartype name: str
    :ivar version: The version of the artifact.
    :vartype version: str
    """

    _attribute_map = {
        'media_type': {'key': 'mediaType', 'type': 'str'},
        'size': {'key': 'size', 'type': 'long'},
        'digest': {'key': 'digest', 'type': 'str'},
        'length': {'key': 'length', 'type': 'long'},
        'repository': {'key': 'repository', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        media_type: Optional[str] = None,
        size: Optional[int] = None,
        digest: Optional[str] = None,
        length: Optional[int] = None,
        repository: Optional[str] = None,
        url: Optional[str] = None,
        tag: Optional[str] = None,
        name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword media_type: The MIME type of the referenced object.
        :paramtype media_type: str
        :keyword size: The number of bytes of the content. Same as Length field.
        :paramtype size: long
        :keyword digest: The digest of the content, as defined by the Registry V2 HTTP API
         Specification.
        :paramtype digest: str
        :keyword length: The number of bytes of the content. Same as Size field.
        :paramtype length: long
        :keyword repository: The repository name.
        :paramtype repository: str
        :keyword url: The direct URL to the content.
        :paramtype url: str
        :keyword tag: The tag name.
        :paramtype tag: str
        :keyword name: The name of the artifact.
        :paramtype name: str
        :keyword version: The version of the artifact.
        :paramtype version: str
        """
        super(Target, self).__init__(**kwargs)
        self.media_type = media_type
        self.size = size
        self.digest = digest
        self.length = length
        self.repository = repository
        self.url = url
        self.tag = tag
        self.name = name
        self.version = version


class TrustPolicy(msrest.serialization.Model):
    """The content trust policy for a container registry.

    :ivar type: The type of trust policy. Possible values include: "Notary". Default value:
     "Notary".
    :vartype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicyType
    :ivar status: The value that indicates whether the policy is enabled or not. Possible values
     include: "enabled", "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "TrustPolicyType"]] = "Notary",
        status: Optional[Union[str, "PolicyStatus"]] = None,
        **kwargs
    ):
        """
        :keyword type: The type of trust policy. Possible values include: "Notary". Default value:
         "Notary".
        :paramtype type: str or ~azure.mgmt.containerregistry.v2019_05_01.models.TrustPolicyType
        :keyword status: The value that indicates whether the policy is enabled or not. Possible values
         include: "enabled", "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.PolicyStatus
        """
        super(TrustPolicy, self).__init__(**kwargs)
        self.type = type
        self.status = status


class VirtualNetworkRule(msrest.serialization.Model):
    """Virtual network rule.

    All required parameters must be populated in order to send to Azure.

    :ivar action: The action of virtual network rule. Possible values include: "Allow".
    :vartype action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Action
    :ivar virtual_network_resource_id: Required. Resource ID of a subnet, for example:
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
    :vartype virtual_network_resource_id: str
    """

    _validation = {
        'virtual_network_resource_id': {'required': True},
    }

    _attribute_map = {
        'action': {'key': 'action', 'type': 'str'},
        'virtual_network_resource_id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        virtual_network_resource_id: str,
        action: Optional[Union[str, "Action"]] = None,
        **kwargs
    ):
        """
        :keyword action: The action of virtual network rule. Possible values include: "Allow".
        :paramtype action: str or ~azure.mgmt.containerregistry.v2019_05_01.models.Action
        :keyword virtual_network_resource_id: Required. Resource ID of a subnet, for example:
         /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualNetworks/{vnetName}/subnets/{subnetName}.
        :paramtype virtual_network_resource_id: str
        """
        super(VirtualNetworkRule, self).__init__(**kwargs)
        self.action = action
        self.virtual_network_resource_id = virtual_network_resource_id


class Webhook(Resource):
    """An object that represents a webhook for a container registry.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: Required. The location of the resource. This cannot be changed after the
     resource is created.
    :vartype location: str
    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    :ivar provisioning_state: The provisioning state of the webhook at the time the operation was
     called. Possible values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed",
     "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.containerregistry.v2019_05_01.models.ProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "WebhookAction"]]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The location of the resource. This cannot be changed after the
         resource is created.
        :paramtype location: str
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Possible
         values include: "enabled", "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
        """
        super(Webhook, self).__init__(location=location, tags=tags, **kwargs)
        self.status = status
        self.scope = scope
        self.actions = actions
        self.provisioning_state = None


class WebhookCreateParameters(msrest.serialization.Model):
    """The parameters for creating a webhook.

    All required parameters must be populated in order to send to Azure.

    :ivar tags: A set of tags. The tags for the webhook.
    :vartype tags: dict[str, str]
    :ivar location: Required. The location of the webhook. This cannot be changed after the
     resource is created.
    :vartype location: str
    :ivar service_uri: The service URI for the webhook to post notifications.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    :ivar status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        service_uri: Optional[str] = None,
        custom_headers: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "WebhookAction"]]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The tags for the webhook.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The location of the webhook. This cannot be changed after the
         resource is created.
        :paramtype location: str
        :keyword service_uri: The service URI for the webhook to post notifications.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Possible
         values include: "enabled", "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
        """
        super(WebhookCreateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.location = location
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions


class WebhookListResult(msrest.serialization.Model):
    """The result of a request to list webhooks for a container registry.

    :ivar value: The list of webhooks. Since this list may be incomplete, the nextLink field should
     be used to request the next list of webhooks.
    :vartype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Webhook]
    :ivar next_link: The URI that can be used to request the next list of webhooks.
    :vartype next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Webhook]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Webhook"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: The list of webhooks. Since this list may be incomplete, the nextLink field
         should be used to request the next list of webhooks.
        :paramtype value: list[~azure.mgmt.containerregistry.v2019_05_01.models.Webhook]
        :keyword next_link: The URI that can be used to request the next list of webhooks.
        :paramtype next_link: str
        """
        super(WebhookListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class WebhookUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a webhook.

    :ivar tags: A set of tags. The tags for the webhook.
    :vartype tags: dict[str, str]
    :ivar service_uri: The service URI for the webhook to post notifications.
    :vartype service_uri: str
    :ivar custom_headers: Custom headers that will be added to the webhook notifications.
    :vartype custom_headers: dict[str, str]
    :ivar status: The status of the webhook at the time the operation was called. Possible values
     include: "enabled", "disabled".
    :vartype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
    :ivar scope: The scope of repositories where the event can be triggered. For example, 'foo:*'
     means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar' only.
     'foo' is equivalent to 'foo:latest'. Empty means all events.
    :vartype scope: str
    :ivar actions: The list of actions that trigger the webhook to post notifications.
    :vartype actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'service_uri': {'key': 'properties.serviceUri', 'type': 'str'},
        'custom_headers': {'key': 'properties.customHeaders', 'type': '{str}'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'scope': {'key': 'properties.scope', 'type': 'str'},
        'actions': {'key': 'properties.actions', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        service_uri: Optional[str] = None,
        custom_headers: Optional[Dict[str, str]] = None,
        status: Optional[Union[str, "WebhookStatus"]] = None,
        scope: Optional[str] = None,
        actions: Optional[List[Union[str, "WebhookAction"]]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The tags for the webhook.
        :paramtype tags: dict[str, str]
        :keyword service_uri: The service URI for the webhook to post notifications.
        :paramtype service_uri: str
        :keyword custom_headers: Custom headers that will be added to the webhook notifications.
        :paramtype custom_headers: dict[str, str]
        :keyword status: The status of the webhook at the time the operation was called. Possible
         values include: "enabled", "disabled".
        :paramtype status: str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookStatus
        :keyword scope: The scope of repositories where the event can be triggered. For example,
         'foo:*' means events for all tags under repository 'foo'. 'foo:bar' means events for 'foo:bar'
         only. 'foo' is equivalent to 'foo:latest'. Empty means all events.
        :paramtype scope: str
        :keyword actions: The list of actions that trigger the webhook to post notifications.
        :paramtype actions: list[str or ~azure.mgmt.containerregistry.v2019_05_01.models.WebhookAction]
        """
        super(WebhookUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.service_uri = service_uri
        self.custom_headers = custom_headers
        self.status = status
        self.scope = scope
        self.actions = actions
