# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=protected-access
from collections.abc import MutableMapping
from io import IOBase
import json
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import PipelineClient
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import HttpRequest, HttpResponse
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .. import models as _models
from .._configuration import MonitorQueryLogsClientConfiguration
from .._utils.model_base import SdkJSONEncoder, _deserialize, _failsafe_deserialize
from .._utils.serialization import Serializer
from .._utils.utils import ClientMixinABC

JSON = MutableMapping[str, Any]
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_monitor_query_logs_execute_request(
    workspace_id: str, *, prefer: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/workspaces/{workspaceId}/query"
    path_format_arguments = {
        "workspaceId": _SERIALIZER.url("workspace_id", workspace_id, "str"),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if prefer is not None:
        _headers["Prefer"] = _SERIALIZER.header("prefer", prefer, "str")
    if content_type is not None:
        _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_monitor_query_logs_execute_with_resource_id_request(  # pylint: disable=name-too-long
    resource_id: str, *, prefer: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/{resourceId}/query"
    path_format_arguments = {
        "resourceId": _SERIALIZER.url("resource_id", resource_id, "str", skip_quote=True),
    }

    _url: str = _url.format(**path_format_arguments)  # type: ignore

    # Construct headers
    if prefer is not None:
        _headers["Prefer"] = _SERIALIZER.header("prefer", prefer, "str")
    if content_type is not None:
        _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_monitor_query_logs_batch_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/$batch"

    # Construct headers
    if content_type is not None:
        _headers["content-type"] = _SERIALIZER.header("content_type", content_type, "str")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


class _MonitorQueryLogsClientOperationsMixin(
    ClientMixinABC[PipelineClient[HttpRequest, HttpResponse], MonitorQueryLogsClientConfiguration]
):

    @overload
    def _execute(
        self,
        workspace_id: str,
        body: _models._models.QueryBody,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.QueryResults: ...
    @overload
    def _execute(
        self,
        workspace_id: str,
        body: JSON,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.QueryResults: ...
    @overload
    def _execute(
        self,
        workspace_id: str,
        body: IO[bytes],
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.QueryResults: ...

    @distributed_trace
    def _execute(
        self,
        workspace_id: str,
        body: Union[_models._models.QueryBody, JSON, IO[bytes]],
        *,
        prefer: Optional[str] = None,
        **kwargs: Any
    ) -> _models._models.QueryResults:
        """Execute an Analytics query.

        Executes an Analytics query for data.
        `Here <https://learn.microsoft.com/azure/azure-monitor/logs/api/request-format>`_
        is an example for using POST with an Analytics query.

        :param workspace_id: Primary Workspace ID of the query. This is the Workspace ID from the
         Properties
         blade in the Azure portal. Required.
        :type workspace_id: str
        :param body: The Analytics query. Learn more about the
         `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_. Is
         one of the following types: QueryBody, JSON, IO[bytes] Required.
        :type body: ~azure.monitor.query.models._models.QueryBody or JSON or IO[bytes]
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :return: QueryResults. The QueryResults is compatible with MutableMapping
        :rtype: ~azure.monitor.query.models._models.QueryResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models._models.QueryResults] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_monitor_query_logs_execute_request(
            workspace_id=workspace_id,
            prefer=prefer,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models._models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.QueryResults, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _execute_with_resource_id(
        self,
        resource_id: str,
        body: _models._models.QueryBody,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.QueryResults: ...
    @overload
    def _execute_with_resource_id(
        self,
        resource_id: str,
        body: JSON,
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.QueryResults: ...
    @overload
    def _execute_with_resource_id(
        self,
        resource_id: str,
        body: IO[bytes],
        *,
        prefer: Optional[str] = None,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models._models.QueryResults: ...

    @distributed_trace
    def _execute_with_resource_id(
        self,
        resource_id: str,
        body: Union[_models._models.QueryBody, JSON, IO[bytes]],
        *,
        prefer: Optional[str] = None,
        **kwargs: Any
    ) -> _models._models.QueryResults:
        """Execute an Analytics query using resource ID.

        Executes an Analytics query for data in the context of a resource.
        `Here <https://learn.microsoft.com/azure/azure-monitor/logs/api/azure-resource-queries>`_
        is an example for using POST with an Analytics query.

        :param resource_id: The identifier of the resource. Required.
        :type resource_id: str
        :param body: The Analytics query. Learn more about the
         `Analytics query syntax
         <https://azure.microsoft.com/documentation/articles/app-insights-analytics-reference/>`_. Is
         one of the following types: QueryBody, JSON, IO[bytes] Required.
        :type body: ~azure.monitor.query.models._models.QueryBody or JSON or IO[bytes]
        :keyword prefer: Optional. The prefer header to set server timeout, query statistics and
         visualization information. Default value is None.
        :paramtype prefer: str
        :return: QueryResults. The QueryResults is compatible with MutableMapping
        :rtype: ~azure.monitor.query.models._models.QueryResults
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models._models.QueryResults] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_monitor_query_logs_execute_with_resource_id_request(
            resource_id=resource_id,
            prefer=prefer,
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models._models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.QueryResults, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    def _batch(
        self, body: _models._models.BatchRequest, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models._models.BatchResponse: ...
    @overload
    def _batch(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> _models._models.BatchResponse: ...
    @overload
    def _batch(
        self, body: IO[bytes], *, content_type: str = "application/json", **kwargs: Any
    ) -> _models._models.BatchResponse: ...

    @distributed_trace
    def _batch(
        self, body: Union[_models._models.BatchRequest, JSON, IO[bytes]], **kwargs: Any
    ) -> _models._models.BatchResponse:
        """Execute a batch of Analytics queries.

        Executes a batch of Analytics queries for data.
        `Here <https://learn.microsoft.com/azure/azure-monitor/logs/api/batch-queries>`_
        is an example for using POST with an Analytics query.

        :param body: The batch request body. Is one of the following types: BatchRequest, JSON,
         IO[bytes] Required.
        :type body: ~azure.monitor.query.models._models.BatchRequest or JSON or IO[bytes]
        :return: BatchResponse. The BatchResponse is compatible with MutableMapping
        :rtype: ~azure.monitor.query.models._models.BatchResponse
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("content-type", None))
        cls: ClsType[_models._models.BatchResponse] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(body, (IOBase, bytes)):
            _content = body
        else:
            _content = json.dumps(body, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_monitor_query_logs_batch_request(
            content_type=content_type,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
            "apiVersion": self._serialize.url("self._config.api_version", self._config.api_version, "str"),
        }
        _request.url = self._client.format_url(_request.url, **path_format_arguments)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _failsafe_deserialize(_models._models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(
                _models._models.BatchResponse, response.json()  # pylint: disable=protected-access
            )

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore
