require 'spec_helper'

# edge cases with `...-&&...` and `...&&-...` are checked in ./ranges_spec.rb

RSpec.describe('CharacterSet::Intersection parsing') do
  include_examples 'parse', /[a&&z]/,
    [0]          => [CharacterSet, count: 1],
    [0, 0]       => [CharacterSet::Intersection, count: 2],
    [0, 0, 0]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 0, 0] => [:literal, text: 'a'],
    [0, 0, 1]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 1, 0] => [:literal, text: 'z']

  include_examples 'parse', /[a-z&&[^a]]/,
    [0]          => [CharacterSet, count: 1],
    [0, 0]       => [CharacterSet::Intersection, count: 2],
    [0, 0, 0]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 0, 0] => [CharacterSet::Range, count: 2],
    [0, 0, 1]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 1, 0] => [CharacterSet, count: 1, negative?: true]

  include_examples 'parse', /[a&&a-z]/,
    [0]          => [CharacterSet, count: 1],
    [0, 0]       => [CharacterSet::Intersection, count: 2],
    [0, 0, 0]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 0, 0] => [:literal, text: 'a'],
    [0, 0, 1]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 1, 0] => [CharacterSet::Range, count: 2]

  include_examples 'parse', /[a&&\w]/,
    [0]          => [CharacterSet, count: 1],
    [0, 0]       => [CharacterSet::Intersection, count: 2],
    [0, 0, 1]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 1, 0] => [:word, text: '\w']

  include_examples 'parse', /[\h&&\w&&efg]/,
    [0]          => [CharacterSet, count: 1],
    [0, 0]       => [CharacterSet::Intersection, count: 3],
    [0, 0, 0]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 0, 0] => [:hex, text: '\h'],
    [0, 0, 1]    => [CharacterSet::IntersectedSequence, count: 1],
    [0, 0, 1, 0] => [:word, text: '\w'],
    [0, 0, 2]    => [CharacterSet::IntersectedSequence, count: 3],
    [0, 0, 2, 0] => [:literal, text: 'e'],
    [0, 0, 2, 1] => [:literal, text: 'f'],
    [0, 0, 2, 2] => [:literal, text: 'g']

  # Some edge-case patterns are evaluated with #match to make sure that
  # their matching behavior still reflects the way they are parsed.
  # #capturing_stderr is used to skip any warnings generated by this.
  specify('intersections behavior remains unchanged') do
    capturing_stderr do
      expect(/[a&&z]/).not_to match 'a'
      expect(/[a&&z]/).not_to match '&'
      expect(/[a&&z]/).not_to match 'z'
      expect(/[a-z&&[^a]]/).not_to match 'a'
      expect(/[a-z&&[^a]]/).not_to match '&'
      expect(/[a-z&&[^a]]/).to     match 'b'
      expect(/[a&&a-z]/).to     match 'a'
      expect(/[a&&a-z]/).not_to match '&'
      expect(/[a&&a-z]/).not_to match 'b'
      expect(/[a&&\w]/).to     match 'a'
      expect(/[a&&\w]/).not_to match '&'
      expect(/[a&&\w]/).not_to match 'b'
      expect(/[\h&&\w&&efg]/).to     match 'e'
      expect(/[\h&&\w&&efg]/).to     match 'f'
      expect(/[\h&&\w&&efg]/).not_to match 'a'
      expect(/[\h&&\w&&efg]/).not_to match 'g'
    end
  end
end
