/**
 * 
 */
package org.jboss.cache.eviction;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.jboss.cache.Fqn;

/**
 * A queue that does nothing.
 * 
 * @author Brian Stansberry
 */
public class NullEvictionQueue implements EvictionQueue
{
   /** Singleton instance of this class. */
   public static final NullEvictionQueue INSTANCE = new NullEvictionQueue();
   
   /**
    * Constructs a new NullEvictionQueue.
    */
   private NullEvictionQueue()
   {
   }

   /** No-op */
   public void addNodeEntry(NodeEntry entry)
   {
      // no-op
   }

   /** No-op */
   public void clear()
   {
      // no-op
   }

   /** Returns <code>false</code> */
   public boolean containsNodeEntry(NodeEntry entry)
   {
      return false;
   }

   /** Returns <code>null</code> */
   public NodeEntry getFirstNodeEntry()
   {
      return null;
   }

   /** Returns <code>null</code> */
   public NodeEntry getNodeEntry(Fqn fqn)
   {
      return null;
   }

   /** Returns <code>null</code> */
   public NodeEntry getNodeEntry(String fqn)
   {
      return null;
   }

   /** Returns <code>0</code> */
   public int getNumberOfElements()
   {
      return 0;
   }

   /** Returns <code>0</code> */
   public int getNumberOfNodes()
   {
      return 0;
   }

   /** 
    * Returns an <code>Iterator</code> whose
    * <code>hasNext()</code> returns <code>false</code>.
    */
   public Iterator iterate()
   {
      return NullQueueIterator.INSTANCE;
   }

   /** No-op */
   public void modifyElementCount(int difference)
   {
      // no-op
   }

   /** No-op */
   public void removeNodeEntry(NodeEntry entry)
   {
      // no-op
   }
   
   static class NullQueueIterator implements Iterator
   {
      private static final NullQueueIterator INSTANCE = new NullQueueIterator();

      private NullQueueIterator() {}
      
      public boolean hasNext()
      {
         return false;
      }

      public Object next()
      {
         throw new NoSuchElementException("No more elements");
      }

      public void remove()
      {
         throw new IllegalStateException("Must call next() before remove()");
      }
   }

}
