/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

/* eslint-disable no-restricted-syntax */

'use strict';

var isnan = require( '@stdlib/math/base/assert/is-nan' );
var bench = require( './../lib' );

var opts = {
	'iterations': 1e8,
	'repeats': 3
};

bench( 'ternary', opts, function benchmark( b ) {
	var r;
	var i;

	b.tic();
	for ( i = 0; i < b.iterations; i++ ) {
		r = (i&1) ? i+2 : 0;
		if ( r !== r ) {
			b.fail( 'something went wrong!' );
		}
	}
	b.toc();
	if ( isnan( r ) ) {
		b.fail( 'something went wrong!' );
	}
	b.pass( 'benchmark finished' );
	b.end();
});

bench( 'short-circuit', opts, function benchmark( b ) {
	var r;
	var i;

	b.tic();
	for ( i = 0; i < b.iterations; i++ ) {
		r = (i&1) && i+2;
		if ( r !== r ) {
			b.fail( 'something went wrong!' );
		}
	}
	b.toc();
	if ( isnan( r ) ) {
		b.fail( 'something went wrong!' );
	}
	b.pass( 'benchmark finished' );
	b.end();
});
