// Single File library
var loadTimelibrary1 = typeof window.library1 === "undefined"
describe("library1", function() {
	it("should load library1 only once", function() {
		expect(loadTimelibrary1).toBe(true);
	});

	it("should load a component", function() {
		expect(require("./lib/component")).toBe("lib1 component");
	});

	it("should load async submodules with require.ensure even if single == true", function(done) {
		var sameTick = true;
		require.ensure(["submodule1", "submodule2"], function(require) {
			expect(sameTick).toBe(true);
			expect(require("submodule1")).toBe("submodule1");
			expect(require("submodule2")).toBe("submodule2");
			expect(require("submodule3")()).toBe("submodule3");
			require.ensure([], function(require) {
				expect(sameTick).toBe(true);
				done();
			});
		});
		setImmediate(function() {
			sameTick = false;
		});
	});
});
module.exports = true;
