# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Compute(msrest.serialization.Model):
    """Machine Learning compute object.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AKS, AmlCompute, ComputeInstance, DataFactory, DataLakeAnalytics, Databricks, HDInsight, VirtualMachine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AKS', 'AmlCompute': 'AmlCompute', 'ComputeInstance': 'ComputeInstance', 'DataFactory': 'DataFactory', 'DataLakeAnalytics': 'DataLakeAnalytics', 'Databricks': 'Databricks', 'HDInsight': 'HDInsight', 'VirtualMachine': 'VirtualMachine'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Compute, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]
        self.compute_location = kwargs.get('compute_location', None)
        self.provisioning_state = None
        self.description = kwargs.get('description', None)
        self.created_on = None
        self.modified_on = None
        self.resource_id = kwargs.get('resource_id', None)
        self.provisioning_errors = None
        self.is_attached_compute = None


class AKS(Compute):
    """A Machine Learning compute based on AKS.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :param properties: AKS properties.
    :type properties: ~azure.mgmt.machinelearningservices.models.AKSProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'AKSProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AKS, self).__init__(**kwargs)
        self.compute_type = 'AKS'  # type: str
        self.properties = kwargs.get('properties', None)


class ComputeSecrets(msrest.serialization.Model):
    """Secrets related to a Machine Learning compute. Might differ for every type of compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AksComputeSecrets, DatabricksComputeSecrets, VirtualMachineSecrets.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
    }

    _subtype_map = {
        'compute_type': {'AKS': 'AksComputeSecrets', 'Databricks': 'DatabricksComputeSecrets', 'VirtualMachine': 'VirtualMachineSecrets'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeSecrets, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]


class AksComputeSecrets(ComputeSecrets):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param user_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :type user_kube_config: str
    :param admin_kube_config: Content of kubeconfig file that can be used to connect to the
     Kubernetes cluster.
    :type admin_kube_config: str
    :param image_pull_secret_name: Image registry pull secret.
    :type image_pull_secret_name: str
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'user_kube_config': {'key': 'userKubeConfig', 'type': 'str'},
        'admin_kube_config': {'key': 'adminKubeConfig', 'type': 'str'},
        'image_pull_secret_name': {'key': 'imagePullSecretName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AksComputeSecrets, self).__init__(**kwargs)
        self.compute_type = 'AKS'  # type: str
        self.user_kube_config = kwargs.get('user_kube_config', None)
        self.admin_kube_config = kwargs.get('admin_kube_config', None)
        self.image_pull_secret_name = kwargs.get('image_pull_secret_name', None)


class AksNetworkingConfiguration(msrest.serialization.Model):
    """Advance configuration for AKS networking.

    :param subnet_id: Virtual network subnet resource ID the compute nodes belong to.
    :type subnet_id: str
    :param service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :type service_cidr: str
    :param dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :type dns_service_ip: str
    :param docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :type docker_bridge_cidr: str
    """

    _validation = {
        'service_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
        'dns_service_ip': {'pattern': r'^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$'},
        'docker_bridge_cidr': {'pattern': r'^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$'},
    }

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'service_cidr': {'key': 'serviceCidr', 'type': 'str'},
        'dns_service_ip': {'key': 'dnsServiceIP', 'type': 'str'},
        'docker_bridge_cidr': {'key': 'dockerBridgeCidr', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AksNetworkingConfiguration, self).__init__(**kwargs)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.service_cidr = kwargs.get('service_cidr', None)
        self.dns_service_ip = kwargs.get('dns_service_ip', None)
        self.docker_bridge_cidr = kwargs.get('docker_bridge_cidr', None)


class AKSProperties(msrest.serialization.Model):
    """AKS properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param cluster_fqdn: Cluster full qualified domain name.
    :type cluster_fqdn: str
    :ivar system_services: System services.
    :vartype system_services: list[~azure.mgmt.machinelearningservices.models.SystemService]
    :param agent_count: Number of agents.
    :type agent_count: int
    :param agent_vm_size: Agent virtual machine size.
    :type agent_vm_size: str
    :param ssl_configuration: SSL configuration.
    :type ssl_configuration: ~azure.mgmt.machinelearningservices.models.SslConfiguration
    :param aks_networking_configuration: AKS networking configuration for vnet.
    :type aks_networking_configuration:
     ~azure.mgmt.machinelearningservices.models.AksNetworkingConfiguration
    """

    _validation = {
        'system_services': {'readonly': True},
        'agent_count': {'minimum': 1},
    }

    _attribute_map = {
        'cluster_fqdn': {'key': 'clusterFqdn', 'type': 'str'},
        'system_services': {'key': 'systemServices', 'type': '[SystemService]'},
        'agent_count': {'key': 'agentCount', 'type': 'int'},
        'agent_vm_size': {'key': 'agentVMSize', 'type': 'str'},
        'ssl_configuration': {'key': 'sslConfiguration', 'type': 'SslConfiguration'},
        'aks_networking_configuration': {'key': 'aksNetworkingConfiguration', 'type': 'AksNetworkingConfiguration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AKSProperties, self).__init__(**kwargs)
        self.cluster_fqdn = kwargs.get('cluster_fqdn', None)
        self.system_services = None
        self.agent_count = kwargs.get('agent_count', None)
        self.agent_vm_size = kwargs.get('agent_vm_size', None)
        self.ssl_configuration = kwargs.get('ssl_configuration', None)
        self.aks_networking_configuration = kwargs.get('aks_networking_configuration', None)


class AmlCompute(Compute):
    """An Azure Machine Learning compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :param properties: AML Compute properties.
    :type properties: ~azure.mgmt.machinelearningservices.models.AmlComputeProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'AmlComputeProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmlCompute, self).__init__(**kwargs)
        self.compute_type = 'AmlCompute'  # type: str
        self.properties = kwargs.get('properties', None)


class AmlComputeNodeInformation(msrest.serialization.Model):
    """Compute node information related to a AmlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar node_id: ID of the compute node.
    :vartype node_id: str
    :ivar private_ip_address: Private IP address of the compute node.
    :vartype private_ip_address: str
    :ivar public_ip_address: Public IP address of the compute node.
    :vartype public_ip_address: str
    :ivar port: SSH port number of the node.
    :vartype port: int
    :ivar node_state: State of the compute node. Values are idle, running, preparing, unusable,
     leaving and preempted. Possible values include: "idle", "running", "preparing", "unusable",
     "leaving", "preempted".
    :vartype node_state: str or ~azure.mgmt.machinelearningservices.models.NodeState
    :ivar run_id: ID of the Experiment running on the node, if any else null.
    :vartype run_id: str
    """

    _validation = {
        'node_id': {'readonly': True},
        'private_ip_address': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'port': {'readonly': True},
        'node_state': {'readonly': True},
        'run_id': {'readonly': True},
    }

    _attribute_map = {
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'port': {'key': 'port', 'type': 'int'},
        'node_state': {'key': 'nodeState', 'type': 'str'},
        'run_id': {'key': 'runId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmlComputeNodeInformation, self).__init__(**kwargs)
        self.node_id = None
        self.private_ip_address = None
        self.public_ip_address = None
        self.port = None
        self.node_state = None
        self.run_id = None


class ComputeNodesInformation(msrest.serialization.Model):
    """Compute nodes information related to a Machine Learning compute. Might differ for every type of compute.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AmlComputeNodesInformation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar next_link: The continuation token.
    :vartype next_link: str
    """

    _validation = {
        'compute_type': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    _subtype_map = {
        'compute_type': {'AmlCompute': 'AmlComputeNodesInformation'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeNodesInformation, self).__init__(**kwargs)
        self.compute_type = None  # type: Optional[str]
        self.next_link = None


class AmlComputeNodesInformation(ComputeNodesInformation):
    """Compute node information related to a AmlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :ivar next_link: The continuation token.
    :vartype next_link: str
    :ivar nodes: The collection of returned AmlCompute nodes details.
    :vartype nodes: list[~azure.mgmt.machinelearningservices.models.AmlComputeNodeInformation]
    """

    _validation = {
        'compute_type': {'required': True},
        'next_link': {'readonly': True},
        'nodes': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'nodes': {'key': 'nodes', 'type': '[AmlComputeNodeInformation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmlComputeNodesInformation, self).__init__(**kwargs)
        self.compute_type = 'AmlCompute'  # type: str
        self.nodes = None


class AmlComputeProperties(msrest.serialization.Model):
    """AML Compute properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param vm_size: Virtual Machine Size.
    :type vm_size: str
    :param vm_priority: Virtual Machine priority. Possible values include: "Dedicated",
     "LowPriority".
    :type vm_priority: str or ~azure.mgmt.machinelearningservices.models.VmPriority
    :param scale_settings: Scale settings for AML Compute.
    :type scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
    :param user_account_credentials: Credentials for an administrator user account that will be
     created on each compute node.
    :type user_account_credentials:
     ~azure.mgmt.machinelearningservices.models.UserAccountCredentials
    :param subnet: Virtual network subnet resource ID the compute nodes belong to.
    :type subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :param remote_login_port_public_access: State of the public SSH port. Possible values are:
     Disabled - Indicates that the public ssh port is closed on all nodes of the cluster. Enabled -
     Indicates that the public ssh port is open on all nodes of the cluster. NotSpecified -
     Indicates that the public ssh port is closed on all nodes of the cluster if VNet is defined,
     else is open all public nodes. It can be default only during cluster creation time, after
     creation it will be either enabled or disabled. Possible values include: "Enabled", "Disabled",
     "NotSpecified". Default value: "NotSpecified".
    :type remote_login_port_public_access: str or
     ~azure.mgmt.machinelearningservices.models.RemoteLoginPortPublicAccess
    :ivar allocation_state: Allocation state of the compute. Possible values are: steady -
     Indicates that the compute is not resizing. There are no changes to the number of compute nodes
     in the compute in progress. A compute enters this state when it is created and when no
     operations are being performed on the compute to change the number of compute nodes. resizing -
     Indicates that the compute is resizing; that is, compute nodes are being added to or removed
     from the compute. Possible values include: "Steady", "Resizing".
    :vartype allocation_state: str or ~azure.mgmt.machinelearningservices.models.AllocationState
    :ivar allocation_state_transition_time: The time at which the compute entered its current
     allocation state.
    :vartype allocation_state_transition_time: ~datetime.datetime
    :ivar errors: Collection of errors encountered by various compute nodes during node setup.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar current_node_count: The number of compute nodes currently assigned to the compute.
    :vartype current_node_count: int
    :ivar target_node_count: The target number of compute nodes for the compute. If the
     allocationState is resizing, this property denotes the target node count for the ongoing resize
     operation. If the allocationState is steady, this property denotes the target node count for
     the previous resize operation.
    :vartype target_node_count: int
    :ivar node_state_counts: Counts of various node states on the compute.
    :vartype node_state_counts: ~azure.mgmt.machinelearningservices.models.NodeStateCounts
    """

    _validation = {
        'allocation_state': {'readonly': True},
        'allocation_state_transition_time': {'readonly': True},
        'errors': {'readonly': True},
        'current_node_count': {'readonly': True},
        'target_node_count': {'readonly': True},
        'node_state_counts': {'readonly': True},
    }

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'vm_priority': {'key': 'vmPriority', 'type': 'str'},
        'scale_settings': {'key': 'scaleSettings', 'type': 'ScaleSettings'},
        'user_account_credentials': {'key': 'userAccountCredentials', 'type': 'UserAccountCredentials'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'remote_login_port_public_access': {'key': 'remoteLoginPortPublicAccess', 'type': 'str'},
        'allocation_state': {'key': 'allocationState', 'type': 'str'},
        'allocation_state_transition_time': {'key': 'allocationStateTransitionTime', 'type': 'iso-8601'},
        'errors': {'key': 'errors', 'type': '[MachineLearningServiceError]'},
        'current_node_count': {'key': 'currentNodeCount', 'type': 'int'},
        'target_node_count': {'key': 'targetNodeCount', 'type': 'int'},
        'node_state_counts': {'key': 'nodeStateCounts', 'type': 'NodeStateCounts'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmlComputeProperties, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)
        self.vm_priority = kwargs.get('vm_priority', None)
        self.scale_settings = kwargs.get('scale_settings', None)
        self.user_account_credentials = kwargs.get('user_account_credentials', None)
        self.subnet = kwargs.get('subnet', None)
        self.remote_login_port_public_access = kwargs.get('remote_login_port_public_access', "NotSpecified")
        self.allocation_state = None
        self.allocation_state_transition_time = None
        self.errors = None
        self.current_node_count = None
        self.target_node_count = None
        self.node_state_counts = None


class AmlUserFeature(msrest.serialization.Model):
    """Features enabled for a workspace.

    :param id: Specifies the feature ID.
    :type id: str
    :param display_name: Specifies the feature name.
    :type display_name: str
    :param description: Describes the feature for user experience.
    :type description: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AmlUserFeature, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.description = kwargs.get('description', None)


class ClusterUpdateParameters(msrest.serialization.Model):
    """AmlCompute update parameters.

    :param scale_settings: Desired scale settings for the amlCompute.
    :type scale_settings: ~azure.mgmt.machinelearningservices.models.ScaleSettings
    """

    _attribute_map = {
        'scale_settings': {'key': 'properties.scaleSettings', 'type': 'ScaleSettings'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClusterUpdateParameters, self).__init__(**kwargs)
        self.scale_settings = kwargs.get('scale_settings', None)


class ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties(msrest.serialization.Model):
    """ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class ComputeInstance(Compute):
    """An Azure Machine Learning compute instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :param properties: Compute Instance properties.
    :type properties: ~azure.mgmt.machinelearningservices.models.ComputeInstanceProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'ComputeInstanceProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeInstance, self).__init__(**kwargs)
        self.compute_type = 'ComputeInstance'  # type: str
        self.properties = kwargs.get('properties', None)


class ComputeInstanceApplication(msrest.serialization.Model):
    """Defines an Aml Instance application and its connectivity endpoint URI.

    :param display_name: Name of the ComputeInstance application.
    :type display_name: str
    :param endpoint_uri: Application' endpoint URI.
    :type endpoint_uri: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'endpoint_uri': {'key': 'endpointUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeInstanceApplication, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.endpoint_uri = kwargs.get('endpoint_uri', None)


class ComputeInstanceConnectivityEndpoints(msrest.serialization.Model):
    """Defines all connectivity endpoints and properties for a ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_ip_address: Public IP Address of this ComputeInstance.
    :vartype public_ip_address: str
    :ivar private_ip_address: Private IP Address of this ComputeInstance (local to the VNET in
     which the compute instance is deployed).
    :vartype private_ip_address: str
    """

    _validation = {
        'public_ip_address': {'readonly': True},
        'private_ip_address': {'readonly': True},
    }

    _attribute_map = {
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'private_ip_address': {'key': 'privateIpAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeInstanceConnectivityEndpoints, self).__init__(**kwargs)
        self.public_ip_address = None
        self.private_ip_address = None


class ComputeInstanceCreatedBy(msrest.serialization.Model):
    """Describes information on user who created this ComputeInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_name: Name of the user.
    :vartype user_name: str
    :ivar user_org_id: Uniquely identifies user' Azure Active Directory organization.
    :vartype user_org_id: str
    :ivar user_id: Uniquely identifies the user within his/her organization.
    :vartype user_id: str
    """

    _validation = {
        'user_name': {'readonly': True},
        'user_org_id': {'readonly': True},
        'user_id': {'readonly': True},
    }

    _attribute_map = {
        'user_name': {'key': 'userName', 'type': 'str'},
        'user_org_id': {'key': 'userOrgId', 'type': 'str'},
        'user_id': {'key': 'userId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeInstanceCreatedBy, self).__init__(**kwargs)
        self.user_name = None
        self.user_org_id = None
        self.user_id = None


class ComputeInstanceLastOperation(msrest.serialization.Model):
    """The last operation on ComputeInstance.

    :param operation_name: Name of the last operation. Possible values include: "Create", "Start",
     "Stop", "Restart", "Reimage", "Delete".
    :type operation_name: str or ~azure.mgmt.machinelearningservices.models.OperationName
    :param operation_time: Time of the last operation.
    :type operation_time: ~datetime.datetime
    :param operation_status: Operation status. Possible values include: "InProgress", "Succeeded",
     "CreateFailed", "StartFailed", "StopFailed", "RestartFailed", "ReimageFailed", "DeleteFailed".
    :type operation_status: str or ~azure.mgmt.machinelearningservices.models.OperationStatus
    """

    _attribute_map = {
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'operation_time': {'key': 'operationTime', 'type': 'iso-8601'},
        'operation_status': {'key': 'operationStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeInstanceLastOperation, self).__init__(**kwargs)
        self.operation_name = kwargs.get('operation_name', None)
        self.operation_time = kwargs.get('operation_time', None)
        self.operation_status = kwargs.get('operation_status', None)


class ComputeInstanceProperties(msrest.serialization.Model):
    """Compute Instance properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param vm_size: Virtual Machine Size.
    :type vm_size: str
    :param subnet: Virtual network subnet resource ID the compute nodes belong to.
    :type subnet: ~azure.mgmt.machinelearningservices.models.ResourceId
    :param application_sharing_policy: Policy for sharing applications on this compute instance
     among users of parent workspace. If Personal, only the creator can access applications on this
     compute instance. When Shared, any workspace user can access applications on this instance
     depending on his/her assigned role. Possible values include: "Personal", "Shared". Default
     value: "Shared".
    :type application_sharing_policy: str or
     ~azure.mgmt.machinelearningservices.models.ApplicationSharingPolicy
    :param ssh_settings: Specifies policy and settings for SSH access.
    :type ssh_settings: ~azure.mgmt.machinelearningservices.models.ComputeInstanceSshSettings
    :ivar connectivity_endpoints: Describes all connectivity endpoints available for this
     ComputeInstance.
    :vartype connectivity_endpoints:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceConnectivityEndpoints
    :ivar applications: Describes available applications and their endpoints on this
     ComputeInstance.
    :vartype applications:
     list[~azure.mgmt.machinelearningservices.models.ComputeInstanceApplication]
    :ivar created_by: Describes information on user who created this ComputeInstance.
    :vartype created_by: ~azure.mgmt.machinelearningservices.models.ComputeInstanceCreatedBy
    :ivar errors: Collection of errors encountered on this ComputeInstance.
    :vartype errors: list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar state: The current state of this ComputeInstance. Possible values include: "Creating",
     "CreateFailed", "Deleting", "Running", "Restarting", "JobRunning", "SettingUp", "SetupFailed",
     "Starting", "Stopped", "Stopping", "UserSettingUp", "UserSetupFailed", "Unknown", "Unusable".
    :vartype state: str or ~azure.mgmt.machinelearningservices.models.ComputeInstanceState
    :ivar last_operation: The last operation on ComputeInstance.
    :vartype last_operation:
     ~azure.mgmt.machinelearningservices.models.ComputeInstanceLastOperation
    """

    _validation = {
        'connectivity_endpoints': {'readonly': True},
        'applications': {'readonly': True},
        'created_by': {'readonly': True},
        'errors': {'readonly': True},
        'state': {'readonly': True},
        'last_operation': {'readonly': True},
    }

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'subnet': {'key': 'subnet', 'type': 'ResourceId'},
        'application_sharing_policy': {'key': 'applicationSharingPolicy', 'type': 'str'},
        'ssh_settings': {'key': 'sshSettings', 'type': 'ComputeInstanceSshSettings'},
        'connectivity_endpoints': {'key': 'connectivityEndpoints', 'type': 'ComputeInstanceConnectivityEndpoints'},
        'applications': {'key': 'applications', 'type': '[ComputeInstanceApplication]'},
        'created_by': {'key': 'createdBy', 'type': 'ComputeInstanceCreatedBy'},
        'errors': {'key': 'errors', 'type': '[MachineLearningServiceError]'},
        'state': {'key': 'state', 'type': 'str'},
        'last_operation': {'key': 'lastOperation', 'type': 'ComputeInstanceLastOperation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeInstanceProperties, self).__init__(**kwargs)
        self.vm_size = kwargs.get('vm_size', None)
        self.subnet = kwargs.get('subnet', None)
        self.application_sharing_policy = kwargs.get('application_sharing_policy', "Shared")
        self.ssh_settings = kwargs.get('ssh_settings', None)
        self.connectivity_endpoints = None
        self.applications = None
        self.created_by = None
        self.errors = None
        self.state = None
        self.last_operation = None


class ComputeInstanceSshSettings(msrest.serialization.Model):
    """Specifies policy and settings for SSH access.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param ssh_public_access: State of the public SSH port. Possible values are: Disabled -
     Indicates that the public ssh port is closed on this instance. Enabled - Indicates that the
     public ssh port is open and accessible according to the VNet/subnet policy if applicable.
     Possible values include: "Enabled", "Disabled". Default value: "Disabled".
    :type ssh_public_access: str or ~azure.mgmt.machinelearningservices.models.SshPublicAccess
    :ivar admin_user_name: Describes the admin user name.
    :vartype admin_user_name: str
    :ivar ssh_port: Describes the port for connecting through SSH.
    :vartype ssh_port: int
    :param admin_public_key: Specifies the SSH rsa public key file as a string. Use "ssh-keygen -t
     rsa -b 2048" to generate your SSH key pairs.
    :type admin_public_key: str
    """

    _validation = {
        'admin_user_name': {'readonly': True},
        'ssh_port': {'readonly': True},
    }

    _attribute_map = {
        'ssh_public_access': {'key': 'sshPublicAccess', 'type': 'str'},
        'admin_user_name': {'key': 'adminUserName', 'type': 'str'},
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'admin_public_key': {'key': 'adminPublicKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeInstanceSshSettings, self).__init__(**kwargs)
        self.ssh_public_access = kwargs.get('ssh_public_access', "Disabled")
        self.admin_user_name = None
        self.ssh_port = None
        self.admin_public_key = kwargs.get('admin_public_key', None)


class Resource(msrest.serialization.Model):
    """Azure Resource Manager resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.machinelearningservices.models.Identity
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: A set of tags. Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param sku: The sku of the workspace.
    :type sku: ~azure.mgmt.machinelearningservices.models.Sku
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.identity = kwargs.get('identity', None)
        self.location = kwargs.get('location', None)
        self.type = None
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)


class ComputeResource(Resource):
    """Machine Learning compute object wrapped into ARM resource envelope.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.machinelearningservices.models.Identity
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: A set of tags. Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param sku: The sku of the workspace.
    :type sku: ~azure.mgmt.machinelearningservices.models.Sku
    :param properties: Compute properties.
    :type properties: ~azure.mgmt.machinelearningservices.models.Compute
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'properties': {'key': 'properties', 'type': 'Compute'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class Databricks(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :param properties:
    :type properties: ~azure.mgmt.machinelearningservices.models.DatabricksProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'DatabricksProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Databricks, self).__init__(**kwargs)
        self.compute_type = 'Databricks'  # type: str
        self.properties = kwargs.get('properties', None)


class DatabricksComputeSecrets(ComputeSecrets):
    """Secrets related to a Machine Learning compute based on Databricks.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param databricks_access_token: access token for databricks account.
    :type databricks_access_token: str
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabricksComputeSecrets, self).__init__(**kwargs)
        self.compute_type = 'Databricks'  # type: str
        self.databricks_access_token = kwargs.get('databricks_access_token', None)


class DatabricksProperties(msrest.serialization.Model):
    """DatabricksProperties.

    :param databricks_access_token: Databricks access token.
    :type databricks_access_token: str
    """

    _attribute_map = {
        'databricks_access_token': {'key': 'databricksAccessToken', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatabricksProperties, self).__init__(**kwargs)
        self.databricks_access_token = kwargs.get('databricks_access_token', None)


class DataFactory(Compute):
    """A DataFactory compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataFactory, self).__init__(**kwargs)
        self.compute_type = 'DataFactory'  # type: str


class DataLakeAnalytics(Compute):
    """A DataLakeAnalytics compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :param properties:
    :type properties: ~azure.mgmt.machinelearningservices.models.DataLakeAnalyticsProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'DataLakeAnalyticsProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeAnalytics, self).__init__(**kwargs)
        self.compute_type = 'DataLakeAnalytics'  # type: str
        self.properties = kwargs.get('properties', None)


class DataLakeAnalyticsProperties(msrest.serialization.Model):
    """DataLakeAnalyticsProperties.

    :param data_lake_store_account_name: DataLake Store Account Name.
    :type data_lake_store_account_name: str
    """

    _attribute_map = {
        'data_lake_store_account_name': {'key': 'dataLakeStoreAccountName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataLakeAnalyticsProperties, self).__init__(**kwargs)
        self.data_lake_store_account_name = kwargs.get('data_lake_store_account_name', None)


class EncryptionProperty(msrest.serialization.Model):
    """EncryptionProperty.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Indicates whether or not the encryption is enabled for the workspace.
     Possible values include: "Enabled", "Disabled".
    :type status: str or ~azure.mgmt.machinelearningservices.models.EncryptionStatus
    :param key_vault_properties: Required. Customer Key vault properties.
    :type key_vault_properties: ~azure.mgmt.machinelearningservices.models.KeyVaultProperties
    """

    _validation = {
        'status': {'required': True},
        'key_vault_properties': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EncryptionProperty, self).__init__(**kwargs)
        self.status = kwargs['status']
        self.key_vault_properties = kwargs['key_vault_properties']


class ErrorDetail(msrest.serialization.Model):
    """Error detail information.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. Error message.
    :type message: str
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = kwargs['code']
        self.message = kwargs['message']


class ErrorResponse(msrest.serialization.Model):
    """Error response information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message.
    :vartype message: str
    :ivar details: An array of error detail objects.
    :vartype details: list[~azure.mgmt.machinelearningservices.models.ErrorDetail]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.details = None


class EstimatedVMPrice(msrest.serialization.Model):
    """The estimated price info for using a VM of a particular OS type, tier, etc.

    All required parameters must be populated in order to send to Azure.

    :param retail_price: Required. The price charged for using the VM.
    :type retail_price: float
    :param os_type: Required. Operating system type used by the VM. Possible values include:
     "Linux", "Windows".
    :type os_type: str or ~azure.mgmt.machinelearningservices.models.VMPriceOSType
    :param vm_tier: Required. The type of the VM. Possible values include: "Standard",
     "LowPriority", "Spot".
    :type vm_tier: str or ~azure.mgmt.machinelearningservices.models.VMTier
    """

    _validation = {
        'retail_price': {'required': True},
        'os_type': {'required': True},
        'vm_tier': {'required': True},
    }

    _attribute_map = {
        'retail_price': {'key': 'retailPrice', 'type': 'float'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'vm_tier': {'key': 'vmTier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EstimatedVMPrice, self).__init__(**kwargs)
        self.retail_price = kwargs['retail_price']
        self.os_type = kwargs['os_type']
        self.vm_tier = kwargs['vm_tier']


class EstimatedVMPrices(msrest.serialization.Model):
    """The estimated price info for using a VM.

    All required parameters must be populated in order to send to Azure.

    :param billing_currency: Required. Three lettered code specifying the currency of the VM price.
     Example: USD. Possible values include: "USD".
    :type billing_currency: str or ~azure.mgmt.machinelearningservices.models.BillingCurrency
    :param unit_of_measure: Required. The unit of time measurement for the specified VM price.
     Example: OneHour. Possible values include: "OneHour".
    :type unit_of_measure: str or ~azure.mgmt.machinelearningservices.models.UnitOfMeasure
    :param values: Required. The list of estimated prices for using a VM of a particular OS type,
     tier, etc.
    :type values: list[~azure.mgmt.machinelearningservices.models.EstimatedVMPrice]
    """

    _validation = {
        'billing_currency': {'required': True},
        'unit_of_measure': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'billing_currency': {'key': 'billingCurrency', 'type': 'str'},
        'unit_of_measure': {'key': 'unitOfMeasure', 'type': 'str'},
        'values': {'key': 'values', 'type': '[EstimatedVMPrice]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EstimatedVMPrices, self).__init__(**kwargs)
        self.billing_currency = kwargs['billing_currency']
        self.unit_of_measure = kwargs['unit_of_measure']
        self.values = kwargs['values']


class HDInsight(Compute):
    """A HDInsight compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :param properties:
    :type properties: ~azure.mgmt.machinelearningservices.models.HDInsightProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'HDInsightProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsight, self).__init__(**kwargs)
        self.compute_type = 'HDInsight'  # type: str
        self.properties = kwargs.get('properties', None)


class HDInsightProperties(msrest.serialization.Model):
    """HDInsightProperties.

    :param ssh_port: Port open for ssh connections on the master node of the cluster.
    :type ssh_port: int
    :param address: Public IP address of the master node of the cluster.
    :type address: str
    :param administrator_account: Admin credentials for master node of the cluster.
    :type administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _attribute_map = {
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'address': {'key': 'address', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HDInsightProperties, self).__init__(**kwargs)
        self.ssh_port = kwargs.get('ssh_port', None)
        self.address = kwargs.get('address', None)
        self.administrator_account = kwargs.get('administrator_account', None)


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: Required. The identity type. Possible values include: "SystemAssigned",
     "UserAssigned", "SystemAssigned,UserAssigned", "None".
    :type type: str or ~azure.mgmt.machinelearningservices.models.ResourceIdentityType
    :param user_assigned_identities: The list of user identities associated with resource. The user
     identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.machinelearningservices.models.ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs['type']
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class KeyVaultProperties(msrest.serialization.Model):
    """KeyVaultProperties.

    All required parameters must be populated in order to send to Azure.

    :param key_vault_arm_id: Required. The ArmId of the keyVault where the customer owned
     encryption key is present.
    :type key_vault_arm_id: str
    :param key_identifier: Required. Key vault uri to access the encryption key.
    :type key_identifier: str
    :param identity_client_id: For future use - The client id of the identity which will be used to
     access key vault.
    :type identity_client_id: str
    """

    _validation = {
        'key_vault_arm_id': {'required': True},
        'key_identifier': {'required': True},
    }

    _attribute_map = {
        'key_vault_arm_id': {'key': 'keyVaultArmId', 'type': 'str'},
        'key_identifier': {'key': 'keyIdentifier', 'type': 'str'},
        'identity_client_id': {'key': 'identityClientId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_vault_arm_id = kwargs['key_vault_arm_id']
        self.key_identifier = kwargs['key_identifier']
        self.identity_client_id = kwargs.get('identity_client_id', None)


class ListAmlUserFeatureResult(msrest.serialization.Model):
    """The List Aml user feature operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML user facing features.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.AmlUserFeature]
    :ivar next_link: The URI to fetch the next page of AML user features information. Call
     ListNext() with this to fetch the next page of AML user features information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AmlUserFeature]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListAmlUserFeatureResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListUsagesResult(msrest.serialization.Model):
    """The List Usages operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of AML resource usages.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.Usage]
    :ivar next_link: The URI to fetch the next page of AML resource usage information. Call
     ListNext() with this to fetch the next page of AML resource usage information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListUsagesResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class ListWorkspaceKeysResult(msrest.serialization.Model):
    """ListWorkspaceKeysResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar user_storage_key:
    :vartype user_storage_key: str
    :ivar user_storage_resource_id:
    :vartype user_storage_resource_id: str
    :ivar app_insights_instrumentation_key:
    :vartype app_insights_instrumentation_key: str
    :ivar container_registry_credentials:
    :vartype container_registry_credentials:
     ~azure.mgmt.machinelearningservices.models.RegistryListCredentialsResult
    :param notebook_access_keys:
    :type notebook_access_keys:
     ~azure.mgmt.machinelearningservices.models.NotebookListCredentialsResult
    """

    _validation = {
        'user_storage_key': {'readonly': True},
        'user_storage_resource_id': {'readonly': True},
        'app_insights_instrumentation_key': {'readonly': True},
        'container_registry_credentials': {'readonly': True},
    }

    _attribute_map = {
        'user_storage_key': {'key': 'userStorageKey', 'type': 'str'},
        'user_storage_resource_id': {'key': 'userStorageResourceId', 'type': 'str'},
        'app_insights_instrumentation_key': {'key': 'appInsightsInstrumentationKey', 'type': 'str'},
        'container_registry_credentials': {'key': 'containerRegistryCredentials', 'type': 'RegistryListCredentialsResult'},
        'notebook_access_keys': {'key': 'notebookAccessKeys', 'type': 'NotebookListCredentialsResult'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListWorkspaceKeysResult, self).__init__(**kwargs)
        self.user_storage_key = None
        self.user_storage_resource_id = None
        self.app_insights_instrumentation_key = None
        self.container_registry_credentials = None
        self.notebook_access_keys = kwargs.get('notebook_access_keys', None)


class ListWorkspaceQuotas(msrest.serialization.Model):
    """The List WorkspaceQuotasByVMFamily operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Workspace Quotas by VM Family.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.ResourceQuota]
    :ivar next_link: The URI to fetch the next page of workspace quota information by VM Family.
     Call ListNext() with this to fetch the next page of Workspace Quota information.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ResourceQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ListWorkspaceQuotas, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class MachineLearningServiceError(msrest.serialization.Model):
    """Wrapper for error response to follow ARM guidelines.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error: The error response.
    :vartype error: ~azure.mgmt.machinelearningservices.models.ErrorResponse
    """

    _validation = {
        'error': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MachineLearningServiceError, self).__init__(**kwargs)
        self.error = None


class NodeStateCounts(msrest.serialization.Model):
    """Counts of various compute node states on the amlCompute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar idle_node_count: Number of compute nodes in idle state.
    :vartype idle_node_count: int
    :ivar running_node_count: Number of compute nodes which are running jobs.
    :vartype running_node_count: int
    :ivar preparing_node_count: Number of compute nodes which are being prepared.
    :vartype preparing_node_count: int
    :ivar unusable_node_count: Number of compute nodes which are in unusable state.
    :vartype unusable_node_count: int
    :ivar leaving_node_count: Number of compute nodes which are leaving the amlCompute.
    :vartype leaving_node_count: int
    :ivar preempted_node_count: Number of compute nodes which are in preempted state.
    :vartype preempted_node_count: int
    """

    _validation = {
        'idle_node_count': {'readonly': True},
        'running_node_count': {'readonly': True},
        'preparing_node_count': {'readonly': True},
        'unusable_node_count': {'readonly': True},
        'leaving_node_count': {'readonly': True},
        'preempted_node_count': {'readonly': True},
    }

    _attribute_map = {
        'idle_node_count': {'key': 'idleNodeCount', 'type': 'int'},
        'running_node_count': {'key': 'runningNodeCount', 'type': 'int'},
        'preparing_node_count': {'key': 'preparingNodeCount', 'type': 'int'},
        'unusable_node_count': {'key': 'unusableNodeCount', 'type': 'int'},
        'leaving_node_count': {'key': 'leavingNodeCount', 'type': 'int'},
        'preempted_node_count': {'key': 'preemptedNodeCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NodeStateCounts, self).__init__(**kwargs)
        self.idle_node_count = None
        self.running_node_count = None
        self.preparing_node_count = None
        self.unusable_node_count = None
        self.leaving_node_count = None
        self.preempted_node_count = None


class NotebookListCredentialsResult(msrest.serialization.Model):
    """NotebookListCredentialsResult.

    :param primary_access_key:
    :type primary_access_key: str
    :param secondary_access_key:
    :type secondary_access_key: str
    """

    _attribute_map = {
        'primary_access_key': {'key': 'primaryAccessKey', 'type': 'str'},
        'secondary_access_key': {'key': 'secondaryAccessKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookListCredentialsResult, self).__init__(**kwargs)
        self.primary_access_key = kwargs.get('primary_access_key', None)
        self.secondary_access_key = kwargs.get('secondary_access_key', None)


class NotebookPreparationError(msrest.serialization.Model):
    """NotebookPreparationError.

    :param error_message:
    :type error_message: str
    :param status_code:
    :type status_code: int
    """

    _attribute_map = {
        'error_message': {'key': 'errorMessage', 'type': 'str'},
        'status_code': {'key': 'statusCode', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookPreparationError, self).__init__(**kwargs)
        self.error_message = kwargs.get('error_message', None)
        self.status_code = kwargs.get('status_code', None)


class NotebookResourceInfo(msrest.serialization.Model):
    """NotebookResourceInfo.

    :param fqdn:
    :type fqdn: str
    :param resource_id: the data plane resourceId that used to initialize notebook component.
    :type resource_id: str
    :param notebook_preparation_error: The error that occurs when preparing notebook.
    :type notebook_preparation_error:
     ~azure.mgmt.machinelearningservices.models.NotebookPreparationError
    """

    _attribute_map = {
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'notebook_preparation_error': {'key': 'notebookPreparationError', 'type': 'NotebookPreparationError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(NotebookResourceInfo, self).__init__(**kwargs)
        self.fqdn = kwargs.get('fqdn', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.notebook_preparation_error = kwargs.get('notebook_preparation_error', None)


class Operation(msrest.serialization.Model):
    """Azure Machine Learning workspace REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: Display name of operation.
    :type display: ~azure.mgmt.machinelearningservices.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(msrest.serialization.Model):
    """Display name of operation.

    :param provider: The resource provider name: Microsoft.MachineLearningExperimentation.
    :type provider: str
    :param resource: The resource on which the operation is performed.
    :type resource: str
    :param operation: The operation that users can perform.
    :type operation: str
    :param description: The description for the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """An array of operations supported by the resource provider.

    :param value: List of AML workspace operations supported by the AML workspace resource
     provider.
    :type value: list[~azure.mgmt.machinelearningservices.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PaginatedComputeResourcesList(msrest.serialization.Model):
    """Paginated list of Machine Learning compute objects wrapped in ARM resource envelope.

    :param value: An array of Machine Learning compute objects wrapped in ARM resource envelope.
    :type value: list[~azure.mgmt.machinelearningservices.models.ComputeResource]
    :param next_link: A continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ComputeResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PaginatedComputeResourcesList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PaginatedWorkspaceConnectionsList(msrest.serialization.Model):
    """Paginated list of Workspace connection objects.

    :param value: An array of Workspace connection objects.
    :type value: list[~azure.mgmt.machinelearningservices.models.WorkspaceConnection]
    :param next_link: A continuation link (absolute URI) to the next page of results in the list.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkspaceConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PaginatedWorkspaceConnectionsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Password(msrest.serialization.Model):
    """Password.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name:
    :vartype name: str
    :ivar value:
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Password, self).__init__(**kwargs)
        self.name = None
        self.value = None


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(msrest.serialization.Model):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ResourceId of the private endpoint connection.
    :vartype id: str
    :ivar name: Friendly name of the private endpoint connection.
    :vartype name: str
    :ivar type: Resource type of private endpoint connection.
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~azure.mgmt.machinelearningservices.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.machinelearningservices.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = None


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.machinelearningservices.models.Identity
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: A set of tags. Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param sku: The sku of the workspace.
    :type sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = kwargs.get('required_zone_names', None)


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~azure.mgmt.machinelearningservices.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected", "Disconnected",
     "Timeout".
    :type status: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)
        self.actions_required = kwargs.get('actions_required', None)


class QuotaBaseProperties(msrest.serialization.Model):
    """The properties for Quota update or retrieval.

    :param id: Specifies the resource ID.
    :type id: str
    :param type: Specifies the resource type.
    :type type: str
    :param limit: The maximum permitted quota of the resource.
    :type limit: long
    :param unit: An enum describing the unit of quota measurement. Possible values include:
     "Count".
    :type unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaBaseProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.type = kwargs.get('type', None)
        self.limit = kwargs.get('limit', None)
        self.unit = kwargs.get('unit', None)


class QuotaUpdateParameters(msrest.serialization.Model):
    """Quota update parameters.

    :param value: The list for update quota.
    :type value: list[~azure.mgmt.machinelearningservices.models.QuotaBaseProperties]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[QuotaBaseProperties]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(QuotaUpdateParameters, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class RegistryListCredentialsResult(msrest.serialization.Model):
    """RegistryListCredentialsResult.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location:
    :vartype location: str
    :ivar username:
    :vartype username: str
    :param passwords:
    :type passwords: list[~azure.mgmt.machinelearningservices.models.Password]
    """

    _validation = {
        'location': {'readonly': True},
        'username': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'passwords': {'key': 'passwords', 'type': '[Password]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RegistryListCredentialsResult, self).__init__(**kwargs)
        self.location = None
        self.username = None
        self.passwords = kwargs.get('passwords', None)


class ResourceId(msrest.serialization.Model):
    """Represents a resource ID. For example, for a subnet, it is the resource URL for the subnet.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the resource.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceId, self).__init__(**kwargs)
        self.id = kwargs['id']


class ResourceName(msrest.serialization.Model):
    """The Resource Name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class ResourceQuota(msrest.serialization.Model):
    """The quota assigned to a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar name: Name of the resource.
    :vartype name: ~azure.mgmt.machinelearningservices.models.ResourceName
    :ivar limit: The maximum permitted quota of the resource.
    :vartype limit: long
    :ivar unit: An enum describing the unit of quota measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'limit': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'ResourceName'},
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceQuota, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.limit = None
        self.unit = None


class ResourceSkuLocationInfo(msrest.serialization.Model):
    """ResourceSkuLocationInfo.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location of the SKU.
    :vartype location: str
    :ivar zones: List of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Details of capabilities available to a SKU in specific zones.
    :vartype zone_details: list[~azure.mgmt.machinelearningservices.models.ResourceSkuZoneDetails]
    """

    _validation = {
        'location': {'readonly': True},
        'zones': {'readonly': True},
        'zone_details': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'zone_details': {'key': 'zoneDetails', 'type': '[ResourceSkuZoneDetails]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuLocationInfo, self).__init__(**kwargs)
        self.location = None
        self.zones = None
        self.zone_details = None


class ResourceSkuZoneDetails(msrest.serialization.Model):
    """Describes The zonal capabilities of a SKU.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The set of zones that the SKU is available in with the specified capabilities.
    :vartype name: list[str]
    :ivar capabilities: A list of capabilities that are available for the SKU in the specified list
     of zones.
    :vartype capabilities: list[~azure.mgmt.machinelearningservices.models.SKUCapability]
    """

    _validation = {
        'name': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': '[str]'},
        'capabilities': {'key': 'capabilities', 'type': '[SKUCapability]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceSkuZoneDetails, self).__init__(**kwargs)
        self.name = None
        self.capabilities = None


class Restriction(msrest.serialization.Model):
    """The restriction because of which SKU cannot be used.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of restrictions. As of now only possible value for this is location.
    :vartype type: str
    :ivar values: The value of restrictions. If the restriction type is set to location. This would
     be different locations where the SKU is restricted.
    :vartype values: list[str]
    :param reason_code: The reason for the restriction. Possible values include: "NotSpecified",
     "NotAvailableForRegion", "NotAvailableForSubscription".
    :type reason_code: str or ~azure.mgmt.machinelearningservices.models.ReasonCode
    """

    _validation = {
        'type': {'readonly': True},
        'values': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
        'reason_code': {'key': 'reasonCode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Restriction, self).__init__(**kwargs)
        self.type = None
        self.values = None
        self.reason_code = kwargs.get('reason_code', None)


class ScaleSettings(msrest.serialization.Model):
    """scale settings for AML Compute.

    All required parameters must be populated in order to send to Azure.

    :param max_node_count: Required. Max number of nodes to use.
    :type max_node_count: int
    :param min_node_count: Min number of nodes to use.
    :type min_node_count: int
    :param node_idle_time_before_scale_down: Node Idle Time before scaling down amlCompute.
    :type node_idle_time_before_scale_down: ~datetime.timedelta
    """

    _validation = {
        'max_node_count': {'required': True},
    }

    _attribute_map = {
        'max_node_count': {'key': 'maxNodeCount', 'type': 'int'},
        'min_node_count': {'key': 'minNodeCount', 'type': 'int'},
        'node_idle_time_before_scale_down': {'key': 'nodeIdleTimeBeforeScaleDown', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleSettings, self).__init__(**kwargs)
        self.max_node_count = kwargs['max_node_count']
        self.min_node_count = kwargs.get('min_node_count', 0)
        self.node_idle_time_before_scale_down = kwargs.get('node_idle_time_before_scale_down', None)


class ServicePrincipalCredentials(msrest.serialization.Model):
    """Service principal credentials.

    All required parameters must be populated in order to send to Azure.

    :param client_id: Required. Client Id.
    :type client_id: str
    :param client_secret: Required. Client secret.
    :type client_secret: str
    """

    _validation = {
        'client_id': {'required': True},
        'client_secret': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'client_secret': {'key': 'clientSecret', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServicePrincipalCredentials, self).__init__(**kwargs)
        self.client_id = kwargs['client_id']
        self.client_secret = kwargs['client_secret']


class SharedPrivateLinkResource(msrest.serialization.Model):
    """SharedPrivateLinkResource.

    :param name: Unique name of the private link.
    :type name: str
    :param private_link_resource_id: The resource id that private link links to.
    :type private_link_resource_id: str
    :param group_id: The private link resource group id.
    :type group_id: str
    :param request_message: Request message.
    :type request_message: str
    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected", "Disconnected",
     "Timeout".
    :type status: str or
     ~azure.mgmt.machinelearningservices.models.PrivateEndpointServiceConnectionStatus
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'private_link_resource_id': {'key': 'properties.privateLinkResourceId', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'request_message': {'key': 'properties.requestMessage', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SharedPrivateLinkResource, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.private_link_resource_id = kwargs.get('private_link_resource_id', None)
        self.group_id = kwargs.get('group_id', None)
        self.request_message = kwargs.get('request_message', None)
        self.status = kwargs.get('status', None)


class Sku(msrest.serialization.Model):
    """Sku of the resource.

    :param name: Name of the sku.
    :type name: str
    :param tier: Tier of the sku like Basic or Enterprise.
    :type tier: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)


class SKUCapability(msrest.serialization.Model):
    """Features/user capabilities associated with the sku.

    :param name: Capability/Feature ID.
    :type name: str
    :param value: Details about the feature/capability.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SKUCapability, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class SkuListResult(msrest.serialization.Model):
    """List of skus with features.

    :param value:
    :type value: list[~azure.mgmt.machinelearningservices.models.WorkspaceSku]
    :param next_link: The URI to fetch the next page of Workspace Skus. Call ListNext() with this
     URI to fetch the next page of Workspace Skus.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[WorkspaceSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class SkuSettings(msrest.serialization.Model):
    """Describes Workspace Sku details and features.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar locations: The set of locations that the SKU is available. This will be supported and
     registered Azure Geo Regions (e.g. West US, East US, Southeast Asia, etc.).
    :vartype locations: list[str]
    :ivar location_info: A list of locations and availability zones in those locations where the
     SKU is available.
    :vartype location_info:
     list[~azure.mgmt.machinelearningservices.models.ResourceSkuLocationInfo]
    :ivar tier: Sku Tier like Basic or Enterprise.
    :vartype tier: str
    :ivar resource_type:
    :vartype resource_type: str
    :ivar name:
    :vartype name: str
    :ivar capabilities: List of features/user capabilities associated with the sku.
    :vartype capabilities: list[~azure.mgmt.machinelearningservices.models.SKUCapability]
    :param restrictions: The restrictions because of which SKU cannot be used. This is empty if
     there are no restrictions.
    :type restrictions: list[~azure.mgmt.machinelearningservices.models.Restriction]
    """

    _validation = {
        'locations': {'readonly': True},
        'location_info': {'readonly': True},
        'tier': {'readonly': True},
        'resource_type': {'readonly': True},
        'name': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'locations': {'key': 'locations', 'type': '[str]'},
        'location_info': {'key': 'locationInfo', 'type': '[ResourceSkuLocationInfo]'},
        'tier': {'key': 'tier', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': '[SKUCapability]'},
        'restrictions': {'key': 'restrictions', 'type': '[Restriction]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SkuSettings, self).__init__(**kwargs)
        self.locations = None
        self.location_info = None
        self.tier = None
        self.resource_type = None
        self.name = None
        self.capabilities = None
        self.restrictions = kwargs.get('restrictions', None)


class SslConfiguration(msrest.serialization.Model):
    """The ssl configuration for scoring.

    :param status: Enable or disable ssl for scoring. Possible values include: "Disabled",
     "Enabled".
    :type status: str or ~azure.mgmt.machinelearningservices.models.SslConfigurationStatus
    :param cert: Cert data.
    :type cert: str
    :param key: Key data.
    :type key: str
    :param cname: CNAME of the cert.
    :type cname: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'cert': {'key': 'cert', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'cname': {'key': 'cname', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SslConfiguration, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.cert = kwargs.get('cert', None)
        self.key = kwargs.get('key', None)
        self.cname = kwargs.get('cname', None)


class SystemService(msrest.serialization.Model):
    """A system service running on a compute.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar system_service_type: The type of this system service.
    :vartype system_service_type: str
    :ivar public_ip_address: Public IP address.
    :vartype public_ip_address: str
    :ivar version: The version for this type.
    :vartype version: str
    """

    _validation = {
        'system_service_type': {'readonly': True},
        'public_ip_address': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'system_service_type': {'key': 'systemServiceType', 'type': 'str'},
        'public_ip_address': {'key': 'publicIpAddress', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemService, self).__init__(**kwargs)
        self.system_service_type = None
        self.public_ip_address = None
        self.version = None


class UpdateWorkspaceQuotas(msrest.serialization.Model):
    """The properties for update Quota response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :param limit: The maximum permitted quota of the resource.
    :type limit: long
    :ivar unit: An enum describing the unit of quota measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.QuotaUnit
    :param status: Status of update workspace quota. Possible values include: "Undefined",
     "Success", "Failure", "InvalidQuotaBelowClusterMinimum",
     "InvalidQuotaExceedsSubscriptionLimit", "InvalidVMFamilyName", "OperationNotSupportedForSku",
     "OperationNotEnabledForRegion".
    :type status: str or ~azure.mgmt.machinelearningservices.models.Status
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'limit': {'key': 'limit', 'type': 'long'},
        'unit': {'key': 'unit', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateWorkspaceQuotas, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.limit = kwargs.get('limit', None)
        self.unit = None
        self.status = kwargs.get('status', None)


class UpdateWorkspaceQuotasResult(msrest.serialization.Model):
    """The result of update workspace quota.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of workspace quota update result.
    :vartype value: list[~azure.mgmt.machinelearningservices.models.UpdateWorkspaceQuotas]
    :ivar next_link: The URI to fetch the next page of workspace quota update result. Call
     ListNext() with this to fetch the next page of Workspace Quota update result.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpdateWorkspaceQuotas]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateWorkspaceQuotasResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Usage(msrest.serialization.Model):
    """Describes AML Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar type: Specifies the resource type.
    :vartype type: str
    :ivar unit: An enum describing the unit of usage measurement. Possible values include: "Count".
    :vartype unit: str or ~azure.mgmt.machinelearningservices.models.UsageUnit
    :ivar current_value: The current usage of the resource.
    :vartype current_value: long
    :ivar limit: The maximum permitted usage of the resource.
    :vartype limit: long
    :ivar name: The name of the type of usage.
    :vartype name: ~azure.mgmt.machinelearningservices.models.UsageName
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'unit': {'readonly': True},
        'current_value': {'readonly': True},
        'limit': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.unit = None
        self.current_value = None
        self.limit = None
        self.name = None


class UsageName(msrest.serialization.Model):
    """The Usage Names.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The name of the resource.
    :vartype value: str
    :ivar localized_value: The localized name of the resource.
    :vartype localized_value: str
    """

    _validation = {
        'value': {'readonly': True},
        'localized_value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = None
        self.localized_value = None


class UserAccountCredentials(msrest.serialization.Model):
    """Settings for user account that gets created on each on the nodes of a compute.

    All required parameters must be populated in order to send to Azure.

    :param admin_user_name: Required. Name of the administrator user account which can be used to
     SSH to nodes.
    :type admin_user_name: str
    :param admin_user_ssh_public_key: SSH public key of the administrator user account.
    :type admin_user_ssh_public_key: str
    :param admin_user_password: Password of the administrator user account.
    :type admin_user_password: str
    """

    _validation = {
        'admin_user_name': {'required': True},
    }

    _attribute_map = {
        'admin_user_name': {'key': 'adminUserName', 'type': 'str'},
        'admin_user_ssh_public_key': {'key': 'adminUserSshPublicKey', 'type': 'str'},
        'admin_user_password': {'key': 'adminUserPassword', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserAccountCredentials, self).__init__(**kwargs)
        self.admin_user_name = kwargs['admin_user_name']
        self.admin_user_ssh_public_key = kwargs.get('admin_user_ssh_public_key', None)
        self.admin_user_password = kwargs.get('admin_user_password', None)


class VirtualMachine(Compute):
    """A Machine Learning compute based on Azure Virtual Machines.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param compute_location: Location for the underlying compute.
    :type compute_location: str
    :ivar provisioning_state: The provision state of the cluster. Valid values are Unknown,
     Updating, Provisioning, Succeeded, and Failed. Possible values include: "Unknown", "Updating",
     "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param description: The description of the Machine Learning compute.
    :type description: str
    :ivar created_on: The date and time when the compute was created.
    :vartype created_on: ~datetime.datetime
    :ivar modified_on: The date and time when the compute was last modified.
    :vartype modified_on: ~datetime.datetime
    :param resource_id: ARM resource id of the underlying compute.
    :type resource_id: str
    :ivar provisioning_errors: Errors during provisioning.
    :vartype provisioning_errors:
     list[~azure.mgmt.machinelearningservices.models.MachineLearningServiceError]
    :ivar is_attached_compute: Indicating whether the compute was provisioned by user and brought
     from outside if true, or machine learning service provisioned it if false.
    :vartype is_attached_compute: bool
    :param properties:
    :type properties: ~azure.mgmt.machinelearningservices.models.VirtualMachineProperties
    """

    _validation = {
        'compute_type': {'required': True},
        'provisioning_state': {'readonly': True},
        'created_on': {'readonly': True},
        'modified_on': {'readonly': True},
        'provisioning_errors': {'readonly': True},
        'is_attached_compute': {'readonly': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'compute_location': {'key': 'computeLocation', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'created_on': {'key': 'createdOn', 'type': 'iso-8601'},
        'modified_on': {'key': 'modifiedOn', 'type': 'iso-8601'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'provisioning_errors': {'key': 'provisioningErrors', 'type': '[MachineLearningServiceError]'},
        'is_attached_compute': {'key': 'isAttachedCompute', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'VirtualMachineProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachine, self).__init__(**kwargs)
        self.compute_type = 'VirtualMachine'  # type: str
        self.properties = kwargs.get('properties', None)


class VirtualMachineProperties(msrest.serialization.Model):
    """VirtualMachineProperties.

    :param virtual_machine_size: Virtual Machine size.
    :type virtual_machine_size: str
    :param ssh_port: Port open for ssh connections.
    :type ssh_port: int
    :param address: Public IP address of the virtual machine.
    :type address: str
    :param administrator_account: Admin credentials for virtual machine.
    :type administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _attribute_map = {
        'virtual_machine_size': {'key': 'virtualMachineSize', 'type': 'str'},
        'ssh_port': {'key': 'sshPort', 'type': 'int'},
        'address': {'key': 'address', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineProperties, self).__init__(**kwargs)
        self.virtual_machine_size = kwargs.get('virtual_machine_size', None)
        self.ssh_port = kwargs.get('ssh_port', None)
        self.address = kwargs.get('address', None)
        self.administrator_account = kwargs.get('administrator_account', None)


class VirtualMachineSecrets(ComputeSecrets):
    """Secrets related to a Machine Learning compute based on AKS.

    All required parameters must be populated in order to send to Azure.

    :param compute_type: Required. The type of compute.Constant filled by server.  Possible values
     include: "AKS", "AmlCompute", "ComputeInstance", "DataFactory", "VirtualMachine", "HDInsight",
     "Databricks", "DataLakeAnalytics".
    :type compute_type: str or ~azure.mgmt.machinelearningservices.models.ComputeType
    :param administrator_account: Admin credentials for virtual machine.
    :type administrator_account:
     ~azure.mgmt.machinelearningservices.models.VirtualMachineSshCredentials
    """

    _validation = {
        'compute_type': {'required': True},
    }

    _attribute_map = {
        'compute_type': {'key': 'computeType', 'type': 'str'},
        'administrator_account': {'key': 'administratorAccount', 'type': 'VirtualMachineSshCredentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineSecrets, self).__init__(**kwargs)
        self.compute_type = 'VirtualMachine'  # type: str
        self.administrator_account = kwargs.get('administrator_account', None)


class VirtualMachineSize(msrest.serialization.Model):
    """Describes the properties of a VM size.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the virtual machine size.
    :vartype name: str
    :ivar family: The family name of the virtual machine size.
    :vartype family: str
    :ivar v_cp_us: The number of vCPUs supported by the virtual machine size.
    :vartype v_cp_us: int
    :ivar gpus: The number of gPUs supported by the virtual machine size.
    :vartype gpus: int
    :ivar os_vhd_size_mb: The OS VHD disk size, in MB, allowed by the virtual machine size.
    :vartype os_vhd_size_mb: int
    :ivar max_resource_volume_mb: The resource volume size, in MB, allowed by the virtual machine
     size.
    :vartype max_resource_volume_mb: int
    :ivar memory_gb: The amount of memory, in GB, supported by the virtual machine size.
    :vartype memory_gb: float
    :ivar low_priority_capable: Specifies if the virtual machine size supports low priority VMs.
    :vartype low_priority_capable: bool
    :ivar premium_io: Specifies if the virtual machine size supports premium IO.
    :vartype premium_io: bool
    :param estimated_vm_prices: The estimated price information for using a VM.
    :type estimated_vm_prices: ~azure.mgmt.machinelearningservices.models.EstimatedVMPrices
    :param supported_compute_types: Specifies the compute types supported by the virtual machine
     size.
    :type supported_compute_types: list[str]
    """

    _validation = {
        'name': {'readonly': True},
        'family': {'readonly': True},
        'v_cp_us': {'readonly': True},
        'gpus': {'readonly': True},
        'os_vhd_size_mb': {'readonly': True},
        'max_resource_volume_mb': {'readonly': True},
        'memory_gb': {'readonly': True},
        'low_priority_capable': {'readonly': True},
        'premium_io': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'v_cp_us': {'key': 'vCPUs', 'type': 'int'},
        'gpus': {'key': 'gpus', 'type': 'int'},
        'os_vhd_size_mb': {'key': 'osVhdSizeMB', 'type': 'int'},
        'max_resource_volume_mb': {'key': 'maxResourceVolumeMB', 'type': 'int'},
        'memory_gb': {'key': 'memoryGB', 'type': 'float'},
        'low_priority_capable': {'key': 'lowPriorityCapable', 'type': 'bool'},
        'premium_io': {'key': 'premiumIO', 'type': 'bool'},
        'estimated_vm_prices': {'key': 'estimatedVMPrices', 'type': 'EstimatedVMPrices'},
        'supported_compute_types': {'key': 'supportedComputeTypes', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineSize, self).__init__(**kwargs)
        self.name = None
        self.family = None
        self.v_cp_us = None
        self.gpus = None
        self.os_vhd_size_mb = None
        self.max_resource_volume_mb = None
        self.memory_gb = None
        self.low_priority_capable = None
        self.premium_io = None
        self.estimated_vm_prices = kwargs.get('estimated_vm_prices', None)
        self.supported_compute_types = kwargs.get('supported_compute_types', None)


class VirtualMachineSizeListResult(msrest.serialization.Model):
    """The List Virtual Machine size operation response.

    :param aml_compute: The list of virtual machine sizes supported by AmlCompute.
    :type aml_compute: list[~azure.mgmt.machinelearningservices.models.VirtualMachineSize]
    """

    _attribute_map = {
        'aml_compute': {'key': 'amlCompute', 'type': '[VirtualMachineSize]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineSizeListResult, self).__init__(**kwargs)
        self.aml_compute = kwargs.get('aml_compute', None)


class VirtualMachineSshCredentials(msrest.serialization.Model):
    """Admin credentials for virtual machine.

    :param username: Username of admin account.
    :type username: str
    :param password: Password of admin account.
    :type password: str
    :param public_key_data: Public key data.
    :type public_key_data: str
    :param private_key_data: Private key data.
    :type private_key_data: str
    """

    _attribute_map = {
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'public_key_data': {'key': 'publicKeyData', 'type': 'str'},
        'private_key_data': {'key': 'privateKeyData', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineSshCredentials, self).__init__(**kwargs)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.public_key_data = kwargs.get('public_key_data', None)
        self.private_key_data = kwargs.get('private_key_data', None)


class Workspace(Resource):
    """An object that represents a machine learning workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Specifies the resource ID.
    :vartype id: str
    :ivar name: Specifies the name of the resource.
    :vartype name: str
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.machinelearningservices.models.Identity
    :param location: Specifies the location of the resource.
    :type location: str
    :ivar type: Specifies the type of the resource.
    :vartype type: str
    :param tags: A set of tags. Contains resource tags defined as key/value pairs.
    :type tags: dict[str, str]
    :param sku: The sku of the workspace.
    :type sku: ~azure.mgmt.machinelearningservices.models.Sku
    :ivar workspace_id: The immutable id associated with this workspace.
    :vartype workspace_id: str
    :param description: The description of this workspace.
    :type description: str
    :param friendly_name: The friendly name for this workspace. This name in mutable.
    :type friendly_name: str
    :ivar creation_time: The creation time of the machine learning workspace in ISO8601 format.
    :vartype creation_time: ~datetime.datetime
    :param key_vault: ARM id of the key vault associated with this workspace. This cannot be
     changed once the workspace has been created.
    :type key_vault: str
    :param application_insights: ARM id of the application insights associated with this workspace.
     This cannot be changed once the workspace has been created.
    :type application_insights: str
    :param container_registry: ARM id of the container registry associated with this workspace.
     This cannot be changed once the workspace has been created.
    :type container_registry: str
    :param storage_account: ARM id of the storage account associated with this workspace. This
     cannot be changed once the workspace has been created.
    :type storage_account: str
    :param discovery_url: Url for the discovery service to identify regional endpoints for machine
     learning experimentation services.
    :type discovery_url: str
    :ivar provisioning_state: The current deployment state of workspace resource. The
     provisioningState is to indicate states for resource provisioning. Possible values include:
     "Unknown", "Updating", "Creating", "Deleting", "Succeeded", "Failed", "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.machinelearningservices.models.ProvisioningState
    :param encryption: The encryption settings of Azure ML workspace.
    :type encryption: ~azure.mgmt.machinelearningservices.models.EncryptionProperty
    :param hbi_workspace: The flag to signal HBI data in the workspace and reduce diagnostic data
     collected by the service.
    :type hbi_workspace: bool
    :ivar service_provisioned_resource_group: The name of the managed resource group created by
     workspace RP in customer subscription if the workspace is CMK workspace.
    :vartype service_provisioned_resource_group: str
    :ivar private_link_count: Count of private connections in the workspace.
    :vartype private_link_count: int
    :param image_build_compute: The compute name for image build.
    :type image_build_compute: str
    :param allow_public_access_when_behind_vnet: The flag to indicate whether to allow public
     access when behind VNet.
    :type allow_public_access_when_behind_vnet: bool
    :ivar private_endpoint_connections: The list of private endpoint connections in the workspace.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.machinelearningservices.models.PrivateEndpointConnection]
    :param shared_private_link_resources: The list of shared private link resources in this
     workspace.
    :type shared_private_link_resources:
     list[~azure.mgmt.machinelearningservices.models.SharedPrivateLinkResource]
    :ivar notebook_info: The notebook info of Azure ML workspace.
    :vartype notebook_info: ~azure.mgmt.machinelearningservices.models.NotebookResourceInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'workspace_id': {'readonly': True},
        'creation_time': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'service_provisioned_resource_group': {'readonly': True},
        'private_link_count': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
        'notebook_info': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'location': {'key': 'location', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'key_vault': {'key': 'properties.keyVault', 'type': 'str'},
        'application_insights': {'key': 'properties.applicationInsights', 'type': 'str'},
        'container_registry': {'key': 'properties.containerRegistry', 'type': 'str'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'str'},
        'discovery_url': {'key': 'properties.discoveryUrl', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'encryption': {'key': 'properties.encryption', 'type': 'EncryptionProperty'},
        'hbi_workspace': {'key': 'properties.hbiWorkspace', 'type': 'bool'},
        'service_provisioned_resource_group': {'key': 'properties.serviceProvisionedResourceGroup', 'type': 'str'},
        'private_link_count': {'key': 'properties.privateLinkCount', 'type': 'int'},
        'image_build_compute': {'key': 'properties.imageBuildCompute', 'type': 'str'},
        'allow_public_access_when_behind_vnet': {'key': 'properties.allowPublicAccessWhenBehindVnet', 'type': 'bool'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'shared_private_link_resources': {'key': 'properties.sharedPrivateLinkResources', 'type': '[SharedPrivateLinkResource]'},
        'notebook_info': {'key': 'properties.notebookInfo', 'type': 'NotebookResourceInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Workspace, self).__init__(**kwargs)
        self.workspace_id = None
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.creation_time = None
        self.key_vault = kwargs.get('key_vault', None)
        self.application_insights = kwargs.get('application_insights', None)
        self.container_registry = kwargs.get('container_registry', None)
        self.storage_account = kwargs.get('storage_account', None)
        self.discovery_url = kwargs.get('discovery_url', None)
        self.provisioning_state = None
        self.encryption = kwargs.get('encryption', None)
        self.hbi_workspace = kwargs.get('hbi_workspace', False)
        self.service_provisioned_resource_group = None
        self.private_link_count = None
        self.image_build_compute = kwargs.get('image_build_compute', None)
        self.allow_public_access_when_behind_vnet = kwargs.get('allow_public_access_when_behind_vnet', False)
        self.private_endpoint_connections = None
        self.shared_private_link_resources = kwargs.get('shared_private_link_resources', None)
        self.notebook_info = None


class WorkspaceConnection(msrest.serialization.Model):
    """Workspace connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: ResourceId of the workspace connection.
    :vartype id: str
    :ivar name: Friendly name of the workspace connection.
    :vartype name: str
    :ivar type: Resource type of workspace connection.
    :vartype type: str
    :param category: Category of the workspace connection.
    :type category: str
    :param target: Target of the workspace connection.
    :type target: str
    :param auth_type: Authorization type of the workspace connection.
    :type auth_type: str
    :param value: Value details of the workspace connection.
    :type value: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'auth_type': {'key': 'properties.authType', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceConnection, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.category = kwargs.get('category', None)
        self.target = kwargs.get('target', None)
        self.auth_type = kwargs.get('auth_type', None)
        self.value = kwargs.get('value', None)


class WorkspaceConnectionDto(msrest.serialization.Model):
    """object used for creating workspace connection.

    :param name: Friendly name of the workspace connection.
    :type name: str
    :param category: Category of the workspace connection.
    :type category: str
    :param target: Target of the workspace connection.
    :type target: str
    :param auth_type: Authorization type of the workspace connection.
    :type auth_type: str
    :param value: Value details of the workspace connection.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'target': {'key': 'properties.target', 'type': 'str'},
        'auth_type': {'key': 'properties.authType', 'type': 'str'},
        'value': {'key': 'properties.value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceConnectionDto, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.category = kwargs.get('category', None)
        self.target = kwargs.get('target', None)
        self.auth_type = kwargs.get('auth_type', None)
        self.value = kwargs.get('value', None)


class WorkspaceListResult(msrest.serialization.Model):
    """The result of a request to list machine learning workspaces.

    :param value: The list of machine learning workspaces. Since this list may be incomplete, the
     nextLink field should be used to request the next list of machine learning workspaces.
    :type value: list[~azure.mgmt.machinelearningservices.models.Workspace]
    :param next_link: The URI that can be used to request the next list of machine learning
     workspaces.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workspace]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class WorkspaceSku(msrest.serialization.Model):
    """AML workspace sku information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type:
    :vartype resource_type: str
    :ivar skus: The list of workspace sku settings.
    :vartype skus: list[~azure.mgmt.machinelearningservices.models.SkuSettings]
    """

    _validation = {
        'resource_type': {'readonly': True},
        'skus': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'skus': {'key': 'skus', 'type': '[SkuSettings]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceSku, self).__init__(**kwargs)
        self.resource_type = None
        self.skus = None


class WorkspaceUpdateParameters(msrest.serialization.Model):
    """The parameters for updating a machine learning workspace.

    :param tags: A set of tags. The resource tags for the machine learning workspace.
    :type tags: dict[str, str]
    :param sku: The sku of the workspace.
    :type sku: ~azure.mgmt.machinelearningservices.models.Sku
    :param description: The description of this workspace.
    :type description: str
    :param friendly_name: The friendly name for this workspace.
    :type friendly_name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WorkspaceUpdateParameters, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.sku = kwargs.get('sku', None)
        self.description = kwargs.get('description', None)
        self.friendly_name = kwargs.get('friendly_name', None)
