from distutils.core import setup, Extension

encode = Extension('qr_encode', sources=['qr_encode.c'], libraries=['qrencode'])

classifiers = """
Development Status :: 4 - Beta
Intended Audience :: Developers
License :: OSI Approved :: Apache Software License
Operating System :: OS Independent
Programming Language :: Python
Topic :: Multimedia :: Graphics
Topic :: Printing
Topic :: Software Development :: Libraries
"""

setup(name='qrencode',
      version='1.01',
      description='Encodes QR-codes.',
      author='Nick Johnson',
      author_email='arachnid@notdot.net',
      url='http://github.com/Arachnid/pyqrencode/tree/master',
      long_description='''A simple wrapper for the C qrencode library.''',
      packages=['qrencode'],
      ext_modules=[encode],
      requires=['PIL'],
      license='http://www.apache.org/licenses/LICENSE-2.0',
      platforms=['any'],
      classifiers=filter(None, classifiers.split('\n')))
