/*
 * altirra_basic.c - BASIC ROM replacement
 *
 * Compiled from the sources in the emuos folder.
 *
 * Altirra BASIC, version 1.58
 * Copyright (C) 2008-2022 Avery Lee
 *
 * Copying and distribution of this file, with or without modification,
 * are permitted in any medium without royalty provided the copyright
 * notice and this notice are preserved.  This file is offered as-is,
 * without any warranty.
 */

#include "config.h"
#include "atari.h"

#if 1
UBYTE const ROM_altirra_basic[] =
{
	0xa6,0x08,0x30,0x45,0x38,0x26,0xb3,0x20,
	0x12,0xbb,0x4c,0x54,0xac,0x41,0x6c,0x74,
	0x69,0x72,0x72,0x61,0x20,0x38,0x4b,0x20,
	0x42,0x41,0x53,0x49,0x43,0x20,0x31,0x2e,
	0x35,0x38,0x00,0x9b,0x52,0x65,0x61,0x64,
	0x79,0x9b,0x00,0x9b,0x53,0x74,0x6f,0x70,
	0x70,0x65,0x64,0x00,0x9b,0x45,0x72,0x72,
	0x6f,0x72,0x2d,0x20,0x20,0x20,0x00,0x20,
	0x61,0x74,0x20,0x6c,0x69,0x6e,0x65,0x20,
	0x00,0x20,0x33,0xb1,0xa2,0x00,0x86,0xa6,
	0xa2,0x16,0x20,0x12,0xbb,0xa2,0xff,0x9a,
	0xe8,0x86,0xf2,0xe8,0x86,0xc2,0xa6,0xa6,
	0x20,0xa3,0xbb,0xf0,0x0b,0x20,0xb0,0xaa,
	0x20,0x07,0xa5,0x90,0xe8,0x4c,0x96,0xa8,
	0x20,0xd2,0xbb,0x4c,0x4c,0xa0,0x4c,0x6a,
	0x33,0x85,0x23,0x3a,0x42,0x16,0x1a,0x2e,
	0x2d,0x58,0x48,0x64,0x42,0x42,0x84,0x3b,
	0xa2,0xd4,0xb0,0x95,0x69,0xb3,0x3b,0x3b,
	0x3b,0x3b,0x41,0x41,0x4e,0x40,0x41,0x41,
	0x4e,0x45,0x41,0xd0,0xd4,0xd4,0x7d,0xb5,
	0xb5,0xcf,0xbb,0x3a,0xe8,0x41,0x8d,0x4b,
	0x41,0xe4,0x41,0x41,0xe8,0x7d,0x81,0x3b,
	0x3a,0x3a,0x41,0x3a,0x39,0xb1,0x38,0xee,
	0x41,0x41,0x00,0x00,0x00,0x00,0x00,0x00,
	0x41,0x41,0x3a,0x3b,0x00,0x00,0x00,0x3c,
	0x3c,0x00,0x41,0xd4,0xd4,0xd4,0xe4,0xd4,
	0x39,0x39,0x3b,0x39,0x3b,0xd6,0x31,0x31,
	0x29,0x25,0x25,0x25,0x25,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x00,0x00,
	0x00,0x00,0x00,0x20,0x00,0x31,0x00,0x1b,
	0x00,0x1b,0x1b,0x1b,0x1b,0x20,0x06,0x28,
	0x37,0x02,0x12,0x09,0x91,0x05,0xfb,0x87,
	0x05,0x16,0x0f,0x09,0x20,0x06,0x28,0x37,
	0xf3,0x09,0x10,0xf7,0x10,0xf6,0x00,0x10,
	0xe4,0x07,0x38,0x87,0x06,0x2c,0x3c,0xe7,
	0x29,0x07,0x2c,0x09,0x20,0x06,0x22,0x0f,
	0xe1,0x0c,0xe7,0x0b,0xe7,0x00,0x87,0x20,
	0x2c,0x07,0x12,0x09,0x03,0x03,0x87,0x01,
	0x09,0x89,0x09,0x14,0x02,0x0b,0x01,0x00,
	0x10,0xfd,0x09,0x20,0x23,0x07,0x1c,0x87,
	0x09,0x28,0x07,0x3a,0x09,0x20,0x06,0x9b,
	0x00,0x24,0x05,0x01,0x0e,0x20,0x02,0x07,
	0x36,0x14,0x03,0x0b,0x02,0x00,0x8f,0x20,
	0x3d,0x10,0x04,0x07,0x2d,0x87,0x82,0x07,
	0x2e,0x89,0x82,0x20,0x06,0x3a,0x14,0xe4,
	0x06,0x9b,0x16,0x01,0x00,0x0e,0x04,0x00,
	0x8f,0x10,0xfc,0x01,0x05,0x39,0x0d,0x37,
	0x87,0x29,0x13,0x2c,0x32,0x01,0x20,0x06,
	0x28,0x2b,0xf5,0x06,0x24,0x00,0xef,0x0a,
	0x26,0x06,0x2b,0x35,0xf1,0x06,0x2d,0x36,
	0xed,0x03,0x07,0x4e,0x4f,0x54,0x01,0x13,
	0x28,0xe4,0x03,0x57,0x0c,0xd3,0x14,0xd0,
	0x0b,0xcf,0x00,0x06,0x3d,0x1d,0xd7,0x06,
	0x3e,0x1e,0xd3,0x13,0x20,0xd0,0x89,0x20,
	0x06,0x2b,0x25,0xca,0x06,0x2d,0x26,0xc6,
	0x06,0x2a,0x24,0xc2,0x06,0x2f,0x27,0xbe,
	0x06,0x5e,0x23,0xba,0x06,0x3c,0x00,0xdb,
	0x06,0x3e,0x00,0x20,0x06,0x3d,0x22,0xae,
	0x06,0x25,0x56,0xaa,0x06,0x21,0x57,0xa6,
	0x06,0x26,0x58,0xa2,0x03,0x06,0x41,0x4e,
	0x44,0x13,0x2a,0x99,0x03,0x05,0x4f,0x52,
	0x13,0x29,0x92,0x09,0x06,0x3d,0x1f,0x8e,
	0x13,0x21,0x8b,0x89,0x20,0x06,0x3c,0x00,
	0x09,0x06,0x3e,0x00,0x10,0x06,0x3d,0x34,
	0xad,0x00,0x06,0x3e,0x30,0xa8,0x06,0x3d,
	0x2f,0xa4,0x13,0x32,0xa1,0x06,0x3d,0x31,
	0x9d,0x13,0x33,0x9a,0x99,0x87,0x11,0x05,
	0x14,0x87,0x2c,0x13,0x3c,0xf7,0x99,0x89,
	0x05,0xf4,0x99,0x87,0x06,0x2c,0x3c,0xfb,
	0x05,0xec,0x99,0x87,0x12,0x29,0x07,0x2c,
	0x09,0x95,0x95,0x95,0x9a,0x8d,0x93,0x05,
	0xfa,0x8d,0x82,0x20,0x08,0x04,0x03,0x03,
	0x49,0x46,0x16,0x82,0x15,0xfd,0x9a,0x20,
	0x0c,0x02,0x14,0x01,0x00,0x20,0x10,0x05,
	0x07,0x39,0x91,0x05,0x07,0x07,0x3b,0x28,
	0x87,0x29,0x07,0x2c,0x20,0x06,0x2c,0x12,
	0xe6,0x82,0x8b,0x20,0x3d,0x07,0x2d,0x87,
	0x07,0x19,0x54,0x4f,0x87,0x06,0x53,0x1a,
	0x01,0x82,0x54,0x45,0x50,0x9a,0x8d,0x93,
	0x8b,0x82,0x8d,0x93,0x9a,0x03,0x07,0x8d,
	0x01,0x06,0x3b,0x15,0x01,0x93,0x0b,0x01,
	0x00,0x15,0xee,0x93,0x05,0xf8,0x87,0x15,
	0xe8,0x07,0x1b,0x54,0x48,0x45,0x4e,0x0a,
	0xe0,0x0e,0x80,0x15,0xdc,0x03,0x05,0x89,
	0x01,0x15,0xd6,0x93,0x87,0x15,0xd2,0x93,
	0x9a,0x96,0x95,0x95,0x8b,0x82,0x8d,0x93,
	0x8b,0x93,0x8b,0x82,0x87,0x47,0x4f,0x06,
	0x54,0x17,0x06,0x53,0x55,0x42,0x13,0x18,
	0x01,0x4f,0x87,0x06,0x2c,0x12,0xfb,0x82,
	0x95,0x8d,0x93,0x95,0x95,0x89,0x82,0x87,
	0x06,0x2c,0x12,0x05,0x06,0x3b,0x15,0x04,
	0x82,0x87,0x05,0xf8,0x9a,0x15,0x01,0x89,
	0x82,0x03,0x04,0x8d,0x01,0x05,0x0b,0x15,
	0xe5,0x06,0x2c,0x12,0xfa,0x06,0x3b,0x15,
	0xf6,0x85,0x15,0xda,0x06,0x2c,0x12,0xef,
	0x06,0x3b,0x15,0xeb,0x00,0x52,0x45,0xcd,
	0x44,0x41,0x54,0xc1,0x49,0x4e,0x50,0x55,
	0xd4,0x43,0x4f,0x4c,0x4f,0xd2,0x4c,0x49,
	0x53,0xd4,0x45,0x4e,0x54,0x45,0xd2,0x4c,
	0x45,0xd4,0x49,0xc6,0x46,0x4f,0xd2,0x4e,
	0x45,0x58,0xd4,0x47,0x4f,0x54,0xcf,0x47,
	0x4f,0x20,0x54,0xcf,0x47,0x4f,0x53,0x55,
	0xc2,0x54,0x52,0x41,0xd0,0x42,0x59,0xc5,
	0x43,0x4f,0x4e,0xd4,0x43,0x4f,0xcd,0x43,
	0x4c,0x4f,0x53,0xc5,0x43,0x4c,0xd2,0x44,
	0x45,0xc7,0x44,0x49,0xcd,0x45,0x4e,0xc4,
	0x4e,0x45,0xd7,0x4f,0x50,0x45,0xce,0x4c,
	0x4f,0x41,0xc4,0x53,0x41,0x56,0xc5,0x53,
	0x54,0x41,0x54,0x55,0xd3,0x4e,0x4f,0x54,
	0xc5,0x50,0x4f,0x49,0x4e,0xd4,0x58,0x49,
	0xcf,0x4f,0xce,0x50,0x4f,0x4b,0xc5,0x50,
	0x52,0x49,0x4e,0xd4,0x52,0x41,0xc4,0x52,
	0x45,0x41,0xc4,0x52,0x45,0x53,0x54,0x4f,
	0x52,0xc5,0x52,0x45,0x54,0x55,0x52,0xce,
	0x52,0x55,0xce,0x53,0x54,0x4f,0xd0,0x50,
	0x4f,0xd0,0xbf,0x47,0x45,0xd4,0x50,0x55,
	0xd4,0x47,0x52,0x41,0x50,0x48,0x49,0x43,
	0xd3,0x50,0x4c,0x4f,0xd4,0x50,0x4f,0x53,
	0x49,0x54,0x49,0x4f,0xce,0x44,0x4f,0xd3,
	0x44,0x52,0x41,0x57,0x54,0xcf,0x53,0x45,
	0x54,0x43,0x4f,0x4c,0x4f,0xd2,0x4c,0x4f,
	0x43,0x41,0x54,0xc5,0x53,0x4f,0x55,0x4e,
	0xc4,0x4c,0x50,0x52,0x49,0x4e,0xd4,0x43,
	0x53,0x41,0x56,0xc5,0x43,0x4c,0x4f,0x41,
	0xc4,0xbf,0xbf,0xbf,0xbf,0xbf,0xbf,0x45,
	0x4c,0x53,0xc5,0x45,0x4e,0x44,0x49,0xc6,
	0x44,0x50,0x4f,0x4b,0xc5,0x4c,0x4f,0x4d,
	0x45,0xcd,0xbf,0xbf,0xbf,0x42,0x50,0x55,
	0xd4,0x42,0x47,0x45,0xd4,0xbf,0x43,0xd0,
	0x45,0x52,0x41,0x53,0xc5,0x50,0x52,0x4f,
	0x54,0x45,0x43,0xd4,0x55,0x4e,0x50,0x52,
	0x4f,0x54,0x45,0x43,0xd4,0x44,0x49,0xd2,
	0x52,0x45,0x4e,0x41,0x4d,0xc5,0x4d,0x4f,
	0x56,0xc5,0x4d,0x49,0x53,0x53,0x49,0x4c,
	0xc5,0x50,0x4d,0x43,0x4c,0xd2,0x50,0x4d,
	0x43,0x4f,0x4c,0x4f,0xd2,0x50,0x4d,0x47,
	0x52,0x41,0x50,0x48,0x49,0x43,0xd3,0x50,
	0x4d,0x4d,0x4f,0x56,0xc5,0x00,0xa5,0xa4,
	0xf0,0x13,0xa0,0x00,0xa2,0x8c,0x20,0x4d,
	0xbc,0xa4,0xa4,0xf0,0x08,0x88,0xb1,0x80,
	0x91,0x8a,0x98,0xd0,0xf8,0x06,0xbe,0x60,
	0x68,0xa0,0x00,0xa5,0xa4,0xc9,0x04,0xb0,
	0x06,0x84,0xa4,0xa5,0xbe,0x30,0xf0,0xb1,
	0x80,0xaa,0xa5,0xbe,0x20,0x13,0xaa,0x85,
	0xd4,0x84,0xd5,0x85,0x8a,0x84,0x8b,0xa0,
	0x02,0xa5,0xa4,0x91,0x80,0x90,0xbf,0xf1,
	0xd4,0xf0,0xc6,0xb0,0xbd,0x85,0xd8,0xa9,
	0xff,0x85,0xd9,0x38,0x45,0xd8,0x65,0xd4,
	0x85,0xd6,0xa5,0xd5,0x69,0x00,0x85,0xd7,
	0x38,0xa5,0x90,0xe5,0xd6,0x85,0xda,0xa5,
	0x91,0xe5,0xd7,0x85,0xdb,0x20,0x3b,0xb6,
	0xa2,0x8c,0x20,0x77,0xbc,0x4c,0x61,0xa4,
	0xe6,0xf2,0xa4,0xf2,0xb1,0xf3,0x20,0x6f,
	0xa7,0xc9,0x9b,0xd0,0xf3,0xa5,0xa4,0xa4,
	0xbd,0x91,0x80,0xd0,0x05,0x20,0x59,0xa6,
	0x24,0x48,0x20,0x59,0xa6,0x30,0x50,0xc9,
	0x20,0x90,0x12,0xd0,0x06,0x20,0xa1,0xdb,
	0x4c,0xe2,0xa4,0xa4,0xf2,0xd1,0xf3,0xd0,
	0x5f,0xe6,0xf2,0xd0,0xe5,0xaa,0xbd,0x42,
	0xa6,0x48,0xbd,0x2b,0xa6,0x48,0x60,0xa2,
	0x05,0xb5,0x84,0x95,0x98,0xca,0x10,0xf9,
	0xa9,0x00,0x85,0xbd,0x48,0x20,0x00,0xd8,
	0x90,0x08,0xa9,0x80,0xa2,0x00,0x86,0xf2,
	0xf0,0x05,0x20,0xea,0xb3,0x30,0x31,0xa0,
	0x01,0x91,0x80,0x85,0xbe,0x88,0x8a,0x91,
	0x80,0xa0,0x03,0x84,0xa4,0xa9,0x80,0x4a,
	0xaa,0x90,0x0a,0xa5,0xa2,0x48,0xa5,0xa3,
	0x48,0xa9,0xff,0x48,0x48,0xbd,0x36,0xa0,
	0xa0,0xa1,0x85,0xa2,0x84,0xa3,0xb0,0x92,
	0x68,0xf0,0x8e,0x68,0x68,0x68,0x90,0xf8,
	0x68,0xf0,0x6c,0xc9,0xff,0xd0,0x05,0x68,
	0x68,0x68,0xb0,0xf4,0x85,0xf2,0x68,0x85,
	0xa4,0x2c,0x68,0x68,0x68,0x85,0xa3,0x68,
	0x85,0xa2,0x4c,0xe2,0xa4,0x20,0x44,0xda,
	0xa2,0x01,0x20,0xaf,0xdb,0x90,0x0c,0x29,
	0xdf,0xc9,0x11,0x90,0x1b,0xc9,0x17,0xb0,
	0x17,0xe9,0x06,0xe6,0xf2,0xa2,0x04,0x06,
	0xd4,0x26,0xd5,0xca,0xd0,0xf9,0x05,0xd4,
	0x85,0xd4,0xa5,0xd5,0xc9,0x10,0x90,0xda,
	0x8a,0xd0,0xb5,0x20,0xaa,0xd9,0xa9,0x0d,
	0xd0,0x10,0xa5,0xf2,0x48,0x20,0x20,0xb5,
	0x68,0x90,0x05,0x85,0xf2,0x4c,0xdd,0xa4,
	0xa9,0x0e,0xa2,0x79,0x20,0x6f,0xa7,0xb5,
	0x5b,0xe8,0x10,0xf8,0x4c,0x38,0xa7,0xa9,
	0x00,0x85,0xa4,0xa2,0x28,0x20,0x12,0xbb,
	0xe6,0xf2,0xa6,0xa4,0xe6,0xa4,0xbd,0x80,
	0x05,0x48,0xc6,0xf2,0xd0,0x0d,0x49,0x80,
	0xc9,0x1b,0xd0,0x07,0xa9,0xa0,0x20,0x71,
	0xbb,0xa9,0x9b,0x20,0x71,0xbb,0x68,0xc9,
	0x9b,0xd0,0xdf,0xa2,0x84,0x20,0x00,0xa6,
	0xa2,0x88,0x20,0x00,0xa6,0x4c,0x55,0xa0,
	0x8a,0x48,0xa5,0x90,0x38,0xf5,0x00,0x85,
	0xda,0xa5,0x91,0xf5,0x01,0x85,0xdb,0xb5,
	0x14,0x85,0xd4,0xf5,0x00,0x85,0xd8,0xb5,
	0x15,0x85,0xd5,0xf5,0x01,0x85,0xd9,0xb4,
	0x00,0xb5,0x01,0x20,0x37,0xb6,0x68,0xaa,
	0x4c,0x77,0xbc,0x57,0x76,0x85,0x16,0x6f,
	0x37,0x3d,0x65,0xc9,0x69,0xa9,0x88,0x7d,
	0x74,0xd4,0x5b,0x2a,0x7a,0x7a,0x31,0x88,
	0x55,0x6f,0xa5,0xa6,0xa6,0xa7,0xa4,0xa7,
	0xa7,0xa7,0xa4,0xa5,0xa5,0xa7,0xa6,0xa5,
	0xa4,0xa8,0xa7,0xa8,0xa8,0xa7,0xa7,0xa7,
	0xa6,0xe6,0xa2,0xd0,0x02,0xe6,0xa3,0xa0,
	0x00,0xb1,0xa2,0x60,0x20,0x59,0xa6,0x10,
	0x02,0xc6,0xa3,0xa2,0xa2,0x4c,0x9b,0xba,
	0xa4,0xa4,0x88,0xa9,0x3d,0x91,0x80,0x68,
	0x68,0x68,0x68,0x4c,0xe2,0xa4,0xa2,0x6d,
	0xa9,0xbe,0xa0,0x3d,0xd0,0x0b,0x20,0x6f,
	0xa7,0x84,0xbd,0xa2,0x05,0xa9,0xa3,0xa0,
	0x00,0x84,0xd5,0x84,0xd4,0x86,0xa9,0x85,
	0xaa,0xa4,0xf2,0xb1,0xf3,0xc9,0x2e,0xd0,
	0x04,0xa5,0xd5,0xf0,0x07,0x38,0xe9,0x3f,
	0xc9,0x1c,0xb0,0x65,0xa0,0x00,0xa6,0xf2,
	0xb1,0xa9,0xf0,0x5d,0x29,0x7f,0xe8,0xdd,
	0x7f,0x05,0xd0,0x43,0xb1,0xa9,0x0a,0xc8,
	0x90,0xee,0xa4,0xd5,0xf0,0x0c,0xc9,0x50,
	0xf0,0x08,0xbd,0x80,0x05,0x20,0x7b,0xa7,
	0x90,0x38,0x86,0xf2,0xa5,0xd4,0x20,0x6f,
	0xa7,0xaa,0xbd,0x84,0xa0,0xa0,0xa2,0x46,
	0xd5,0x90,0x18,0x86,0xbc,0x20,0x64,0xa6,
	0xa5,0xa2,0x48,0xa5,0xa3,0x48,0xa5,0xa4,
	0x48,0xa9,0x00,0x48,0xa6,0xbc,0xbd,0x99,
	0xa0,0xa0,0xa2,0x18,0x4c,0x4a,0xa5,0xa4,
	0xd5,0xd0,0x07,0xbd,0x7f,0x05,0xc9,0x2e,
	0xf0,0xc8,0x20,0x90,0xba,0xe6,0xd4,0xd0,
	0x9b,0xa5,0xd5,0xf0,0x26,0xd0,0x18,0x20,
	0x59,0xa6,0x18,0x65,0xa2,0x48,0xa5,0xa3,
	0x69,0x00,0x48,0xa5,0xa4,0x48,0xa5,0xf2,
	0x4c,0xe1,0xa4,0xa5,0xd2,0x30,0x09,0x4c,
	0xdd,0xa4,0x20,0x59,0xa6,0x20,0x6f,0xa7,
	0x20,0x64,0xa6,0x4c,0xe2,0xa4,0x20,0x59,
	0xa6,0xa4,0xf2,0xd1,0xf3,0xf0,0x06,0x20,
	0x59,0xa6,0x4c,0xdd,0xa4,0xe6,0xf2,0x20,
	0x59,0xa6,0xf0,0xe4,0xd0,0xdf,0x20,0xa1,
	0xdb,0xb1,0xf3,0xc9,0x3a,0xf0,0xd9,0xc9,
	0x9b,0xf0,0xd5,0x4c,0xdd,0xa4,0x20,0x6c,
	0xa7,0x4c,0xe2,0xa4,0x20,0x59,0xa6,0xa4,
	0xa4,0xe6,0xa4,0xf0,0x03,0x91,0x80,0x60,
	0x4c,0xf9,0xbe,0x48,0x38,0xe9,0x30,0xc9,
	0x0a,0x90,0x04,0xe9,0x11,0xc9,0x1a,0x68,
	0x60,0xe0,0x14,0x66,0xdf,0x20,0xa1,0xdb,
	0xb1,0xf3,0x38,0xe9,0x41,0xc9,0x1a,0xb0,
	0x1c,0xc8,0xb1,0xf3,0x20,0x7b,0xa7,0xb0,
	0x03,0xc8,0xd0,0xf6,0xaa,0xa9,0x00,0x85,
	0xd3,0xe0,0x24,0xf0,0x0c,0xe0,0x28,0xf0,
	0x07,0x24,0xdf,0x10,0x06,0x4c,0xdd,0xa4,
	0x6a,0x6a,0xc8,0x85,0xd2,0x84,0xda,0xa5,
	0x82,0x85,0xa9,0xa5,0x83,0x85,0xaa,0xa0,
	0x00,0xa6,0xf2,0xe8,0xb1,0xa9,0xf0,0x28,
	0x30,0x08,0xdd,0x7f,0x05,0xd0,0x17,0xc8,
	0xd0,0xf1,0xe4,0xda,0xd0,0x10,0x49,0x80,
	0xdd,0x7f,0x05,0xd0,0x09,0x86,0xf2,0xa5,
	0xd3,0x09,0x80,0x4c,0x35,0xa7,0x20,0x90,
	0xba,0xe6,0xd3,0x10,0xd2,0x4c,0x0d,0xbf,
	0xa5,0x89,0x85,0xd5,0x48,0xa5,0x88,0x85,
	0xd4,0x48,0xa5,0xda,0xaa,0x38,0xe5,0xf2,
	0x86,0xf2,0x85,0xdc,0x69,0x07,0xa2,0x88,
	0x20,0x4d,0xbc,0x38,0x68,0x85,0xd6,0xe5,
	0x84,0x85,0xda,0x68,0x85,0xd7,0xe5,0x85,
	0x85,0xdb,0xa5,0x88,0xe9,0x08,0xa8,0xa5,
	0x89,0xe9,0x00,0x20,0x9a,0xbc,0xa6,0xf2,
	0xa4,0xdc,0xa9,0x80,0x2c,0xa9,0x00,0xca,
	0x5d,0x80,0x05,0x88,0x91,0x84,0xd0,0xf5,
	0xa2,0x86,0xa5,0xdc,0x20,0x9b,0xba,0xca,
	0xca,0xe0,0x82,0xd0,0xf5,0xa5,0xd3,0x20,
	0x5b,0xba,0x20,0x44,0xda,0xa8,0x20,0x80,
	0xae,0x4c,0xe7,0xa7,0xa4,0xa4,0x84,0xd4,
	0x20,0x6f,0xa7,0xa6,0xf2,0xbd,0x80,0x05,
	0xc9,0x9b,0xf0,0x06,0xe6,0xf2,0xc9,0x22,
	0xd0,0xee,0x98,0xe5,0xd4,0xa4,0xd4,0x91,
	0x80,0xa2,0x12,0xe0,0x12,0x66,0xd2,0x4c,
	0xe2,0xa4,0xa5,0x88,0x85,0x8a,0xa5,0x89,
	0x85,0x8b,0x20,0x41,0xae,0xa0,0x01,0xb1,
	0x8a,0x10,0x03,0x4c,0x49,0xa0,0x20,0xc8,
	0xaf,0xa5,0x11,0x10,0x35,0xc4,0x94,0xb0,
	0x14,0xb1,0x8a,0x85,0x93,0xc8,0xb1,0x8a,
	0xc8,0x84,0x92,0xaa,0x20,0xc9,0xa8,0xa4,
	0x93,0xd0,0xe6,0x68,0x68,0xa0,0x01,0xb1,
	0x8a,0x30,0x0b,0xc8,0xb1,0x8a,0xa2,0x8a,
	0x20,0x9b,0xba,0x4c,0x8d,0xa8,0x4c,0x50,
	0xa0,0xbd,0xc1,0xa9,0x48,0xbd,0x6f,0xa9,
	0x48,0x60,0xa0,0x80,0x2c,0xa0,0x1c,0x84,
	0xc2,0x4c,0x13,0xbf,0x20,0xdf,0xb2,0xa4,
	0x92,0xb1,0x8a,0xc9,0x1b,0xd0,0x19,0xa5,
	0xd4,0xf0,0xc8,0xc8,0xc4,0x93,0xf0,0xe1,
	0xa2,0x7a,0xc8,0xb1,0x8a,0x95,0x5a,0xe8,
	0x10,0xf8,0x20,0xfc,0xb3,0x4c,0xfe,0xaf,
	0xa5,0xd4,0xd0,0xcd,0x38,0x24,0x18,0x66,
	0xbc,0xa9,0xff,0x85,0xbd,0xe6,0xbd,0xa4,
	0x93,0xc4,0x94,0xd0,0x1a,0x98,0x48,0xa0,
	0x01,0xb1,0x8a,0x30,0xb8,0x68,0xa2,0x8a,
	0x20,0x9b,0xba,0xb1,0x8a,0x30,0xae,0xc8,
	0xb1,0x8a,0x85,0x94,0xc8,0xd0,0xe2,0xb1,
	0x8a,0x85,0x93,0xc8,0xb1,0x8a,0xc9,0x3d,
	0xd0,0x05,0xc6,0xbd,0x10,0xd1,0x60,0xc9,
	0x3c,0xd0,0x09,0xa5,0xbd,0xd0,0xc8,0x24,
	0xbc,0x10,0x8a,0x60,0xc9,0x07,0xd0,0xbf,
	0xc8,0xc4,0x93,0xf0,0xb8,0xb1,0x8a,0xc9,
	0x1b,0xf0,0xb4,0xc9,0x0f,0x90,0x07,0xd0,
	0xef,0xc8,0xb1,0x8a,0x18,0x2c,0xa9,0x06,
	0x84,0x92,0x65,0x92,0xa8,0xd0,0xe1,0xb2,
	0xb2,0xe9,0xc3,0xd2,0xc9,0xe1,0xdb,0xcb,
	0x69,0xfa,0xfa,0xef,0xc3,0x70,0x0e,0x36,
	0xd4,0x00,0x2e,0x36,0x48,0x53,0xa5,0xb0,
	0x28,0x53,0x64,0x88,0x9e,0xcf,0xc3,0xdc,
	0x31,0xf2,0x30,0x40,0xa7,0xd1,0x47,0xdc,
	0x68,0x8a,0x91,0xa7,0x24,0xad,0xb3,0x74,
	0x63,0x41,0x98,0x21,0x9d,0xe1,0xf2,0xf2,
	0xf2,0xf2,0xf2,0x05,0xd0,0xc3,0x4a,0xf2,
	0xf2,0xf2,0xea,0xed,0xf2,0xad,0xa5,0xa5,
	0xa5,0xda,0xa5,0xb5,0x13,0x84,0x6a,0x14,
	0x94,0xa8,0xa8,0xaa,0xab,0xbc,0xab,0xb2,
	0xa8,0xae,0xaf,0xaf,0xaf,0xaf,0xae,0xe4,
	0xb0,0xac,0xab,0xac,0xac,0xac,0xa0,0xac,
	0xad,0xac,0xad,0xad,0xad,0xad,0xad,0xaf,
	0xad,0xad,0xac,0xaa,0xae,0xaf,0xac,0xa8,
	0xae,0xad,0xae,0xae,0xae,0xae,0xb0,0xae,
	0xae,0xb0,0xae,0xb0,0xb0,0xad,0xac,0xb2,
	0xbe,0xbe,0xbe,0xbe,0xbe,0xa9,0xa8,0xad,
	0xac,0xbe,0xbe,0xbe,0xb0,0xb0,0xbe,0xae,
	0xb0,0xb0,0xb0,0xab,0xb0,0xb0,0xb2,0xb1,
	0xb0,0xb1,0xb1,0x86,0xd4,0x85,0xd5,0x8a,
	0xa2,0x00,0xc1,0x8a,0xa0,0x01,0xa5,0xd5,
	0xf1,0x8a,0xb0,0x02,0xa2,0xfe,0xb5,0x8b,
	0x85,0xaa,0xb5,0x8a,0xa2,0x00,0x85,0xa9,
	0xb1,0xa9,0xc5,0xd5,0x90,0x08,0xd0,0x14,
	0xa1,0xa9,0xc5,0xd4,0xb0,0x0c,0xc8,0xa5,
	0xa9,0x71,0xa9,0x88,0x90,0xe8,0xe6,0xaa,
	0xd0,0xe4,0xf0,0x01,0x18,0xa5,0xa9,0xa4,
	0xaa,0x60,0xa4,0x92,0xb1,0x8a,0xc9,0x14,
	0xf0,0x02,0xc9,0x16,0x60,0xa4,0x92,0xe6,
	0x92,0xb1,0x8a,0xc9,0x12,0x60,0x18,0x65,
	0x90,0xaa,0xa9,0x00,0x65,0x91,0xec,0xe5,
	0x02,0xed,0xe6,0x02,0x90,0x03,0x4c,0x11,
	0xbf,0x24,0x97,0x10,0x2f,0x46,0x97,0xa5,
	0x90,0x48,0xa5,0x91,0x48,0xd0,0x1a,0xa9,
	0xfc,0x20,0x5a,0xae,0xa0,0x01,0xb1,0x90,
	0xaa,0xc8,0xb1,0x90,0x20,0x13,0xaa,0x90,
	0x14,0xa6,0xaa,0x20,0x2c,0xaf,0x20,0x52,
	0xae,0x20,0x61,0xaf,0x90,0xe1,0x68,0x85,
	0x91,0x68,0x85,0x90,0x60,0x4c,0xf7,0xbe,
	0x24,0x97,0x30,0xf8,0x38,0x66,0x97,0xa5,
	0x90,0x48,0xa5,0x91,0x48,0x20,0x61,0xaf,
	0xb0,0xe4,0xa9,0xfc,0x20,0x5a,0xae,0xa0,
	0x02,0xb1,0x90,0x85,0xd5,0x88,0xb1,0x90,
	0x85,0xd4,0xb1,0xd4,0xaa,0x88,0xb1,0xd4,
	0x20,0x2c,0xaf,0x20,0x52,0xae,0x4c,0xbd,
	0xaa,0xa0,0x01,0xb1,0xc4,0x10,0x57,0x4c,
	0x09,0xbf,0x20,0x6c,0xb2,0xb0,0x0a,0xe6,
	0x92,0xd0,0x06,0xa9,0xff,0x85,0xa7,0x85,
	0xa8,0xa6,0xa8,0xd0,0x05,0xa9,0x3f,0x20,
	0x79,0xbb,0xa9,0x00,0x85,0xf2,0xa6,0xa7,
	0x10,0x65,0xa5,0xc5,0xd0,0x15,0xa6,0xb7,
	0xa5,0xb8,0x20,0x13,0xaa,0x85,0xc4,0x84,
	0xc5,0xa9,0x00,0x85,0xc6,0xa0,0x02,0xb1,
	0xc4,0x85,0xb0,0xa4,0xc6,0xf0,0xba,0xc4,
	0xb0,0x90,0x27,0xa5,0xb0,0xa2,0xc4,0x20,
	0x9b,0xba,0xa0,0x01,0xa1,0x00,0x85,0xb7,
	0xb1,0xc4,0x85,0xb8,0x10,0xdb,0xa0,0x03,
	0xc4,0xb0,0xf0,0xe7,0xc8,0xb1,0xc4,0xc9,
	0x01,0xf0,0x06,0x88,0xb1,0xc4,0xa8,0xd0,
	0xef,0xc8,0x84,0xf2,0xa5,0xc4,0xa4,0xc5,
	0x20,0x20,0xbc,0xd0,0x18,0xa4,0xb0,0x24,
	0xa7,0x10,0x02,0x84,0xc6,0x20,0x5d,0xaa,
	0xd0,0x4f,0x8a,0xd0,0x08,0xf0,0x8a,0x20,
	0x34,0xbc,0x20,0x02,0xbc,0x20,0xdf,0xb2,
	0xa5,0x9d,0x10,0x3e,0xa2,0xe0,0x20,0x46,
	0xda,0xa4,0xf2,0x84,0xe0,0xb1,0xf3,0xc9,
	0x9b,0xf0,0x0d,0x24,0xa7,0x10,0x04,0xc9,
	0x2c,0xf0,0x05,0xc8,0xe6,0xe2,0xd0,0xed,
	0x84,0xf2,0xa2,0xe0,0x86,0x9c,0xa0,0xf3,
	0x20,0xc3,0xbc,0x20,0xe5,0xb5,0xa4,0xf2,
	0xb1,0xf3,0x49,0x9b,0xaa,0xf0,0xae,0xc8,
	0x84,0xf2,0xc9,0xb7,0xf0,0xa9,0x4c,0x05,
	0xbf,0x60,0x20,0x20,0xb5,0xb0,0xf7,0x20,
	0x7e,0xae,0xf0,0xe2,0x20,0x66,0xb2,0x86,
	0xc8,0x60,0x20,0xcc,0xbb,0x20,0xb0,0xbb,
	0x86,0xa6,0x4c,0x55,0xa0,0x20,0x8b,0xb2,
	0x4c,0xd6,0xbb,0x20,0xcc,0xbb,0xa9,0x06,
	0xa4,0x99,0xd0,0x07,0xa0,0xb7,0x20,0xe6,
	0xbb,0x10,0x03,0x20,0xb2,0xbb,0xa2,0x70,
	0x20,0xa3,0xbb,0xf0,0xe3,0xa2,0x00,0x20,
	0x32,0xbc,0xa9,0x09,0x20,0xfd,0xbb,0x10,
	0xed,0x20,0x44,0xda,0x20,0x5b,0xba,0xd0,
	0x10,0x20,0x7e,0xae,0xa2,0x9e,0xa1,0x00,
	0x29,0xc0,0x81,0x00,0xa9,0x08,0x20,0x9b,
	0xba,0xa5,0x9e,0xc5,0x88,0xa5,0x9f,0xe5,
	0x89,0x90,0xe6,0xa2,0xfc,0xb5,0x90,0x95,
	0x92,0xe8,0xd0,0xf9,0x4c,0x82,0xbc,0xa9,
	0x06,0x2c,0xa9,0x00,0x85,0xfb,0x60,0xa9,
	0x40,0x20,0xe4,0xb2,0x20,0x5d,0xaa,0xf0,
	0xf6,0x60,0xa5,0xb3,0xf0,0xfb,0x30,0x15,
	0x4c,0x25,0xbc,0x20,0x66,0xb2,0x8e,0xe7,
	0x02,0x8d,0xe8,0x02,0x20,0x5d,0xac,0x20,
	0x41,0xae,0x4c,0x49,0xa0,0xac,0xe8,0x02,
	0xad,0xe7,0x02,0x85,0x80,0x18,0x69,0x6c,
	0x85,0xae,0x98,0x69,0x00,0x85,0xaf,0xc8,
	0x84,0x81,0xa2,0xf0,0x86,0x96,0x20,0x25,
	0xac,0x86,0xb3,0xc6,0x81,0xa9,0x0a,0x85,
	0xc9,0x86,0xfb,0x86,0xd9,0xe8,0x86,0xd8,
	0xa2,0x86,0x20,0x77,0xbc,0xa0,0x03,0x84,
	0xd8,0xb9,0xa5,0xbf,0x91,0x82,0x88,0x10,
	0xf8,0xa2,0x8c,0x4c,0x77,0xbc,0xa9,0x04,
	0x20,0xe0,0xbb,0x38,0x66,0xbc,0x30,0x12,
	0x46,0xbc,0x20,0x52,0xaa,0xf0,0x32,0xd0,
	0x03,0x38,0x66,0xbc,0x20,0xcc,0xbb,0x20,
	0xb0,0xbb,0xa9,0x07,0x20,0xf6,0xac,0xa5,
	0xd4,0x05,0xd5,0xd0,0x2e,0xc6,0xb3,0xa2,
	0x74,0xb5,0x62,0x18,0x65,0x80,0x95,0x0e,
	0xa8,0xb5,0x63,0x65,0x81,0x95,0x0f,0x20,
	0x89,0xbc,0xe8,0xe8,0x10,0xeb,0x20,0x09,
	0xad,0xe6,0xb3,0x20,0x33,0xb1,0x20,0x01,
	0xac,0x06,0xbc,0xb0,0x03,0x4c,0x82,0xa8,
	0x4c,0x4c,0xa0,0x4c,0xef,0xbe,0x48,0xa6,
	0xa7,0xa0,0x00,0xa9,0xd4,0x20,0x0d,0xb1,
	0xa0,0x0e,0x20,0x43,0xbc,0x68,0x4c,0xfd,
	0xbb,0xa6,0xa7,0xa5,0x82,0xa4,0x83,0x20,
	0x0d,0xb1,0x38,0xa5,0x8c,0xe5,0x82,0xa8,
	0xa5,0x8d,0xe5,0x83,0x20,0x45,0xbc,0x4c,
	0x02,0xbc,0xa9,0x08,0x20,0xe0,0xbb,0x10,
	0x08,0x20,0xcc,0xbb,0xa9,0x08,0x20,0xb2,
	0xbb,0x20,0x44,0xda,0xa2,0x0c,0x38,0xb5,
	0x80,0xe5,0x82,0x95,0xd4,0xb5,0x81,0xe5,
	0x83,0x69,0x00,0x95,0xd5,0xca,0xca,0xd0,
	0xed,0xa9,0x0b,0x20,0xf6,0xac,0x20,0x09,
	0xad,0x4c,0xd6,0xbb,0x20,0x8b,0xb2,0x20,
	0xdd,0xb2,0xa9,0x0d,0x20,0xfd,0xbb,0xbd,
	0x43,0x03,0x4c,0x7b,0xae,0x20,0x8b,0xb2,
	0xa9,0x26,0x20,0xfd,0xbb,0x20,0xdd,0xb2,
	0xa4,0xa7,0xb9,0x4c,0x03,0xbe,0x4d,0x03,
	0x20,0xf7,0xba,0x20,0x7e,0xae,0x20,0xdd,
	0xb2,0xa6,0xa7,0xbd,0x4e,0x03,0x4c,0x7b,
	0xae,0x20,0x8b,0xb2,0xa9,0x08,0x20,0x02,
	0xb1,0x20,0x64,0xb2,0x8a,0xa6,0xa7,0x9d,
	0x4e,0x03,0xa9,0x25,0x4c,0xfd,0xbb,0x20,
	0x66,0xb2,0xe6,0x92,0x8a,0x2c,0xa9,0x03,
	0x48,0x20,0x61,0xb2,0x8a,0x48,0x20,0x64,
	0xb2,0x8a,0x48,0x20,0xdd,0xb2,0xa6,0xa7,
	0x68,0x9d,0x4b,0x03,0x68,0x9d,0x4a,0x03,
	0x68,0x4c,0xb9,0xbb,0x86,0xbe,0x20,0x66,
	0xb2,0x85,0xbd,0x86,0xbc,0x20,0x64,0xb2,
	0xa0,0x01,0x46,0xbe,0xb0,0x02,0x91,0xbc,
	0x8a,0x88,0x91,0xbc,0x60,0xa5,0xc9,0x85,
	0xab,0x20,0x6c,0xb2,0x46,0xbc,0x10,0x11,
	0x20,0x6f,0xbb,0x20,0x6f,0xbb,0xa5,0xab,
	0xc5,0xc9,0xd0,0xf7,0x38,0x66,0xbc,0xe6,
	0x92,0x20,0x52,0xaa,0xd0,0x07,0x24,0xbc,
	0x30,0xda,0x4c,0x6c,0xbb,0xc9,0x15,0xf0,
	0xeb,0xc9,0x12,0xf0,0xdb,0x46,0xbc,0x20,
	0xdf,0xb2,0xa5,0x9d,0x30,0x05,0x20,0x27,
	0xbb,0x30,0xde,0x20,0x1c,0xbc,0xa5,0xd6,
	0xd0,0x04,0xc6,0xd7,0x30,0xd3,0xc6,0xd6,
	0xa0,0x00,0xb1,0xf3,0x20,0x64,0xbb,0x10,
	0xed,0x20,0x41,0xae,0x20,0x52,0xaa,0xf0,
	0x07,0x20,0xf9,0xb3,0x86,0xb7,0x85,0xb8,
	0x60,0xa9,0x00,0x85,0xc5,0xaa,0xf0,0xf4,
	0x20,0x61,0xaf,0xb0,0x16,0xa9,0xfc,0x20,
	0x5b,0xae,0xa0,0x00,0xb1,0x90,0x10,0x0b,
	0xa9,0xf4,0x18,0x65,0x90,0x85,0x90,0xb0,
	0x02,0xc6,0x91,0x60,0x20,0x25,0xb0,0xd0,
	0x03,0x20,0x8b,0xb2,0x20,0xdd,0xb2,0xa6,
	0xa7,0xa0,0x00,0x20,0x43,0xbc,0xa9,0x07,
	0x20,0xfd,0xbb,0x20,0xf5,0xba,0xa0,0x02,
	0xb9,0xd2,0x00,0x91,0x9e,0xc8,0xc0,0x08,
	0xd0,0xf6,0x60,0x20,0x61,0xb2,0x8a,0x4c,
	0x79,0xbb,0x20,0x66,0xb2,0x20,0x4a,0xb1,
	0xa5,0xd4,0x8d,0xab,0x03,0x29,0x30,0x49,
	0x1c,0xa0,0xb4,0xa2,0x60,0x4c,0xe8,0xbb,
	0x20,0x25,0xb0,0x4c,0x79,0xbb,0x20,0x33,
	0xb1,0x6c,0x0a,0x00,0xa9,0x0c,0x8d,0xaa,
	0x03,0x20,0x25,0xb0,0x8d,0xfb,0x02,0xa9,
	0x11,0x4c,0xfd,0xbb,0x20,0x66,0xb2,0x86,
	0x95,0x85,0x96,0x60,0xb1,0x8a,0x85,0xbc,
	0xa5,0x90,0x48,0xa5,0x91,0x48,0xd0,0x14,
	0xa9,0xfc,0x20,0x5a,0xae,0xa0,0x00,0xb1,
	0x90,0x10,0x0e,0xc5,0xbc,0x08,0x20,0x52,
	0xae,0x28,0xf0,0x0c,0x20,0x61,0xaf,0x90,
	0xe7,0x68,0x85,0x91,0x68,0x85,0x90,0x2c,
	0x68,0x68,0xa9,0x10,0x20,0x66,0xaa,0x20,
	0xe2,0xb2,0x20,0xdd,0xb2,0xa0,0x00,0x20,
	0x36,0xaf,0x20,0x48,0xb5,0x20,0x52,0xaa,
	0xf0,0x03,0x20,0xdd,0xb2,0xa0,0x06,0x20,
	0x36,0xaf,0xa5,0xbc,0xa6,0x8a,0x20,0x2e,
	0xaf,0xa5,0x8b,0xa6,0x93,0x20,0x2e,0xaf,
	0x98,0x4c,0xb5,0xaf,0xa0,0x01,0x91,0x90,
	0xc8,0x8a,0x91,0x90,0xc8,0x60,0xa2,0x7a,
	0xb5,0x5a,0x91,0x90,0xc8,0xe8,0x10,0xf8,
	0x60,0x20,0x5e,0xaf,0xb0,0x15,0xc6,0x91,
	0xa0,0xfc,0xb1,0x90,0x10,0x02,0xa0,0xf0,
	0x20,0x28,0xaf,0xc0,0xf0,0xf0,0xea,0xa0,
	0x01,0xd0,0x5f,0x4c,0xf5,0xbe,0x20,0x79,
	0xaa,0xa5,0x8e,0xc5,0x90,0xa5,0x8f,0xe5,
	0x91,0x60,0x20,0x5e,0xaf,0x90,0x03,0x4c,
	0xfb,0xbe,0xa9,0xf0,0x20,0x5a,0xae,0xa0,
	0x0c,0xb1,0x90,0xf0,0xf2,0xa4,0x92,0xd1,
	0x8a,0xd0,0xe7,0x20,0x5b,0xba,0x20,0x70,
	0xba,0xa0,0x0b,0xa2,0x05,0xb1,0x90,0x88,
	0x95,0xe0,0xca,0x10,0xf8,0x85,0xbc,0x20,
	0x66,0xda,0x20,0x7e,0xae,0xa6,0x90,0xa4,
	0x91,0x20,0x98,0xdd,0x20,0xa5,0xba,0xf0,
	0x05,0x6a,0x45,0xbc,0x30,0x21,0xa0,0x0d,
	0x20,0xba,0xaf,0xa9,0x10,0xa2,0x90,0x4c,
	0x9b,0xba,0xb1,0x90,0xc8,0x85,0x8a,0xb1,
	0x90,0xc8,0x85,0x8b,0xb1,0x90,0x85,0x93,
	0xa0,0x02,0xb1,0x8a,0xc8,0x85,0x94,0x60,
	0x20,0xf9,0xb3,0xd0,0x6a,0x8a,0xf0,0x13,
	0x85,0xbc,0x20,0x5d,0xaa,0x48,0xc6,0xbc,
	0xf0,0x0a,0x20,0xf9,0xb3,0x20,0x5d,0xaa,
	0xf0,0xf4,0x68,0x60,0x68,0x4a,0xb0,0x0b,
	0xa9,0x04,0x20,0x66,0xaa,0xa9,0x00,0xa8,
	0x20,0x1c,0xaf,0x20,0xf9,0xb3,0x20,0x13,
	0xaa,0x90,0x09,0x85,0x8a,0x84,0x8b,0x68,
	0x68,0x4c,0x8d,0xa8,0x4c,0xfd,0xbe,0xa0,
	0x01,0xb1,0x8a,0x10,0x29,0xa6,0xba,0xa5,
	0xbb,0x30,0xf1,0x20,0x13,0xaa,0x85,0x8a,
	0x84,0x8b,0x4c,0xb5,0xa8,0x20,0x66,0xb2,
	0x48,0x8a,0x48,0x20,0xf7,0xb3,0xd0,0x0f,
	0x86,0x54,0x68,0x85,0x55,0x68,0x85,0x56,
	0xa5,0xc8,0xa2,0x60,0x86,0xa7,0x60,0x4c,
	0x0f,0xbf,0x20,0xf9,0xb3,0xd0,0xf8,0x8a,
	0xc9,0x04,0xb0,0xf3,0x0a,0x85,0xbc,0x20,
	0x64,0xb2,0x8a,0x48,0x20,0x8a,0xb0,0xa6,
	0xbc,0x9d,0x01,0xd2,0x68,0x9d,0x00,0xd2,
	0xa9,0x00,0x8d,0x08,0xd2,0xa9,0x03,0x8d,
	0x0f,0xd2,0x60,0x20,0xf9,0xb3,0xe0,0x04,
	0xb0,0xcd,0x8a,0x10,0x0a,0x20,0xf9,0xb3,
	0xe0,0x05,0xb0,0xc3,0x8a,0x69,0x04,0x85,
	0xbc,0x20,0x8a,0xb0,0xa6,0xbc,0x9d,0xc0,
	0x02,0x60,0x20,0x8d,0xb0,0x0a,0x0a,0x0a,
	0x0a,0x48,0x20,0x64,0xb2,0x68,0x65,0xd4,
	0x60,0xa0,0xb6,0xa9,0x08,0x20,0xe6,0xbb,
	0x20,0xe4,0xad,0x4c,0xd6,0xbb,0xbd,0x6a,
	0xb0,0x48,0x20,0xcc,0xbb,0x68,0x4c,0xb9,
	0xbb,0x21,0x23,0x24,0x00,0x20,0x20,0x66,
	0xb2,0x48,0x8a,0x48,0x20,0x64,0xb2,0x48,
	0x8a,0x48,0x20,0xdd,0xb2,0x20,0xec,0xba,
	0x20,0xea,0xb3,0x86,0xda,0x85,0xdb,0xa2,
	0x7c,0x68,0x95,0x58,0xe8,0x10,0xfa,0x24,
	0xc0,0x30,0x03,0x4c,0x3b,0xb6,0xa0,0xda,
	0x20,0xc1,0xbc,0xa2,0xd6,0x20,0xc3,0xbc,
	0x4c,0x9e,0xbc,0xa9,0x0b,0x2c,0xa9,0x07,
	0x48,0x20,0x8b,0xb2,0xa9,0x00,0x20,0x02,
	0xb1,0xa9,0x04,0x20,0x02,0xb1,0x68,0x4c,
	0xfd,0xbb,0x05,0xa7,0x85,0xbc,0x20,0x64,
	0xb2,0xa8,0x8a,0xa6,0xbc,0x9d,0x44,0x03,
	0x98,0x9d,0x45,0x03,0x60,0x20,0xf9,0xb3,
	0xca,0x30,0x33,0xf0,0x02,0xa2,0x01,0xbc,
	0xa6,0xbf,0xbd,0x83,0xb1,0x2d,0xe6,0x02,
	0x18,0x7d,0x83,0xb1,0xc5,0x91,0xb0,0x27,
	0x4c,0x11,0xbf,0x20,0x42,0xac,0xa2,0x70,
	0x20,0xd8,0xbb,0x8a,0x38,0xe9,0x10,0xaa,
	0xd0,0xf6,0xa2,0x07,0x9d,0x00,0xd2,0xca,
	0x10,0xfa,0xa5,0xb1,0xf0,0x34,0xa2,0x02,
	0xa9,0x00,0xa8,0x8d,0x1d,0xd0,0x18,0x85,
	0xb1,0x8d,0x07,0xd4,0x84,0xb2,0x90,0x0d,
	0xa9,0x03,0x8d,0x1d,0xd0,0x0d,0x6f,0x02,
	0x29,0xc1,0x8d,0x6f,0x02,0xad,0x2f,0x02,
	0x29,0xe3,0x1d,0xa3,0xbf,0x8d,0x2f,0x02,
	0xa0,0x11,0xa9,0x00,0x99,0x00,0xd0,0x88,
	0x10,0xfa,0x60,0xf8,0xfc,0x20,0xf9,0xb3,
	0x20,0x3f,0xb2,0xa4,0xb2,0xa9,0x00,0x88,
	0x91,0xa2,0xd0,0xfb,0x60,0x20,0xf9,0xb3,
	0xe0,0x08,0xb0,0xf8,0x86,0xbd,0xbd,0xf2,
	0xbf,0x85,0xbf,0x20,0x3f,0xb2,0x85,0xaa,
	0x20,0x5d,0xaa,0xd0,0x0b,0x20,0xf9,0xb3,
	0x8a,0xa6,0xbd,0x9d,0x00,0xd0,0x10,0xf0,
	0xc9,0x15,0xd0,0xd8,0x20,0xdf,0xb2,0x20,
	0xec,0xba,0x20,0xea,0xb3,0x8a,0x05,0xb2,
	0x45,0xb2,0xf0,0xc8,0x85,0xbe,0x05,0xa2,
	0x85,0xa9,0xa5,0xb2,0x38,0xe5,0xbe,0x24,
	0xc0,0x10,0x1c,0xa8,0x88,0xb1,0xa2,0x51,
	0xa9,0x25,0xbf,0x51,0xa2,0x91,0xa9,0x98,
	0xd0,0xf2,0xa4,0xbe,0x88,0xb1,0xa2,0x25,
	0xbf,0x91,0xa2,0x98,0xd0,0xf6,0x60,0xa0,
	0x00,0xaa,0xb1,0xa9,0x51,0xa2,0x25,0xbf,
	0x51,0xa9,0x91,0xa2,0xc8,0xca,0xd0,0xf2,
	0xb1,0xa2,0x25,0xbf,0x91,0xa2,0xc8,0xc4,
	0xb2,0xd0,0xf5,0x60,0x20,0xf9,0xb3,0x8a,
	0x29,0x03,0xaa,0xbd,0xf6,0xbf,0x49,0xff,
	0x85,0xbc,0x20,0xf7,0xb3,0x86,0xbd,0xa2,
	0x04,0x20,0x3f,0xb2,0x20,0xf7,0xb3,0x8a,
	0xf0,0x0c,0xa4,0xbd,0xb1,0xa2,0x45,0xbc,
	0x91,0xa2,0xc8,0xca,0xd0,0xf6,0x60,0xa0,
	0x00,0x84,0xa2,0xa9,0x03,0xe0,0x04,0xb0,
	0x03,0x8a,0x09,0x04,0x24,0xb2,0x10,0x03,
	0x4a,0x66,0xa2,0x05,0xb1,0xc9,0x08,0x90,
	0x03,0x85,0xa3,0x60,0xa0,0x1e,0x4c,0xd7,
	0xa8,0x20,0x8b,0xb2,0xe6,0x92,0x20,0xdf,
	0xb2,0x4c,0xea,0xb3,0xa2,0x00,0x86,0xa7,
	0x20,0x52,0xaa,0xc9,0x1c,0x38,0xd0,0x0d,
	0x20,0xf7,0xb3,0x8a,0x0a,0x0a,0x0a,0x0a,
	0x30,0x06,0x85,0xa7,0x18,0x86,0xa8,0x60,
	0x4c,0xed,0xbe,0x20,0x78,0xb2,0x8a,0xf0,
	0xf7,0x60,0x85,0x9d,0x20,0x24,0xb4,0xa4,
	0x92,0xb1,0x8a,0xc8,0x85,0xd4,0xb1,0x8a,
	0xc8,0x85,0xd5,0xb1,0x8a,0xc8,0x85,0xd6,
	0xb1,0x8a,0xc8,0x85,0xd7,0xb1,0x8a,0xc8,
	0x85,0xd8,0xb1,0x8a,0xc8,0x85,0xd9,0x84,
	0x92,0xd0,0x33,0x20,0x24,0xb4,0xa9,0x83,
	0x85,0x9d,0xa4,0x92,0xb1,0x8a,0x85,0xd6,
	0x38,0x65,0x92,0x85,0x92,0x98,0x38,0x65,
	0x8a,0x85,0xd4,0xa9,0x00,0x85,0xd7,0x65,
	0x8b,0x85,0xd5,0xd0,0x11,0xe6,0x92,0xa9,
	0x00,0x2c,0xa9,0x80,0x85,0x9c,0xa0,0x00,
	0x84,0x98,0x84,0x99,0x84,0x9a,0xa4,0x92,
	0xe6,0x92,0xb1,0x8a,0x30,0x38,0xc9,0x0f,
	0x90,0x98,0xf0,0xbf,0x48,0xaa,0xbd,0x62,
	0xb3,0x30,0x1e,0x85,0xa5,0xa4,0x98,0xf0,
	0x14,0xb1,0x80,0xaa,0xbd,0x62,0xb3,0x29,
	0x7e,0xc5,0xa5,0x90,0x08,0xe6,0x98,0x20,
	0x6b,0xb3,0x4c,0x05,0xb3,0xa5,0xa5,0xf0,
	0x09,0xc6,0x98,0xa4,0x98,0x68,0x91,0x80,
	0xd0,0xc4,0x68,0xc6,0x92,0x60,0x20,0x5b,
	0xba,0xa4,0x99,0xd0,0x12,0xa5,0x9e,0x69,
	0x02,0x85,0xa0,0xa5,0x9f,0x69,0x00,0x85,
	0xa1,0xa0,0x03,0x84,0x99,0xd0,0x03,0x20,
	0x28,0xb4,0x20,0x70,0xba,0xa0,0x00,0xb1,
	0x9e,0x85,0x9d,0xc9,0x40,0x90,0x97,0x4a,
	0x90,0x0a,0x4a,0xb0,0x91,0xa0,0x8c,0x20,
	0xc1,0xbc,0xd0,0x8a,0x24,0x9c,0x70,0xf2,
	0x4c,0x03,0xbf,0xbd,0x73,0xb4,0x48,0xbd,
	0x2c,0xb4,0x48,0x60,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,
	0x10,0x10,0x10,0x10,0x10,0x18,0x14,0x12,
	0x12,0x14,0x8e,0x0a,0x0c,0x84,0x02,0x08,
	0x08,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x9a,
	0x9a,0x84,0x84,0x84,0x84,0x84,0x07,0x9e,
	0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
	0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
	0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,0x9e,
	0x16,0x16,0x16,0x9e,0x84,0x9e,0x9e,0x9e,
	0x9e,0x9e,0x9e,0x9e,0x20,0xb6,0xdd,0xa4,
	0x99,0x88,0xb1,0xae,0x85,0xd9,0xb1,0x80,
	0x85,0xd8,0x88,0xb1,0xae,0x85,0xd7,0xb1,
	0x80,0x85,0xd6,0x88,0xb1,0xae,0x85,0xd5,
	0xb1,0x80,0x85,0xd4,0x84,0x99,0x60,0x20,
	0xc7,0xb3,0x20,0xd2,0xd9,0xb0,0x05,0xa6,
	0xd4,0xa5,0xd5,0x60,0x4c,0x0f,0xbf,0xe6,
	0x92,0x20,0xdf,0xb2,0x20,0xea,0xb3,0x10,
	0xf2,0x4c,0x07,0xbf,0xa4,0x99,0x88,0xb1,
	0xae,0x85,0xe5,0xb1,0x80,0x85,0xe4,0x88,
	0xb1,0xae,0x85,0xe3,0xb1,0x80,0x85,0xe2,
	0x88,0xb1,0xae,0x85,0xe1,0xb1,0x80,0x85,
	0xe0,0x84,0x99,0x60,0xa4,0x99,0xf0,0x1c,
	0xa5,0xd4,0x91,0x80,0xa5,0xd5,0x91,0xae,
	0xc8,0xa5,0xd6,0x91,0x80,0xa5,0xd7,0x91,
	0xae,0xc8,0xa5,0xd8,0x91,0x80,0xa5,0xd9,
	0x91,0xae,0xc8,0x2c,0xa0,0x03,0x84,0x99,
	0x60,0x27,0x27,0x27,0x27,0x27,0x27,0x65,
	0xc1,0xcd,0xca,0xd8,0x43,0x54,0x5b,0x3f,
	0x47,0xcc,0xe1,0xd6,0xd6,0xd6,0xd6,0xd6,
	0xd6,0x5d,0xb8,0x5e,0xdb,0x4e,0x3f,0x9e,
	0x5b,0xdd,0xf0,0x0a,0x3f,0x55,0x69,0x71,
	0x76,0xc0,0x3c,0xc3,0x32,0x4d,0x64,0x5e,
	0x6c,0x72,0xe7,0xeb,0xc1,0x29,0x29,0x29,
	0x29,0xf2,0x18,0x0d,0xff,0xf2,0x3d,0xf2,
	0xd7,0xf2,0x47,0xf2,0xca,0xca,0x31,0x23,
	0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,
	0xb5,0xb5,0xb5,0xb5,0xb5,0xb5,0xb7,0xb4,
	0xb7,0xb5,0xb4,0xb4,0xb4,0xb4,0xb4,0xb4,
	0xb6,0xb5,0xb6,0xb6,0xb7,0xb7,0xb7,0xb6,
	0xb7,0xb7,0xb8,0xb8,0xb8,0xb8,0xb8,0xb8,
	0xb8,0xb8,0xb8,0xb9,0xb9,0xb9,0xb9,0xb9,
	0xb9,0xb9,0xba,0xba,0xb8,0xb8,0xb8,0xb8,
	0xbe,0xba,0xba,0xb9,0xbe,0xba,0xbe,0xb7,
	0xbe,0xb8,0xbe,0xb9,0xb9,0xba,0xba,0x86,
	0x9d,0xbd,0x20,0xb5,0x85,0xda,0x20,0x04,
	0xb4,0xa6,0xd7,0xe4,0xe3,0xd0,0x04,0xa5,
	0xd6,0xc5,0xe2,0x08,0x68,0x85,0xc0,0xa0,
	0x00,0x90,0x06,0xa5,0xe2,0x85,0xd6,0xa6,
	0xe3,0x8a,0xf0,0x19,0xb1,0xd4,0xd1,0xe0,
	0xd0,0x1b,0xc8,0xd0,0xf7,0xe6,0xd5,0xe6,
	0xe1,0xca,0xd0,0xf0,0xf0,0x07,0xb1,0xd4,
	0xd1,0xe0,0xd0,0x09,0xc8,0xc4,0xd6,0xd0,
	0xf5,0xa5,0xc0,0x48,0x28,0x4c,0x33,0xb5,
	0x20,0x00,0xd8,0xa5,0xd5,0xf0,0x1a,0x60,
	0xbd,0x32,0xb5,0x85,0xda,0x20,0x04,0xb4,
	0x20,0xa5,0xba,0xf0,0x06,0xa9,0x16,0x90,
	0x04,0x4a,0x2c,0xa9,0x25,0x25,0xda,0xd0,
	0x07,0x4c,0x44,0xda,0xa5,0xd5,0xd0,0xf9,
	0xa2,0xf0,0xa0,0xbf,0x4c,0x89,0xdd,0x01,
	0x02,0x04,0x08,0x10,0x20,0x20,0x04,0xb4,
	0xd0,0xee,0xf0,0x05,0x20,0x04,0xb4,0xf0,
	0xe0,0xa5,0xd4,0x4c,0x3f,0xb5,0xa2,0x06,
	0xb5,0xd3,0x48,0xca,0xd0,0xfa,0x86,0xc1,
	0x20,0xc7,0xb3,0x20,0xec,0xba,0xc9,0x01,
	0x66,0xc0,0x10,0x03,0x20,0x6d,0xb9,0xa2,
	0xfa,0x68,0x95,0xe6,0xe8,0xd0,0xfa,0xa5,
	0xe0,0xf0,0x1c,0x06,0xc0,0x90,0x25,0x10,
	0x16,0xe9,0xc5,0x10,0x12,0xc9,0xfb,0x90,
	0x3d,0xaa,0xb5,0xe6,0x85,0xc1,0xb0,0x04,
	0xb5,0xe6,0xd0,0x32,0xe8,0x30,0xf9,0x20,
	0xc5,0xb5,0x20,0xcc,0xdd,0xb0,0x27,0x46,
	0xc1,0xb0,0x06,0x60,0xa5,0xe0,0x30,0x1e,
	0x60,0xa5,0xd4,0xf0,0x04,0x49,0x80,0x85,
	0xd4,0x60,0x20,0x04,0xb4,0x20,0xdb,0xda,
	0x4c,0xd4,0xb5,0x20,0xb9,0xb5,0x20,0x04,
	0xb4,0x20,0x66,0xda,0x90,0xdd,0x4c,0xff,
	0xbe,0x20,0xc4,0xb3,0x20,0x28,0xdb,0x4c,
	0xd4,0xb5,0x20,0xc4,0xb3,0xa6,0xe3,0xa5,
	0xe2,0xe4,0xd9,0xd0,0x02,0xc5,0xd8,0x90,
	0x04,0xa6,0xd9,0xa5,0xd8,0x85,0xda,0x86,
	0xdb,0x38,0xa5,0xd4,0xe5,0x8c,0xaa,0xa5,
	0xd5,0xe5,0x8d,0xa8,0x18,0x8a,0x65,0xda,
	0xaa,0x98,0x65,0xdb,0x48,0xa0,0x00,0x38,
	0x8a,0xf1,0xa0,0xaa,0xc8,0x68,0xf1,0xa0,
	0x85,0xe5,0x24,0x9c,0x30,0x0b,0x8a,0xc8,
	0xd1,0xa0,0xc8,0xa5,0xe5,0xf1,0xa0,0x90,
	0x0a,0xa0,0x03,0xa5,0xe5,0x91,0xa0,0x88,
	0x8a,0x91,0xa0,0xa4,0xe0,0xa5,0xe1,0x84,
	0xd6,0x85,0xd7,0xa0,0x00,0xa6,0xdb,0xf0,
	0x0e,0xb1,0xd6,0x91,0xd4,0xc8,0xd0,0xf9,
	0xe6,0xd7,0xe6,0xd5,0xca,0xd0,0xf2,0xa6,
	0xda,0xf0,0x08,0xb1,0xd6,0x91,0xd4,0xc8,
	0xca,0xd0,0xf8,0x60,0xe6,0x9a,0x60,0xa5,
	0x9a,0xf0,0x0a,0x20,0xfc,0xb3,0x86,0xe4,
	0x85,0xe5,0x20,0xc7,0xb3,0x20,0xfc,0xb3,
	0xa8,0x8a,0xd0,0x03,0x88,0x30,0x28,0xca,
	0x86,0xe2,0x84,0xe3,0x20,0xc7,0xb3,0xa2,
	0x03,0xe4,0x99,0xd0,0x0c,0xa5,0x9c,0xf0,
	0x08,0xa2,0x05,0xa5,0x9a,0xf0,0x02,0x06,
	0x9c,0xa5,0x9a,0xf0,0x0f,0xb5,0xd3,0xc5,
	0xe4,0xb5,0xd4,0xe5,0xe5,0xb0,0x03,0x4c,
	0x0b,0xbf,0xa2,0x11,0xb5,0xd3,0x85,0xd8,
	0x18,0xe5,0xe2,0xb5,0xd4,0x85,0xd9,0xe5,
	0xe3,0x90,0xec,0xa0,0xe2,0x84,0x9d,0x20,
	0xc1,0xbc,0xa2,0x7c,0x38,0xb5,0x5a,0xe5,
	0xe2,0x95,0x5a,0xa8,0xb5,0x5b,0xe5,0xe3,
	0x95,0x5b,0xe8,0xe8,0x10,0xee,0xc4,0xd6,
	0xaa,0xe5,0xd7,0xb0,0x04,0x84,0xd6,0x86,
	0xd7,0x4c,0x40,0xb7,0xa5,0x9a,0xf0,0x25,
	0x20,0xea,0xb3,0x86,0xd8,0x85,0xd9,0xa5,
	0x99,0x38,0xe9,0x04,0xa8,0x8a,0xf1,0x80,
	0xa5,0xd5,0xf1,0xae,0xb0,0x56,0x88,0xb1,
	0xae,0x85,0xd7,0xb1,0x80,0x85,0xd6,0x20,
	0x6b,0xbf,0x20,0xc4,0xb3,0x20,0xea,0xb3,
	0xa4,0x99,0x88,0x88,0x8a,0xd1,0x80,0xa5,
	0xd5,0xf1,0xae,0x88,0x84,0x99,0xb0,0x34,
	0xa5,0x9a,0xf0,0x05,0xa0,0xe0,0x20,0xc1,
	0xbc,0x20,0x8f,0xbf,0xa4,0x99,0xb1,0x80,
	0x65,0xd4,0x85,0x9e,0xaa,0xb1,0xae,0x65,
	0xd5,0x85,0x9f,0xc0,0x03,0xd0,0x04,0x85,
	0xa1,0x86,0xa0,0xa0,0x00,0x20,0x72,0xba,
	0xa5,0x9a,0x85,0x9b,0xa0,0x00,0x68,0x68,
	0x68,0x4c,0xec,0xb2,0x4c,0x03,0xbf,0x20,
	0xea,0xb3,0xa4,0x9a,0x84,0xe0,0x84,0xe1,
	0xf0,0x06,0x20,0xb6,0xdd,0x20,0xe7,0xb3,
	0xa8,0xe8,0x86,0xd6,0xd0,0x01,0xc8,0xa5,
	0xe0,0x18,0x69,0x01,0xaa,0xa9,0x00,0x65,
	0xe1,0x85,0xd9,0x20,0xb6,0xb7,0x20,0x6b,
	0xbf,0xb0,0xd1,0xc9,0x1a,0xb0,0xcd,0x20,
	0x8f,0xbf,0xa8,0xa5,0xd4,0xa6,0x8e,0x86,
	0xd4,0xa6,0x8f,0x86,0xd5,0xa2,0x8e,0x20,
	0x4d,0xbc,0xa0,0xfe,0xc6,0xa1,0xb1,0xa0,
	0x09,0x01,0x91,0xa0,0x4c,0x40,0xb7,0x20,
	0xfc,0xb3,0x85,0xd9,0x05,0xd4,0xf0,0xa4,
	0xa0,0x00,0x84,0xd6,0x20,0xb6,0xb7,0xa5,
	0xd8,0xa4,0xd9,0x4c,0x85,0xb7,0x84,0xd7,
	0x86,0xd8,0xa0,0x03,0xb1,0xae,0xf0,0x8c,
	0xa5,0x8e,0x38,0xe5,0x8c,0x85,0xd4,0xa5,
	0x8f,0xe5,0x8d,0x85,0xd5,0xa0,0x05,0xb9,
	0xd4,0x00,0x91,0xa0,0x88,0x10,0xf8,0x60,
	0x18,0x20,0x38,0xbb,0xd0,0x0f,0x20,0xe6,
	0xd8,0xa0,0xff,0xc8,0xb1,0xf3,0x10,0xfb,
	0x49,0x80,0x91,0xf3,0xc8,0xa5,0xf3,0xd0,
	0x0a,0x20,0xea,0xb3,0x8e,0xc0,0x05,0xa9,
	0xc0,0xa0,0x01,0xa2,0x05,0x85,0xd4,0x86,
	0xd5,0x84,0xd6,0xa2,0x00,0x86,0xd7,0xca,
	0x86,0x9d,0x60,0xa5,0x9b,0x85,0xc0,0x20,
	0xea,0xb3,0x20,0x20,0xb8,0x4c,0xaa,0xd9,
	0x8a,0x48,0xa5,0xd5,0x48,0x20,0xe7,0xb3,
	0xc6,0x9b,0x10,0xf4,0xa5,0xc0,0x48,0x6c,
	0xd4,0x00,0xbd,0xe8,0xb7,0x48,0x20,0xfc,
	0xb3,0xa9,0x02,0x85,0xd5,0x68,0xa8,0x90,
	0x0b,0x70,0x78,0x7c,0x84,0x20,0xea,0xb3,
	0xa0,0x00,0x84,0x9d,0xa2,0x00,0xf0,0x09,
	0x20,0xea,0xb3,0xa0,0x01,0xb1,0xd4,0xaa,
	0x88,0xb1,0xd4,0x4c,0xf7,0xba,0xa9,0x00,
	0x85,0xf2,0x85,0x9d,0x20,0x08,0xbc,0x20,
	0x20,0xb5,0x20,0x25,0xbc,0x90,0x41,0x4c,
	0xf1,0xbe,0xa5,0xd6,0x85,0xd4,0xa5,0xd7,
	0x85,0xd5,0x46,0x9d,0x4c,0xaa,0xd9,0x20,
	0xec,0xba,0x0a,0x30,0x05,0x20,0xa9,0xb8,
	0x90,0x14,0x20,0xb6,0xdd,0x20,0x48,0xb5,
	0x20,0x28,0xdb,0x20,0xa9,0xb8,0xa2,0xdb,
	0x20,0x00,0xbb,0x20,0x60,0xda,0xa5,0xfb,
	0xf0,0x08,0xa2,0xea,0x20,0x00,0xbb,0x20,
	0xdb,0xda,0x06,0xd4,0x06,0xc0,0x66,0xd4,
	0x60,0x20,0x04,0xbb,0x20,0xb6,0xdd,0x20,
	0xdb,0xda,0xa2,0xae,0xa0,0xdf,0xa9,0x0b,
	0x20,0x40,0xdd,0x20,0x0b,0xbb,0x4c,0xdb,
	0xda,0xa2,0x01,0x2c,0xa2,0x00,0x86,0xc0,
	0xa9,0xdb,0x18,0x65,0xfb,0xaa,0x20,0x00,
	0xbb,0x20,0x28,0xdb,0x20,0x04,0xbb,0x20,
	0xc2,0xba,0xa5,0xd4,0x29,0x7f,0xaa,0xa9,
	0x00,0xe0,0x40,0x90,0x06,0xe0,0x45,0xb0,
	0x02,0xb5,0x95,0x29,0x1f,0xc9,0x10,0x90,
	0x02,0x69,0x01,0x24,0xd4,0x10,0x03,0x49,
	0x03,0x38,0x65,0xc0,0x85,0xc1,0x20,0x0b,
	0xbb,0x20,0x60,0xda,0x46,0xc1,0x90,0x06,
	0x20,0xfe,0xba,0x20,0x66,0xda,0x20,0xec,
	0xba,0x20,0x04,0xbb,0x20,0xb6,0xdd,0x20,
	0xdb,0xda,0xa2,0xbd,0xa0,0xbf,0xa9,0x06,
	0x20,0xb8,0xb8,0x46,0xc1,0x90,0x03,0x20,
	0xb9,0xb5,0x24,0xd4,0x50,0x04,0xa9,0x00,
	0x85,0xd9,0x60,0xa2,0x05,0xa9,0x3f,0x85,
	0xd4,0xad,0x0a,0xd2,0xc9,0xa0,0xb0,0xf9,
	0x95,0xd4,0x29,0x0f,0xc9,0x0a,0xb0,0xf1,
	0xca,0xd0,0xee,0x4c,0x00,0xdc,0xad,0xe5,
	0x02,0x38,0xe5,0x90,0xa8,0xad,0xe6,0x02,
	0xe5,0x91,0xaa,0x98,0x4c,0xf7,0xba,0x20,
	0xcd,0xde,0xb0,0x06,0x60,0x20,0xc0,0xdd,
	0x90,0xfa,0x4c,0x0f,0xbf,0x20,0xd1,0xde,
	0x4c,0x62,0xb9,0x20,0x04,0xbb,0xa5,0xd4,
	0xf0,0x47,0x30,0xee,0x18,0x69,0x40,0x85,
	0xd4,0xa2,0x09,0x86,0xc0,0xa9,0x00,0x69,
	0x11,0xca,0xbc,0xc2,0xb9,0xc4,0xd5,0x90,
	0xf6,0x46,0xd4,0xb0,0x02,0x29,0x0f,0x85,
	0xd5,0x20,0xb6,0xdd,0xa2,0xe0,0x20,0x06,
	0xbb,0xa2,0xe6,0xa0,0x05,0x20,0x89,0xdd,
	0x20,0x28,0xdb,0xa2,0xe0,0x20,0x0d,0xbb,
	0x20,0x66,0xda,0xa2,0x6c,0xa0,0xdf,0x20,
	0x98,0xdd,0x20,0xdb,0xda,0x06,0xc0,0x10,
	0xd8,0x60,0xff,0x87,0x66,0x55,0x36,0x24,
	0x14,0x07,0x02,0xe0,0x60,0x08,0x20,0xfc,
	0xb3,0xbd,0x78,0x02,0x48,0x20,0x44,0xda,
	0x68,0x28,0xf0,0x04,0x4a,0x4a,0x49,0x03,
	0x29,0x03,0xaa,0xbd,0xe6,0xbf,0x85,0xd4,
	0x06,0xd4,0xf0,0x0a,0xa9,0x80,0x6a,0x48,
	0x20,0x48,0xb5,0x68,0x85,0xd4,0x60,0x20,
	0xea,0xb3,0x20,0xb6,0xdd,0x4c,0xe7,0xb3,
	0x20,0xf7,0xb9,0x25,0xe1,0xa8,0x8a,0x25,
	0xe0,0x84,0xd5,0x4c,0xf9,0xba,0x20,0xf7,
	0xb9,0x05,0xe1,0xa8,0x8a,0x05,0xe0,0x90,
	0xf0,0x20,0xf7,0xb9,0x45,0xe1,0xa8,0x8a,
	0x45,0xe0,0x90,0xe5,0xa5,0xba,0xa6,0xd4,
	0xf0,0x03,0xa6,0xbb,0x2c,0xa5,0xc3,0x4c,
	0xf7,0xba,0x20,0xea,0xb3,0x20,0x3f,0xb2,
	0xaa,0xa5,0xa2,0x4c,0xf7,0xba,0x20,0xf7,
	0xb9,0xa5,0xe0,0x29,0x08,0x49,0x0c,0x45,
	0xd4,0xa8,0xa5,0xe0,0x29,0x03,0xaa,0xbd,
	0x4f,0xb5,0x39,0x00,0xd0,0x20,0x3f,0xb5,
	0x4c,0x40,0xb7,0x0a,0x0a,0x26,0x9f,0x0a,
	0x26,0x9f,0x18,0x65,0x86,0x85,0x9e,0xa5,
	0x9f,0x29,0x03,0x65,0x87,0x85,0x9f,0x60,
	0xa0,0x02,0xb1,0x9e,0xc8,0x85,0xd4,0xb1,
	0x9e,0xc8,0x85,0xd5,0xb1,0x9e,0xc8,0x85,
	0xd6,0xb1,0x9e,0xc8,0x85,0xd7,0xb1,0x9e,
	0xc8,0x85,0xd8,0xb1,0x9e,0x85,0xd9,0x60,
	0xa0,0x00,0xb1,0xa9,0xc8,0xaa,0x10,0xfa,
	0x98,0xa2,0xa9,0x18,0x75,0x00,0x95,0x00,
	0x90,0x02,0xf6,0x01,0x60,0xa5,0xe0,0x45,
	0xd4,0x10,0x07,0x24,0x6a,0x45,0xd4,0x38,
	0x2a,0x60,0x05,0xd4,0xf0,0xfb,0xa2,0xfa,
	0xb5,0xda,0xd5,0xe6,0xd0,0xee,0xe8,0xd0,
	0xf7,0x60,0xa5,0xd4,0x0a,0x30,0x08,0x08,
	0x20,0x44,0xda,0x28,0xb0,0x18,0x60,0x4a,
	0x69,0xbc,0xb0,0xfa,0xaa,0xa9,0x00,0xa8,
	0x15,0xda,0x94,0xda,0xe8,0xd0,0xf9,0xa8,
	0xf0,0xec,0xa5,0xd4,0x10,0xe8,0x20,0xfe,
	0xba,0x4c,0x60,0xda,0xa5,0xd4,0x85,0xc0,
	0x29,0x7f,0x85,0xd4,0x60,0xa2,0x00,0x86,
	0xd5,0x85,0xd4,0x4c,0xaa,0xd9,0xa2,0xf0,
	0xa0,0xbf,0xd0,0x0b,0xa2,0xe6,0xa0,0x05,
	0x4c,0xa7,0xdd,0xa2,0xe6,0xa0,0x05,0x4c,
	0x98,0xdd,0xa9,0x00,0x85,0xa7,0x86,0xf3,
	0xa6,0xf3,0xbd,0x0d,0xa0,0xf0,0x18,0x20,
	0x64,0xbb,0x10,0xf4,0x20,0xaa,0xd9,0x20,
	0xe6,0xd8,0xa0,0x00,0xb1,0xf3,0x48,0x29,
	0x7f,0x20,0x64,0xbb,0x68,0x10,0xf3,0x60,
	0x08,0x20,0x51,0xda,0x20,0xd2,0xd9,0xa0,
	0x00,0x28,0xa5,0xd5,0x90,0x02,0xf0,0x03,
	0x20,0x4d,0xbb,0xa5,0xd4,0x48,0x4a,0x4a,
	0x4a,0x4a,0x20,0x58,0xbb,0x68,0x29,0x0f,
	0xc9,0x0a,0x90,0x02,0x69,0x06,0x69,0x30,
	0x91,0xf3,0xc8,0x60,0xe6,0xf3,0xd0,0x02,
	0xe6,0xf4,0xd0,0x05,0xa9,0x9b,0x2c,0xa9,
	0x20,0xc6,0xab,0xd0,0x04,0xa6,0xc9,0x86,
	0xab,0xa6,0xa7,0x20,0x91,0xbb,0x98,0x10,
	0x21,0x84,0xc2,0xa5,0xa7,0x49,0x70,0xd0,
	0x05,0x85,0xa6,0x20,0xd6,0xbb,0x4c,0x13,
	0xbf,0x85,0x2f,0xbd,0x4a,0x03,0x85,0x2a,
	0xbd,0x47,0x03,0x48,0xbd,0x46,0x03,0x48,
	0xa5,0x2f,0x60,0x20,0x32,0xbc,0x20,0x56,
	0xe4,0x10,0xf7,0xc0,0x88,0xd0,0xd2,0x60,
	0xa9,0x04,0xa6,0xa7,0x9d,0x4a,0x03,0xa9,
	0x03,0xa6,0xa7,0x48,0x20,0x08,0xbc,0x20,
	0x0d,0xb1,0x68,0x20,0xda,0xbb,0x20,0x25,
	0xbc,0x4c,0x7f,0xbb,0x20,0xd2,0xbb,0x4c,
	0xdf,0xb2,0xa2,0x70,0x86,0xa7,0xa6,0xa7,
	0xa9,0x0c,0x9d,0x42,0x03,0x4c,0x56,0xe4,
	0x38,0x6e,0xbb,0x03,0xa0,0xb3,0xa2,0x70,
	0x86,0xa7,0x84,0xbf,0x48,0x20,0xd8,0xbb,
	0x68,0x9d,0x4a,0x03,0xa5,0xbf,0xa0,0xbf,
	0x20,0x0d,0xb1,0xa9,0x03,0xa6,0xa7,0x9d,
	0x42,0x03,0x20,0x56,0xe4,0x4c,0x7f,0xbb,
	0xa4,0xd6,0xa5,0xd7,0xf0,0x02,0xa0,0xff,
	0x84,0xad,0xb1,0xd4,0x85,0xac,0xe6,0xb3,
	0xa9,0x9b,0x91,0xd4,0xa5,0xd4,0xa4,0xd5,
	0x85,0xf3,0x84,0xf4,0x60,0x98,0x48,0xa4,
	0xad,0xa5,0xac,0x91,0xf3,0xc6,0xb3,0x68,
	0xa8,0x60,0x86,0xa7,0x20,0x51,0xda,0xa0,
	0x05,0xa9,0x80,0x20,0x0d,0xb1,0x9d,0x42,
	0x03,0xa0,0xff,0xa9,0x00,0x9d,0x49,0x03,
	0x98,0x9d,0x48,0x03,0x60,0x85,0xd8,0x84,
	0xd9,0x8a,0x48,0x38,0x38,0xa5,0x90,0xe5,
	0xd4,0x85,0xda,0xa5,0x91,0xe5,0xd5,0x85,
	0xdb,0x18,0xa5,0x90,0x85,0xd6,0x65,0xd8,
	0xa8,0xa5,0x91,0x85,0xd7,0x65,0xd9,0x20,
	0x89,0xbc,0x20,0x9a,0xbc,0x68,0xaa,0xa0,
	0xd8,0x20,0xc3,0xbc,0xe8,0xe8,0xe0,0x92,
	0xd0,0xf7,0x85,0x0f,0xa5,0x90,0x85,0x0e,
	0x60,0xb0,0x0c,0xcd,0xe6,0x02,0xd0,0x05,
	0xcc,0xe5,0x02,0xf0,0xf3,0x90,0xf1,0x4c,
	0x11,0xbf,0x84,0xd4,0x85,0xd5,0xa0,0x00,
	0xa6,0xdb,0xe8,0xd0,0x08,0x88,0xb1,0xd6,
	0x91,0xd4,0x98,0xd0,0xf8,0xc6,0xd5,0xc6,
	0xd7,0xca,0xd0,0xf1,0xa6,0xda,0xf0,0x08,
	0x88,0xb1,0xd6,0x91,0xd4,0xca,0xd0,0xf8,
	0x60,0xa2,0xd4,0xb5,0x00,0x18,0x79,0x00,
	0x00,0x95,0x00,0xb5,0x01,0x79,0x01,0x00,
	0x95,0x01,0x60,0xa9,0xff,0x85,0xbd,0x4a,
	0x85,0xbe,0xa9,0x00,0x85,0xa2,0x85,0xa3,
	0x85,0xa7,0x20,0xdf,0xb2,0xa4,0x99,0xf0,
	0x2f,0xa5,0x9d,0x10,0x16,0x20,0xd2,0xbb,
	0xa9,0x08,0x20,0xb2,0xbb,0x20,0xfb,0xbc,
	0x4c,0xd6,0xbb,0x20,0x52,0xaa,0xf0,0x18,
	0x20,0xdd,0xb2,0x20,0xfc,0xb3,0x86,0xa2,
	0x85,0xa3,0x20,0x52,0xaa,0xf0,0x03,0x20,
	0xf7,0xb3,0x86,0xbd,0xa5,0xd5,0x85,0xbe,
	0xa6,0xa2,0xa5,0xa3,0x20,0x13,0xaa,0x85,
	0xa2,0x84,0xa3,0x38,0x6e,0xfe,0x02,0xa0,
	0x00,0x18,0xb1,0xa2,0x85,0xd4,0xe5,0xbd,
	0xc8,0xb1,0xa2,0x85,0xd5,0xe5,0xbe,0x90,
	0x04,0x0e,0xfe,0x02,0x60,0x20,0x24,0xbb,
	0x20,0x6f,0xbb,0xa0,0x03,0xb1,0xa2,0xc8,
	0x85,0xbf,0xb1,0xa2,0xc8,0x84,0xa4,0xc9,
	0x36,0xf0,0x13,0xc9,0x37,0xf0,0x35,0x48,
	0xa0,0x05,0xa2,0xa3,0x20,0xf9,0xbd,0x20,
	0x6f,0xbb,0x68,0x4a,0xf0,0x2b,0x20,0x12,
	0xbe,0xc9,0x16,0xf0,0x09,0x20,0xea,0xbd,
	0xa4,0xa4,0xc4,0xbf,0xd0,0xf0,0xa0,0x02,
	0xb1,0xa2,0xc5,0xbf,0xf0,0x04,0xa4,0xbf,
	0xd0,0xc3,0xa2,0xa2,0x20,0x9b,0xba,0x20,
	0x6c,0xbb,0x10,0x9b,0xa2,0x28,0x20,0x16,
	0xbb,0x20,0x12,0xbe,0xc9,0x9b,0xf0,0xde,
	0x20,0x71,0xbb,0x10,0xf4,0x48,0xa2,0xfa,
	0x20,0x12,0xbe,0x95,0xda,0xe8,0xd0,0xf8,
	0x68,0xc9,0x0d,0xf0,0x03,0x4c,0x27,0xbb,
	0xa9,0x24,0x20,0x71,0xbb,0x38,0x20,0x38,
	0xbb,0x09,0x80,0x88,0x91,0xf3,0x4c,0x2a,
	0xbb,0x20,0xd5,0xbd,0x20,0x12,0xbe,0x85,
	0xd4,0xf0,0x0a,0x20,0x12,0xbe,0x20,0x71,
	0xbb,0xc6,0xd4,0xd0,0xf6,0xa9,0x22,0x4c,
	0x71,0xbb,0x29,0x7f,0xa4,0x82,0xa6,0x83,
	0x20,0xf9,0xbd,0xc9,0xa8,0xd0,0x02,0xe6,
	0xa4,0x60,0xaa,0x30,0xed,0xc9,0x0f,0x90,
	0xac,0xf0,0xce,0xe9,0x12,0xa0,0x19,0xa2,
	0xbe,0x85,0xbc,0x84,0xa9,0x86,0xaa,0x98,
	0x4c,0x06,0xbe,0x20,0x90,0xba,0xc6,0xbc,
	0x10,0xf9,0xa4,0xaa,0x20,0x20,0xbc,0x4c,
	0x2a,0xbb,0xa4,0xa4,0xe6,0xa4,0xb1,0xa2,
	0x60,0xac,0xa4,0xba,0xbb,0xbf,0x20,0x47,
	0x4f,0x54,0x4f,0xa0,0x20,0x47,0x4f,0x53,
	0x55,0x42,0xa0,0x20,0x54,0x4f,0xa0,0x20,
	0x53,0x54,0x45,0x50,0xa0,0x20,0x54,0x48,
	0x45,0x4e,0xa0,0xa3,0x3c,0xbd,0x3c,0xbe,
	0x3e,0xbd,0xbc,0xbe,0xbd,0xde,0xaa,0xab,
	0xad,0xaf,0x20,0x4e,0x4f,0x54,0xa0,0x20,
	0x4f,0x52,0xa0,0x20,0x41,0x4e,0x44,0xa0,
	0xa8,0xa9,0xbd,0xbd,0x3c,0xbd,0x3c,0xbe,
	0x3e,0xbd,0xbc,0xbe,0xbd,0xab,0xad,0xa8,
	0xa8,0xa8,0xa8,0xa8,0xac,0x53,0x54,0x52,
	0xa4,0x43,0x48,0x52,0xa4,0x55,0x53,0xd2,
	0x41,0x53,0xc3,0x56,0x41,0xcc,0x4c,0x45,
	0xce,0x41,0x44,0xd2,0x41,0x54,0xce,0x43,
	0x4f,0xd3,0x50,0x45,0x45,0xcb,0x53,0x49,
	0xce,0x52,0x4e,0xc4,0x46,0x52,0xc5,0x45,
	0x58,0xd0,0x4c,0x4f,0xc7,0x43,0x4c,0x4f,
	0xc7,0x53,0x51,0xd2,0x53,0x47,0xce,0x41,
	0x42,0xd3,0x49,0x4e,0xd4,0x50,0x41,0x44,
	0x44,0x4c,0xc5,0x53,0x54,0x49,0x43,0xcb,
	0x50,0x54,0x52,0x49,0xc7,0x53,0x54,0x52,
	0x49,0xc7,0x81,0xa5,0xa1,0xa6,0x81,0x42,
	0x55,0x4d,0x50,0xa8,0x81,0x48,0x45,0x58,
	0xa4,0x81,0x44,0x50,0x45,0x45,0xcb,0x81,
	0x56,0x53,0x54,0x49,0x43,0xcb,0x48,0x53,
	0x54,0x49,0x43,0xcb,0x50,0x4d,0x41,0x44,
	0xd2,0x45,0x52,0xd2,0x00,0xe6,0xc2,0xe6,
	0xc2,0xe6,0xc2,0xe6,0xc2,0xe6,0xc2,0xe6,
	0xc2,0xe6,0xc2,0xe6,0xc2,0xe6,0xc2,0xe6,
	0xc2,0xe6,0xc2,0xe6,0xc2,0xe6,0xc2,0xe6,
	0xc2,0xe6,0xc2,0xe6,0xc2,0xe6,0xc2,0xe6,
	0xc2,0xe6,0xc2,0xa2,0xff,0x9a,0x86,0x11,
	0x20,0x42,0xac,0xa0,0x00,0x8c,0xfe,0x02,
	0x84,0xd5,0xb1,0x8a,0x85,0xba,0xc8,0xb1,
	0x8a,0x85,0xbb,0xa5,0xc2,0x85,0xd4,0x84,
	0xc2,0xc9,0x80,0xd0,0x08,0xa2,0x1e,0x20,
	0x12,0xbb,0x4c,0x53,0xbf,0x85,0xc3,0xa5,
	0x96,0x30,0x08,0xa6,0x95,0x38,0x66,0x96,
	0x20,0xfe,0xaf,0xa2,0x27,0x20,0x12,0xbb,
	0x20,0x24,0xbb,0xa5,0xbb,0x85,0xd5,0x30,
	0x0c,0xa2,0x32,0x20,0x16,0xbb,0xa5,0xba,
	0x85,0xd4,0x20,0x24,0xbb,0x20,0x6c,0xbb,
	0x4c,0x55,0xa0,0xa9,0x00,0x85,0xd4,0xa2,
	0x10,0x06,0xd4,0x2a,0xb0,0x18,0xa8,0x06,
	0xd6,0x26,0xd7,0x90,0x0c,0x18,0xa5,0xd4,
	0x65,0xd8,0x85,0xd4,0x98,0x65,0xd9,0xb0,
	0x05,0xca,0xd0,0xe5,0x85,0xd5,0x60,0xa5,
	0xd4,0xa4,0xd5,0x0a,0x26,0xd5,0x65,0xd4,
	0x85,0xd4,0x98,0x65,0xd5,0x06,0xd4,0x2a,
	0x85,0xd5,0x60,0x1c,0x0c,0x00,0x00,0x80,
	0x03,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x43,0x53,0x45,0x50,0x44,
	0x3a,0x2a,0x2e,0x2a,0x9b,0xbd,0x03,0x43,
	0x18,0x69,0x61,0x3e,0x01,0x60,0x25,0x47,
	0x91,0xbe,0x46,0x81,0x65,0x78,0x84,0x3f,
	0x07,0x96,0x92,0x60,0x37,0xbf,0x64,0x59,
	0x64,0x09,0x56,0x40,0x01,0x57,0x07,0x96,
	0x33,0x40,0x90,0x00,0x00,0x00,0x00,0xff,
	0x01,0x00,0x40,0x57,0x29,0x57,0x79,0x51,
	0x40,0x01,0x00,0x00,0x00,0x00,0xfc,0xf3,
	0xcf,0x3f,0x00,0xa0,0x00,0x05,0x51,0xaa
};
#endif
