# Copyright (C) 2005 JanRain, Inc.
# Copyright (C) 2009, 2010 Canonical Ltd
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import urllib

from apache_openid import logging

class ProvidersMixin(object):
    @property
    def allowed_ops(self):
        """Get OPs that can be selected for login using directed identity."""
        try:
            return self._allowed_ops
        except AttributeError:
            return self.get_allowed_ops_from_url(
                self.options.get('allowed-op-list-url'))

    def get_allowed_ops_from_url(self, url):
        try:
            url_handle = urllib.urlopen(url)
            data = url_handle.read()
            url_handle.close()
            op_list = self.parse_allowed_ops(data)
            self._allowed_ops = op_list
            return self._allowed_ops
        except (AttributeError, IOError):
            logging.error('Failed to fetch allowed OP URL %r', url)
            return {}

    def parse_allowed_ops(self, data):
        """Parse a key=value string of OP URI's, separated by newlines."""
        ops = {}
        for s in data.split('\n'):
            op = s.strip()
            if not op or op[0] == '#':
                continue
            if op.find('=') < 0:
                ops[op] = op
            else:
                op_parts = op.split('=')
                ops[op_parts[0].strip()] = op_parts[1].strip()
        return ops
