/* KDevelop
 *
 * Copyright 2007 Andreas Pakulat <apaku@gmx.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

#ifndef FUNCTIONSCOPETEST_H
#define FUNCTIONSCOPETEST_H

#include <QObject>
#include <QTest>

namespace QMake
{
    class StatementAST;
    class ProjectAST;
    class FunctionArgAST;
}

class FunctionScopeTest : public QObject
{
        Q_OBJECT
    public:
        explicit FunctionScopeTest( QObject* parent = nullptr );
        ~FunctionScopeTest() override;
    private Q_SLOTS:
        void init();
        void cleanup();
        void execSimpleFunc();
        void execSimpleFunc_data();
        void execBasicFunc();
        void execBasicFunc_data();
        void evalQMakeSyntax();
        void evalQMakeSyntax_data();
        void simpleVarArg();
        void simpleVarArg_data();
        void argWithEqual();
        void argWithEqual_data();
        void partlyQuotedArg();
        void partlyQuotedArg_data();
        void slashArg();
        void slashArg_data();
        void oneStatementScope();
        void oneStatementScope_data();
        void nestedFunccalls();
        void nestedFunccalls_data();
        void multiLineScope();
        void multiLineScope_data();
        void multiLineScopeFuncCall();
        void multiLineScopeFuncCall_data();
        void oneStatementSubScope();
        void oneStatementSubScope_data();
        void notFunc();
        void notFunc_data();
        void orOperator();
        void orOperator_data();
        void spaceBeforeBrace();
        void spaceBeforeBrace_data();

        void missingStatement();
        void missingStatement_data();
        void missingBrace();
        void missingBrace_data();
        void missingParenthesis();
        void missingParenthesis_data();
    private:
        QMake::ProjectAST* ast;

};

#endif

