## Usage

```js
var isUncPath = require('{%= name %}');
```

**true**

Returns true for windows UNC paths:

```js
isUncPath('\\/foo/bar');
isUncPath('\\\\foo/bar');
isUncPath('\\\\foo\\admin$');
isUncPath('\\\\foo\\admin$\\system32');
isUncPath('\\\\foo\\temp');
isUncPath('\\\\/foo/bar');
isUncPath('\\\\\\/foo/bar');
```

**false**

Returns false for non-UNC paths:

```js
isUncPath('/foo/bar');
isUncPath('/');
isUncPath('/foo');
isUncPath('/foo/');
isUncPath('c:');
isUncPath('c:.');
isUncPath('c:./');
isUncPath('c:./file');
isUncPath('c:/');
isUncPath('c:/file');
```

**Customization**

Use `.source` to use the regex as a component of another regex:

```js
var myRegex = new RegExp(isUncPath.source + 'foo');
```

**[Rules for UNC paths][rules]**

- The computer name is always preceded by a double backward-slash (`\\`).
- UNC paths cannot contain a drive letter (such as `D:`)


[rules]: http://resources.esri.com/help/9.3/ArcGISDesktop/com/Gp_ToolRef/sharing_tools_and_toolboxes/pathnames_explained_colon_absolute_relative_unc_and_url.htm
