# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .rating_py3 import Rating


class AggregateRating(Rating):
    """Defines the metrics that indicate how well an item was rated by others.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar text: Text representation of an item.
    :vartype text: str
    :param _type: Required. Constant filled by server.
    :type _type: str
    :param rating_value: Required. The mean (average) rating. The possible
     values are 1.0 through 5.0.
    :type rating_value: float
    :ivar best_rating: The highest rated review. The possible values are 1.0
     through 5.0.
    :vartype best_rating: float
    :ivar review_count: The number of times the recipe has been rated or
     reviewed.
    :vartype review_count: int
    """

    _validation = {
        'text': {'readonly': True},
        '_type': {'required': True},
        'rating_value': {'required': True},
        'best_rating': {'readonly': True},
        'review_count': {'readonly': True},
    }

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        '_type': {'key': '_type', 'type': 'str'},
        'rating_value': {'key': 'ratingValue', 'type': 'float'},
        'best_rating': {'key': 'bestRating', 'type': 'float'},
        'review_count': {'key': 'reviewCount', 'type': 'int'},
    }

    def __init__(self, *, rating_value: float, **kwargs) -> None:
        super(AggregateRating, self).__init__(rating_value=rating_value, **kwargs)
        self.review_count = None
        self._type = 'AggregateRating'
