# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Capabilities(Model):
    """The regional capabilities.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar resource_type: The resource type that this capability describes.
    :vartype resource_type: str
    :ivar os_type: The OS type that this capability describes.
    :vartype os_type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar ip_address_type: The ip address type that this capability describes.
    :vartype ip_address_type: str
    :ivar gpu: The GPU sku that this capability describes.
    :vartype gpu: str
    :ivar capabilities: The supported capabilities.
    :vartype capabilities:
     ~azure.mgmt.containerinstance.models.CapabilitiesCapabilities
    """

    _validation = {
        'resource_type': {'readonly': True},
        'os_type': {'readonly': True},
        'location': {'readonly': True},
        'ip_address_type': {'readonly': True},
        'gpu': {'readonly': True},
        'capabilities': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'ip_address_type': {'key': 'ipAddressType', 'type': 'str'},
        'gpu': {'key': 'gpu', 'type': 'str'},
        'capabilities': {'key': 'capabilities', 'type': 'CapabilitiesCapabilities'},
    }

    def __init__(self, **kwargs):
        super(Capabilities, self).__init__(**kwargs)
        self.resource_type = None
        self.os_type = None
        self.location = None
        self.ip_address_type = None
        self.gpu = None
        self.capabilities = None
