# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ManagementLockObject(Model):
    """Management lock information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param level: The lock level of the management lock. Possible values
     include: 'NotSpecified', 'CanNotDelete', 'ReadOnly'
    :type level: str or
     ~azure.mgmt.resource.locks.v2015_01_01.models.LockLevel
    :param notes: The notes of the management lock.
    :type notes: str
    :ivar id: The Id of the lock.
    :vartype id: str
    :ivar type: The type of the lock.
    :vartype type: str
    :param name: The name of the lock.
    :type name: str
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'level': {'key': 'properties.level', 'type': 'str'},
        'notes': {'key': 'properties.notes', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ManagementLockObject, self).__init__(**kwargs)
        self.level = kwargs.get('level', None)
        self.notes = kwargs.get('notes', None)
        self.id = None
        self.type = None
        self.name = kwargs.get('name', None)
