# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceSku(Model):
    """The billing information of the SignalR resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Required.
     Allowed values: Standard_S1, Free_F1
    :type name: str
    :param tier: Optional tier of this particular SKU. 'Standard' or 'Free'.
     `Basic` is deprecated, use `Standard` instead. Possible values include:
     'Free', 'Basic', 'Standard', 'Premium'
    :type tier: str or ~azure.mgmt.signalr.models.SignalRSkuTier
    :param size: Optional string. For future use.
    :type size: str
    :param family: Optional string. For future use.
    :type family: str
    :param capacity: Optional, integer. The unit count of SignalR resource. 1
     by default.
     If present, following values are allowed:
     Free: 1
     Standard: 1,2,5,10,20,50,100
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'size': {'key': 'size', 'type': 'str'},
        'family': {'key': 'family', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ResourceSku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.size = kwargs.get('size', None)
        self.family = kwargs.get('family', None)
        self.capacity = kwargs.get('capacity', None)
