# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential
    from azure.core.pipeline.transport import HttpRequest, HttpResponse

from ._configuration import VMwareCloudSimpleConfiguration
from .operations import Operations
from .operations import DedicatedCloudNodesOperations
from .operations import DedicatedCloudServicesOperations
from .operations import SkusAvailabilityOperations
from .operations import PrivateCloudsOperations
from .operations import CustomizationPoliciesOperations
from .operations import ResourcePoolsOperations
from .operations import VirtualMachineTemplatesOperations
from .operations import VirtualNetworksOperations
from .operations import UsagesOperations
from .operations import VirtualMachinesOperations
from . import models


class VMwareCloudSimple(object):
    """Description of the new service.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.vmwarecloudsimple.operations.Operations
    :ivar dedicated_cloud_nodes: DedicatedCloudNodesOperations operations
    :vartype dedicated_cloud_nodes: azure.mgmt.vmwarecloudsimple.operations.DedicatedCloudNodesOperations
    :ivar dedicated_cloud_services: DedicatedCloudServicesOperations operations
    :vartype dedicated_cloud_services: azure.mgmt.vmwarecloudsimple.operations.DedicatedCloudServicesOperations
    :ivar skus_availability: SkusAvailabilityOperations operations
    :vartype skus_availability: azure.mgmt.vmwarecloudsimple.operations.SkusAvailabilityOperations
    :ivar private_clouds: PrivateCloudsOperations operations
    :vartype private_clouds: azure.mgmt.vmwarecloudsimple.operations.PrivateCloudsOperations
    :ivar customization_policies: CustomizationPoliciesOperations operations
    :vartype customization_policies: azure.mgmt.vmwarecloudsimple.operations.CustomizationPoliciesOperations
    :ivar resource_pools: ResourcePoolsOperations operations
    :vartype resource_pools: azure.mgmt.vmwarecloudsimple.operations.ResourcePoolsOperations
    :ivar virtual_machine_templates: VirtualMachineTemplatesOperations operations
    :vartype virtual_machine_templates: azure.mgmt.vmwarecloudsimple.operations.VirtualMachineTemplatesOperations
    :ivar virtual_networks: VirtualNetworksOperations operations
    :vartype virtual_networks: azure.mgmt.vmwarecloudsimple.operations.VirtualNetworksOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.vmwarecloudsimple.operations.UsagesOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.vmwarecloudsimple.operations.VirtualMachinesOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The subscription ID.
    :type subscription_id: str
    :param referer: referer url.
    :type referer: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        referer,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = VMwareCloudSimpleConfiguration(credential, subscription_id, referer, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize)
        self.dedicated_cloud_nodes = DedicatedCloudNodesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.dedicated_cloud_services = DedicatedCloudServicesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.skus_availability = SkusAvailabilityOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.private_clouds = PrivateCloudsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.customization_policies = CustomizationPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.resource_pools = ResourcePoolsOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machine_templates = VirtualMachineTemplatesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_networks = VirtualNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.usages = UsagesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, http_request, **kwargs):
        # type: (HttpRequest, Any) -> HttpResponse
        """Runs the network request through the client's chained policies.

        :param http_request: The network request you want to make. Required.
        :type http_request: ~azure.core.pipeline.transport.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to True.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.pipeline.transport.HttpResponse
        """
        path_format_arguments = {
            'subscriptionId': self._serialize.url("self._config.subscription_id", self._config.subscription_id, 'str'),
        }
        http_request.url = self._client.format_url(http_request.url, **path_format_arguments)
        stream = kwargs.pop("stream", True)
        pipeline_response = self._client._pipeline.run(http_request, stream=stream, **kwargs)
        return pipeline_response.http_response

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> VMwareCloudSimple
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
