# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import msrest.serialization


class DeleteOption(msrest.serialization.Model):
    """Delete Option.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AbsoluteDeleteOption.

    All required parameters must be populated in order to send to Azure.

    :param duration: Required. Duration of deletion after given timespan.
    :type duration: str
    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'duration': {'required': True},
        'object_type': {'required': True},
    }

    _attribute_map = {
        'duration': {'key': 'duration', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AbsoluteDeleteOption': 'AbsoluteDeleteOption'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeleteOption, self).__init__(**kwargs)
        self.duration = kwargs['duration']
        self.object_type = None  # type: Optional[str]


class AbsoluteDeleteOption(DeleteOption):
    """Delete option with duration.

    All required parameters must be populated in order to send to Azure.

    :param duration: Required. Duration of deletion after given timespan.
    :type duration: str
    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'duration': {'required': True},
        'object_type': {'required': True},
    }

    _attribute_map = {
        'duration': {'key': 'duration', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AbsoluteDeleteOption, self).__init__(**kwargs)
        self.object_type = 'AbsoluteDeleteOption'  # type: str


class AdHocBackupRuleOptions(msrest.serialization.Model):
    """Adhoc backup rules.

    All required parameters must be populated in order to send to Azure.

    :param rule_name: Required.
    :type rule_name: str
    :param trigger_option: Required. Adhoc backup trigger option.
    :type trigger_option: ~azure.mgmt.dataprotection.models.AdhocBackupTriggerOption
    """

    _validation = {
        'rule_name': {'required': True},
        'trigger_option': {'required': True},
    }

    _attribute_map = {
        'rule_name': {'key': 'ruleName', 'type': 'str'},
        'trigger_option': {'key': 'triggerOption', 'type': 'AdhocBackupTriggerOption'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdHocBackupRuleOptions, self).__init__(**kwargs)
        self.rule_name = kwargs['rule_name']
        self.trigger_option = kwargs['trigger_option']


class AdhocBackupTriggerOption(msrest.serialization.Model):
    """Adhoc backup trigger option.

    :param retention_tag_override:
    :type retention_tag_override: str
    """

    _attribute_map = {
        'retention_tag_override': {'key': 'retentionTagOverride', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdhocBackupTriggerOption, self).__init__(**kwargs)
        self.retention_tag_override = kwargs.get('retention_tag_override', None)


class AdhocBasedTaggingCriteria(msrest.serialization.Model):
    """Adhoc backup tagging criteria.

    :param tag_info: Retention tag information.
    :type tag_info: ~azure.mgmt.dataprotection.models.RetentionTag
    """

    _attribute_map = {
        'tag_info': {'key': 'tagInfo', 'type': 'RetentionTag'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdhocBasedTaggingCriteria, self).__init__(**kwargs)
        self.tag_info = kwargs.get('tag_info', None)


class TriggerContext(msrest.serialization.Model):
    """Trigger context.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AdhocBasedTriggerContext, ScheduleBasedTriggerContext.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AdhocBasedTriggerContext': 'AdhocBasedTriggerContext', 'ScheduleBasedTriggerContext': 'ScheduleBasedTriggerContext'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggerContext, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class AdhocBasedTriggerContext(TriggerContext):
    """Adhoc trigger context.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param tagging_criteria: Required. Tagging Criteria containing retention tag for adhoc backup.
    :type tagging_criteria: ~azure.mgmt.dataprotection.models.AdhocBasedTaggingCriteria
    """

    _validation = {
        'object_type': {'required': True},
        'tagging_criteria': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'tagging_criteria': {'key': 'taggingCriteria', 'type': 'AdhocBasedTaggingCriteria'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AdhocBasedTriggerContext, self).__init__(**kwargs)
        self.object_type = 'AdhocBasedTriggerContext'  # type: str
        self.tagging_criteria = kwargs['tagging_criteria']


class AuthCredentials(msrest.serialization.Model):
    """Base class for different types of authentication credentials.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: SecretStoreBasedAuthCredentials.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'SecretStoreBasedAuthCredentials': 'SecretStoreBasedAuthCredentials'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AuthCredentials, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class AzureBackupRecoveryPoint(msrest.serialization.Model):
    """Azure backup recoveryPoint.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupDiscreteRecoveryPoint.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureBackupDiscreteRecoveryPoint': 'AzureBackupDiscreteRecoveryPoint'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRecoveryPoint, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class AzureBackupDiscreteRecoveryPoint(AzureBackupRecoveryPoint):
    """Azure backup discrete RecoveryPoint.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param friendly_name:
    :type friendly_name: str
    :param recovery_point_data_stores_details:
    :type recovery_point_data_stores_details:
     list[~azure.mgmt.dataprotection.models.RecoveryPointDataStoreDetails]
    :param recovery_point_time: Required.
    :type recovery_point_time: ~datetime.datetime
    :param policy_name:
    :type policy_name: str
    :param policy_version:
    :type policy_version: str
    :param recovery_point_id:
    :type recovery_point_id: str
    :param recovery_point_type:
    :type recovery_point_type: str
    :param retention_tag_name:
    :type retention_tag_name: str
    :param retention_tag_version:
    :type retention_tag_version: str
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_point_time': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'recovery_point_data_stores_details': {'key': 'recoveryPointDataStoresDetails', 'type': '[RecoveryPointDataStoreDetails]'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'policy_version': {'key': 'policyVersion', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'recovery_point_type': {'key': 'recoveryPointType', 'type': 'str'},
        'retention_tag_name': {'key': 'retentionTagName', 'type': 'str'},
        'retention_tag_version': {'key': 'retentionTagVersion', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupDiscreteRecoveryPoint, self).__init__(**kwargs)
        self.object_type = 'AzureBackupDiscreteRecoveryPoint'  # type: str
        self.friendly_name = kwargs.get('friendly_name', None)
        self.recovery_point_data_stores_details = kwargs.get('recovery_point_data_stores_details', None)
        self.recovery_point_time = kwargs['recovery_point_time']
        self.policy_name = kwargs.get('policy_name', None)
        self.policy_version = kwargs.get('policy_version', None)
        self.recovery_point_id = kwargs.get('recovery_point_id', None)
        self.recovery_point_type = kwargs.get('recovery_point_type', None)
        self.retention_tag_name = kwargs.get('retention_tag_name', None)
        self.retention_tag_version = kwargs.get('retention_tag_version', None)


class AzureBackupFindRestorableTimeRangesRequest(msrest.serialization.Model):
    """List Restore Ranges Request.

    All required parameters must be populated in order to send to Azure.

    :param source_data_store_type: Required. Gets or sets the type of the source data store.
     Possible values include: "OperationalStore", "VaultStore", "ArchiveStore".
    :type source_data_store_type: str or
     ~azure.mgmt.dataprotection.models.RestoreSourceDataStoreType
    :param start_time: Start time for the List Restore Ranges request. ISO 8601 format.
    :type start_time: str
    :param end_time: End time for the List Restore Ranges request. ISO 8601 format.
    :type end_time: str
    """

    _validation = {
        'source_data_store_type': {'required': True},
    }

    _attribute_map = {
        'source_data_store_type': {'key': 'sourceDataStoreType', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupFindRestorableTimeRangesRequest, self).__init__(**kwargs)
        self.source_data_store_type = kwargs['source_data_store_type']
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)


class DppWorkerRequest(msrest.serialization.Model):
    """DppWorkerRequest.

    :param subscription_id:
    :type subscription_id: str
    :param uri:
    :type uri: str
    :param headers: Dictionary of
     <components·ikn5y4·schemas·dppworkerrequest·properties·headers·additionalproperties>.
    :type headers: dict[str, list[str]]
    :param supported_group_versions:
    :type supported_group_versions: list[str]
    :param culture_info:
    :type culture_info: str
    :param parameters: Dictionary of :code:`<string>`.
    :type parameters: dict[str, str]
    :param http_method:
    :type http_method: str
    """

    _attribute_map = {
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{[str]}'},
        'supported_group_versions': {'key': 'supportedGroupVersions', 'type': '[str]'},
        'culture_info': {'key': 'cultureInfo', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DppWorkerRequest, self).__init__(**kwargs)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.uri = kwargs.get('uri', None)
        self.headers = kwargs.get('headers', None)
        self.supported_group_versions = kwargs.get('supported_group_versions', None)
        self.culture_info = kwargs.get('culture_info', None)
        self.parameters = kwargs.get('parameters', None)
        self.http_method = kwargs.get('http_method', None)


class AzureBackupFindRestorableTimeRangesRequestResource(DppWorkerRequest):
    """List Restore Ranges Request.

    :param subscription_id:
    :type subscription_id: str
    :param uri:
    :type uri: str
    :param headers: Dictionary of
     <components·ikn5y4·schemas·dppworkerrequest·properties·headers·additionalproperties>.
    :type headers: dict[str, list[str]]
    :param supported_group_versions:
    :type supported_group_versions: list[str]
    :param culture_info:
    :type culture_info: str
    :param parameters: Dictionary of :code:`<string>`.
    :type parameters: dict[str, str]
    :param http_method:
    :type http_method: str
    :param content: AzureBackupFindRestorableTimeRangesRequestResource content.
    :type content: ~azure.mgmt.dataprotection.models.AzureBackupFindRestorableTimeRangesRequest
    """

    _attribute_map = {
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'uri': {'key': 'uri', 'type': 'str'},
        'headers': {'key': 'headers', 'type': '{[str]}'},
        'supported_group_versions': {'key': 'supportedGroupVersions', 'type': '[str]'},
        'culture_info': {'key': 'cultureInfo', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': '{str}'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
        'content': {'key': 'content', 'type': 'AzureBackupFindRestorableTimeRangesRequest'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupFindRestorableTimeRangesRequestResource, self).__init__(**kwargs)
        self.content = kwargs.get('content', None)


class AzureBackupFindRestorableTimeRangesResponse(msrest.serialization.Model):
    """List Restore Ranges Response.

    :param restorable_time_ranges: Returns the Restore Ranges available on the Backup Instance.
    :type restorable_time_ranges: list[~azure.mgmt.dataprotection.models.RestorableTimeRange]
    :param object_type:
    :type object_type: str
    """

    _attribute_map = {
        'restorable_time_ranges': {'key': 'restorableTimeRanges', 'type': '[RestorableTimeRange]'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupFindRestorableTimeRangesResponse, self).__init__(**kwargs)
        self.restorable_time_ranges = kwargs.get('restorable_time_ranges', None)
        self.object_type = kwargs.get('object_type', None)


class DppResource(msrest.serialization.Model):
    """Resource class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DppResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class AzureBackupFindRestorableTimeRangesResponseResource(DppResource):
    """List Restore Ranges Response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :param properties: AzureBackupFindRestorableTimeRangesResponseResource properties.
    :type properties: ~azure.mgmt.dataprotection.models.AzureBackupFindRestorableTimeRangesResponse
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'AzureBackupFindRestorableTimeRangesResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupFindRestorableTimeRangesResponseResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AzureBackupJob(msrest.serialization.Model):
    """AzureBackup Job Class.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param activity_id: Required. Job Activity Id.
    :type activity_id: str
    :param backup_instance_friendly_name: Required. Name of the Backup Instance.
    :type backup_instance_friendly_name: str
    :ivar backup_instance_id: ARM ID of the Backup Instance.
    :vartype backup_instance_id: str
    :param data_source_id: Required. ARM ID of the DataSource.
    :type data_source_id: str
    :param data_source_location: Required. Location of the DataSource.
    :type data_source_location: str
    :param data_source_name: Required. User Friendly Name of the DataSource.
    :type data_source_name: str
    :param data_source_set_name: Data Source Set Name of the DataSource.
    :type data_source_set_name: str
    :param data_source_type: Required. Type of DataSource.
    :type data_source_type: str
    :param duration: Total run time of the job. ISO 8601 format.
    :type duration: str
    :ivar end_time: EndTime of the job(in UTC).
    :vartype end_time: ~datetime.datetime
    :ivar error_details: A List, detailing the errors related to the job.
    :vartype error_details: list[~azure.mgmt.dataprotection.models.UserFacingError]
    :ivar extended_info: Extended Information about the job.
    :vartype extended_info: ~azure.mgmt.dataprotection.models.JobExtendedInfo
    :param is_user_triggered: Required. Indicated that whether the job is adhoc(true) or
     scheduled(false).
    :type is_user_triggered: bool
    :param operation: Required. It indicates the type of Job i.e. Backup:full/log/diff
     ;Restore:ALR/OLR; Tiering:Backup/Archive ; Management:ConfigureProtection/UnConfigure.
    :type operation: str
    :param operation_category: Required. It indicates the type of Job i.e.
     Backup/Restore/Tiering/Management.
    :type operation_category: str
    :ivar policy_id: ARM ID of the policy.
    :vartype policy_id: str
    :ivar policy_name: Name of the policy.
    :vartype policy_name: str
    :param progress_enabled: Required. Indicated whether progress is enabled for the job.
    :type progress_enabled: bool
    :ivar progress_url: Url which contains job's progress.
    :vartype progress_url: str
    :ivar restore_type: It indicates the sub type of operation i.e. in case of Restore it can be
     ALR/OLR.
    :vartype restore_type: str
    :param source_resource_group: Required. Resource Group Name of the Datasource.
    :type source_resource_group: str
    :param source_subscription_id: Required. SubscriptionId corresponding to the DataSource.
    :type source_subscription_id: str
    :param start_time: Required. StartTime of the job(in UTC).
    :type start_time: ~datetime.datetime
    :param status: Required. Status of the job like
     InProgress/Success/Failed/Cancelled/SuccessWithWarning.
    :type status: str
    :param subscription_id: Required. Subscription Id of the corresponding backup vault.
    :type subscription_id: str
    :param supported_actions: Required. List of supported actions.
    :type supported_actions: list[str]
    :param vault_name: Required. Name of the vault.
    :type vault_name: str
    :param etag:
    :type etag: str
    :param source_data_store_name:
    :type source_data_store_name: str
    :param destination_data_store_name:
    :type destination_data_store_name: str
    """

    _validation = {
        'activity_id': {'required': True},
        'backup_instance_friendly_name': {'required': True},
        'backup_instance_id': {'readonly': True},
        'data_source_id': {'required': True},
        'data_source_location': {'required': True},
        'data_source_name': {'required': True},
        'data_source_type': {'required': True},
        'end_time': {'readonly': True},
        'error_details': {'readonly': True},
        'extended_info': {'readonly': True},
        'is_user_triggered': {'required': True},
        'operation': {'required': True},
        'operation_category': {'required': True},
        'policy_id': {'readonly': True},
        'policy_name': {'readonly': True},
        'progress_enabled': {'required': True},
        'progress_url': {'readonly': True},
        'restore_type': {'readonly': True},
        'source_resource_group': {'required': True},
        'source_subscription_id': {'required': True},
        'start_time': {'required': True},
        'status': {'required': True},
        'subscription_id': {'required': True},
        'supported_actions': {'required': True},
        'vault_name': {'required': True},
    }

    _attribute_map = {
        'activity_id': {'key': 'activityID', 'type': 'str'},
        'backup_instance_friendly_name': {'key': 'backupInstanceFriendlyName', 'type': 'str'},
        'backup_instance_id': {'key': 'backupInstanceId', 'type': 'str'},
        'data_source_id': {'key': 'dataSourceId', 'type': 'str'},
        'data_source_location': {'key': 'dataSourceLocation', 'type': 'str'},
        'data_source_name': {'key': 'dataSourceName', 'type': 'str'},
        'data_source_set_name': {'key': 'dataSourceSetName', 'type': 'str'},
        'data_source_type': {'key': 'dataSourceType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error_details': {'key': 'errorDetails', 'type': '[UserFacingError]'},
        'extended_info': {'key': 'extendedInfo', 'type': 'JobExtendedInfo'},
        'is_user_triggered': {'key': 'isUserTriggered', 'type': 'bool'},
        'operation': {'key': 'operation', 'type': 'str'},
        'operation_category': {'key': 'operationCategory', 'type': 'str'},
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'progress_enabled': {'key': 'progressEnabled', 'type': 'bool'},
        'progress_url': {'key': 'progressUrl', 'type': 'str'},
        'restore_type': {'key': 'restoreType', 'type': 'str'},
        'source_resource_group': {'key': 'sourceResourceGroup', 'type': 'str'},
        'source_subscription_id': {'key': 'sourceSubscriptionID', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'supported_actions': {'key': 'supportedActions', 'type': '[str]'},
        'vault_name': {'key': 'vaultName', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'source_data_store_name': {'key': 'sourceDataStoreName', 'type': 'str'},
        'destination_data_store_name': {'key': 'destinationDataStoreName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupJob, self).__init__(**kwargs)
        self.activity_id = kwargs['activity_id']
        self.backup_instance_friendly_name = kwargs['backup_instance_friendly_name']
        self.backup_instance_id = None
        self.data_source_id = kwargs['data_source_id']
        self.data_source_location = kwargs['data_source_location']
        self.data_source_name = kwargs['data_source_name']
        self.data_source_set_name = kwargs.get('data_source_set_name', None)
        self.data_source_type = kwargs['data_source_type']
        self.duration = kwargs.get('duration', None)
        self.end_time = None
        self.error_details = None
        self.extended_info = None
        self.is_user_triggered = kwargs['is_user_triggered']
        self.operation = kwargs['operation']
        self.operation_category = kwargs['operation_category']
        self.policy_id = None
        self.policy_name = None
        self.progress_enabled = kwargs['progress_enabled']
        self.progress_url = None
        self.restore_type = None
        self.source_resource_group = kwargs['source_resource_group']
        self.source_subscription_id = kwargs['source_subscription_id']
        self.start_time = kwargs['start_time']
        self.status = kwargs['status']
        self.subscription_id = kwargs['subscription_id']
        self.supported_actions = kwargs['supported_actions']
        self.vault_name = kwargs['vault_name']
        self.etag = kwargs.get('etag', None)
        self.source_data_store_name = kwargs.get('source_data_store_name', None)
        self.destination_data_store_name = kwargs.get('destination_data_store_name', None)


class AzureBackupJobResource(DppResource):
    """AzureBackup Job Resource Class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :param properties: AzureBackupJobResource properties.
    :type properties: ~azure.mgmt.dataprotection.models.AzureBackupJob
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'AzureBackupJob'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupJobResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class DppResourceList(msrest.serialization.Model):
    """ListResource.

    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DppResourceList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)


class AzureBackupJobResourceList(DppResourceList):
    """List of AzureBackup Job resources.

    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    :param value: List of resources.
    :type value: list[~azure.mgmt.dataprotection.models.AzureBackupJobResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AzureBackupJobResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupJobResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class BackupParameters(msrest.serialization.Model):
    """BackupParameters base.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupParams.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureBackupParams': 'AzureBackupParams'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupParameters, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class AzureBackupParams(BackupParameters):
    """Azure backup parameters.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param backup_type: Required. BackupType ; Full/Incremental etc.
    :type backup_type: str
    """

    _validation = {
        'object_type': {'required': True},
        'backup_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'backup_type': {'key': 'backupType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupParams, self).__init__(**kwargs)
        self.object_type = 'AzureBackupParams'  # type: str
        self.backup_type = kwargs['backup_type']


class AzureBackupRestoreRequest(msrest.serialization.Model):
    """Azure backup restore request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupRecoveryPointBasedRestoreRequest, AzureBackupRecoveryTimeBasedRestoreRequest.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param restore_target_info: Required. Gets or sets the restore target information.
    :type restore_target_info: ~azure.mgmt.dataprotection.models.RestoreTargetInfoBase
    :param source_data_store_type: Required. Gets or sets the type of the source data store.
     Possible values include: "ArchiveStore", "SnapshotStore", "VaultStore".
    :type source_data_store_type: str or ~azure.mgmt.dataprotection.models.SourceDataStoreType
    """

    _validation = {
        'object_type': {'required': True},
        'restore_target_info': {'required': True},
        'source_data_store_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'restore_target_info': {'key': 'restoreTargetInfo', 'type': 'RestoreTargetInfoBase'},
        'source_data_store_type': {'key': 'sourceDataStoreType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureBackupRecoveryPointBasedRestoreRequest': 'AzureBackupRecoveryPointBasedRestoreRequest', 'AzureBackupRecoveryTimeBasedRestoreRequest': 'AzureBackupRecoveryTimeBasedRestoreRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRestoreRequest, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]
        self.restore_target_info = kwargs['restore_target_info']
        self.source_data_store_type = kwargs['source_data_store_type']


class AzureBackupRecoveryPointBasedRestoreRequest(AzureBackupRestoreRequest):
    """Azure backup recoveryPoint based restore request.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupRestoreWithRehydrationRequest.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param restore_target_info: Required. Gets or sets the restore target information.
    :type restore_target_info: ~azure.mgmt.dataprotection.models.RestoreTargetInfoBase
    :param source_data_store_type: Required. Gets or sets the type of the source data store.
     Possible values include: "ArchiveStore", "SnapshotStore", "VaultStore".
    :type source_data_store_type: str or ~azure.mgmt.dataprotection.models.SourceDataStoreType
    :param recovery_point_id: Required.
    :type recovery_point_id: str
    """

    _validation = {
        'object_type': {'required': True},
        'restore_target_info': {'required': True},
        'source_data_store_type': {'required': True},
        'recovery_point_id': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'restore_target_info': {'key': 'restoreTargetInfo', 'type': 'RestoreTargetInfoBase'},
        'source_data_store_type': {'key': 'sourceDataStoreType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureBackupRestoreWithRehydrationRequest': 'AzureBackupRestoreWithRehydrationRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRecoveryPointBasedRestoreRequest, self).__init__(**kwargs)
        self.object_type = 'AzureBackupRecoveryPointBasedRestoreRequest'  # type: str
        self.recovery_point_id = kwargs['recovery_point_id']


class AzureBackupRecoveryPointResource(DppResource):
    """Azure backup recoveryPoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :param properties: AzureBackupRecoveryPointResource properties.
    :type properties: ~azure.mgmt.dataprotection.models.AzureBackupRecoveryPoint
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'AzureBackupRecoveryPoint'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRecoveryPointResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class AzureBackupRecoveryPointResourceList(DppResourceList):
    """Azure backup recoveryPoint resource list.

    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    :param value: List of resources.
    :type value: list[~azure.mgmt.dataprotection.models.AzureBackupRecoveryPointResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[AzureBackupRecoveryPointResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRecoveryPointResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class AzureBackupRecoveryTimeBasedRestoreRequest(AzureBackupRestoreRequest):
    """AzureBackup RecoveryPointTime Based Restore Request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param restore_target_info: Required. Gets or sets the restore target information.
    :type restore_target_info: ~azure.mgmt.dataprotection.models.RestoreTargetInfoBase
    :param source_data_store_type: Required. Gets or sets the type of the source data store.
     Possible values include: "ArchiveStore", "SnapshotStore", "VaultStore".
    :type source_data_store_type: str or ~azure.mgmt.dataprotection.models.SourceDataStoreType
    :param recovery_point_time: Required. The recovery time in ISO 8601 format example -
     2020-08-14T17:30:00.0000000Z.
    :type recovery_point_time: str
    """

    _validation = {
        'object_type': {'required': True},
        'restore_target_info': {'required': True},
        'source_data_store_type': {'required': True},
        'recovery_point_time': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'restore_target_info': {'key': 'restoreTargetInfo', 'type': 'RestoreTargetInfoBase'},
        'source_data_store_type': {'key': 'sourceDataStoreType', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRecoveryTimeBasedRestoreRequest, self).__init__(**kwargs)
        self.object_type = 'AzureBackupRecoveryTimeBasedRestoreRequest'  # type: str
        self.recovery_point_time = kwargs['recovery_point_time']


class AzureBackupRehydrationRequest(msrest.serialization.Model):
    """Azure Backup Rehydrate Request.

    All required parameters must be populated in order to send to Azure.

    :param recovery_point_id: Required. Id of the recovery point to be recovered.
    :type recovery_point_id: str
    :param rehydration_priority: Priority to be used for rehydration. Values High or Standard.
     Possible values include: "Invalid", "High", "Standard".
    :type rehydration_priority: str or ~azure.mgmt.dataprotection.models.RehydrationPriority
    :param rehydration_retention_duration: Required. Retention duration in ISO 8601 format i.e P10D
     .
    :type rehydration_retention_duration: str
    """

    _validation = {
        'recovery_point_id': {'required': True},
        'rehydration_retention_duration': {'required': True},
    }

    _attribute_map = {
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'rehydration_priority': {'key': 'rehydrationPriority', 'type': 'str'},
        'rehydration_retention_duration': {'key': 'rehydrationRetentionDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRehydrationRequest, self).__init__(**kwargs)
        self.recovery_point_id = kwargs['recovery_point_id']
        self.rehydration_priority = kwargs.get('rehydration_priority', None)
        self.rehydration_retention_duration = kwargs['rehydration_retention_duration']


class AzureBackupRestoreWithRehydrationRequest(AzureBackupRecoveryPointBasedRestoreRequest):
    """AzureBackup Restore with Rehydration Request.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param restore_target_info: Required. Gets or sets the restore target information.
    :type restore_target_info: ~azure.mgmt.dataprotection.models.RestoreTargetInfoBase
    :param source_data_store_type: Required. Gets or sets the type of the source data store.
     Possible values include: "ArchiveStore", "SnapshotStore", "VaultStore".
    :type source_data_store_type: str or ~azure.mgmt.dataprotection.models.SourceDataStoreType
    :param recovery_point_id: Required.
    :type recovery_point_id: str
    :param rehydration_priority: Required. Priority to be used for rehydration. Values High or
     Standard. Possible values include: "Invalid", "High", "Standard".
    :type rehydration_priority: str or ~azure.mgmt.dataprotection.models.RehydrationPriority
    :param rehydration_retention_duration: Required. Retention duration in ISO 8601 format i.e P10D
     .
    :type rehydration_retention_duration: str
    """

    _validation = {
        'object_type': {'required': True},
        'restore_target_info': {'required': True},
        'source_data_store_type': {'required': True},
        'recovery_point_id': {'required': True},
        'rehydration_priority': {'required': True},
        'rehydration_retention_duration': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'restore_target_info': {'key': 'restoreTargetInfo', 'type': 'RestoreTargetInfoBase'},
        'source_data_store_type': {'key': 'sourceDataStoreType', 'type': 'str'},
        'recovery_point_id': {'key': 'recoveryPointId', 'type': 'str'},
        'rehydration_priority': {'key': 'rehydrationPriority', 'type': 'str'},
        'rehydration_retention_duration': {'key': 'rehydrationRetentionDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRestoreWithRehydrationRequest, self).__init__(**kwargs)
        self.object_type = 'AzureBackupRestoreWithRehydrationRequest'  # type: str
        self.rehydration_priority = kwargs['rehydration_priority']
        self.rehydration_retention_duration = kwargs['rehydration_retention_duration']


class BasePolicyRule(msrest.serialization.Model):
    """BasePolicy Rule.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureBackupRule, AzureRetentionRule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'name': {'required': True},
        'object_type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureBackupRule': 'AzureBackupRule', 'AzureRetentionRule': 'AzureRetentionRule'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BasePolicyRule, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.object_type = None  # type: Optional[str]


class AzureBackupRule(BasePolicyRule):
    """Azure backup rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param backup_parameters: BackupParameters base.
    :type backup_parameters: ~azure.mgmt.dataprotection.models.BackupParameters
    :param data_store: Required. DataStoreInfo base.
    :type data_store: ~azure.mgmt.dataprotection.models.DataStoreInfoBase
    :param trigger: Required. Trigger context.
    :type trigger: ~azure.mgmt.dataprotection.models.TriggerContext
    """

    _validation = {
        'name': {'required': True},
        'object_type': {'required': True},
        'data_store': {'required': True},
        'trigger': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'backup_parameters': {'key': 'backupParameters', 'type': 'BackupParameters'},
        'data_store': {'key': 'dataStore', 'type': 'DataStoreInfoBase'},
        'trigger': {'key': 'trigger', 'type': 'TriggerContext'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureBackupRule, self).__init__(**kwargs)
        self.object_type = 'AzureBackupRule'  # type: str
        self.backup_parameters = kwargs.get('backup_parameters', None)
        self.data_store = kwargs['data_store']
        self.trigger = kwargs['trigger']


class DataStoreParameters(msrest.serialization.Model):
    """Parameters for DataStore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureOperationalStoreParameters.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param data_store_type: Required. type of datastore; Operational/Vault/Archive. Possible values
     include: "OperationalStore", "VaultStore", "ArchiveStore".
    :type data_store_type: str or ~azure.mgmt.dataprotection.models.DataStoreTypes
    """

    _validation = {
        'object_type': {'required': True},
        'data_store_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'data_store_type': {'key': 'dataStoreType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'AzureOperationalStoreParameters': 'AzureOperationalStoreParameters'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataStoreParameters, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]
        self.data_store_type = kwargs['data_store_type']


class AzureOperationalStoreParameters(DataStoreParameters):
    """Parameters for Operational-Tier DataStore.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param data_store_type: Required. type of datastore; Operational/Vault/Archive. Possible values
     include: "OperationalStore", "VaultStore", "ArchiveStore".
    :type data_store_type: str or ~azure.mgmt.dataprotection.models.DataStoreTypes
    :param resource_group_id: Gets or sets the Snapshot Resource Group Uri.
    :type resource_group_id: str
    """

    _validation = {
        'object_type': {'required': True},
        'data_store_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'data_store_type': {'key': 'dataStoreType', 'type': 'str'},
        'resource_group_id': {'key': 'resourceGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureOperationalStoreParameters, self).__init__(**kwargs)
        self.object_type = 'AzureOperationalStoreParameters'  # type: str
        self.resource_group_id = kwargs.get('resource_group_id', None)


class AzureRetentionRule(BasePolicyRule):
    """Azure retention rule.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param is_default:
    :type is_default: bool
    :param lifecycles: Required.
    :type lifecycles: list[~azure.mgmt.dataprotection.models.SourceLifeCycle]
    """

    _validation = {
        'name': {'required': True},
        'object_type': {'required': True},
        'lifecycles': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'lifecycles': {'key': 'lifecycles', 'type': '[SourceLifeCycle]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AzureRetentionRule, self).__init__(**kwargs)
        self.object_type = 'AzureRetentionRule'  # type: str
        self.is_default = kwargs.get('is_default', None)
        self.lifecycles = kwargs['lifecycles']


class BackupCriteria(msrest.serialization.Model):
    """BackupCriteria base class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ScheduleBasedBackupCriteria.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'ScheduleBasedBackupCriteria': 'ScheduleBasedBackupCriteria'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupCriteria, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class BackupInstance(msrest.serialization.Model):
    """Backup Instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param friendly_name: Gets or sets the Backup Instance friendly name.
    :type friendly_name: str
    :param data_source_info: Required. Gets or sets the data source information.
    :type data_source_info: ~azure.mgmt.dataprotection.models.Datasource
    :param data_source_set_info: Gets or sets the data source set information.
    :type data_source_set_info: ~azure.mgmt.dataprotection.models.DatasourceSet
    :param policy_info: Required. Gets or sets the policy information.
    :type policy_info: ~azure.mgmt.dataprotection.models.PolicyInfo
    :ivar protection_status: Specifies the protection status of the resource.
    :vartype protection_status: ~azure.mgmt.dataprotection.models.ProtectionStatusDetails
    :ivar current_protection_state: Specifies the current protection state of the resource.
     Possible values include: "Invalid", "NotProtected", "ConfiguringProtection",
     "ProtectionConfigured", "BackupSchedulesSuspended", "RetentionSchedulesSuspended",
     "ProtectionStopped", "ProtectionError", "ConfiguringProtectionFailed", "SoftDeleting",
     "SoftDeleted", "UpdatingProtection".
    :vartype current_protection_state: str or
     ~azure.mgmt.dataprotection.models.CurrentProtectionState
    :ivar protection_error_details: Specifies the protection error of the resource.
    :vartype protection_error_details: ~azure.mgmt.dataprotection.models.UserFacingError
    :ivar provisioning_state: Specifies the provisioning state of the resource i.e.
     provisioning/updating/Succeeded/Failed.
    :vartype provisioning_state: str
    :param datasource_auth_credentials: Credentials to use to authenticate with data source
     provider.
    :type datasource_auth_credentials: ~azure.mgmt.dataprotection.models.AuthCredentials
    :param object_type: Required.
    :type object_type: str
    """

    _validation = {
        'data_source_info': {'required': True},
        'policy_info': {'required': True},
        'protection_status': {'readonly': True},
        'current_protection_state': {'readonly': True},
        'protection_error_details': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'object_type': {'required': True},
    }

    _attribute_map = {
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'data_source_info': {'key': 'dataSourceInfo', 'type': 'Datasource'},
        'data_source_set_info': {'key': 'dataSourceSetInfo', 'type': 'DatasourceSet'},
        'policy_info': {'key': 'policyInfo', 'type': 'PolicyInfo'},
        'protection_status': {'key': 'protectionStatus', 'type': 'ProtectionStatusDetails'},
        'current_protection_state': {'key': 'currentProtectionState', 'type': 'str'},
        'protection_error_details': {'key': 'protectionErrorDetails', 'type': 'UserFacingError'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'datasource_auth_credentials': {'key': 'datasourceAuthCredentials', 'type': 'AuthCredentials'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupInstance, self).__init__(**kwargs)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.data_source_info = kwargs['data_source_info']
        self.data_source_set_info = kwargs.get('data_source_set_info', None)
        self.policy_info = kwargs['policy_info']
        self.protection_status = None
        self.current_protection_state = None
        self.protection_error_details = None
        self.provisioning_state = None
        self.datasource_auth_credentials = kwargs.get('datasource_auth_credentials', None)
        self.object_type = kwargs['object_type']


class BackupInstanceResource(DppResource):
    """BackupInstance Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :param properties: BackupInstanceResource properties.
    :type properties: ~azure.mgmt.dataprotection.models.BackupInstance
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'BackupInstance'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupInstanceResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class BackupInstanceResourceList(DppResourceList):
    """BackupInstance Resource list response.

    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    :param value: List of resources.
    :type value: list[~azure.mgmt.dataprotection.models.BackupInstanceResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BackupInstanceResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupInstanceResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class BaseBackupPolicy(msrest.serialization.Model):
    """BackupPolicy base.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BackupPolicy.

    All required parameters must be populated in order to send to Azure.

    :param datasource_types: Required. Type of datasource for the backup management.
    :type datasource_types: list[str]
    :param object_type: Required. Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'datasource_types': {'required': True},
        'object_type': {'required': True},
    }

    _attribute_map = {
        'datasource_types': {'key': 'datasourceTypes', 'type': '[str]'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'BackupPolicy': 'BackupPolicy'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseBackupPolicy, self).__init__(**kwargs)
        self.datasource_types = kwargs['datasource_types']
        self.object_type = None  # type: Optional[str]


class BackupPolicy(BaseBackupPolicy):
    """Rule based backup policy.

    All required parameters must be populated in order to send to Azure.

    :param datasource_types: Required. Type of datasource for the backup management.
    :type datasource_types: list[str]
    :param object_type: Required. Constant filled by server.
    :type object_type: str
    :param policy_rules: Required. Policy rule dictionary that contains rules for each backuptype
     i.e Full/Incremental/Logs etc.
    :type policy_rules: list[~azure.mgmt.dataprotection.models.BasePolicyRule]
    """

    _validation = {
        'datasource_types': {'required': True},
        'object_type': {'required': True},
        'policy_rules': {'required': True},
    }

    _attribute_map = {
        'datasource_types': {'key': 'datasourceTypes', 'type': '[str]'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'policy_rules': {'key': 'policyRules', 'type': '[BasePolicyRule]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupPolicy, self).__init__(**kwargs)
        self.object_type = 'BackupPolicy'  # type: str
        self.policy_rules = kwargs['policy_rules']


class BackupSchedule(msrest.serialization.Model):
    """Schedule for backup.

    All required parameters must be populated in order to send to Azure.

    :param repeating_time_intervals: Required. ISO 8601 repeating time interval format.
    :type repeating_time_intervals: list[str]
    :param time_zone: Time zone for a schedule. Example: Pacific Standard Time.
    :type time_zone: str
    """

    _validation = {
        'repeating_time_intervals': {'required': True},
    }

    _attribute_map = {
        'repeating_time_intervals': {'key': 'repeatingTimeIntervals', 'type': '[str]'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupSchedule, self).__init__(**kwargs)
        self.repeating_time_intervals = kwargs['repeating_time_intervals']
        self.time_zone = kwargs.get('time_zone', None)


class BackupVault(msrest.serialization.Model):
    """Backup Vault.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: Provisioning state of the BackupVault resource. Possible values
     include: "Failed", "Provisioning", "Succeeded", "Unknown", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.dataprotection.models.ProvisioningState
    :ivar resource_move_state: Resource move state for backup vault. Possible values include:
     "Unknown", "InProgress", "PrepareFailed", "CommitFailed", "Failed", "PrepareTimedout",
     "CommitTimedout", "CriticalFailure", "PartialSuccess", "MoveSucceeded".
    :vartype resource_move_state: str or ~azure.mgmt.dataprotection.models.ResourceMoveState
    :ivar resource_move_details: Resource move details for backup vault.
    :vartype resource_move_details: ~azure.mgmt.dataprotection.models.ResourceMoveDetails
    :param storage_settings: Required. Storage Settings.
    :type storage_settings: list[~azure.mgmt.dataprotection.models.StorageSetting]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'resource_move_state': {'readonly': True},
        'resource_move_details': {'readonly': True},
        'storage_settings': {'required': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'resource_move_state': {'key': 'resourceMoveState', 'type': 'str'},
        'resource_move_details': {'key': 'resourceMoveDetails', 'type': 'ResourceMoveDetails'},
        'storage_settings': {'key': 'storageSettings', 'type': '[StorageSetting]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupVault, self).__init__(**kwargs)
        self.provisioning_state = None
        self.resource_move_state = None
        self.resource_move_details = None
        self.storage_settings = kwargs['storage_settings']


class DppTrackedResource(msrest.serialization.Model):
    """DppTrackedResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param e_tag: Optional ETag.
    :type e_tag: str
    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :param identity: Input Managed Identity Details.
    :type identity: ~azure.mgmt.dataprotection.models.DppIdentityDetails
    :param location: Resource location.
    :type location: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'DppIdentityDetails'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DppTrackedResource, self).__init__(**kwargs)
        self.e_tag = kwargs.get('e_tag', None)
        self.id = None
        self.identity = kwargs.get('identity', None)
        self.location = kwargs.get('location', None)
        self.name = None
        self.tags = kwargs.get('tags', None)
        self.type = None
        self.system_data = None


class BackupVaultResource(DppTrackedResource):
    """Backup Vault Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param e_tag: Optional ETag.
    :type e_tag: str
    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :param identity: Input Managed Identity Details.
    :type identity: ~azure.mgmt.dataprotection.models.DppIdentityDetails
    :param location: Resource location.
    :type location: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :param properties: Required. BackupVaultResource properties.
    :type properties: ~azure.mgmt.dataprotection.models.BackupVault
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'DppIdentityDetails'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'BackupVault'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupVaultResource, self).__init__(**kwargs)
        self.properties = kwargs['properties']


class BackupVaultResourceList(DppResourceList):
    """List of BackupVault resources.

    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    :param value: List of resources.
    :type value: list[~azure.mgmt.dataprotection.models.BackupVaultResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BackupVaultResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BackupVaultResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class BaseBackupPolicyResource(DppResource):
    """BaseBackupPolicy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :param properties: BaseBackupPolicyResource properties.
    :type properties: ~azure.mgmt.dataprotection.models.BaseBackupPolicy
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'BaseBackupPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseBackupPolicyResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class BaseBackupPolicyResourceList(DppResourceList):
    """List of BaseBackupPolicy resources.

    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    :param value: List of resources.
    :type value: list[~azure.mgmt.dataprotection.models.BaseBackupPolicyResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[BaseBackupPolicyResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BaseBackupPolicyResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class CheckNameAvailabilityRequest(msrest.serialization.Model):
    """CheckNameAvailability Request.

    :param name: Resource name for which availability needs to be checked.
    :type name: str
    :param type: Describes the Resource type: Microsoft.DataProtection/BackupVaults.
    :type type: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityRequest, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """CheckNameAvailability Result.

    :param message: Gets or sets the message.
    :type message: str
    :param name_available: Gets or sets a value indicating whether [name available].
    :type name_available: bool
    :param reason: Gets or sets the reason.
    :type reason: str
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.message = kwargs.get('message', None)
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)


class ClientDiscoveryDisplay(msrest.serialization.Model):
    """Localized display information of an operation.

    :param description: Description of the operation having details of what operation is about.
    :type description: str
    :param operation: Operations Name itself.
    :type operation: str
    :param provider: Name of the provider for display purposes.
    :type provider: str
    :param resource: ResourceType for which this Operation can be performed.
    :type resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientDiscoveryDisplay, self).__init__(**kwargs)
        self.description = kwargs.get('description', None)
        self.operation = kwargs.get('operation', None)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)


class ClientDiscoveryForLogSpecification(msrest.serialization.Model):
    """Class to represent shoebox log specification in json client discovery.

    :param blob_duration: blob duration of shoebox log specification.
    :type blob_duration: str
    :param display_name: Localized display name.
    :type display_name: str
    :param name: Name for shoebox log specification.
    :type name: str
    """

    _attribute_map = {
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientDiscoveryForLogSpecification, self).__init__(**kwargs)
        self.blob_duration = kwargs.get('blob_duration', None)
        self.display_name = kwargs.get('display_name', None)
        self.name = kwargs.get('name', None)


class ClientDiscoveryForProperties(msrest.serialization.Model):
    """Class to represent shoebox properties in json client discovery.

    :param service_specification: Operation properties.
    :type service_specification:
     ~azure.mgmt.dataprotection.models.ClientDiscoveryForServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'ClientDiscoveryForServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientDiscoveryForProperties, self).__init__(**kwargs)
        self.service_specification = kwargs.get('service_specification', None)


class ClientDiscoveryForServiceSpecification(msrest.serialization.Model):
    """Class to represent shoebox service specification in json client discovery.

    :param log_specifications: List of log specifications of this operation.
    :type log_specifications:
     list[~azure.mgmt.dataprotection.models.ClientDiscoveryForLogSpecification]
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[ClientDiscoveryForLogSpecification]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientDiscoveryForServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = kwargs.get('log_specifications', None)


class ClientDiscoveryResponse(msrest.serialization.Model):
    """Operations List response which contains list of available APIs.

    :param next_link: Link to the next chunk of Response.
    :type next_link: str
    :param value: List of available operations.
    :type value: list[~azure.mgmt.dataprotection.models.ClientDiscoveryValueForSingleApi]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ClientDiscoveryValueForSingleApi]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientDiscoveryResponse, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)
        self.value = kwargs.get('value', None)


class ClientDiscoveryValueForSingleApi(msrest.serialization.Model):
    """Available operation details.

    :param display: Contains the localized display information for this particular operation.
    :type display: ~azure.mgmt.dataprotection.models.ClientDiscoveryDisplay
    :param name: Name of the Operation.
    :type name: str
    :param is_data_action: Indicates whether the operation is a data action.
    :type is_data_action: bool
    :param origin: The intended executor of the operation;governs the display of the operation in
     the RBAC UX and the audit logs UX.
    :type origin: str
    :param properties: Properties for the given operation.
    :type properties: ~azure.mgmt.dataprotection.models.ClientDiscoveryForProperties
    """

    _attribute_map = {
        'display': {'key': 'display', 'type': 'ClientDiscoveryDisplay'},
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ClientDiscoveryForProperties'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ClientDiscoveryValueForSingleApi, self).__init__(**kwargs)
        self.display = kwargs.get('display', None)
        self.name = kwargs.get('name', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.origin = kwargs.get('origin', None)
        self.properties = kwargs.get('properties', None)


class CopyOption(msrest.serialization.Model):
    """Options to copy.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: CopyOnExpiryOption, CustomCopyOption, ImmediateCopyOption.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'CopyOnExpiryOption': 'CopyOnExpiryOption', 'CustomCopyOption': 'CustomCopyOption', 'ImmediateCopyOption': 'ImmediateCopyOption'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopyOption, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class CopyOnExpiryOption(CopyOption):
    """Copy on Expiry Option.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CopyOnExpiryOption, self).__init__(**kwargs)
        self.object_type = 'CopyOnExpiryOption'  # type: str


class CustomCopyOption(CopyOption):
    """Duration based custom options to copy.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param duration: Data copied after given timespan.
    :type duration: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'duration': {'key': 'duration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CustomCopyOption, self).__init__(**kwargs)
        self.object_type = 'CustomCopyOption'  # type: str
        self.duration = kwargs.get('duration', None)


class Datasource(msrest.serialization.Model):
    """Datasource to be backed up.

    All required parameters must be populated in order to send to Azure.

    :param datasource_type: DatasourceType of the resource.
    :type datasource_type: str
    :param object_type: Type of Datasource object, used to initialize the right inherited type.
    :type object_type: str
    :param resource_id: Required. Full ARM ID of the resource. For azure resources, this is ARM ID.
     For non azure resources, this will be the ID created by backup service via Fabric/Vault.
    :type resource_id: str
    :param resource_location: Location of datasource.
    :type resource_location: str
    :param resource_name: Unique identifier of the resource in the context of parent.
    :type resource_name: str
    :param resource_type: Resource Type of Datasource.
    :type resource_type: str
    :param resource_uri: Uri of the resource.
    :type resource_uri: str
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'datasource_type': {'key': 'datasourceType', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'resource_id': {'key': 'resourceID', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Datasource, self).__init__(**kwargs)
        self.datasource_type = kwargs.get('datasource_type', None)
        self.object_type = kwargs.get('object_type', None)
        self.resource_id = kwargs['resource_id']
        self.resource_location = kwargs.get('resource_location', None)
        self.resource_name = kwargs.get('resource_name', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_uri = kwargs.get('resource_uri', None)


class DatasourceSet(msrest.serialization.Model):
    """DatasourceSet details of datasource to be backed up.

    All required parameters must be populated in order to send to Azure.

    :param datasource_type: DatasourceType of the resource.
    :type datasource_type: str
    :param object_type: Type of Datasource object, used to initialize the right inherited type.
    :type object_type: str
    :param resource_id: Required. Full ARM ID of the resource. For azure resources, this is ARM ID.
     For non azure resources, this will be the ID created by backup service via Fabric/Vault.
    :type resource_id: str
    :param resource_location: Location of datasource.
    :type resource_location: str
    :param resource_name: Unique identifier of the resource in the context of parent.
    :type resource_name: str
    :param resource_type: Resource Type of Datasource.
    :type resource_type: str
    :param resource_uri: Uri of the resource.
    :type resource_uri: str
    """

    _validation = {
        'resource_id': {'required': True},
    }

    _attribute_map = {
        'datasource_type': {'key': 'datasourceType', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
        'resource_id': {'key': 'resourceID', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'resource_name': {'key': 'resourceName', 'type': 'str'},
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DatasourceSet, self).__init__(**kwargs)
        self.datasource_type = kwargs.get('datasource_type', None)
        self.object_type = kwargs.get('object_type', None)
        self.resource_id = kwargs['resource_id']
        self.resource_location = kwargs.get('resource_location', None)
        self.resource_name = kwargs.get('resource_name', None)
        self.resource_type = kwargs.get('resource_type', None)
        self.resource_uri = kwargs.get('resource_uri', None)


class DataStoreInfoBase(msrest.serialization.Model):
    """DataStoreInfo base.

    All required parameters must be populated in order to send to Azure.

    :param data_store_type: Required. type of datastore; Operational/Vault/Archive. Possible values
     include: "OperationalStore", "VaultStore", "ArchiveStore".
    :type data_store_type: str or ~azure.mgmt.dataprotection.models.DataStoreTypes
    :param object_type: Required. Type of Datasource object, used to initialize the right inherited
     type.
    :type object_type: str
    """

    _validation = {
        'data_store_type': {'required': True},
        'object_type': {'required': True},
    }

    _attribute_map = {
        'data_store_type': {'key': 'dataStoreType', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataStoreInfoBase, self).__init__(**kwargs)
        self.data_store_type = kwargs['data_store_type']
        self.object_type = kwargs['object_type']


class Day(msrest.serialization.Model):
    """Day of the week.

    :param date: Date of the month.
    :type date: int
    :param is_last: Whether Date is last date of month.
    :type is_last: bool
    """

    _attribute_map = {
        'date': {'key': 'date', 'type': 'int'},
        'is_last': {'key': 'isLast', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Day, self).__init__(**kwargs)
        self.date = kwargs.get('date', None)
        self.is_last = kwargs.get('is_last', None)


class DppBaseResource(msrest.serialization.Model):
    """Base resource under Microsoft.DataProtection provider namespace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DppBaseResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DppBaseResourceList(msrest.serialization.Model):
    """Base for all lists of V2 resources.

    :param value: List of Dpp resources.
    :type value: list[~azure.mgmt.dataprotection.models.DppBaseResource]
    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DppBaseResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DppBaseResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class DppIdentityDetails(msrest.serialization.Model):
    """Identity details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The object ID of the service principal object for the managed identity that
     is used to grant role-based access to an Azure resource.
    :vartype principal_id: str
    :ivar tenant_id: A Globally Unique Identifier (GUID) that represents the Azure AD tenant where
     the resource is now a member.
    :vartype tenant_id: str
    :param type: The identityType which can be either SystemAssigned or None.
    :type type: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DppIdentityDetails, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)


class DppTrackedResourceList(msrest.serialization.Model):
    """DppTrackedResourceList.

    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DppTrackedResourceList, self).__init__(**kwargs)
        self.next_link = kwargs.get('next_link', None)


class Error(msrest.serialization.Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.dataprotection.models.ErrorAdditionalInfo]
    :ivar code: The error code.
    :vartype code: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.dataprotection.models.Error]
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    """

    _validation = {
        'additional_info': {'readonly': True},
        'code': {'readonly': True},
        'details': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
    }

    _attribute_map = {
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[Error]'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Error, self).__init__(**kwargs)
        self.additional_info = None
        self.code = None
        self.details = None
        self.message = None
        self.target = None


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar info: The additional info.
    :vartype info: any
    :ivar type: The additional info type.
    :vartype type: str
    """

    _validation = {
        'info': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'info': {'key': 'info', 'type': 'object'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.info = None
        self.type = None


class ExportJobsResult(msrest.serialization.Model):
    """The result for export jobs containing blob details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar blob_url: URL of the blob into which the serialized string of list of jobs is exported.
    :vartype blob_url: str
    :ivar blob_sas_key: SAS key to access the blob.
    :vartype blob_sas_key: str
    :ivar excel_file_blob_url: URL of the blob into which the ExcelFile is uploaded.
    :vartype excel_file_blob_url: str
    :ivar excel_file_blob_sas_key: SAS key to access the ExcelFile blob.
    :vartype excel_file_blob_sas_key: str
    """

    _validation = {
        'blob_url': {'readonly': True},
        'blob_sas_key': {'readonly': True},
        'excel_file_blob_url': {'readonly': True},
        'excel_file_blob_sas_key': {'readonly': True},
    }

    _attribute_map = {
        'blob_url': {'key': 'blobUrl', 'type': 'str'},
        'blob_sas_key': {'key': 'blobSasKey', 'type': 'str'},
        'excel_file_blob_url': {'key': 'excelFileBlobUrl', 'type': 'str'},
        'excel_file_blob_sas_key': {'key': 'excelFileBlobSasKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ExportJobsResult, self).__init__(**kwargs)
        self.blob_url = None
        self.blob_sas_key = None
        self.excel_file_blob_url = None
        self.excel_file_blob_sas_key = None


class FeatureValidationRequestBase(msrest.serialization.Model):
    """Base class for Backup Feature support.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FeatureValidationRequest.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'FeatureValidationRequest': 'FeatureValidationRequest'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FeatureValidationRequestBase, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class FeatureValidationRequest(FeatureValidationRequestBase):
    """Base class for feature object.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param feature_type: backup support feature type. Possible values include: "Invalid",
     "DataSourceType".
    :type feature_type: str or ~azure.mgmt.dataprotection.models.FeatureType
    :param feature_name: backup support feature name.
    :type feature_name: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'feature_type': {'key': 'featureType', 'type': 'str'},
        'feature_name': {'key': 'featureName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FeatureValidationRequest, self).__init__(**kwargs)
        self.object_type = 'FeatureValidationRequest'  # type: str
        self.feature_type = kwargs.get('feature_type', None)
        self.feature_name = kwargs.get('feature_name', None)


class FeatureValidationResponseBase(msrest.serialization.Model):
    """Base class for Backup Feature support.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: FeatureValidationResponse.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'FeatureValidationResponse': 'FeatureValidationResponse'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FeatureValidationResponseBase, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class FeatureValidationResponse(FeatureValidationResponseBase):
    """Feature Validation Response.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param feature_type: backup support feature type. Possible values include: "Invalid",
     "DataSourceType".
    :type feature_type: str or ~azure.mgmt.dataprotection.models.FeatureType
    :param features: Response features.
    :type features: list[~azure.mgmt.dataprotection.models.SupportedFeature]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'feature_type': {'key': 'featureType', 'type': 'str'},
        'features': {'key': 'features', 'type': '[SupportedFeature]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FeatureValidationResponse, self).__init__(**kwargs)
        self.object_type = 'FeatureValidationResponse'  # type: str
        self.feature_type = kwargs.get('feature_type', None)
        self.features = kwargs.get('features', None)


class ImmediateCopyOption(CopyOption):
    """Immediate copy Option.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ImmediateCopyOption, self).__init__(**kwargs)
        self.object_type = 'ImmediateCopyOption'  # type: str


class InnerError(msrest.serialization.Model):
    """Inner Error.

    :param additional_info: Any Key value pairs that can be provided to the client for additional
     verbose information.
    :type additional_info: dict[str, str]
    :param code: Unique code for this error.
    :type code: str
    :param embedded_inner_error: Child Inner Error, to allow Nesting.
    :type embedded_inner_error: ~azure.mgmt.dataprotection.models.InnerError
    """

    _attribute_map = {
        'additional_info': {'key': 'additionalInfo', 'type': '{str}'},
        'code': {'key': 'code', 'type': 'str'},
        'embedded_inner_error': {'key': 'embeddedInnerError', 'type': 'InnerError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.additional_info = kwargs.get('additional_info', None)
        self.code = kwargs.get('code', None)
        self.embedded_inner_error = kwargs.get('embedded_inner_error', None)


class ItemLevelRestoreCriteria(msrest.serialization.Model):
    """Class to contain criteria for item level restore.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RangeBasedItemLevelRestoreCriteria.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'RangeBasedItemLevelRestoreCriteria': 'RangeBasedItemLevelRestoreCriteria'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ItemLevelRestoreCriteria, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class RestoreTargetInfoBase(msrest.serialization.Model):
    """Base class common to RestoreTargetInfo and RestoreFilesTargetInfo.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ItemLevelRestoreTargetInfo, RestoreFilesTargetInfo, RestoreTargetInfo.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of Datasource object, used to initialize the right inherited
     type.Constant filled by server.
    :type object_type: str
    :param recovery_option: Required. Recovery Option. Possible values include: "FailIfExists".
    :type recovery_option: str or ~azure.mgmt.dataprotection.models.RecoveryOption
    :param restore_location: Target Restore region.
    :type restore_location: str
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_option': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_option': {'key': 'recoveryOption', 'type': 'str'},
        'restore_location': {'key': 'restoreLocation', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'ItemLevelRestoreTargetInfo': 'ItemLevelRestoreTargetInfo', 'RestoreFilesTargetInfo': 'RestoreFilesTargetInfo', 'RestoreTargetInfo': 'RestoreTargetInfo'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestoreTargetInfoBase, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]
        self.recovery_option = kwargs['recovery_option']
        self.restore_location = kwargs.get('restore_location', None)


class ItemLevelRestoreTargetInfo(RestoreTargetInfoBase):
    """Restore target info for Item level restore operation.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of Datasource object, used to initialize the right inherited
     type.Constant filled by server.
    :type object_type: str
    :param recovery_option: Required. Recovery Option. Possible values include: "FailIfExists".
    :type recovery_option: str or ~azure.mgmt.dataprotection.models.RecoveryOption
    :param restore_location: Target Restore region.
    :type restore_location: str
    :param restore_criteria: Required. Restore Criteria.
    :type restore_criteria: list[~azure.mgmt.dataprotection.models.ItemLevelRestoreCriteria]
    :param datasource_info: Required. Information of target DS.
    :type datasource_info: ~azure.mgmt.dataprotection.models.Datasource
    :param datasource_set_info: Information of target DS Set.
    :type datasource_set_info: ~azure.mgmt.dataprotection.models.DatasourceSet
    :param datasource_auth_credentials: Credentials to use to authenticate with data source
     provider.
    :type datasource_auth_credentials: ~azure.mgmt.dataprotection.models.AuthCredentials
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_option': {'required': True},
        'restore_criteria': {'required': True},
        'datasource_info': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_option': {'key': 'recoveryOption', 'type': 'str'},
        'restore_location': {'key': 'restoreLocation', 'type': 'str'},
        'restore_criteria': {'key': 'restoreCriteria', 'type': '[ItemLevelRestoreCriteria]'},
        'datasource_info': {'key': 'datasourceInfo', 'type': 'Datasource'},
        'datasource_set_info': {'key': 'datasourceSetInfo', 'type': 'DatasourceSet'},
        'datasource_auth_credentials': {'key': 'datasourceAuthCredentials', 'type': 'AuthCredentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ItemLevelRestoreTargetInfo, self).__init__(**kwargs)
        self.object_type = 'ItemLevelRestoreTargetInfo'  # type: str
        self.restore_criteria = kwargs['restore_criteria']
        self.datasource_info = kwargs['datasource_info']
        self.datasource_set_info = kwargs.get('datasource_set_info', None)
        self.datasource_auth_credentials = kwargs.get('datasource_auth_credentials', None)


class JobExtendedInfo(msrest.serialization.Model):
    """Extended Information about the job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param additional_details: Job's Additional Details.
    :type additional_details: dict[str, str]
    :ivar backup_instance_state: State of the Backup Instance.
    :vartype backup_instance_state: str
    :ivar data_transferred_in_bytes: Number of bytes transferred.
    :vartype data_transferred_in_bytes: float
    :ivar recovery_destination: Destination where restore is done.
    :vartype recovery_destination: str
    :ivar source_recover_point: Details of the Source Recovery Point.
    :vartype source_recover_point: ~azure.mgmt.dataprotection.models.RestoreJobRecoveryPointDetails
    :ivar sub_tasks: List of Sub Tasks of the job.
    :vartype sub_tasks: list[~azure.mgmt.dataprotection.models.JobSubTask]
    :ivar target_recover_point: Details of the Target Recovery Point.
    :vartype target_recover_point: ~azure.mgmt.dataprotection.models.RestoreJobRecoveryPointDetails
    """

    _validation = {
        'backup_instance_state': {'readonly': True},
        'data_transferred_in_bytes': {'readonly': True},
        'recovery_destination': {'readonly': True},
        'source_recover_point': {'readonly': True},
        'sub_tasks': {'readonly': True},
        'target_recover_point': {'readonly': True},
    }

    _attribute_map = {
        'additional_details': {'key': 'additionalDetails', 'type': '{str}'},
        'backup_instance_state': {'key': 'backupInstanceState', 'type': 'str'},
        'data_transferred_in_bytes': {'key': 'dataTransferredInBytes', 'type': 'float'},
        'recovery_destination': {'key': 'recoveryDestination', 'type': 'str'},
        'source_recover_point': {'key': 'sourceRecoverPoint', 'type': 'RestoreJobRecoveryPointDetails'},
        'sub_tasks': {'key': 'subTasks', 'type': '[JobSubTask]'},
        'target_recover_point': {'key': 'targetRecoverPoint', 'type': 'RestoreJobRecoveryPointDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobExtendedInfo, self).__init__(**kwargs)
        self.additional_details = kwargs.get('additional_details', None)
        self.backup_instance_state = None
        self.data_transferred_in_bytes = None
        self.recovery_destination = None
        self.source_recover_point = None
        self.sub_tasks = None
        self.target_recover_point = None


class JobSubTask(msrest.serialization.Model):
    """Details of Job's Sub Task.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param additional_details: Additional details of Sub Tasks.
    :type additional_details: dict[str, str]
    :param task_id: Required. Task Id of the Sub Task.
    :type task_id: int
    :param task_name: Required. Name of the Sub Task.
    :type task_name: str
    :ivar task_progress: Progress of the Sub Task.
    :vartype task_progress: str
    :param task_status: Required. Status of the Sub Task.
    :type task_status: str
    """

    _validation = {
        'task_id': {'required': True},
        'task_name': {'required': True},
        'task_progress': {'readonly': True},
        'task_status': {'required': True},
    }

    _attribute_map = {
        'additional_details': {'key': 'additionalDetails', 'type': '{str}'},
        'task_id': {'key': 'taskId', 'type': 'int'},
        'task_name': {'key': 'taskName', 'type': 'str'},
        'task_progress': {'key': 'taskProgress', 'type': 'str'},
        'task_status': {'key': 'taskStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(JobSubTask, self).__init__(**kwargs)
        self.additional_details = kwargs.get('additional_details', None)
        self.task_id = kwargs['task_id']
        self.task_name = kwargs['task_name']
        self.task_progress = None
        self.task_status = kwargs['task_status']


class OperationExtendedInfo(msrest.serialization.Model):
    """Operation Extended Info.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: OperationJobExtendedInfo.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types.Constant filled by server.
    :type object_type: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    _subtype_map = {
        'object_type': {'OperationJobExtendedInfo': 'OperationJobExtendedInfo'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationExtendedInfo, self).__init__(**kwargs)
        self.object_type = None  # type: Optional[str]


class OperationJobExtendedInfo(OperationExtendedInfo):
    """Operation Job Extended Info.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types.Constant filled by server.
    :type object_type: str
    :param job_id: Arm Id of the job created for this operation.
    :type job_id: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationJobExtendedInfo, self).__init__(**kwargs)
        self.object_type = 'OperationJobExtendedInfo'  # type: str
        self.job_id = kwargs.get('job_id', None)


class OperationResource(msrest.serialization.Model):
    """Operation Resource.

    :param end_time: End time of the operation.
    :type end_time: ~datetime.datetime
    :param error: Required if status == failed or status == canceled. This is the OData v4 error
     format, used by the RPC and will go into the v2.2 Azure REST API guidelines.
     The full set of optional properties (e.g. inner errors / details) can be found in the "Error
     Response" section.
    :type error: ~azure.mgmt.dataprotection.models.Error
    :param id: It should match what is used to GET the operation result.
    :type id: str
    :param name: It must match the last segment of the "id" field, and will typically be a GUID /
     system generated value.
    :type name: str
    :param properties: End time of the operation.
    :type properties: ~azure.mgmt.dataprotection.models.OperationExtendedInfo
    :param start_time: Start time of the operation.
    :type start_time: ~datetime.datetime
    :param status:
    :type status: str
    """

    _attribute_map = {
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'Error'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OperationExtendedInfo'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationResource, self).__init__(**kwargs)
        self.end_time = kwargs.get('end_time', None)
        self.error = kwargs.get('error', None)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.properties = kwargs.get('properties', None)
        self.start_time = kwargs.get('start_time', None)
        self.status = kwargs.get('status', None)


class PatchResourceRequestInput(msrest.serialization.Model):
    """Patch Request content for Microsoft.DataProtection resources.

    :param identity: Input Managed Identity Details.
    :type identity: ~azure.mgmt.dataprotection.models.DppIdentityDetails
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'identity': {'key': 'identity', 'type': 'DppIdentityDetails'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PatchResourceRequestInput, self).__init__(**kwargs)
        self.identity = kwargs.get('identity', None)
        self.tags = kwargs.get('tags', None)


class PolicyInfo(msrest.serialization.Model):
    """Policy Info in backupInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param policy_id: Required.
    :type policy_id: str
    :ivar policy_version:
    :vartype policy_version: str
    :param policy_parameters: Policy parameters for the backup instance.
    :type policy_parameters: ~azure.mgmt.dataprotection.models.PolicyParameters
    """

    _validation = {
        'policy_id': {'required': True},
        'policy_version': {'readonly': True},
    }

    _attribute_map = {
        'policy_id': {'key': 'policyId', 'type': 'str'},
        'policy_version': {'key': 'policyVersion', 'type': 'str'},
        'policy_parameters': {'key': 'policyParameters', 'type': 'PolicyParameters'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyInfo, self).__init__(**kwargs)
        self.policy_id = kwargs['policy_id']
        self.policy_version = None
        self.policy_parameters = kwargs.get('policy_parameters', None)


class PolicyParameters(msrest.serialization.Model):
    """Parameters in Policy.

    :param data_store_parameters_list: Gets or sets the DataStore Parameters.
    :type data_store_parameters_list: list[~azure.mgmt.dataprotection.models.DataStoreParameters]
    """

    _attribute_map = {
        'data_store_parameters_list': {'key': 'dataStoreParametersList', 'type': '[DataStoreParameters]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PolicyParameters, self).__init__(**kwargs)
        self.data_store_parameters_list = kwargs.get('data_store_parameters_list', None)


class ProtectionStatusDetails(msrest.serialization.Model):
    """Protection status details.

    :param error_details: Specifies the protection status error of the resource.
    :type error_details: ~azure.mgmt.dataprotection.models.UserFacingError
    :param status: Specifies the protection status of the resource. Possible values include:
     "ConfiguringProtection", "ConfiguringProtectionFailed", "ProtectionConfigured",
     "ProtectionStopped", "SoftDeleted", "SoftDeleting".
    :type status: str or ~azure.mgmt.dataprotection.models.Status
    """

    _attribute_map = {
        'error_details': {'key': 'errorDetails', 'type': 'UserFacingError'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProtectionStatusDetails, self).__init__(**kwargs)
        self.error_details = kwargs.get('error_details', None)
        self.status = kwargs.get('status', None)


class RangeBasedItemLevelRestoreCriteria(ItemLevelRestoreCriteria):
    """Item Level target info for restore operation.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param min_matching_value: minimum value for range prefix match.
    :type min_matching_value: str
    :param max_matching_value: maximum value for range prefix match.
    :type max_matching_value: str
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'min_matching_value': {'key': 'minMatchingValue', 'type': 'str'},
        'max_matching_value': {'key': 'maxMatchingValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RangeBasedItemLevelRestoreCriteria, self).__init__(**kwargs)
        self.object_type = 'RangeBasedItemLevelRestoreCriteria'  # type: str
        self.min_matching_value = kwargs.get('min_matching_value', None)
        self.max_matching_value = kwargs.get('max_matching_value', None)


class RecoveryPointDataStoreDetails(msrest.serialization.Model):
    """RecoveryPoint datastore details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param creation_time:
    :type creation_time: ~datetime.datetime
    :param expiry_time:
    :type expiry_time: ~datetime.datetime
    :param id:
    :type id: str
    :param meta_data:
    :type meta_data: str
    :param state:
    :type state: str
    :param type:
    :type type: str
    :param visible:
    :type visible: bool
    :ivar rehydration_expiry_time:
    :vartype rehydration_expiry_time: ~datetime.datetime
    :ivar rehydration_status:  Possible values include: "CREATE_IN_PROGRESS", "COMPLETED",
     "DELETE_IN_PROGRESS", "DELETED", "FAILED".
    :vartype rehydration_status: str or ~azure.mgmt.dataprotection.models.RehydrationStatus
    """

    _validation = {
        'rehydration_expiry_time': {'readonly': True},
        'rehydration_status': {'readonly': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'id': {'key': 'id', 'type': 'str'},
        'meta_data': {'key': 'metaData', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'visible': {'key': 'visible', 'type': 'bool'},
        'rehydration_expiry_time': {'key': 'rehydrationExpiryTime', 'type': 'iso-8601'},
        'rehydration_status': {'key': 'rehydrationStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryPointDataStoreDetails, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.expiry_time = kwargs.get('expiry_time', None)
        self.id = kwargs.get('id', None)
        self.meta_data = kwargs.get('meta_data', None)
        self.state = kwargs.get('state', None)
        self.type = kwargs.get('type', None)
        self.visible = kwargs.get('visible', None)
        self.rehydration_expiry_time = None
        self.rehydration_status = None


class RecoveryPointsFilters(msrest.serialization.Model):
    """RecoveryPointsFilters.

    :param restore_point_data_store_id:
    :type restore_point_data_store_id: str
    :param is_visible:
    :type is_visible: bool
    :param start_date:
    :type start_date: str
    :param end_date:
    :type end_date: str
    :param extended_info:
    :type extended_info: bool
    :param restore_point_state:
    :type restore_point_state: str
    """

    _attribute_map = {
        'restore_point_data_store_id': {'key': 'restorePointDataStoreId', 'type': 'str'},
        'is_visible': {'key': 'isVisible', 'type': 'bool'},
        'start_date': {'key': 'startDate', 'type': 'str'},
        'end_date': {'key': 'endDate', 'type': 'str'},
        'extended_info': {'key': 'extendedInfo', 'type': 'bool'},
        'restore_point_state': {'key': 'restorePointState', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryPointsFilters, self).__init__(**kwargs)
        self.restore_point_data_store_id = kwargs.get('restore_point_data_store_id', None)
        self.is_visible = kwargs.get('is_visible', None)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.extended_info = kwargs.get('extended_info', None)
        self.restore_point_state = kwargs.get('restore_point_state', None)


class ResourceGuard(msrest.serialization.Model):
    """ResourceGuard.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the BackupVault resource. Possible values
     include: "Failed", "Provisioning", "Succeeded", "Unknown", "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.dataprotection.models.ProvisioningState
    :ivar allow_auto_approvals: This flag indicates whether auto approval is allowed or not.
    :vartype allow_auto_approvals: bool
    :ivar resource_guard_operations: {readonly} List of operation details those are protected by
     the ResourceGuard resource.
    :vartype resource_guard_operations:
     list[~azure.mgmt.dataprotection.models.ResourceGuardOperation]
    :ivar vault_critical_operation_exclusion_list: List of critical operations which are not
     protected by this resourceGuard.
    :vartype vault_critical_operation_exclusion_list: list[str]
    :ivar description: Description about the pre-req steps to perform all the critical operations.
    :vartype description: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'allow_auto_approvals': {'readonly': True},
        'resource_guard_operations': {'readonly': True},
        'vault_critical_operation_exclusion_list': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'allow_auto_approvals': {'key': 'allowAutoApprovals', 'type': 'bool'},
        'resource_guard_operations': {'key': 'resourceGuardOperations', 'type': '[ResourceGuardOperation]'},
        'vault_critical_operation_exclusion_list': {'key': 'vaultCriticalOperationExclusionList', 'type': '[str]'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceGuard, self).__init__(**kwargs)
        self.provisioning_state = None
        self.allow_auto_approvals = None
        self.resource_guard_operations = None
        self.vault_critical_operation_exclusion_list = None
        self.description = None


class ResourceGuardOperation(msrest.serialization.Model):
    """This class contains all the details about a critical operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar vault_critical_operation: Name of the critical operation.
    :vartype vault_critical_operation: str
    :ivar request_resource_type: Type of resource request.
    :vartype request_resource_type: str
    """

    _validation = {
        'vault_critical_operation': {'readonly': True},
        'request_resource_type': {'readonly': True},
    }

    _attribute_map = {
        'vault_critical_operation': {'key': 'vaultCriticalOperation', 'type': 'str'},
        'request_resource_type': {'key': 'requestResourceType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceGuardOperation, self).__init__(**kwargs)
        self.vault_critical_operation = None
        self.request_resource_type = None


class ResourceGuardResource(DppTrackedResource):
    """ResourceGuardResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param e_tag: Optional ETag.
    :type e_tag: str
    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :param identity: Input Managed Identity Details.
    :type identity: ~azure.mgmt.dataprotection.models.DppIdentityDetails
    :param location: Resource location.
    :type location: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.dataprotection.models.SystemData
    :param properties: ResourceGuardResource properties.
    :type properties: ~azure.mgmt.dataprotection.models.ResourceGuard
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'DppIdentityDetails'},
        'location': {'key': 'location', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'properties': {'key': 'properties', 'type': 'ResourceGuard'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceGuardResource, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class ResourceGuardResourceList(DppTrackedResourceList):
    """List of ResourceGuard resources.

    :param next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
     page of resources.
    :type next_link: str
    :param value: List of resources.
    :type value: list[~azure.mgmt.dataprotection.models.ResourceGuardResource]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ResourceGuardResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceGuardResourceList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ResourceMoveDetails(msrest.serialization.Model):
    """ResourceMoveDetails will be returned in response to GetResource call from ARM.

    :param operation_id: CorrelationId of latest ResourceMove operation attempted.
    :type operation_id: str
    :param start_time_utc: Start time in UTC of latest ResourceMove operation attempted. ISO 8601
     format.
    :type start_time_utc: str
    :param completion_time_utc: Completion time in UTC of latest ResourceMove operation attempted.
     ISO 8601 format.
    :type completion_time_utc: str
    :param source_resource_path: ARM resource path of source resource.
    :type source_resource_path: str
    :param target_resource_path: ARM resource path of target resource used in latest ResourceMove
     operation.
    :type target_resource_path: str
    """

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'str'},
        'completion_time_utc': {'key': 'completionTimeUtc', 'type': 'str'},
        'source_resource_path': {'key': 'sourceResourcePath', 'type': 'str'},
        'target_resource_path': {'key': 'targetResourcePath', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ResourceMoveDetails, self).__init__(**kwargs)
        self.operation_id = kwargs.get('operation_id', None)
        self.start_time_utc = kwargs.get('start_time_utc', None)
        self.completion_time_utc = kwargs.get('completion_time_utc', None)
        self.source_resource_path = kwargs.get('source_resource_path', None)
        self.target_resource_path = kwargs.get('target_resource_path', None)


class RestorableTimeRange(msrest.serialization.Model):
    """RestorableTimeRange.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. Start time for the available restore range.
    :type start_time: str
    :param end_time: Required. End time for the available restore range.
    :type end_time: str
    :param object_type:
    :type object_type: str
    """

    _validation = {
        'start_time': {'required': True},
        'end_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'object_type': {'key': 'objectType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestorableTimeRange, self).__init__(**kwargs)
        self.start_time = kwargs['start_time']
        self.end_time = kwargs['end_time']
        self.object_type = kwargs.get('object_type', None)


class RestoreFilesTargetInfo(RestoreTargetInfoBase):
    """Class encapsulating restore as files target parameters.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of Datasource object, used to initialize the right inherited
     type.Constant filled by server.
    :type object_type: str
    :param recovery_option: Required. Recovery Option. Possible values include: "FailIfExists".
    :type recovery_option: str or ~azure.mgmt.dataprotection.models.RecoveryOption
    :param restore_location: Target Restore region.
    :type restore_location: str
    :param target_details: Required. Destination of RestoreAsFiles operation, when destination is
     not a datasource.
    :type target_details: ~azure.mgmt.dataprotection.models.TargetDetails
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_option': {'required': True},
        'target_details': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_option': {'key': 'recoveryOption', 'type': 'str'},
        'restore_location': {'key': 'restoreLocation', 'type': 'str'},
        'target_details': {'key': 'targetDetails', 'type': 'TargetDetails'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestoreFilesTargetInfo, self).__init__(**kwargs)
        self.object_type = 'RestoreFilesTargetInfo'  # type: str
        self.target_details = kwargs['target_details']


class RestoreJobRecoveryPointDetails(msrest.serialization.Model):
    """RestoreJobRecoveryPointDetails.

    :param recovery_point_id:
    :type recovery_point_id: str
    :param recovery_point_time:
    :type recovery_point_time: ~datetime.datetime
    """

    _attribute_map = {
        'recovery_point_id': {'key': 'recoveryPointID', 'type': 'str'},
        'recovery_point_time': {'key': 'recoveryPointTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestoreJobRecoveryPointDetails, self).__init__(**kwargs)
        self.recovery_point_id = kwargs.get('recovery_point_id', None)
        self.recovery_point_time = kwargs.get('recovery_point_time', None)


class RestoreTargetInfo(RestoreTargetInfoBase):
    """Class encapsulating restore target parameters.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of Datasource object, used to initialize the right inherited
     type.Constant filled by server.
    :type object_type: str
    :param recovery_option: Required. Recovery Option. Possible values include: "FailIfExists".
    :type recovery_option: str or ~azure.mgmt.dataprotection.models.RecoveryOption
    :param restore_location: Target Restore region.
    :type restore_location: str
    :param datasource_info: Required. Information of target DS.
    :type datasource_info: ~azure.mgmt.dataprotection.models.Datasource
    :param datasource_set_info: Information of target DS Set.
    :type datasource_set_info: ~azure.mgmt.dataprotection.models.DatasourceSet
    :param datasource_auth_credentials: Credentials to use to authenticate with data source
     provider.
    :type datasource_auth_credentials: ~azure.mgmt.dataprotection.models.AuthCredentials
    """

    _validation = {
        'object_type': {'required': True},
        'recovery_option': {'required': True},
        'datasource_info': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'recovery_option': {'key': 'recoveryOption', 'type': 'str'},
        'restore_location': {'key': 'restoreLocation', 'type': 'str'},
        'datasource_info': {'key': 'datasourceInfo', 'type': 'Datasource'},
        'datasource_set_info': {'key': 'datasourceSetInfo', 'type': 'DatasourceSet'},
        'datasource_auth_credentials': {'key': 'datasourceAuthCredentials', 'type': 'AuthCredentials'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RestoreTargetInfo, self).__init__(**kwargs)
        self.object_type = 'RestoreTargetInfo'  # type: str
        self.datasource_info = kwargs['datasource_info']
        self.datasource_set_info = kwargs.get('datasource_set_info', None)
        self.datasource_auth_credentials = kwargs.get('datasource_auth_credentials', None)


class RetentionTag(msrest.serialization.Model):
    """Retention tag.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar e_tag: Retention Tag version.
    :vartype e_tag: str
    :ivar id: Retention Tag version.
    :vartype id: str
    :param tag_name: Required. Retention Tag Name to relate it to retention rule.
    :type tag_name: str
    """

    _validation = {
        'e_tag': {'readonly': True},
        'id': {'readonly': True},
        'tag_name': {'required': True},
    }

    _attribute_map = {
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'tag_name': {'key': 'tagName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetentionTag, self).__init__(**kwargs)
        self.e_tag = None
        self.id = None
        self.tag_name = kwargs['tag_name']


class ScheduleBasedBackupCriteria(BackupCriteria):
    """Schedule based backup criteria.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param absolute_criteria: it contains absolute values like "AllBackup" / "FirstOfDay" /
     "FirstOfWeek" / "FirstOfMonth"
     and should be part of AbsoluteMarker enum.
    :type absolute_criteria: list[str or ~azure.mgmt.dataprotection.models.AbsoluteMarker]
    :param days_of_month: This is day of the month from 1 to 28 other wise last of month.
    :type days_of_month: list[~azure.mgmt.dataprotection.models.Day]
    :param days_of_the_week: It should be Sunday/Monday/T..../Saturday.
    :type days_of_the_week: list[str or ~azure.mgmt.dataprotection.models.DayOfWeek]
    :param months_of_year: It should be January/February/....../December.
    :type months_of_year: list[str or ~azure.mgmt.dataprotection.models.Month]
    :param schedule_times: List of schedule times for backup.
    :type schedule_times: list[~datetime.datetime]
    :param weeks_of_the_month: It should be First/Second/Third/Fourth/Last.
    :type weeks_of_the_month: list[str or ~azure.mgmt.dataprotection.models.WeekNumber]
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'absolute_criteria': {'key': 'absoluteCriteria', 'type': '[str]'},
        'days_of_month': {'key': 'daysOfMonth', 'type': '[Day]'},
        'days_of_the_week': {'key': 'daysOfTheWeek', 'type': '[str]'},
        'months_of_year': {'key': 'monthsOfYear', 'type': '[str]'},
        'schedule_times': {'key': 'scheduleTimes', 'type': '[iso-8601]'},
        'weeks_of_the_month': {'key': 'weeksOfTheMonth', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScheduleBasedBackupCriteria, self).__init__(**kwargs)
        self.object_type = 'ScheduleBasedBackupCriteria'  # type: str
        self.absolute_criteria = kwargs.get('absolute_criteria', None)
        self.days_of_month = kwargs.get('days_of_month', None)
        self.days_of_the_week = kwargs.get('days_of_the_week', None)
        self.months_of_year = kwargs.get('months_of_year', None)
        self.schedule_times = kwargs.get('schedule_times', None)
        self.weeks_of_the_month = kwargs.get('weeks_of_the_month', None)


class ScheduleBasedTriggerContext(TriggerContext):
    """Schedule based trigger context.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param schedule: Required. Schedule for this backup.
    :type schedule: ~azure.mgmt.dataprotection.models.BackupSchedule
    :param tagging_criteria: Required. List of tags that can be applicable for given schedule.
    :type tagging_criteria: list[~azure.mgmt.dataprotection.models.TaggingCriteria]
    """

    _validation = {
        'object_type': {'required': True},
        'schedule': {'required': True},
        'tagging_criteria': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'BackupSchedule'},
        'tagging_criteria': {'key': 'taggingCriteria', 'type': '[TaggingCriteria]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScheduleBasedTriggerContext, self).__init__(**kwargs)
        self.object_type = 'ScheduleBasedTriggerContext'  # type: str
        self.schedule = kwargs['schedule']
        self.tagging_criteria = kwargs['tagging_criteria']


class SecretStoreBasedAuthCredentials(AuthCredentials):
    """Secret store based authentication credentials.

    All required parameters must be populated in order to send to Azure.

    :param object_type: Required. Type of the specific object - used for deserializing.Constant
     filled by server.
    :type object_type: str
    :param secret_store_resource: Secret store resource.
    :type secret_store_resource: ~azure.mgmt.dataprotection.models.SecretStoreResource
    """

    _validation = {
        'object_type': {'required': True},
    }

    _attribute_map = {
        'object_type': {'key': 'objectType', 'type': 'str'},
        'secret_store_resource': {'key': 'secretStoreResource', 'type': 'SecretStoreResource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretStoreBasedAuthCredentials, self).__init__(**kwargs)
        self.object_type = 'SecretStoreBasedAuthCredentials'  # type: str
        self.secret_store_resource = kwargs.get('secret_store_resource', None)


class SecretStoreResource(msrest.serialization.Model):
    """Class representing a secret store resource.

    All required parameters must be populated in order to send to Azure.

    :param uri: Uri to get to the resource.
    :type uri: str
    :param secret_store_type: Required. Gets or sets the type of secret store. Possible values
     include: "Invalid", "AzureKeyVault".
    :type secret_store_type: str or ~azure.mgmt.dataprotection.models.SecretStoreType
    """

    _validation = {
        'secret_store_type': {'required': True},
    }

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
        'secret_store_type': {'key': 'secretStoreType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SecretStoreResource, self).__init__(**kwargs)
        self.uri = kwargs.get('uri', None)
        self.secret_store_type = kwargs['secret_store_type']


class SourceLifeCycle(msrest.serialization.Model):
    """Source LifeCycle.

    All required parameters must be populated in order to send to Azure.

    :param delete_after: Required. Delete Option.
    :type delete_after: ~azure.mgmt.dataprotection.models.DeleteOption
    :param source_data_store: Required. DataStoreInfo base.
    :type source_data_store: ~azure.mgmt.dataprotection.models.DataStoreInfoBase
    :param target_data_store_copy_settings:
    :type target_data_store_copy_settings:
     list[~azure.mgmt.dataprotection.models.TargetCopySetting]
    """

    _validation = {
        'delete_after': {'required': True},
        'source_data_store': {'required': True},
    }

    _attribute_map = {
        'delete_after': {'key': 'deleteAfter', 'type': 'DeleteOption'},
        'source_data_store': {'key': 'sourceDataStore', 'type': 'DataStoreInfoBase'},
        'target_data_store_copy_settings': {'key': 'targetDataStoreCopySettings', 'type': '[TargetCopySetting]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SourceLifeCycle, self).__init__(**kwargs)
        self.delete_after = kwargs['delete_after']
        self.source_data_store = kwargs['source_data_store']
        self.target_data_store_copy_settings = kwargs.get('target_data_store_copy_settings', None)


class StorageSetting(msrest.serialization.Model):
    """Storage setting.

    :param datastore_type: Gets or sets the type of the datastore. Possible values include:
     "ArchiveStore", "SnapshotStore", "VaultStore".
    :type datastore_type: str or ~azure.mgmt.dataprotection.models.StorageSettingStoreTypes
    :param type: Gets or sets the type. Possible values include: "GeoRedundant",
     "LocallyRedundant".
    :type type: str or ~azure.mgmt.dataprotection.models.StorageSettingTypes
    """

    _attribute_map = {
        'datastore_type': {'key': 'datastoreType', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StorageSetting, self).__init__(**kwargs)
        self.datastore_type = kwargs.get('datastore_type', None)
        self.type = kwargs.get('type', None)


class SupportedFeature(msrest.serialization.Model):
    """Elements class for feature request.

    :param feature_name: support feature type.
    :type feature_name: str
    :param support_status: feature support status. Possible values include: "Invalid",
     "NotSupported", "AlphaPreview", "PrivatePreview", "PublicPreview", "GenerallyAvailable".
    :type support_status: str or ~azure.mgmt.dataprotection.models.FeatureSupportStatus
    :param exposure_controlled_features: support feature type.
    :type exposure_controlled_features: list[str]
    """

    _attribute_map = {
        'feature_name': {'key': 'featureName', 'type': 'str'},
        'support_status': {'key': 'supportStatus', 'type': 'str'},
        'exposure_controlled_features': {'key': 'exposureControlledFeatures', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SupportedFeature, self).__init__(**kwargs)
        self.feature_name = kwargs.get('feature_name', None)
        self.support_status = kwargs.get('support_status', None)
        self.exposure_controlled_features = kwargs.get('exposure_controlled_features', None)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~azure.mgmt.dataprotection.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~azure.mgmt.dataprotection.models.CreatedByType
    :param last_modified_at: The type of identity that last modified the resource.
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TaggingCriteria(msrest.serialization.Model):
    """Tagging criteria.

    All required parameters must be populated in order to send to Azure.

    :param criteria: Criteria which decides whether the tag can be applied to a triggered backup.
    :type criteria: list[~azure.mgmt.dataprotection.models.BackupCriteria]
    :param is_default: Required. Specifies if tag is default.
    :type is_default: bool
    :param tagging_priority: Required. Retention Tag priority.
    :type tagging_priority: long
    :param tag_info: Required. Retention tag information.
    :type tag_info: ~azure.mgmt.dataprotection.models.RetentionTag
    """

    _validation = {
        'is_default': {'required': True},
        'tagging_priority': {'required': True},
        'tag_info': {'required': True},
    }

    _attribute_map = {
        'criteria': {'key': 'criteria', 'type': '[BackupCriteria]'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'tagging_priority': {'key': 'taggingPriority', 'type': 'long'},
        'tag_info': {'key': 'tagInfo', 'type': 'RetentionTag'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TaggingCriteria, self).__init__(**kwargs)
        self.criteria = kwargs.get('criteria', None)
        self.is_default = kwargs['is_default']
        self.tagging_priority = kwargs['tagging_priority']
        self.tag_info = kwargs['tag_info']


class TargetCopySetting(msrest.serialization.Model):
    """Target copy settings.

    All required parameters must be populated in order to send to Azure.

    :param copy_after: Required. It can be CustomCopyOption or ImmediateCopyOption.
    :type copy_after: ~azure.mgmt.dataprotection.models.CopyOption
    :param data_store: Required. Info of target datastore.
    :type data_store: ~azure.mgmt.dataprotection.models.DataStoreInfoBase
    """

    _validation = {
        'copy_after': {'required': True},
        'data_store': {'required': True},
    }

    _attribute_map = {
        'copy_after': {'key': 'copyAfter', 'type': 'CopyOption'},
        'data_store': {'key': 'dataStore', 'type': 'DataStoreInfoBase'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TargetCopySetting, self).__init__(**kwargs)
        self.copy_after = kwargs['copy_after']
        self.data_store = kwargs['data_store']


class TargetDetails(msrest.serialization.Model):
    """Class encapsulating target details, used where the destination is not a datasource.

    All required parameters must be populated in order to send to Azure.

    :param file_prefix: Required. Restore operation may create multiple files inside location
     pointed by Url
     Below will be the common prefix for all of them.
    :type file_prefix: str
    :param restore_target_location_type: Required. Denotes the target location where the data will
     be restored,
     string value for the enum
     {Microsoft.Internal.AzureBackup.DataProtection.Common.Interface.RestoreTargetLocationType}.
     Possible values include: "Invalid", "AzureBlobs", "AzureFiles".
    :type restore_target_location_type: str or
     ~azure.mgmt.dataprotection.models.RestoreTargetLocationType
    :param url: Required. Url denoting the restore destination. It can point to container / file
     share etc.
    :type url: str
    """

    _validation = {
        'file_prefix': {'required': True},
        'restore_target_location_type': {'required': True},
        'url': {'required': True},
    }

    _attribute_map = {
        'file_prefix': {'key': 'filePrefix', 'type': 'str'},
        'restore_target_location_type': {'key': 'restoreTargetLocationType', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TargetDetails, self).__init__(**kwargs)
        self.file_prefix = kwargs['file_prefix']
        self.restore_target_location_type = kwargs['restore_target_location_type']
        self.url = kwargs['url']


class TriggerBackupRequest(msrest.serialization.Model):
    """Trigger backup request.

    All required parameters must be populated in order to send to Azure.

    :param backup_rule_options: Required. Name for the Rule of the Policy which needs to be applied
     for this backup.
    :type backup_rule_options: ~azure.mgmt.dataprotection.models.AdHocBackupRuleOptions
    """

    _validation = {
        'backup_rule_options': {'required': True},
    }

    _attribute_map = {
        'backup_rule_options': {'key': 'backupRuleOptions', 'type': 'AdHocBackupRuleOptions'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TriggerBackupRequest, self).__init__(**kwargs)
        self.backup_rule_options = kwargs['backup_rule_options']


class UserFacingError(msrest.serialization.Model):
    """Error object used by layers that have access to localized content, and propagate that to user.

    :param code: Unique code for this error.
    :type code: str
    :param details: Additional related Errors.
    :type details: list[~azure.mgmt.dataprotection.models.UserFacingError]
    :param inner_error: Inner Error.
    :type inner_error: ~azure.mgmt.dataprotection.models.InnerError
    :param is_retryable: Whether the operation will be retryable or not.
    :type is_retryable: bool
    :param is_user_error: Whether the operation is due to a user error or service error.
    :type is_user_error: bool
    :param properties: Any key value pairs that can be injected inside error object.
    :type properties: dict[str, str]
    :param message:
    :type message: str
    :param recommended_action: RecommendedAction � localized.
    :type recommended_action: list[str]
    :param target: Target of the error.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'details': {'key': 'details', 'type': '[UserFacingError]'},
        'inner_error': {'key': 'innerError', 'type': 'InnerError'},
        'is_retryable': {'key': 'isRetryable', 'type': 'bool'},
        'is_user_error': {'key': 'isUserError', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': '{str}'},
        'message': {'key': 'message', 'type': 'str'},
        'recommended_action': {'key': 'recommendedAction', 'type': '[str]'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UserFacingError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.details = kwargs.get('details', None)
        self.inner_error = kwargs.get('inner_error', None)
        self.is_retryable = kwargs.get('is_retryable', None)
        self.is_user_error = kwargs.get('is_user_error', None)
        self.properties = kwargs.get('properties', None)
        self.message = kwargs.get('message', None)
        self.recommended_action = kwargs.get('recommended_action', None)
        self.target = kwargs.get('target', None)


class ValidateForBackupRequest(msrest.serialization.Model):
    """Validate for backup request.

    All required parameters must be populated in order to send to Azure.

    :param backup_instance: Required. Backup Instance.
    :type backup_instance: ~azure.mgmt.dataprotection.models.BackupInstance
    """

    _validation = {
        'backup_instance': {'required': True},
    }

    _attribute_map = {
        'backup_instance': {'key': 'backupInstance', 'type': 'BackupInstance'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateForBackupRequest, self).__init__(**kwargs)
        self.backup_instance = kwargs['backup_instance']


class ValidateRestoreRequestObject(msrest.serialization.Model):
    """Validate restore request object.

    All required parameters must be populated in order to send to Azure.

    :param restore_request_object: Required. Gets or sets the restore request object.
    :type restore_request_object: ~azure.mgmt.dataprotection.models.AzureBackupRestoreRequest
    """

    _validation = {
        'restore_request_object': {'required': True},
    }

    _attribute_map = {
        'restore_request_object': {'key': 'restoreRequestObject', 'type': 'AzureBackupRestoreRequest'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ValidateRestoreRequestObject, self).__init__(**kwargs)
        self.restore_request_object = kwargs['restore_request_object']
