# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

from .. import models as _models
from .._vendor import _convert_request, _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, List, Optional, TypeVar, Union

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
# fmt: off

def build_count_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs/$count')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_search_get_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    search_text = kwargs.pop('search_text', None)  # type: Optional[str]
    include_total_result_count = kwargs.pop('include_total_result_count', None)  # type: Optional[bool]
    facets = kwargs.pop('facets', None)  # type: Optional[List[str]]
    filter = kwargs.pop('filter', None)  # type: Optional[str]
    highlight_fields = kwargs.pop('highlight_fields', None)  # type: Optional[List[str]]
    highlight_post_tag = kwargs.pop('highlight_post_tag', None)  # type: Optional[str]
    highlight_pre_tag = kwargs.pop('highlight_pre_tag', None)  # type: Optional[str]
    minimum_coverage = kwargs.pop('minimum_coverage', None)  # type: Optional[float]
    order_by = kwargs.pop('order_by', None)  # type: Optional[List[str]]
    query_type = kwargs.pop('query_type', None)  # type: Optional[Union[str, "_models.QueryType"]]
    scoring_parameters = kwargs.pop('scoring_parameters', None)  # type: Optional[List[str]]
    scoring_profile = kwargs.pop('scoring_profile', None)  # type: Optional[str]
    search_fields = kwargs.pop('search_fields', None)  # type: Optional[List[str]]
    query_language = kwargs.pop('query_language', None)  # type: Optional[Union[str, "_models.QueryLanguage"]]
    speller = kwargs.pop('speller', None)  # type: Optional[Union[str, "_models.Speller"]]
    answers = kwargs.pop('answers', None)  # type: Optional[Union[str, "_models.Answers"]]
    search_mode = kwargs.pop('search_mode', None)  # type: Optional[Union[str, "_models.SearchMode"]]
    scoring_statistics = kwargs.pop('scoring_statistics', None)  # type: Optional[Union[str, "_models.ScoringStatistics"]]
    session_id = kwargs.pop('session_id', None)  # type: Optional[str]
    select = kwargs.pop('select', None)  # type: Optional[List[str]]
    skip = kwargs.pop('skip', None)  # type: Optional[int]
    top = kwargs.pop('top', None)  # type: Optional[int]
    captions = kwargs.pop('captions', None)  # type: Optional[Union[str, "_models.Captions"]]
    semantic_fields = kwargs.pop('semantic_fields', None)  # type: Optional[List[str]]
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if search_text is not None:
        query_parameters['search'] = _SERIALIZER.query("search_text", search_text, 'str')
    if include_total_result_count is not None:
        query_parameters['$count'] = _SERIALIZER.query("include_total_result_count", include_total_result_count, 'bool')
    if facets is not None:
        query_parameters['facet'] = [_SERIALIZER.query("facets", q, 'str') if q is not None else '' for q in facets]
    if filter is not None:
        query_parameters['$filter'] = _SERIALIZER.query("filter", filter, 'str')
    if highlight_fields is not None:
        query_parameters['highlight'] = _SERIALIZER.query("highlight_fields", highlight_fields, '[str]', div=',')
    if highlight_post_tag is not None:
        query_parameters['highlightPostTag'] = _SERIALIZER.query("highlight_post_tag", highlight_post_tag, 'str')
    if highlight_pre_tag is not None:
        query_parameters['highlightPreTag'] = _SERIALIZER.query("highlight_pre_tag", highlight_pre_tag, 'str')
    if minimum_coverage is not None:
        query_parameters['minimumCoverage'] = _SERIALIZER.query("minimum_coverage", minimum_coverage, 'float')
    if order_by is not None:
        query_parameters['$orderby'] = _SERIALIZER.query("order_by", order_by, '[str]', div=',')
    if query_type is not None:
        query_parameters['queryType'] = _SERIALIZER.query("query_type", query_type, 'str')
    if scoring_parameters is not None:
        query_parameters['scoringParameter'] = [_SERIALIZER.query("scoring_parameters", q, 'str') if q is not None else '' for q in scoring_parameters]
    if scoring_profile is not None:
        query_parameters['scoringProfile'] = _SERIALIZER.query("scoring_profile", scoring_profile, 'str')
    if search_fields is not None:
        query_parameters['searchFields'] = _SERIALIZER.query("search_fields", search_fields, '[str]', div=',')
    if query_language is not None:
        query_parameters['queryLanguage'] = _SERIALIZER.query("query_language", query_language, 'str')
    if speller is not None:
        query_parameters['speller'] = _SERIALIZER.query("speller", speller, 'str')
    if answers is not None:
        query_parameters['answers'] = _SERIALIZER.query("answers", answers, 'str')
    if search_mode is not None:
        query_parameters['searchMode'] = _SERIALIZER.query("search_mode", search_mode, 'str')
    if scoring_statistics is not None:
        query_parameters['scoringStatistics'] = _SERIALIZER.query("scoring_statistics", scoring_statistics, 'str')
    if session_id is not None:
        query_parameters['sessionId'] = _SERIALIZER.query("session_id", session_id, 'str')
    if select is not None:
        query_parameters['$select'] = _SERIALIZER.query("select", select, '[str]', div=',')
    if skip is not None:
        query_parameters['$skip'] = _SERIALIZER.query("skip", skip, 'int')
    if top is not None:
        query_parameters['$top'] = _SERIALIZER.query("top", top, 'int')
    if captions is not None:
        query_parameters['captions'] = _SERIALIZER.query("captions", captions, 'str')
    if semantic_fields is not None:
        query_parameters['semanticFields'] = _SERIALIZER.query("semantic_fields", semantic_fields, '[str]', div=',')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_search_post_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs/search.post.search')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_get_request(
    key,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    selected_fields = kwargs.pop('selected_fields', None)  # type: Optional[List[str]]
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs(\'{key}\')')
    path_format_arguments = {
        "key": _SERIALIZER.url("key", key, 'str'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if selected_fields is not None:
        query_parameters['$select'] = _SERIALIZER.query("selected_fields", selected_fields, '[str]', div=',')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_suggest_get_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    search_text = kwargs.pop('search_text')  # type: str
    suggester_name = kwargs.pop('suggester_name')  # type: str
    filter = kwargs.pop('filter', None)  # type: Optional[str]
    use_fuzzy_matching = kwargs.pop('use_fuzzy_matching', None)  # type: Optional[bool]
    highlight_post_tag = kwargs.pop('highlight_post_tag', None)  # type: Optional[str]
    highlight_pre_tag = kwargs.pop('highlight_pre_tag', None)  # type: Optional[str]
    minimum_coverage = kwargs.pop('minimum_coverage', None)  # type: Optional[float]
    order_by = kwargs.pop('order_by', None)  # type: Optional[List[str]]
    search_fields = kwargs.pop('search_fields', None)  # type: Optional[List[str]]
    select = kwargs.pop('select', None)  # type: Optional[List[str]]
    top = kwargs.pop('top', None)  # type: Optional[int]
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs/search.suggest')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['search'] = _SERIALIZER.query("search_text", search_text, 'str')
    query_parameters['suggesterName'] = _SERIALIZER.query("suggester_name", suggester_name, 'str')
    if filter is not None:
        query_parameters['$filter'] = _SERIALIZER.query("filter", filter, 'str')
    if use_fuzzy_matching is not None:
        query_parameters['fuzzy'] = _SERIALIZER.query("use_fuzzy_matching", use_fuzzy_matching, 'bool')
    if highlight_post_tag is not None:
        query_parameters['highlightPostTag'] = _SERIALIZER.query("highlight_post_tag", highlight_post_tag, 'str')
    if highlight_pre_tag is not None:
        query_parameters['highlightPreTag'] = _SERIALIZER.query("highlight_pre_tag", highlight_pre_tag, 'str')
    if minimum_coverage is not None:
        query_parameters['minimumCoverage'] = _SERIALIZER.query("minimum_coverage", minimum_coverage, 'float')
    if order_by is not None:
        query_parameters['$orderby'] = _SERIALIZER.query("order_by", order_by, '[str]', div=',')
    if search_fields is not None:
        query_parameters['searchFields'] = _SERIALIZER.query("search_fields", search_fields, '[str]', div=',')
    if select is not None:
        query_parameters['$select'] = _SERIALIZER.query("select", select, '[str]', div=',')
    if top is not None:
        query_parameters['$top'] = _SERIALIZER.query("top", top, 'int')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_suggest_post_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs/search.post.suggest')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_index_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs/search.index')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_autocomplete_get_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    search_text = kwargs.pop('search_text')  # type: str
    suggester_name = kwargs.pop('suggester_name')  # type: str
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]
    autocomplete_mode = kwargs.pop('autocomplete_mode', None)  # type: Optional[Union[str, "_models.AutocompleteMode"]]
    filter = kwargs.pop('filter', None)  # type: Optional[str]
    use_fuzzy_matching = kwargs.pop('use_fuzzy_matching', None)  # type: Optional[bool]
    highlight_post_tag = kwargs.pop('highlight_post_tag', None)  # type: Optional[str]
    highlight_pre_tag = kwargs.pop('highlight_pre_tag', None)  # type: Optional[str]
    minimum_coverage = kwargs.pop('minimum_coverage', None)  # type: Optional[float]
    search_fields = kwargs.pop('search_fields', None)  # type: Optional[List[str]]
    top = kwargs.pop('top', None)  # type: Optional[int]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs/search.autocomplete')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    query_parameters['search'] = _SERIALIZER.query("search_text", search_text, 'str')
    query_parameters['suggesterName'] = _SERIALIZER.query("suggester_name", suggester_name, 'str')
    if autocomplete_mode is not None:
        query_parameters['autocompleteMode'] = _SERIALIZER.query("autocomplete_mode", autocomplete_mode, 'str')
    if filter is not None:
        query_parameters['$filter'] = _SERIALIZER.query("filter", filter, 'str')
    if use_fuzzy_matching is not None:
        query_parameters['fuzzy'] = _SERIALIZER.query("use_fuzzy_matching", use_fuzzy_matching, 'bool')
    if highlight_post_tag is not None:
        query_parameters['highlightPostTag'] = _SERIALIZER.query("highlight_post_tag", highlight_post_tag, 'str')
    if highlight_pre_tag is not None:
        query_parameters['highlightPreTag'] = _SERIALIZER.query("highlight_pre_tag", highlight_pre_tag, 'str')
    if minimum_coverage is not None:
        query_parameters['minimumCoverage'] = _SERIALIZER.query("minimum_coverage", minimum_coverage, 'float')
    if search_fields is not None:
        query_parameters['searchFields'] = _SERIALIZER.query("search_fields", search_fields, '[str]', div=',')
    if top is not None:
        query_parameters['$top'] = _SERIALIZER.query("top", top, 'int')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_autocomplete_post_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    x_ms_client_request_id = kwargs.pop('x_ms_client_request_id', None)  # type: Optional[str]

    api_version = "2021-04-30-Preview"
    accept = "application/json"
    # Construct URL
    url = kwargs.pop("template_url", '/docs/search.post.autocomplete')

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if x_ms_client_request_id is not None:
        header_parameters['x-ms-client-request-id'] = _SERIALIZER.header("x_ms_client_request_id", x_ms_client_request_id, 'str')
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class DocumentsOperations(object):
    """DocumentsOperations operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.search.documents.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = _models

    def __init__(self, client, config, serializer, deserializer):
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace
    def count(
        self,
        request_options=None,  # type: Optional["_models.RequestOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> int
        """Queries the number of documents in the index.

        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: long, or the result of cls(response)
        :rtype: long
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[int]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _x_ms_client_request_id = None
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id

        request = build_count_request(
            x_ms_client_request_id=_x_ms_client_request_id,
            template_url=self.count.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('long', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    count.metadata = {'url': '/docs/$count'}  # type: ignore


    @distributed_trace
    def search_get(
        self,
        search_text=None,  # type: Optional[str]
        search_options=None,  # type: Optional["_models.SearchOptions"]
        request_options=None,  # type: Optional["_models.RequestOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SearchDocumentsResult"
        """Searches for documents in the index.

        :param search_text: A full-text search query expression; Use "*" or omit this parameter to
         match all documents.
        :type search_text: str
        :param search_options: Parameter group.
        :type search_options: ~azure.search.documents.models.SearchOptions
        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchDocumentsResult, or the result of cls(response)
        :rtype: ~azure.search.documents.models.SearchDocumentsResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SearchDocumentsResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _include_total_result_count = None
        _facets = None
        _filter = None
        _highlight_fields = None
        _highlight_post_tag = None
        _highlight_pre_tag = None
        _minimum_coverage = None
        _order_by = None
        _query_type = None
        _scoring_parameters = None
        _scoring_profile = None
        _search_fields = None
        _query_language = None
        _speller = None
        _answers = None
        _search_mode = None
        _scoring_statistics = None
        _session_id = None
        _select = None
        _skip = None
        _top = None
        _captions = None
        _semantic_fields = None
        _x_ms_client_request_id = None
        if search_options is not None:
            _include_total_result_count = search_options.include_total_result_count
            _facets = search_options.facets
            _filter = search_options.filter
            _highlight_fields = search_options.highlight_fields
            _highlight_post_tag = search_options.highlight_post_tag
            _highlight_pre_tag = search_options.highlight_pre_tag
            _minimum_coverage = search_options.minimum_coverage
            _order_by = search_options.order_by
            _query_type = search_options.query_type
            _scoring_parameters = search_options.scoring_parameters
            _scoring_profile = search_options.scoring_profile
            _search_fields = search_options.search_fields
            _query_language = search_options.query_language
            _speller = search_options.speller
            _answers = search_options.answers
            _search_mode = search_options.search_mode
            _scoring_statistics = search_options.scoring_statistics
            _session_id = search_options.session_id
            _select = search_options.select
            _skip = search_options.skip
            _top = search_options.top
            _captions = search_options.captions
            _semantic_fields = search_options.semantic_fields
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id

        request = build_search_get_request(
            search_text=search_text,
            include_total_result_count=_include_total_result_count,
            facets=_facets,
            filter=_filter,
            highlight_fields=_highlight_fields,
            highlight_post_tag=_highlight_post_tag,
            highlight_pre_tag=_highlight_pre_tag,
            minimum_coverage=_minimum_coverage,
            order_by=_order_by,
            query_type=_query_type,
            scoring_parameters=_scoring_parameters,
            scoring_profile=_scoring_profile,
            search_fields=_search_fields,
            query_language=_query_language,
            speller=_speller,
            answers=_answers,
            search_mode=_search_mode,
            scoring_statistics=_scoring_statistics,
            session_id=_session_id,
            select=_select,
            skip=_skip,
            top=_top,
            captions=_captions,
            semantic_fields=_semantic_fields,
            x_ms_client_request_id=_x_ms_client_request_id,
            template_url=self.search_get.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchDocumentsResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    search_get.metadata = {'url': '/docs'}  # type: ignore


    @distributed_trace
    def search_post(
        self,
        search_request,  # type: "_models.SearchRequest"
        request_options=None,  # type: Optional["_models.RequestOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SearchDocumentsResult"
        """Searches for documents in the index.

        :param search_request: The definition of the Search request.
        :type search_request: ~azure.search.documents.models.SearchRequest
        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SearchDocumentsResult, or the result of cls(response)
        :rtype: ~azure.search.documents.models.SearchDocumentsResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SearchDocumentsResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _x_ms_client_request_id = None
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id
        json = self._serialize.body(search_request, 'SearchRequest')

        request = build_search_post_request(
            content_type=content_type,
            x_ms_client_request_id=_x_ms_client_request_id,
            json=json,
            template_url=self.search_post.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SearchDocumentsResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    search_post.metadata = {'url': '/docs/search.post.search'}  # type: ignore


    @distributed_trace
    def get(
        self,
        key,  # type: str
        selected_fields=None,  # type: Optional[List[str]]
        request_options=None,  # type: Optional["_models.RequestOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> Any
        """Retrieves a document from the index.

        :param key: The key of the document to retrieve.
        :type key: str
        :param selected_fields: List of field names to retrieve for the document; Any field not
         retrieved will be missing from the returned document.
        :type selected_fields: list[str]
        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: any, or the result of cls(response)
        :rtype: any
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _x_ms_client_request_id = None
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id

        request = build_get_request(
            key=key,
            selected_fields=selected_fields,
            x_ms_client_request_id=_x_ms_client_request_id,
            template_url=self.get.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('object', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get.metadata = {'url': '/docs(\'{key}\')'}  # type: ignore


    @distributed_trace
    def suggest_get(
        self,
        search_text,  # type: str
        suggester_name,  # type: str
        suggest_options=None,  # type: Optional["_models.SuggestOptions"]
        request_options=None,  # type: Optional["_models.RequestOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SuggestDocumentsResult"
        """Suggests documents in the index that match the given partial query text.

        :param search_text: The search text to use to suggest documents. Must be at least 1 character,
         and no more than 100 characters.
        :type search_text: str
        :param suggester_name: The name of the suggester as specified in the suggesters collection
         that's part of the index definition.
        :type suggester_name: str
        :param suggest_options: Parameter group.
        :type suggest_options: ~azure.search.documents.models.SuggestOptions
        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SuggestDocumentsResult, or the result of cls(response)
        :rtype: ~azure.search.documents.models.SuggestDocumentsResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SuggestDocumentsResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _filter = None
        _use_fuzzy_matching = None
        _highlight_post_tag = None
        _highlight_pre_tag = None
        _minimum_coverage = None
        _order_by = None
        _search_fields = None
        _select = None
        _top = None
        _x_ms_client_request_id = None
        if suggest_options is not None:
            _filter = suggest_options.filter
            _use_fuzzy_matching = suggest_options.use_fuzzy_matching
            _highlight_post_tag = suggest_options.highlight_post_tag
            _highlight_pre_tag = suggest_options.highlight_pre_tag
            _minimum_coverage = suggest_options.minimum_coverage
            _order_by = suggest_options.order_by
            _search_fields = suggest_options.search_fields
            _select = suggest_options.select
            _top = suggest_options.top
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id

        request = build_suggest_get_request(
            search_text=search_text,
            suggester_name=suggester_name,
            filter=_filter,
            use_fuzzy_matching=_use_fuzzy_matching,
            highlight_post_tag=_highlight_post_tag,
            highlight_pre_tag=_highlight_pre_tag,
            minimum_coverage=_minimum_coverage,
            order_by=_order_by,
            search_fields=_search_fields,
            select=_select,
            top=_top,
            x_ms_client_request_id=_x_ms_client_request_id,
            template_url=self.suggest_get.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SuggestDocumentsResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    suggest_get.metadata = {'url': '/docs/search.suggest'}  # type: ignore


    @distributed_trace
    def suggest_post(
        self,
        suggest_request,  # type: "_models.SuggestRequest"
        request_options=None,  # type: Optional["_models.RequestOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.SuggestDocumentsResult"
        """Suggests documents in the index that match the given partial query text.

        :param suggest_request: The Suggest request.
        :type suggest_request: ~azure.search.documents.models.SuggestRequest
        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: SuggestDocumentsResult, or the result of cls(response)
        :rtype: ~azure.search.documents.models.SuggestDocumentsResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.SuggestDocumentsResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _x_ms_client_request_id = None
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id
        json = self._serialize.body(suggest_request, 'SuggestRequest')

        request = build_suggest_post_request(
            content_type=content_type,
            x_ms_client_request_id=_x_ms_client_request_id,
            json=json,
            template_url=self.suggest_post.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('SuggestDocumentsResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    suggest_post.metadata = {'url': '/docs/search.post.suggest'}  # type: ignore


    @distributed_trace
    def index(
        self,
        actions,  # type: List["_models.IndexAction"]
        request_options=None,  # type: Optional["_models.RequestOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.IndexDocumentsResult"
        """Sends a batch of document write actions to the index.

        :param actions: The actions in the batch.
        :type actions: list[~azure.search.documents.models.IndexAction]
        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IndexDocumentsResult, or the result of cls(response)
        :rtype: ~azure.search.documents.models.IndexDocumentsResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.IndexDocumentsResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _x_ms_client_request_id = None
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id
        _batch = _models.IndexBatch(actions=actions)
        json = self._serialize.body(_batch, 'IndexBatch')

        request = build_index_request(
            content_type=content_type,
            x_ms_client_request_id=_x_ms_client_request_id,
            json=json,
            template_url=self.index.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 207]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        if response.status_code == 200:
            deserialized = self._deserialize('IndexDocumentsResult', pipeline_response)

        if response.status_code == 207:
            deserialized = self._deserialize('IndexDocumentsResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    index.metadata = {'url': '/docs/search.index'}  # type: ignore


    @distributed_trace
    def autocomplete_get(
        self,
        search_text,  # type: str
        suggester_name,  # type: str
        request_options=None,  # type: Optional["_models.RequestOptions"]
        autocomplete_options=None,  # type: Optional["_models.AutocompleteOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.AutocompleteResult"
        """Autocompletes incomplete query terms based on input text and matching terms in the index.

        :param search_text: The incomplete term which should be auto-completed.
        :type search_text: str
        :param suggester_name: The name of the suggester as specified in the suggesters collection
         that's part of the index definition.
        :type suggester_name: str
        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :param autocomplete_options: Parameter group.
        :type autocomplete_options: ~azure.search.documents.models.AutocompleteOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutocompleteResult, or the result of cls(response)
        :rtype: ~azure.search.documents.models.AutocompleteResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AutocompleteResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        _x_ms_client_request_id = None
        _autocomplete_mode = None
        _filter = None
        _use_fuzzy_matching = None
        _highlight_post_tag = None
        _highlight_pre_tag = None
        _minimum_coverage = None
        _search_fields = None
        _top = None
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id
        if autocomplete_options is not None:
            _autocomplete_mode = autocomplete_options.autocomplete_mode
            _filter = autocomplete_options.filter
            _use_fuzzy_matching = autocomplete_options.use_fuzzy_matching
            _highlight_post_tag = autocomplete_options.highlight_post_tag
            _highlight_pre_tag = autocomplete_options.highlight_pre_tag
            _minimum_coverage = autocomplete_options.minimum_coverage
            _search_fields = autocomplete_options.search_fields
            _top = autocomplete_options.top

        request = build_autocomplete_get_request(
            search_text=search_text,
            suggester_name=suggester_name,
            x_ms_client_request_id=_x_ms_client_request_id,
            autocomplete_mode=_autocomplete_mode,
            filter=_filter,
            use_fuzzy_matching=_use_fuzzy_matching,
            highlight_post_tag=_highlight_post_tag,
            highlight_pre_tag=_highlight_pre_tag,
            minimum_coverage=_minimum_coverage,
            search_fields=_search_fields,
            top=_top,
            template_url=self.autocomplete_get.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('AutocompleteResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    autocomplete_get.metadata = {'url': '/docs/search.autocomplete'}  # type: ignore


    @distributed_trace
    def autocomplete_post(
        self,
        autocomplete_request,  # type: "_models.AutocompleteRequest"
        request_options=None,  # type: Optional["_models.RequestOptions"]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.AutocompleteResult"
        """Autocompletes incomplete query terms based on input text and matching terms in the index.

        :param autocomplete_request: The definition of the Autocomplete request.
        :type autocomplete_request: ~azure.search.documents.models.AutocompleteRequest
        :param request_options: Parameter group.
        :type request_options: ~azure.search.documents.models.RequestOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: AutocompleteResult, or the result of cls(response)
        :rtype: ~azure.search.documents.models.AutocompleteResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.AutocompleteResult"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _x_ms_client_request_id = None
        if request_options is not None:
            _x_ms_client_request_id = request_options.x_ms_client_request_id
        json = self._serialize.body(autocomplete_request, 'AutocompleteRequest')

        request = build_autocomplete_post_request(
            content_type=content_type,
            x_ms_client_request_id=_x_ms_client_request_id,
            json=json,
            template_url=self.autocomplete_post.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
            "indexName": self._serialize.url("self._config.index_name", self._config.index_name, 'str'),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.SearchError, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('AutocompleteResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    autocomplete_post.metadata = {'url': '/docs/search.post.autocomplete'}  # type: ignore

