# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._microsoft_storage_sync_enums import *


class BackupRequest(msrest.serialization.Model):
    """Backup request.

    :param azure_file_share: Azure File Share.
    :type azure_file_share: str
    """

    _attribute_map = {
        'azure_file_share': {'key': 'azureFileShare', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        azure_file_share: Optional[str] = None,
        **kwargs
    ):
        super(BackupRequest, self).__init__(**kwargs)
        self.azure_file_share = azure_file_share


class CheckNameAvailabilityParameters(msrest.serialization.Model):
    """Parameters for a check name availability request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name to check for availability.
    :type name: str
    :ivar type: Required. The resource type. Must be set to
     Microsoft.StorageSync/storageSyncServices. Default value:
     "Microsoft.StorageSync/storageSyncServices".
    :vartype type: str
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    type = "Microsoft.StorageSync/storageSyncServices"

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        super(CheckNameAvailabilityParameters, self).__init__(**kwargs)
        self.name = name


class CheckNameAvailabilityResult(msrest.serialization.Model):
    """The CheckNameAvailability operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: Gets a boolean value that indicates whether the name is available for you
     to use. If true, the name is available. If false, the name has already been taken or invalid
     and cannot be used.
    :vartype name_available: bool
    :ivar reason: Gets the reason that a Storage Sync Service name could not be used. The Reason
     element is only returned if NameAvailable is false. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.storagesync.models.NameAvailabilityReason
    :ivar message: Gets an error message explaining the Reason value in more detail.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = None


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ProxyResource, self).__init__(**kwargs)


class CloudEndpoint(ProxyResource):
    """Cloud Endpoint object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param storage_account_resource_id: Storage Account Resource Id.
    :type storage_account_resource_id: str
    :param azure_file_share_name: Azure file share name.
    :type azure_file_share_name: str
    :param storage_account_tenant_id: Storage Account Tenant Id.
    :type storage_account_tenant_id: str
    :param partnership_id: Partnership Id.
    :type partnership_id: str
    :param friendly_name: Friendly Name.
    :type friendly_name: str
    :ivar backup_enabled: Backup Enabled.
    :vartype backup_enabled: str
    :param provisioning_state: CloudEndpoint Provisioning State.
    :type provisioning_state: str
    :param last_workflow_id: CloudEndpoint lastWorkflowId.
    :type last_workflow_id: str
    :param last_operation_name: Resource Last Operation Name.
    :type last_operation_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'backup_enabled': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'azure_file_share_name': {'key': 'properties.azureFileShareName', 'type': 'str'},
        'storage_account_tenant_id': {'key': 'properties.storageAccountTenantId', 'type': 'str'},
        'partnership_id': {'key': 'properties.partnershipId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'backup_enabled': {'key': 'properties.backupEnabled', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'last_workflow_id': {'key': 'properties.lastWorkflowId', 'type': 'str'},
        'last_operation_name': {'key': 'properties.lastOperationName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account_resource_id: Optional[str] = None,
        azure_file_share_name: Optional[str] = None,
        storage_account_tenant_id: Optional[str] = None,
        partnership_id: Optional[str] = None,
        friendly_name: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        last_workflow_id: Optional[str] = None,
        last_operation_name: Optional[str] = None,
        **kwargs
    ):
        super(CloudEndpoint, self).__init__(**kwargs)
        self.storage_account_resource_id = storage_account_resource_id
        self.azure_file_share_name = azure_file_share_name
        self.storage_account_tenant_id = storage_account_tenant_id
        self.partnership_id = partnership_id
        self.friendly_name = friendly_name
        self.backup_enabled = None
        self.provisioning_state = provisioning_state
        self.last_workflow_id = last_workflow_id
        self.last_operation_name = last_operation_name


class CloudEndpointArray(msrest.serialization.Model):
    """Array of CloudEndpoint.

    :param value: Collection of CloudEndpoint.
    :type value: list[~azure.mgmt.storagesync.models.CloudEndpoint]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CloudEndpoint]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CloudEndpoint"]] = None,
        **kwargs
    ):
        super(CloudEndpointArray, self).__init__(**kwargs)
        self.value = value


class CloudEndpointCreateParameters(ProxyResource):
    """The parameters used when creating a cloud endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param storage_account_resource_id: Storage Account Resource Id.
    :type storage_account_resource_id: str
    :param azure_file_share_name: Azure file share name.
    :type azure_file_share_name: str
    :param storage_account_tenant_id: Storage Account Tenant Id.
    :type storage_account_tenant_id: str
    :param friendly_name: Friendly Name.
    :type friendly_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'azure_file_share_name': {'key': 'properties.azureFileShareName', 'type': 'str'},
        'storage_account_tenant_id': {'key': 'properties.storageAccountTenantId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account_resource_id: Optional[str] = None,
        azure_file_share_name: Optional[str] = None,
        storage_account_tenant_id: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs
    ):
        super(CloudEndpointCreateParameters, self).__init__(**kwargs)
        self.storage_account_resource_id = storage_account_resource_id
        self.azure_file_share_name = azure_file_share_name
        self.storage_account_tenant_id = storage_account_tenant_id
        self.friendly_name = friendly_name


class CloudTieringCachePerformance(msrest.serialization.Model):
    """Server endpoint cloud tiering status object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_updated_timestamp: Last updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar cache_hit_bytes: Count of bytes that were served from the local server.
    :vartype cache_hit_bytes: long
    :ivar cache_miss_bytes: Count of bytes that were served from the cloud.
    :vartype cache_miss_bytes: long
    :ivar cache_hit_bytes_percent: Percentage of total bytes (hit + miss) that were served from the
     local server.
    :vartype cache_hit_bytes_percent: int
    """

    _validation = {
        'last_updated_timestamp': {'readonly': True},
        'cache_hit_bytes': {'readonly': True, 'minimum': 0},
        'cache_miss_bytes': {'readonly': True, 'minimum': 0},
        'cache_hit_bytes_percent': {'readonly': True, 'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'cache_hit_bytes': {'key': 'cacheHitBytes', 'type': 'long'},
        'cache_miss_bytes': {'key': 'cacheMissBytes', 'type': 'long'},
        'cache_hit_bytes_percent': {'key': 'cacheHitBytesPercent', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudTieringCachePerformance, self).__init__(**kwargs)
        self.last_updated_timestamp = None
        self.cache_hit_bytes = None
        self.cache_miss_bytes = None
        self.cache_hit_bytes_percent = None


class CloudTieringDatePolicyStatus(msrest.serialization.Model):
    """Status of the date policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_updated_timestamp: Last updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar tiered_files_most_recent_access_timestamp: Most recent access time of tiered files.
    :vartype tiered_files_most_recent_access_timestamp: ~datetime.datetime
    """

    _validation = {
        'last_updated_timestamp': {'readonly': True},
        'tiered_files_most_recent_access_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'tiered_files_most_recent_access_timestamp': {'key': 'tieredFilesMostRecentAccessTimestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudTieringDatePolicyStatus, self).__init__(**kwargs)
        self.last_updated_timestamp = None
        self.tiered_files_most_recent_access_timestamp = None


class CloudTieringFilesNotTiering(msrest.serialization.Model):
    """Server endpoint cloud tiering status object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_updated_timestamp: Last updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar total_file_count: Last cloud tiering result (HResult).
    :vartype total_file_count: long
    :ivar errors: Array of tiering errors.
    :vartype errors: list[~azure.mgmt.storagesync.models.FilesNotTieringError]
    """

    _validation = {
        'last_updated_timestamp': {'readonly': True},
        'total_file_count': {'readonly': True, 'minimum': 0},
        'errors': {'readonly': True},
    }

    _attribute_map = {
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'total_file_count': {'key': 'totalFileCount', 'type': 'long'},
        'errors': {'key': 'errors', 'type': '[FilesNotTieringError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudTieringFilesNotTiering, self).__init__(**kwargs)
        self.last_updated_timestamp = None
        self.total_file_count = None
        self.errors = None


class CloudTieringSpaceSavings(msrest.serialization.Model):
    """Server endpoint cloud tiering status object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_updated_timestamp: Last updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar volume_size_bytes: Volume size.
    :vartype volume_size_bytes: long
    :ivar total_size_cloud_bytes: Total size of content in the azure file share.
    :vartype total_size_cloud_bytes: long
    :ivar cached_size_bytes: Cached content size on the server.
    :vartype cached_size_bytes: long
    :ivar space_savings_percent: Percentage of cached size over total size.
    :vartype space_savings_percent: int
    :ivar space_savings_bytes: Count of bytes saved on the server.
    :vartype space_savings_bytes: long
    """

    _validation = {
        'last_updated_timestamp': {'readonly': True},
        'volume_size_bytes': {'readonly': True, 'minimum': 0},
        'total_size_cloud_bytes': {'readonly': True, 'minimum': 0},
        'cached_size_bytes': {'readonly': True, 'minimum': 0},
        'space_savings_percent': {'readonly': True, 'maximum': 100, 'minimum': 0},
        'space_savings_bytes': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'volume_size_bytes': {'key': 'volumeSizeBytes', 'type': 'long'},
        'total_size_cloud_bytes': {'key': 'totalSizeCloudBytes', 'type': 'long'},
        'cached_size_bytes': {'key': 'cachedSizeBytes', 'type': 'long'},
        'space_savings_percent': {'key': 'spaceSavingsPercent', 'type': 'int'},
        'space_savings_bytes': {'key': 'spaceSavingsBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudTieringSpaceSavings, self).__init__(**kwargs)
        self.last_updated_timestamp = None
        self.volume_size_bytes = None
        self.total_size_cloud_bytes = None
        self.cached_size_bytes = None
        self.space_savings_percent = None
        self.space_savings_bytes = None


class CloudTieringVolumeFreeSpacePolicyStatus(msrest.serialization.Model):
    """Status of the volume free space policy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_updated_timestamp: Last updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar effective_volume_free_space_policy: In the case where multiple server endpoints are
     present in a volume, an effective free space policy is applied.
    :vartype effective_volume_free_space_policy: int
    :ivar current_volume_free_space_percent: Current volume free space percentage.
    :vartype current_volume_free_space_percent: int
    """

    _validation = {
        'last_updated_timestamp': {'readonly': True},
        'effective_volume_free_space_policy': {'readonly': True, 'maximum': 100, 'minimum': 0},
        'current_volume_free_space_percent': {'readonly': True, 'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'effective_volume_free_space_policy': {'key': 'effectiveVolumeFreeSpacePolicy', 'type': 'int'},
        'current_volume_free_space_percent': {'key': 'currentVolumeFreeSpacePercent', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudTieringVolumeFreeSpacePolicyStatus, self).__init__(**kwargs)
        self.last_updated_timestamp = None
        self.effective_volume_free_space_policy = None
        self.current_volume_free_space_percent = None


class FilesNotTieringError(msrest.serialization.Model):
    """Files not tiering error object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Error code (HResult).
    :vartype error_code: int
    :ivar file_count: Count of files with this error.
    :vartype file_count: long
    """

    _validation = {
        'error_code': {'readonly': True},
        'file_count': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'file_count': {'key': 'fileCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(FilesNotTieringError, self).__init__(**kwargs)
        self.error_code = None
        self.file_count = None


class OperationDisplayInfo(msrest.serialization.Model):
    """The operation supported by storage sync.

    :param description: The description of the operation.
    :type description: str
    :param operation: The action that users can perform, based on their permission level.
    :type operation: str
    :param provider: Service provider: Microsoft StorageSync.
    :type provider: str
    :param resource: Resource on which the operation is performed.
    :type resource: str
    """

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        operation: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplayInfo, self).__init__(**kwargs)
        self.description = description
        self.operation = operation
        self.provider = provider
        self.resource = resource


class OperationDisplayResource(msrest.serialization.Model):
    """Operation Display Resource object.

    :param provider: Operation Display Resource Provider.
    :type provider: str
    :param resource: Operation Display Resource.
    :type resource: str
    :param operation: Operation Display Resource Operation.
    :type operation: str
    :param description: Operation Display Resource Description.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationDisplayResource, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationEntity(msrest.serialization.Model):
    """The operation supported by storage sync.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param display: The operation supported by storage sync.
    :type display: ~azure.mgmt.storagesync.models.OperationDisplayInfo
    :param origin: The origin.
    :type origin: str
    :param properties: Properties of the operations resource.
    :type properties: ~azure.mgmt.storagesync.models.OperationProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplayInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OperationProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationDisplayInfo"] = None,
        origin: Optional[str] = None,
        properties: Optional["OperationProperties"] = None,
        **kwargs
    ):
        super(OperationEntity, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationEntityListResult(msrest.serialization.Model):
    """The list of storage sync operations.

    :param next_link: The link used to get the next page of operations.
    :type next_link: str
    :param value: The list of operations.
    :type value: list[~azure.mgmt.storagesync.models.OperationEntity]
    """

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[OperationEntity]'},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["OperationEntity"]] = None,
        **kwargs
    ):
        super(OperationEntityListResult, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class OperationProperties(msrest.serialization.Model):
    """Properties of the operations resource.

    :param service_specification: Service specification for the operations resource.
    :type service_specification:
     ~azure.mgmt.storagesync.models.OperationResourceServiceSpecification
    """

    _attribute_map = {
        'service_specification': {'key': 'serviceSpecification', 'type': 'OperationResourceServiceSpecification'},
    }

    def __init__(
        self,
        *,
        service_specification: Optional["OperationResourceServiceSpecification"] = None,
        **kwargs
    ):
        super(OperationProperties, self).__init__(**kwargs)
        self.service_specification = service_specification


class OperationResourceMetricSpecification(msrest.serialization.Model):
    """Operation Display Resource object.

    :param name: Name of the metric.
    :type name: str
    :param display_name: Display name for the metric.
    :type display_name: str
    :param display_description: Display description for the metric.
    :type display_description: str
    :param unit: Unit for the metric.
    :type unit: str
    :param aggregation_type: Aggregation type for the metric.
    :type aggregation_type: str
    :param fill_gap_with_zero: Fill gaps in the metric with zero.
    :type fill_gap_with_zero: bool
    :param dimensions: Dimensions for the metric specification.
    :type dimensions:
     list[~azure.mgmt.storagesync.models.OperationResourceMetricSpecificationDimension]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'dimensions': {'key': 'dimensions', 'type': '[OperationResourceMetricSpecificationDimension]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        fill_gap_with_zero: Optional[bool] = None,
        dimensions: Optional[List["OperationResourceMetricSpecificationDimension"]] = None,
        **kwargs
    ):
        super(OperationResourceMetricSpecification, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.fill_gap_with_zero = fill_gap_with_zero
        self.dimensions = dimensions


class OperationResourceMetricSpecificationDimension(msrest.serialization.Model):
    """OperationResourceMetricSpecificationDimension object.

    :param name: Name of the dimension.
    :type name: str
    :param display_name: Display name of the dimensions.
    :type display_name: str
    :param to_be_exported_for_shoebox: Indicates metric should be exported for Shoebox.
    :type to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs
    ):
        super(OperationResourceMetricSpecificationDimension, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class OperationResourceServiceSpecification(msrest.serialization.Model):
    """Service specification.

    :param metric_specifications: List of metric specifications.
    :type metric_specifications:
     list[~azure.mgmt.storagesync.models.OperationResourceMetricSpecification]
    """

    _attribute_map = {
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[OperationResourceMetricSpecification]'},
    }

    def __init__(
        self,
        *,
        metric_specifications: Optional[List["OperationResourceMetricSpecification"]] = None,
        **kwargs
    ):
        super(OperationResourceServiceSpecification, self).__init__(**kwargs)
        self.metric_specifications = metric_specifications


class OperationStatus(msrest.serialization.Model):
    """Operation status object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation Id.
    :vartype name: str
    :ivar status: Operation status.
    :vartype status: str
    :ivar start_time: Start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar error: Error details.
    :vartype error: ~azure.mgmt.storagesync.models.StorageSyncApiError
    """

    _validation = {
        'name': {'readonly': True},
        'status': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'error': {'key': 'error', 'type': 'StorageSyncApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationStatus, self).__init__(**kwargs)
        self.name = None
        self.status = None
        self.start_time = None
        self.end_time = None
        self.error = None


class PostBackupResponse(msrest.serialization.Model):
    """Post Backup Response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cloud_endpoint_name: cloud endpoint Name.
    :vartype cloud_endpoint_name: str
    """

    _validation = {
        'cloud_endpoint_name': {'readonly': True},
    }

    _attribute_map = {
        'cloud_endpoint_name': {'key': 'backupMetadata.cloudEndpointName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PostBackupResponse, self).__init__(**kwargs)
        self.cloud_endpoint_name = None


class PostRestoreRequest(msrest.serialization.Model):
    """Post Restore Request.

    :param partition: Post Restore partition.
    :type partition: str
    :param replica_group: Post Restore replica group.
    :type replica_group: str
    :param request_id: Post Restore request id.
    :type request_id: str
    :param azure_file_share_uri: Post Restore Azure file share uri.
    :type azure_file_share_uri: str
    :param status: Post Restore Azure status.
    :type status: str
    :param source_azure_file_share_uri: Post Restore Azure source azure file share uri.
    :type source_azure_file_share_uri: str
    :param failed_file_list: Post Restore Azure failed file list.
    :type failed_file_list: str
    :param restore_file_spec: Post Restore restore file spec array.
    :type restore_file_spec: list[~azure.mgmt.storagesync.models.RestoreFileSpec]
    """

    _attribute_map = {
        'partition': {'key': 'partition', 'type': 'str'},
        'replica_group': {'key': 'replicaGroup', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'azure_file_share_uri': {'key': 'azureFileShareUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'source_azure_file_share_uri': {'key': 'sourceAzureFileShareUri', 'type': 'str'},
        'failed_file_list': {'key': 'failedFileList', 'type': 'str'},
        'restore_file_spec': {'key': 'restoreFileSpec', 'type': '[RestoreFileSpec]'},
    }

    def __init__(
        self,
        *,
        partition: Optional[str] = None,
        replica_group: Optional[str] = None,
        request_id: Optional[str] = None,
        azure_file_share_uri: Optional[str] = None,
        status: Optional[str] = None,
        source_azure_file_share_uri: Optional[str] = None,
        failed_file_list: Optional[str] = None,
        restore_file_spec: Optional[List["RestoreFileSpec"]] = None,
        **kwargs
    ):
        super(PostRestoreRequest, self).__init__(**kwargs)
        self.partition = partition
        self.replica_group = replica_group
        self.request_id = request_id
        self.azure_file_share_uri = azure_file_share_uri
        self.status = status
        self.source_azure_file_share_uri = source_azure_file_share_uri
        self.failed_file_list = failed_file_list
        self.restore_file_spec = restore_file_spec


class PreRestoreRequest(msrest.serialization.Model):
    """Pre Restore request object.

    :param partition: Pre Restore partition.
    :type partition: str
    :param replica_group: Pre Restore replica group.
    :type replica_group: str
    :param request_id: Pre Restore request id.
    :type request_id: str
    :param azure_file_share_uri: Pre Restore Azure file share uri.
    :type azure_file_share_uri: str
    :param status: Pre Restore Azure status.
    :type status: str
    :param source_azure_file_share_uri: Pre Restore Azure source azure file share uri.
    :type source_azure_file_share_uri: str
    :param backup_metadata_property_bag: Pre Restore backup metadata property bag.
    :type backup_metadata_property_bag: str
    :param restore_file_spec: Pre Restore restore file spec array.
    :type restore_file_spec: list[~azure.mgmt.storagesync.models.RestoreFileSpec]
    :param pause_wait_for_sync_drain_time_period_in_seconds: Pre Restore pause wait for sync drain
     time period in seconds.
    :type pause_wait_for_sync_drain_time_period_in_seconds: int
    """

    _attribute_map = {
        'partition': {'key': 'partition', 'type': 'str'},
        'replica_group': {'key': 'replicaGroup', 'type': 'str'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'azure_file_share_uri': {'key': 'azureFileShareUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'source_azure_file_share_uri': {'key': 'sourceAzureFileShareUri', 'type': 'str'},
        'backup_metadata_property_bag': {'key': 'backupMetadataPropertyBag', 'type': 'str'},
        'restore_file_spec': {'key': 'restoreFileSpec', 'type': '[RestoreFileSpec]'},
        'pause_wait_for_sync_drain_time_period_in_seconds': {'key': 'pauseWaitForSyncDrainTimePeriodInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        partition: Optional[str] = None,
        replica_group: Optional[str] = None,
        request_id: Optional[str] = None,
        azure_file_share_uri: Optional[str] = None,
        status: Optional[str] = None,
        source_azure_file_share_uri: Optional[str] = None,
        backup_metadata_property_bag: Optional[str] = None,
        restore_file_spec: Optional[List["RestoreFileSpec"]] = None,
        pause_wait_for_sync_drain_time_period_in_seconds: Optional[int] = None,
        **kwargs
    ):
        super(PreRestoreRequest, self).__init__(**kwargs)
        self.partition = partition
        self.replica_group = replica_group
        self.request_id = request_id
        self.azure_file_share_uri = azure_file_share_uri
        self.status = status
        self.source_azure_file_share_uri = source_azure_file_share_uri
        self.backup_metadata_property_bag = backup_metadata_property_bag
        self.restore_file_spec = restore_file_spec
        self.pause_wait_for_sync_drain_time_period_in_seconds = pause_wait_for_sync_drain_time_period_in_seconds


class PrivateEndpoint(msrest.serialization.Model):
    """The Private Endpoint resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ARM identifier for Private Endpoint.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = None


class PrivateEndpointConnection(Resource):
    """The Private Endpoint Connection resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param private_endpoint: The resource of private end point.
    :type private_endpoint: ~azure.mgmt.storagesync.models.PrivateEndpoint
    :param private_link_service_connection_state: A collection of information about the state of
     the connection between service consumer and provider.
    :type private_link_service_connection_state:
     ~azure.mgmt.storagesync.models.PrivateLinkServiceConnectionState
    :ivar provisioning_state: The provisioning state of the private endpoint connection resource.
     Possible values include: "Succeeded", "Creating", "Deleting", "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.storagesync.models.PrivateEndpointConnectionProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'PrivateLinkServiceConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["PrivateLinkServiceConnectionState"] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = None


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """List of private endpoint connection associated with the specified storage account.

    :param value: Array of private endpoint connections.
    :type value: list[~azure.mgmt.storagesync.models.PrivateEndpointConnection]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkResource(Resource):
    """A private link resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS zone name.
    :type required_zone_names: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'group_id': {'readonly': True},
        'required_members': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = None
        self.required_members = None
        self.required_zone_names = required_zone_names


class PrivateLinkResourceListResult(msrest.serialization.Model):
    """A list of private link resources.

    :param value: Array of private link resources.
    :type value: list[~azure.mgmt.storagesync.models.PrivateLinkResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        **kwargs
    ):
        super(PrivateLinkResourceListResult, self).__init__(**kwargs)
        self.value = value


class PrivateLinkServiceConnectionState(msrest.serialization.Model):
    """A collection of information about the state of the connection between service consumer and provider.

    :param status: Indicates whether the connection has been Approved/Rejected/Removed by the owner
     of the service. Possible values include: "Pending", "Approved", "Rejected".
    :type status: str or ~azure.mgmt.storagesync.models.PrivateEndpointServiceConnectionStatus
    :param description: The reason for approval/rejection of the connection.
    :type description: str
    :param actions_required: A message indicating if changes on the service provider require any
     updates on the consumer.
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PrivateEndpointServiceConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkServiceConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class RecallActionParameters(msrest.serialization.Model):
    """The parameters used when calling recall action on server endpoint.

    :param pattern: Pattern of the files.
    :type pattern: str
    :param recall_path: Recall path.
    :type recall_path: str
    """

    _attribute_map = {
        'pattern': {'key': 'pattern', 'type': 'str'},
        'recall_path': {'key': 'recallPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        pattern: Optional[str] = None,
        recall_path: Optional[str] = None,
        **kwargs
    ):
        super(RecallActionParameters, self).__init__(**kwargs)
        self.pattern = pattern
        self.recall_path = recall_path


class RegisteredServer(ProxyResource):
    """Registered Server resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param server_certificate: Registered Server Certificate.
    :type server_certificate: str
    :param agent_version: Registered Server Agent Version.
    :type agent_version: str
    :ivar agent_version_status: Registered Server Agent Version Status. Possible values include:
     "Ok", "NearExpiry", "Expired", "Blocked".
    :vartype agent_version_status: str or
     ~azure.mgmt.storagesync.models.RegisteredServerAgentVersionStatus
    :ivar agent_version_expiration_date: Registered Server Agent Version Expiration Date.
    :vartype agent_version_expiration_date: ~datetime.datetime
    :param server_os_version: Registered Server OS Version.
    :type server_os_version: str
    :ivar server_management_error_code: Registered Server Management Error Code.
    :vartype server_management_error_code: int
    :ivar last_heart_beat: Registered Server last heart beat.
    :vartype last_heart_beat: ~datetime.datetime
    :ivar provisioning_state: Registered Server Provisioning State.
    :vartype provisioning_state: str
    :param server_role: Registered Server serverRole.
    :type server_role: str
    :param cluster_id: Registered Server clusterId.
    :type cluster_id: str
    :param cluster_name: Registered Server clusterName.
    :type cluster_name: str
    :param server_id: Registered Server serverId.
    :type server_id: str
    :ivar storage_sync_service_uid: Registered Server storageSyncServiceUid.
    :vartype storage_sync_service_uid: str
    :ivar last_workflow_id: Registered Server lastWorkflowId.
    :vartype last_workflow_id: str
    :ivar last_operation_name: Resource Last Operation Name.
    :vartype last_operation_name: str
    :ivar discovery_endpoint_uri: Resource discoveryEndpointUri.
    :vartype discovery_endpoint_uri: str
    :ivar resource_location: Resource Location.
    :vartype resource_location: str
    :ivar service_location: Service Location.
    :vartype service_location: str
    :param friendly_name: Friendly Name.
    :type friendly_name: str
    :ivar management_endpoint_uri: Management Endpoint Uri.
    :vartype management_endpoint_uri: str
    :ivar monitoring_endpoint_uri: Telemetry Endpoint Uri.
    :vartype monitoring_endpoint_uri: str
    :ivar monitoring_configuration: Monitoring Configuration.
    :vartype monitoring_configuration: str
    :ivar server_name: Server name.
    :vartype server_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'agent_version_status': {'readonly': True},
        'agent_version_expiration_date': {'readonly': True},
        'server_management_error_code': {'readonly': True},
        'last_heart_beat': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'storage_sync_service_uid': {'readonly': True},
        'last_workflow_id': {'readonly': True},
        'last_operation_name': {'readonly': True},
        'discovery_endpoint_uri': {'readonly': True},
        'resource_location': {'readonly': True},
        'service_location': {'readonly': True},
        'management_endpoint_uri': {'readonly': True},
        'monitoring_endpoint_uri': {'readonly': True},
        'monitoring_configuration': {'readonly': True},
        'server_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_certificate': {'key': 'properties.serverCertificate', 'type': 'str'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'agent_version_status': {'key': 'properties.agentVersionStatus', 'type': 'str'},
        'agent_version_expiration_date': {'key': 'properties.agentVersionExpirationDate', 'type': 'iso-8601'},
        'server_os_version': {'key': 'properties.serverOSVersion', 'type': 'str'},
        'server_management_error_code': {'key': 'properties.serverManagementErrorCode', 'type': 'int'},
        'last_heart_beat': {'key': 'properties.lastHeartBeat', 'type': 'iso-8601'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'cluster_name': {'key': 'properties.clusterName', 'type': 'str'},
        'server_id': {'key': 'properties.serverId', 'type': 'str'},
        'storage_sync_service_uid': {'key': 'properties.storageSyncServiceUid', 'type': 'str'},
        'last_workflow_id': {'key': 'properties.lastWorkflowId', 'type': 'str'},
        'last_operation_name': {'key': 'properties.lastOperationName', 'type': 'str'},
        'discovery_endpoint_uri': {'key': 'properties.discoveryEndpointUri', 'type': 'str'},
        'resource_location': {'key': 'properties.resourceLocation', 'type': 'str'},
        'service_location': {'key': 'properties.serviceLocation', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'management_endpoint_uri': {'key': 'properties.managementEndpointUri', 'type': 'str'},
        'monitoring_endpoint_uri': {'key': 'properties.monitoringEndpointUri', 'type': 'str'},
        'monitoring_configuration': {'key': 'properties.monitoringConfiguration', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_certificate: Optional[str] = None,
        agent_version: Optional[str] = None,
        server_os_version: Optional[str] = None,
        server_role: Optional[str] = None,
        cluster_id: Optional[str] = None,
        cluster_name: Optional[str] = None,
        server_id: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs
    ):
        super(RegisteredServer, self).__init__(**kwargs)
        self.server_certificate = server_certificate
        self.agent_version = agent_version
        self.agent_version_status = None
        self.agent_version_expiration_date = None
        self.server_os_version = server_os_version
        self.server_management_error_code = None
        self.last_heart_beat = None
        self.provisioning_state = None
        self.server_role = server_role
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.server_id = server_id
        self.storage_sync_service_uid = None
        self.last_workflow_id = None
        self.last_operation_name = None
        self.discovery_endpoint_uri = None
        self.resource_location = None
        self.service_location = None
        self.friendly_name = friendly_name
        self.management_endpoint_uri = None
        self.monitoring_endpoint_uri = None
        self.monitoring_configuration = None
        self.server_name = None


class RegisteredServerArray(msrest.serialization.Model):
    """Array of RegisteredServer.

    :param value: Collection of Registered Server.
    :type value: list[~azure.mgmt.storagesync.models.RegisteredServer]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RegisteredServer]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["RegisteredServer"]] = None,
        **kwargs
    ):
        super(RegisteredServerArray, self).__init__(**kwargs)
        self.value = value


class RegisteredServerCreateParameters(ProxyResource):
    """The parameters used when creating a registered server.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param server_certificate: Registered Server Certificate.
    :type server_certificate: str
    :param agent_version: Registered Server Agent Version.
    :type agent_version: str
    :param server_os_version: Registered Server OS Version.
    :type server_os_version: str
    :param last_heart_beat: Registered Server last heart beat.
    :type last_heart_beat: str
    :param server_role: Registered Server serverRole.
    :type server_role: str
    :param cluster_id: Registered Server clusterId.
    :type cluster_id: str
    :param cluster_name: Registered Server clusterName.
    :type cluster_name: str
    :param server_id: Registered Server serverId.
    :type server_id: str
    :param friendly_name: Friendly Name.
    :type friendly_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_certificate': {'key': 'properties.serverCertificate', 'type': 'str'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'server_os_version': {'key': 'properties.serverOSVersion', 'type': 'str'},
        'last_heart_beat': {'key': 'properties.lastHeartBeat', 'type': 'str'},
        'server_role': {'key': 'properties.serverRole', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'cluster_name': {'key': 'properties.clusterName', 'type': 'str'},
        'server_id': {'key': 'properties.serverId', 'type': 'str'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_certificate: Optional[str] = None,
        agent_version: Optional[str] = None,
        server_os_version: Optional[str] = None,
        last_heart_beat: Optional[str] = None,
        server_role: Optional[str] = None,
        cluster_id: Optional[str] = None,
        cluster_name: Optional[str] = None,
        server_id: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs
    ):
        super(RegisteredServerCreateParameters, self).__init__(**kwargs)
        self.server_certificate = server_certificate
        self.agent_version = agent_version
        self.server_os_version = server_os_version
        self.last_heart_beat = last_heart_beat
        self.server_role = server_role
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.server_id = server_id
        self.friendly_name = friendly_name


class ResourcesMoveInfo(msrest.serialization.Model):
    """Resource Move Info.

    :param target_resource_group: Target resource group.
    :type target_resource_group: str
    :param resources: Collection of Resources.
    :type resources: list[str]
    """

    _attribute_map = {
        'target_resource_group': {'key': 'targetResourceGroup', 'type': 'str'},
        'resources': {'key': 'resources', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        target_resource_group: Optional[str] = None,
        resources: Optional[List[str]] = None,
        **kwargs
    ):
        super(ResourcesMoveInfo, self).__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class RestoreFileSpec(msrest.serialization.Model):
    """Restore file spec.

    :param path: Restore file spec path.
    :type path: str
    :param isdir: Restore file spec isdir.
    :type isdir: bool
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'isdir': {'key': 'isdir', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        isdir: Optional[bool] = None,
        **kwargs
    ):
        super(RestoreFileSpec, self).__init__(**kwargs)
        self.path = path
        self.isdir = isdir


class ServerEndpoint(ProxyResource):
    """Server Endpoint object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param server_local_path: Server Local path.
    :type server_local_path: str
    :param cloud_tiering: Cloud Tiering. Possible values include: "on", "off".
    :type cloud_tiering: str or ~azure.mgmt.storagesync.models.FeatureStatus
    :param volume_free_space_percent: Level of free space to be maintained by Cloud Tiering if it
     is enabled.
    :type volume_free_space_percent: int
    :param tier_files_older_than_days: Tier files older than days.
    :type tier_files_older_than_days: int
    :param friendly_name: Friendly Name.
    :type friendly_name: str
    :param server_resource_id: Server Resource Id.
    :type server_resource_id: str
    :ivar provisioning_state: ServerEndpoint Provisioning State.
    :vartype provisioning_state: str
    :ivar last_workflow_id: ServerEndpoint lastWorkflowId.
    :vartype last_workflow_id: str
    :ivar last_operation_name: Resource Last Operation Name.
    :vartype last_operation_name: str
    :ivar sync_status: Server Endpoint sync status.
    :vartype sync_status: ~azure.mgmt.storagesync.models.ServerEndpointSyncStatus
    :param offline_data_transfer: Offline data transfer. Possible values include: "on", "off".
    :type offline_data_transfer: str or ~azure.mgmt.storagesync.models.FeatureStatus
    :ivar offline_data_transfer_storage_account_resource_id: Offline data transfer storage account
     resource ID.
    :vartype offline_data_transfer_storage_account_resource_id: str
    :ivar offline_data_transfer_storage_account_tenant_id: Offline data transfer storage account
     tenant ID.
    :vartype offline_data_transfer_storage_account_tenant_id: str
    :param offline_data_transfer_share_name: Offline data transfer share name.
    :type offline_data_transfer_share_name: str
    :ivar cloud_tiering_status: Cloud tiering status. Only populated if cloud tiering is enabled.
    :vartype cloud_tiering_status: ~azure.mgmt.storagesync.models.ServerEndpointCloudTieringStatus
    :ivar recall_status: Recall status. Only populated if cloud tiering is enabled.
    :vartype recall_status: ~azure.mgmt.storagesync.models.ServerEndpointRecallStatus
    :param initial_download_policy: Policy for how namespace and files are recalled during FastDr.
     Possible values include: "NamespaceOnly", "NamespaceThenModifiedFiles", "AvoidTieredFiles".
    :type initial_download_policy: str or ~azure.mgmt.storagesync.models.InitialDownloadPolicy
    :param local_cache_mode: Policy for enabling follow-the-sun business models: link local cache
     to cloud behavior to pre-populate before local access. Possible values include:
     "DownloadNewAndModifiedFiles", "UpdateLocallyCachedFiles".
    :type local_cache_mode: str or ~azure.mgmt.storagesync.models.LocalCacheMode
    :ivar server_name: Server name.
    :vartype server_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'volume_free_space_percent': {'maximum': 100, 'minimum': 0},
        'tier_files_older_than_days': {'maximum': 2147483647, 'minimum': 0},
        'provisioning_state': {'readonly': True},
        'last_workflow_id': {'readonly': True},
        'last_operation_name': {'readonly': True},
        'sync_status': {'readonly': True},
        'offline_data_transfer_storage_account_resource_id': {'readonly': True},
        'offline_data_transfer_storage_account_tenant_id': {'readonly': True},
        'cloud_tiering_status': {'readonly': True},
        'recall_status': {'readonly': True},
        'server_name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_local_path': {'key': 'properties.serverLocalPath', 'type': 'str'},
        'cloud_tiering': {'key': 'properties.cloudTiering', 'type': 'str'},
        'volume_free_space_percent': {'key': 'properties.volumeFreeSpacePercent', 'type': 'int'},
        'tier_files_older_than_days': {'key': 'properties.tierFilesOlderThanDays', 'type': 'int'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'server_resource_id': {'key': 'properties.serverResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'last_workflow_id': {'key': 'properties.lastWorkflowId', 'type': 'str'},
        'last_operation_name': {'key': 'properties.lastOperationName', 'type': 'str'},
        'sync_status': {'key': 'properties.syncStatus', 'type': 'ServerEndpointSyncStatus'},
        'offline_data_transfer': {'key': 'properties.offlineDataTransfer', 'type': 'str'},
        'offline_data_transfer_storage_account_resource_id': {'key': 'properties.offlineDataTransferStorageAccountResourceId', 'type': 'str'},
        'offline_data_transfer_storage_account_tenant_id': {'key': 'properties.offlineDataTransferStorageAccountTenantId', 'type': 'str'},
        'offline_data_transfer_share_name': {'key': 'properties.offlineDataTransferShareName', 'type': 'str'},
        'cloud_tiering_status': {'key': 'properties.cloudTieringStatus', 'type': 'ServerEndpointCloudTieringStatus'},
        'recall_status': {'key': 'properties.recallStatus', 'type': 'ServerEndpointRecallStatus'},
        'initial_download_policy': {'key': 'properties.initialDownloadPolicy', 'type': 'str'},
        'local_cache_mode': {'key': 'properties.localCacheMode', 'type': 'str'},
        'server_name': {'key': 'properties.serverName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_local_path: Optional[str] = None,
        cloud_tiering: Optional[Union[str, "FeatureStatus"]] = None,
        volume_free_space_percent: Optional[int] = None,
        tier_files_older_than_days: Optional[int] = None,
        friendly_name: Optional[str] = None,
        server_resource_id: Optional[str] = None,
        offline_data_transfer: Optional[Union[str, "FeatureStatus"]] = None,
        offline_data_transfer_share_name: Optional[str] = None,
        initial_download_policy: Optional[Union[str, "InitialDownloadPolicy"]] = None,
        local_cache_mode: Optional[Union[str, "LocalCacheMode"]] = None,
        **kwargs
    ):
        super(ServerEndpoint, self).__init__(**kwargs)
        self.server_local_path = server_local_path
        self.cloud_tiering = cloud_tiering
        self.volume_free_space_percent = volume_free_space_percent
        self.tier_files_older_than_days = tier_files_older_than_days
        self.friendly_name = friendly_name
        self.server_resource_id = server_resource_id
        self.provisioning_state = None
        self.last_workflow_id = None
        self.last_operation_name = None
        self.sync_status = None
        self.offline_data_transfer = offline_data_transfer
        self.offline_data_transfer_storage_account_resource_id = None
        self.offline_data_transfer_storage_account_tenant_id = None
        self.offline_data_transfer_share_name = offline_data_transfer_share_name
        self.cloud_tiering_status = None
        self.recall_status = None
        self.initial_download_policy = initial_download_policy
        self.local_cache_mode = local_cache_mode
        self.server_name = None


class ServerEndpointArray(msrest.serialization.Model):
    """Array of ServerEndpoint.

    :param value: Collection of ServerEndpoint.
    :type value: list[~azure.mgmt.storagesync.models.ServerEndpoint]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServerEndpoint]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ServerEndpoint"]] = None,
        **kwargs
    ):
        super(ServerEndpointArray, self).__init__(**kwargs)
        self.value = value


class ServerEndpointBackgroundDataDownloadActivity(msrest.serialization.Model):
    """Background data download activity object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Timestamp when properties were updated.
    :vartype timestamp: ~datetime.datetime
    :ivar percent_progress: Progress percentage.
    :vartype percent_progress: int
    :ivar downloaded_bytes: Running count of bytes downloaded.
    :vartype downloaded_bytes: long
    """

    _validation = {
        'timestamp': {'readonly': True},
        'percent_progress': {'readonly': True, 'maximum': 100, 'minimum': 0},
        'downloaded_bytes': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'percent_progress': {'key': 'percentProgress', 'type': 'int'},
        'downloaded_bytes': {'key': 'downloadedBytes', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEndpointBackgroundDataDownloadActivity, self).__init__(**kwargs)
        self.timestamp = None
        self.percent_progress = None
        self.downloaded_bytes = None


class ServerEndpointCloudTieringStatus(msrest.serialization.Model):
    """Server endpoint cloud tiering status object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_updated_timestamp: Last updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar health: Cloud tiering health state. Possible values include: "Unavailable", "Healthy",
     "Error".
    :vartype health: str or ~azure.mgmt.storagesync.models.ServerEndpointHealthState
    :ivar health_last_updated_timestamp: The last updated timestamp of health state.
    :vartype health_last_updated_timestamp: ~datetime.datetime
    :ivar last_cloud_tiering_result: Last cloud tiering result (HResult).
    :vartype last_cloud_tiering_result: int
    :ivar last_success_timestamp: Last cloud tiering success timestamp.
    :vartype last_success_timestamp: ~datetime.datetime
    :ivar space_savings: Information regarding how much local space cloud tiering is saving.
    :vartype space_savings: ~azure.mgmt.storagesync.models.CloudTieringSpaceSavings
    :ivar cache_performance: Information regarding how well the local cache on the server is
     performing.
    :vartype cache_performance: ~azure.mgmt.storagesync.models.CloudTieringCachePerformance
    :ivar files_not_tiering: Information regarding files that failed to be tiered.
    :vartype files_not_tiering: ~azure.mgmt.storagesync.models.CloudTieringFilesNotTiering
    :ivar volume_free_space_policy_status: Status of the volume free space policy.
    :vartype volume_free_space_policy_status:
     ~azure.mgmt.storagesync.models.CloudTieringVolumeFreeSpacePolicyStatus
    :ivar date_policy_status: Status of the date policy.
    :vartype date_policy_status: ~azure.mgmt.storagesync.models.CloudTieringDatePolicyStatus
    """

    _validation = {
        'last_updated_timestamp': {'readonly': True},
        'health': {'readonly': True},
        'health_last_updated_timestamp': {'readonly': True},
        'last_cloud_tiering_result': {'readonly': True},
        'last_success_timestamp': {'readonly': True},
        'space_savings': {'readonly': True},
        'cache_performance': {'readonly': True},
        'files_not_tiering': {'readonly': True},
        'volume_free_space_policy_status': {'readonly': True},
        'date_policy_status': {'readonly': True},
    }

    _attribute_map = {
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'health': {'key': 'health', 'type': 'str'},
        'health_last_updated_timestamp': {'key': 'healthLastUpdatedTimestamp', 'type': 'iso-8601'},
        'last_cloud_tiering_result': {'key': 'lastCloudTieringResult', 'type': 'int'},
        'last_success_timestamp': {'key': 'lastSuccessTimestamp', 'type': 'iso-8601'},
        'space_savings': {'key': 'spaceSavings', 'type': 'CloudTieringSpaceSavings'},
        'cache_performance': {'key': 'cachePerformance', 'type': 'CloudTieringCachePerformance'},
        'files_not_tiering': {'key': 'filesNotTiering', 'type': 'CloudTieringFilesNotTiering'},
        'volume_free_space_policy_status': {'key': 'volumeFreeSpacePolicyStatus', 'type': 'CloudTieringVolumeFreeSpacePolicyStatus'},
        'date_policy_status': {'key': 'datePolicyStatus', 'type': 'CloudTieringDatePolicyStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEndpointCloudTieringStatus, self).__init__(**kwargs)
        self.last_updated_timestamp = None
        self.health = None
        self.health_last_updated_timestamp = None
        self.last_cloud_tiering_result = None
        self.last_success_timestamp = None
        self.space_savings = None
        self.cache_performance = None
        self.files_not_tiering = None
        self.volume_free_space_policy_status = None
        self.date_policy_status = None


class ServerEndpointCreateParameters(ProxyResource):
    """The parameters used when creating a server endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param server_local_path: Server Local path.
    :type server_local_path: str
    :param cloud_tiering: Cloud Tiering. Possible values include: "on", "off".
    :type cloud_tiering: str or ~azure.mgmt.storagesync.models.FeatureStatus
    :param volume_free_space_percent: Level of free space to be maintained by Cloud Tiering if it
     is enabled.
    :type volume_free_space_percent: int
    :param tier_files_older_than_days: Tier files older than days.
    :type tier_files_older_than_days: int
    :param friendly_name: Friendly Name.
    :type friendly_name: str
    :param server_resource_id: Server Resource Id.
    :type server_resource_id: str
    :param offline_data_transfer: Offline data transfer. Possible values include: "on", "off".
    :type offline_data_transfer: str or ~azure.mgmt.storagesync.models.FeatureStatus
    :param offline_data_transfer_share_name: Offline data transfer share name.
    :type offline_data_transfer_share_name: str
    :param initial_download_policy: Policy for how namespace and files are recalled during FastDr.
     Possible values include: "NamespaceOnly", "NamespaceThenModifiedFiles", "AvoidTieredFiles".
    :type initial_download_policy: str or ~azure.mgmt.storagesync.models.InitialDownloadPolicy
    :param local_cache_mode: Policy for enabling follow-the-sun business models: link local cache
     to cloud behavior to pre-populate before local access. Possible values include:
     "DownloadNewAndModifiedFiles", "UpdateLocallyCachedFiles".
    :type local_cache_mode: str or ~azure.mgmt.storagesync.models.LocalCacheMode
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'volume_free_space_percent': {'maximum': 100, 'minimum': 0},
        'tier_files_older_than_days': {'maximum': 2147483647, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'server_local_path': {'key': 'properties.serverLocalPath', 'type': 'str'},
        'cloud_tiering': {'key': 'properties.cloudTiering', 'type': 'str'},
        'volume_free_space_percent': {'key': 'properties.volumeFreeSpacePercent', 'type': 'int'},
        'tier_files_older_than_days': {'key': 'properties.tierFilesOlderThanDays', 'type': 'int'},
        'friendly_name': {'key': 'properties.friendlyName', 'type': 'str'},
        'server_resource_id': {'key': 'properties.serverResourceId', 'type': 'str'},
        'offline_data_transfer': {'key': 'properties.offlineDataTransfer', 'type': 'str'},
        'offline_data_transfer_share_name': {'key': 'properties.offlineDataTransferShareName', 'type': 'str'},
        'initial_download_policy': {'key': 'properties.initialDownloadPolicy', 'type': 'str'},
        'local_cache_mode': {'key': 'properties.localCacheMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_local_path: Optional[str] = None,
        cloud_tiering: Optional[Union[str, "FeatureStatus"]] = None,
        volume_free_space_percent: Optional[int] = None,
        tier_files_older_than_days: Optional[int] = None,
        friendly_name: Optional[str] = None,
        server_resource_id: Optional[str] = None,
        offline_data_transfer: Optional[Union[str, "FeatureStatus"]] = None,
        offline_data_transfer_share_name: Optional[str] = None,
        initial_download_policy: Optional[Union[str, "InitialDownloadPolicy"]] = None,
        local_cache_mode: Optional[Union[str, "LocalCacheMode"]] = None,
        **kwargs
    ):
        super(ServerEndpointCreateParameters, self).__init__(**kwargs)
        self.server_local_path = server_local_path
        self.cloud_tiering = cloud_tiering
        self.volume_free_space_percent = volume_free_space_percent
        self.tier_files_older_than_days = tier_files_older_than_days
        self.friendly_name = friendly_name
        self.server_resource_id = server_resource_id
        self.offline_data_transfer = offline_data_transfer
        self.offline_data_transfer_share_name = offline_data_transfer_share_name
        self.initial_download_policy = initial_download_policy
        self.local_cache_mode = local_cache_mode


class ServerEndpointFilesNotSyncingError(msrest.serialization.Model):
    """Files not syncing error object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Error code (HResult).
    :vartype error_code: int
    :ivar persistent_count: Count of persistent files not syncing with the specified error code.
    :vartype persistent_count: long
    :ivar transient_count: Count of transient files not syncing with the specified error code.
    :vartype transient_count: long
    """

    _validation = {
        'error_code': {'readonly': True},
        'persistent_count': {'readonly': True, 'minimum': 0},
        'transient_count': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'persistent_count': {'key': 'persistentCount', 'type': 'long'},
        'transient_count': {'key': 'transientCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEndpointFilesNotSyncingError, self).__init__(**kwargs)
        self.error_code = None
        self.persistent_count = None
        self.transient_count = None


class ServerEndpointRecallError(msrest.serialization.Model):
    """Server endpoint recall error object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Error code (HResult).
    :vartype error_code: int
    :ivar count: Count of occurences of the error.
    :vartype count: long
    """

    _validation = {
        'error_code': {'readonly': True},
        'count': {'readonly': True, 'minimum': 0},
    }

    _attribute_map = {
        'error_code': {'key': 'errorCode', 'type': 'int'},
        'count': {'key': 'count', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEndpointRecallError, self).__init__(**kwargs)
        self.error_code = None
        self.count = None


class ServerEndpointRecallStatus(msrest.serialization.Model):
    """Server endpoint recall status object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_updated_timestamp: Last updated timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar total_recall_errors_count: Total count of recall errors.
    :vartype total_recall_errors_count: long
    :ivar recall_errors: Array of recall errors.
    :vartype recall_errors: list[~azure.mgmt.storagesync.models.ServerEndpointRecallError]
    """

    _validation = {
        'last_updated_timestamp': {'readonly': True},
        'total_recall_errors_count': {'readonly': True, 'minimum': 0},
        'recall_errors': {'readonly': True},
    }

    _attribute_map = {
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'total_recall_errors_count': {'key': 'totalRecallErrorsCount', 'type': 'long'},
        'recall_errors': {'key': 'recallErrors', 'type': '[ServerEndpointRecallError]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEndpointRecallStatus, self).__init__(**kwargs)
        self.last_updated_timestamp = None
        self.total_recall_errors_count = None
        self.recall_errors = None


class ServerEndpointSyncActivityStatus(msrest.serialization.Model):
    """Sync Session status object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar timestamp: Timestamp when properties were updated.
    :vartype timestamp: ~datetime.datetime
    :ivar per_item_error_count: Per item error count.
    :vartype per_item_error_count: long
    :ivar applied_item_count: Applied item count.
    :vartype applied_item_count: long
    :ivar total_item_count: Total item count (if available).
    :vartype total_item_count: long
    :ivar applied_bytes: Applied bytes.
    :vartype applied_bytes: long
    :ivar total_bytes: Total bytes (if available).
    :vartype total_bytes: long
    :ivar sync_mode: Sync mode. Possible values include: "Regular", "NamespaceDownload",
     "InitialUpload", "SnapshotUpload", "InitialFullDownload".
    :vartype sync_mode: str or ~azure.mgmt.storagesync.models.ServerEndpointSyncMode
    """

    _validation = {
        'timestamp': {'readonly': True},
        'per_item_error_count': {'readonly': True, 'minimum': 0},
        'applied_item_count': {'readonly': True, 'minimum': 0},
        'total_item_count': {'readonly': True, 'minimum': 0},
        'applied_bytes': {'readonly': True, 'minimum': 0},
        'total_bytes': {'readonly': True, 'minimum': 0},
        'sync_mode': {'readonly': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'per_item_error_count': {'key': 'perItemErrorCount', 'type': 'long'},
        'applied_item_count': {'key': 'appliedItemCount', 'type': 'long'},
        'total_item_count': {'key': 'totalItemCount', 'type': 'long'},
        'applied_bytes': {'key': 'appliedBytes', 'type': 'long'},
        'total_bytes': {'key': 'totalBytes', 'type': 'long'},
        'sync_mode': {'key': 'syncMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEndpointSyncActivityStatus, self).__init__(**kwargs)
        self.timestamp = None
        self.per_item_error_count = None
        self.applied_item_count = None
        self.total_item_count = None
        self.applied_bytes = None
        self.total_bytes = None
        self.sync_mode = None


class ServerEndpointSyncSessionStatus(msrest.serialization.Model):
    """Sync Session status object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar last_sync_result: Last sync result (HResult).
    :vartype last_sync_result: int
    :ivar last_sync_timestamp: Last sync timestamp.
    :vartype last_sync_timestamp: ~datetime.datetime
    :ivar last_sync_success_timestamp: Last sync success timestamp.
    :vartype last_sync_success_timestamp: ~datetime.datetime
    :ivar last_sync_per_item_error_count: Last sync per item error count.
    :vartype last_sync_per_item_error_count: long
    :ivar persistent_files_not_syncing_count: Count of persistent files not syncing.
    :vartype persistent_files_not_syncing_count: long
    :ivar transient_files_not_syncing_count: Count of transient files not syncing.
    :vartype transient_files_not_syncing_count: long
    :ivar files_not_syncing_errors: Array of per-item errors coming from the last sync session.
    :vartype files_not_syncing_errors:
     list[~azure.mgmt.storagesync.models.ServerEndpointFilesNotSyncingError]
    :ivar last_sync_mode: Sync mode. Possible values include: "Regular", "NamespaceDownload",
     "InitialUpload", "SnapshotUpload", "InitialFullDownload".
    :vartype last_sync_mode: str or ~azure.mgmt.storagesync.models.ServerEndpointSyncMode
    """

    _validation = {
        'last_sync_result': {'readonly': True},
        'last_sync_timestamp': {'readonly': True},
        'last_sync_success_timestamp': {'readonly': True},
        'last_sync_per_item_error_count': {'readonly': True, 'minimum': 0},
        'persistent_files_not_syncing_count': {'readonly': True, 'minimum': 0},
        'transient_files_not_syncing_count': {'readonly': True, 'minimum': 0},
        'files_not_syncing_errors': {'readonly': True},
        'last_sync_mode': {'readonly': True},
    }

    _attribute_map = {
        'last_sync_result': {'key': 'lastSyncResult', 'type': 'int'},
        'last_sync_timestamp': {'key': 'lastSyncTimestamp', 'type': 'iso-8601'},
        'last_sync_success_timestamp': {'key': 'lastSyncSuccessTimestamp', 'type': 'iso-8601'},
        'last_sync_per_item_error_count': {'key': 'lastSyncPerItemErrorCount', 'type': 'long'},
        'persistent_files_not_syncing_count': {'key': 'persistentFilesNotSyncingCount', 'type': 'long'},
        'transient_files_not_syncing_count': {'key': 'transientFilesNotSyncingCount', 'type': 'long'},
        'files_not_syncing_errors': {'key': 'filesNotSyncingErrors', 'type': '[ServerEndpointFilesNotSyncingError]'},
        'last_sync_mode': {'key': 'lastSyncMode', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEndpointSyncSessionStatus, self).__init__(**kwargs)
        self.last_sync_result = None
        self.last_sync_timestamp = None
        self.last_sync_success_timestamp = None
        self.last_sync_per_item_error_count = None
        self.persistent_files_not_syncing_count = None
        self.transient_files_not_syncing_count = None
        self.files_not_syncing_errors = None
        self.last_sync_mode = None


class ServerEndpointSyncStatus(msrest.serialization.Model):
    """Server Endpoint sync status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar download_health: Download Health Status. Possible values include: "Unavailable",
     "Healthy", "Error".
    :vartype download_health: str or ~azure.mgmt.storagesync.models.ServerEndpointHealthState
    :ivar upload_health: Upload Health Status. Possible values include: "Unavailable", "Healthy",
     "Error".
    :vartype upload_health: str or ~azure.mgmt.storagesync.models.ServerEndpointHealthState
    :ivar combined_health: Combined Health Status. Possible values include: "Unavailable",
     "Healthy", "Error".
    :vartype combined_health: str or ~azure.mgmt.storagesync.models.ServerEndpointHealthState
    :ivar sync_activity: Sync activity. Possible values include: "Upload", "Download",
     "UploadAndDownload".
    :vartype sync_activity: str or ~azure.mgmt.storagesync.models.ServerEndpointSyncActivityState
    :ivar total_persistent_files_not_syncing_count: Total count of persistent files not syncing
     (combined upload + download).
    :vartype total_persistent_files_not_syncing_count: long
    :ivar last_updated_timestamp: Last Updated Timestamp.
    :vartype last_updated_timestamp: ~datetime.datetime
    :ivar upload_status: Upload Status.
    :vartype upload_status: ~azure.mgmt.storagesync.models.ServerEndpointSyncSessionStatus
    :ivar download_status: Download Status.
    :vartype download_status: ~azure.mgmt.storagesync.models.ServerEndpointSyncSessionStatus
    :ivar upload_activity: Upload sync activity.
    :vartype upload_activity: ~azure.mgmt.storagesync.models.ServerEndpointSyncActivityStatus
    :ivar download_activity: Download sync activity.
    :vartype download_activity: ~azure.mgmt.storagesync.models.ServerEndpointSyncActivityStatus
    :ivar offline_data_transfer_status: Offline Data Transfer State. Possible values include:
     "InProgress", "Stopping", "NotRunning", "Complete".
    :vartype offline_data_transfer_status: str or
     ~azure.mgmt.storagesync.models.ServerEndpointOfflineDataTransferState
    :ivar background_data_download_activity: Background data download activity.
    :vartype background_data_download_activity:
     ~azure.mgmt.storagesync.models.ServerEndpointBackgroundDataDownloadActivity
    """

    _validation = {
        'download_health': {'readonly': True},
        'upload_health': {'readonly': True},
        'combined_health': {'readonly': True},
        'sync_activity': {'readonly': True},
        'total_persistent_files_not_syncing_count': {'readonly': True, 'minimum': 0},
        'last_updated_timestamp': {'readonly': True},
        'upload_status': {'readonly': True},
        'download_status': {'readonly': True},
        'upload_activity': {'readonly': True},
        'download_activity': {'readonly': True},
        'offline_data_transfer_status': {'readonly': True},
        'background_data_download_activity': {'readonly': True},
    }

    _attribute_map = {
        'download_health': {'key': 'downloadHealth', 'type': 'str'},
        'upload_health': {'key': 'uploadHealth', 'type': 'str'},
        'combined_health': {'key': 'combinedHealth', 'type': 'str'},
        'sync_activity': {'key': 'syncActivity', 'type': 'str'},
        'total_persistent_files_not_syncing_count': {'key': 'totalPersistentFilesNotSyncingCount', 'type': 'long'},
        'last_updated_timestamp': {'key': 'lastUpdatedTimestamp', 'type': 'iso-8601'},
        'upload_status': {'key': 'uploadStatus', 'type': 'ServerEndpointSyncSessionStatus'},
        'download_status': {'key': 'downloadStatus', 'type': 'ServerEndpointSyncSessionStatus'},
        'upload_activity': {'key': 'uploadActivity', 'type': 'ServerEndpointSyncActivityStatus'},
        'download_activity': {'key': 'downloadActivity', 'type': 'ServerEndpointSyncActivityStatus'},
        'offline_data_transfer_status': {'key': 'offlineDataTransferStatus', 'type': 'str'},
        'background_data_download_activity': {'key': 'backgroundDataDownloadActivity', 'type': 'ServerEndpointBackgroundDataDownloadActivity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServerEndpointSyncStatus, self).__init__(**kwargs)
        self.download_health = None
        self.upload_health = None
        self.combined_health = None
        self.sync_activity = None
        self.total_persistent_files_not_syncing_count = None
        self.last_updated_timestamp = None
        self.upload_status = None
        self.download_status = None
        self.upload_activity = None
        self.download_activity = None
        self.offline_data_transfer_status = None
        self.background_data_download_activity = None


class ServerEndpointUpdateParameters(msrest.serialization.Model):
    """Parameters for updating an Server Endpoint.

    :param cloud_tiering: Cloud Tiering. Possible values include: "on", "off".
    :type cloud_tiering: str or ~azure.mgmt.storagesync.models.FeatureStatus
    :param volume_free_space_percent: Level of free space to be maintained by Cloud Tiering if it
     is enabled.
    :type volume_free_space_percent: int
    :param tier_files_older_than_days: Tier files older than days.
    :type tier_files_older_than_days: int
    :param offline_data_transfer: Offline data transfer. Possible values include: "on", "off".
    :type offline_data_transfer: str or ~azure.mgmt.storagesync.models.FeatureStatus
    :param offline_data_transfer_share_name: Offline data transfer share name.
    :type offline_data_transfer_share_name: str
    :param local_cache_mode: Policy for enabling follow-the-sun business models: link local cache
     to cloud behavior to pre-populate before local access. Possible values include:
     "DownloadNewAndModifiedFiles", "UpdateLocallyCachedFiles".
    :type local_cache_mode: str or ~azure.mgmt.storagesync.models.LocalCacheMode
    """

    _validation = {
        'volume_free_space_percent': {'maximum': 100, 'minimum': 0},
        'tier_files_older_than_days': {'maximum': 2147483647, 'minimum': 0},
    }

    _attribute_map = {
        'cloud_tiering': {'key': 'properties.cloudTiering', 'type': 'str'},
        'volume_free_space_percent': {'key': 'properties.volumeFreeSpacePercent', 'type': 'int'},
        'tier_files_older_than_days': {'key': 'properties.tierFilesOlderThanDays', 'type': 'int'},
        'offline_data_transfer': {'key': 'properties.offlineDataTransfer', 'type': 'str'},
        'offline_data_transfer_share_name': {'key': 'properties.offlineDataTransferShareName', 'type': 'str'},
        'local_cache_mode': {'key': 'properties.localCacheMode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        cloud_tiering: Optional[Union[str, "FeatureStatus"]] = None,
        volume_free_space_percent: Optional[int] = None,
        tier_files_older_than_days: Optional[int] = None,
        offline_data_transfer: Optional[Union[str, "FeatureStatus"]] = None,
        offline_data_transfer_share_name: Optional[str] = None,
        local_cache_mode: Optional[Union[str, "LocalCacheMode"]] = None,
        **kwargs
    ):
        super(ServerEndpointUpdateParameters, self).__init__(**kwargs)
        self.cloud_tiering = cloud_tiering
        self.volume_free_space_percent = volume_free_space_percent
        self.tier_files_older_than_days = tier_files_older_than_days
        self.offline_data_transfer = offline_data_transfer
        self.offline_data_transfer_share_name = offline_data_transfer_share_name
        self.local_cache_mode = local_cache_mode


class StorageSyncApiError(msrest.serialization.Model):
    """Error type.

    :param code: Error code of the given entry.
    :type code: str
    :param message: Error message of the given entry.
    :type message: str
    :param target: Target of the given error entry.
    :type target: str
    :param details: Error details of the given entry.
    :type details: ~azure.mgmt.storagesync.models.StorageSyncErrorDetails
    :param inner_error: Inner error details of the given entry.
    :type inner_error: ~azure.mgmt.storagesync.models.StorageSyncInnerErrorDetails
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': 'StorageSyncErrorDetails'},
        'inner_error': {'key': 'innerError', 'type': 'StorageSyncInnerErrorDetails'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional["StorageSyncErrorDetails"] = None,
        inner_error: Optional["StorageSyncInnerErrorDetails"] = None,
        **kwargs
    ):
        super(StorageSyncApiError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class StorageSyncError(msrest.serialization.Model):
    """Error type.

    :param error: Error details of the given entry.
    :type error: ~azure.mgmt.storagesync.models.StorageSyncApiError
    :param innererror: Error details of the given entry.
    :type innererror: ~azure.mgmt.storagesync.models.StorageSyncApiError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'StorageSyncApiError'},
        'innererror': {'key': 'innererror', 'type': 'StorageSyncApiError'},
    }

    def __init__(
        self,
        *,
        error: Optional["StorageSyncApiError"] = None,
        innererror: Optional["StorageSyncApiError"] = None,
        **kwargs
    ):
        super(StorageSyncError, self).__init__(**kwargs)
        self.error = error
        self.innererror = innererror


class StorageSyncErrorDetails(msrest.serialization.Model):
    """Error Details object.

    :param code: Error code of the given entry.
    :type code: str
    :param message: Error message of the given entry.
    :type message: str
    :param target: Target of the given entry.
    :type target: str
    :param request_uri: Request URI of the given entry.
    :type request_uri: str
    :param exception_type: Exception type of the given entry.
    :type exception_type: str
    :param http_method: HTTP method of the given entry.
    :type http_method: str
    :param hashed_message: Hashed message of the given entry.
    :type hashed_message: str
    :param http_error_code: HTTP error code of the given entry.
    :type http_error_code: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'request_uri': {'key': 'requestUri', 'type': 'str'},
        'exception_type': {'key': 'exceptionType', 'type': 'str'},
        'http_method': {'key': 'httpMethod', 'type': 'str'},
        'hashed_message': {'key': 'hashedMessage', 'type': 'str'},
        'http_error_code': {'key': 'httpErrorCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        request_uri: Optional[str] = None,
        exception_type: Optional[str] = None,
        http_method: Optional[str] = None,
        hashed_message: Optional[str] = None,
        http_error_code: Optional[str] = None,
        **kwargs
    ):
        super(StorageSyncErrorDetails, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.request_uri = request_uri
        self.exception_type = exception_type
        self.http_method = http_method
        self.hashed_message = hashed_message
        self.http_error_code = http_error_code


class StorageSyncInnerErrorDetails(msrest.serialization.Model):
    """Error Details object.

    :param call_stack: Call stack of the error.
    :type call_stack: str
    :param message: Error message of the error.
    :type message: str
    :param inner_exception: Exception of the inner error.
    :type inner_exception: str
    :param inner_exception_call_stack: Call stack of the inner error.
    :type inner_exception_call_stack: str
    """

    _attribute_map = {
        'call_stack': {'key': 'callStack', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'inner_exception': {'key': 'innerException', 'type': 'str'},
        'inner_exception_call_stack': {'key': 'innerExceptionCallStack', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        call_stack: Optional[str] = None,
        message: Optional[str] = None,
        inner_exception: Optional[str] = None,
        inner_exception_call_stack: Optional[str] = None,
        **kwargs
    ):
        super(StorageSyncInnerErrorDetails, self).__init__(**kwargs)
        self.call_stack = call_stack
        self.message = message
        self.inner_exception = inner_exception
        self.inner_exception_call_stack = inner_exception_call_stack


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class StorageSyncService(TrackedResource):
    """Storage Sync Service object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param incoming_traffic_policy: Incoming Traffic Policy. Possible values include:
     "AllowAllTraffic", "AllowVirtualNetworksOnly".
    :type incoming_traffic_policy: str or ~azure.mgmt.storagesync.models.IncomingTrafficPolicy
    :ivar storage_sync_service_status: Storage Sync service status.
    :vartype storage_sync_service_status: int
    :ivar storage_sync_service_uid: Storage Sync service Uid.
    :vartype storage_sync_service_uid: str
    :ivar provisioning_state: StorageSyncService Provisioning State.
    :vartype provisioning_state: str
    :ivar last_workflow_id: StorageSyncService lastWorkflowId.
    :vartype last_workflow_id: str
    :ivar last_operation_name: Resource Last Operation Name.
    :vartype last_operation_name: str
    :ivar private_endpoint_connections: List of private endpoint connection associated with the
     specified storage sync service.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.storagesync.models.PrivateEndpointConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'storage_sync_service_status': {'readonly': True},
        'storage_sync_service_uid': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'last_workflow_id': {'readonly': True},
        'last_operation_name': {'readonly': True},
        'private_endpoint_connections': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'incoming_traffic_policy': {'key': 'properties.incomingTrafficPolicy', 'type': 'str'},
        'storage_sync_service_status': {'key': 'properties.storageSyncServiceStatus', 'type': 'int'},
        'storage_sync_service_uid': {'key': 'properties.storageSyncServiceUid', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'last_workflow_id': {'key': 'properties.lastWorkflowId', 'type': 'str'},
        'last_operation_name': {'key': 'properties.lastOperationName', 'type': 'str'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        incoming_traffic_policy: Optional[Union[str, "IncomingTrafficPolicy"]] = None,
        **kwargs
    ):
        super(StorageSyncService, self).__init__(tags=tags, location=location, **kwargs)
        self.incoming_traffic_policy = incoming_traffic_policy
        self.storage_sync_service_status = None
        self.storage_sync_service_uid = None
        self.provisioning_state = None
        self.last_workflow_id = None
        self.last_operation_name = None
        self.private_endpoint_connections = None


class StorageSyncServiceArray(msrest.serialization.Model):
    """Array of StorageSyncServices.

    :param value: Collection of StorageSyncServices.
    :type value: list[~azure.mgmt.storagesync.models.StorageSyncService]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[StorageSyncService]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["StorageSyncService"]] = None,
        **kwargs
    ):
        super(StorageSyncServiceArray, self).__init__(**kwargs)
        self.value = value


class StorageSyncServiceCreateParameters(msrest.serialization.Model):
    """The parameters used when creating a storage sync service.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. Required. Gets or sets the location of the resource. This will be
     one of the supported and registered Azure Geo Regions (e.g. West US, East US, Southeast Asia,
     etc.). The geo region of a resource cannot be changed once it is created, but if an identical
     geo region is specified on update, the request will succeed.
    :type location: str
    :param tags: A set of tags. Gets or sets a list of key value pairs that describe the resource.
     These tags can be used for viewing and grouping this resource (across resource groups). A
     maximum of 15 tags can be provided for a resource. Each tag must have a key with a length no
     greater than 128 characters and a value with a length no greater than 256 characters.
    :type tags: dict[str, str]
    :param incoming_traffic_policy: Incoming Traffic Policy. Possible values include:
     "AllowAllTraffic", "AllowVirtualNetworksOnly".
    :type incoming_traffic_policy: str or ~azure.mgmt.storagesync.models.IncomingTrafficPolicy
    """

    _validation = {
        'location': {'required': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'incoming_traffic_policy': {'key': 'properties.incomingTrafficPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        incoming_traffic_policy: Optional[Union[str, "IncomingTrafficPolicy"]] = None,
        **kwargs
    ):
        super(StorageSyncServiceCreateParameters, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.incoming_traffic_policy = incoming_traffic_policy


class StorageSyncServiceUpdateParameters(msrest.serialization.Model):
    """Parameters for updating an Storage sync service.

    :param tags: A set of tags. The user-specified tags associated with the storage sync service.
    :type tags: dict[str, str]
    :param incoming_traffic_policy: Incoming Traffic Policy. Possible values include:
     "AllowAllTraffic", "AllowVirtualNetworksOnly".
    :type incoming_traffic_policy: str or ~azure.mgmt.storagesync.models.IncomingTrafficPolicy
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'incoming_traffic_policy': {'key': 'properties.incomingTrafficPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        incoming_traffic_policy: Optional[Union[str, "IncomingTrafficPolicy"]] = None,
        **kwargs
    ):
        super(StorageSyncServiceUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.incoming_traffic_policy = incoming_traffic_policy


class SubscriptionState(msrest.serialization.Model):
    """Subscription State object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param state: State of Azure Subscription. Possible values include: "Registered",
     "Unregistered", "Warned", "Suspended", "Deleted".
    :type state: str or ~azure.mgmt.storagesync.models.Reason
    :ivar istransitioning: Is Transitioning.
    :vartype istransitioning: bool
    :param properties: Subscription state properties.
    :type properties: object
    """

    _validation = {
        'istransitioning': {'readonly': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'istransitioning': {'key': 'istransitioning', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        state: Optional[Union[str, "Reason"]] = None,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(SubscriptionState, self).__init__(**kwargs)
        self.state = state
        self.istransitioning = None
        self.properties = properties


class SyncGroup(ProxyResource):
    """Sync Group object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar unique_id: Unique Id.
    :vartype unique_id: str
    :ivar sync_group_status: Sync group status.
    :vartype sync_group_status: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'unique_id': {'readonly': True},
        'sync_group_status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'sync_group_status': {'key': 'properties.syncGroupStatus', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SyncGroup, self).__init__(**kwargs)
        self.unique_id = None
        self.sync_group_status = None


class SyncGroupArray(msrest.serialization.Model):
    """Array of SyncGroup.

    :param value: Collection of SyncGroup.
    :type value: list[~azure.mgmt.storagesync.models.SyncGroup]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SyncGroup]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SyncGroup"]] = None,
        **kwargs
    ):
        super(SyncGroupArray, self).__init__(**kwargs)
        self.value = value


class SyncGroupCreateParameters(ProxyResource):
    """The parameters used when creating a sync group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param properties: The parameters used to create the sync group.
    :type properties: object
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(SyncGroupCreateParameters, self).__init__(**kwargs)
        self.properties = properties


class TriggerChangeDetectionParameters(msrest.serialization.Model):
    """The parameters used when calling trigger change detection action on cloud endpoint.

    :param directory_path: Relative path to a directory Azure File share for which change detection
     is to be performed.
    :type directory_path: str
    :param change_detection_mode: Change Detection Mode. Applies to a directory specified in
     directoryPath parameter. Possible values include: "Default", "Recursive".
    :type change_detection_mode: str or ~azure.mgmt.storagesync.models.ChangeDetectionMode
    :param paths: Array of relative paths on the Azure File share to be included in the change
     detection. Can be files and directories.
    :type paths: list[str]
    """

    _attribute_map = {
        'directory_path': {'key': 'directoryPath', 'type': 'str'},
        'change_detection_mode': {'key': 'changeDetectionMode', 'type': 'str'},
        'paths': {'key': 'paths', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        directory_path: Optional[str] = None,
        change_detection_mode: Optional[Union[str, "ChangeDetectionMode"]] = None,
        paths: Optional[List[str]] = None,
        **kwargs
    ):
        super(TriggerChangeDetectionParameters, self).__init__(**kwargs)
        self.directory_path = directory_path
        self.change_detection_mode = change_detection_mode
        self.paths = paths


class TriggerRolloverRequest(msrest.serialization.Model):
    """Trigger Rollover Request.

    :param server_certificate: Certificate Data.
    :type server_certificate: str
    """

    _attribute_map = {
        'server_certificate': {'key': 'serverCertificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        server_certificate: Optional[str] = None,
        **kwargs
    ):
        super(TriggerRolloverRequest, self).__init__(**kwargs)
        self.server_certificate = server_certificate


class Workflow(ProxyResource):
    """Workflow resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar last_step_name: last step name.
    :vartype last_step_name: str
    :ivar status: workflow status. Possible values include: "active", "expired", "succeeded",
     "aborted", "failed".
    :vartype status: str or ~azure.mgmt.storagesync.models.WorkflowStatus
    :ivar operation: operation direction. Possible values include: "do", "undo", "cancel".
    :vartype operation: str or ~azure.mgmt.storagesync.models.OperationDirection
    :ivar steps: workflow steps.
    :vartype steps: str
    :ivar last_operation_id: workflow last operation identifier.
    :vartype last_operation_id: str
    :ivar command_name: workflow command name.
    :vartype command_name: str
    :ivar created_timestamp: workflow created timestamp.
    :vartype created_timestamp: ~datetime.datetime
    :ivar last_status_timestamp: workflow last status timestamp.
    :vartype last_status_timestamp: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'last_step_name': {'readonly': True},
        'status': {'readonly': True},
        'operation': {'readonly': True},
        'steps': {'readonly': True},
        'last_operation_id': {'readonly': True},
        'command_name': {'readonly': True},
        'created_timestamp': {'readonly': True},
        'last_status_timestamp': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'last_step_name': {'key': 'properties.lastStepName', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'operation': {'key': 'properties.operation', 'type': 'str'},
        'steps': {'key': 'properties.steps', 'type': 'str'},
        'last_operation_id': {'key': 'properties.lastOperationId', 'type': 'str'},
        'command_name': {'key': 'properties.commandName', 'type': 'str'},
        'created_timestamp': {'key': 'properties.createdTimestamp', 'type': 'iso-8601'},
        'last_status_timestamp': {'key': 'properties.lastStatusTimestamp', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Workflow, self).__init__(**kwargs)
        self.last_step_name = None
        self.status = None
        self.operation = None
        self.steps = None
        self.last_operation_id = None
        self.command_name = None
        self.created_timestamp = None
        self.last_status_timestamp = None


class WorkflowArray(msrest.serialization.Model):
    """Array of Workflow.

    :param value: Collection of workflow items.
    :type value: list[~azure.mgmt.storagesync.models.Workflow]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Workflow]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Workflow"]] = None,
        **kwargs
    ):
        super(WorkflowArray, self).__init__(**kwargs)
        self.value = value
