/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2007-2014 by The University of Queensland //
// Centre for Geoscience Computing                         //
// http://earth.uq.edu.au/centre-geoscience-computing      //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#ifndef __BOXWITHPLANES3D_H
#define __BOXWITHPLANES3D_H

// --- Project includes ---
#include "AVolume3D.h"
#include "geometry/Plane.h"

// --- STL includes ---
#include <vector>
#include <map>

using std::vector;
using std::map;

/*!
  \class BoxWithPlanes3D

  A class for the generation of random particles inside a 3D box. An arbitrary number 
  of planes can be added to which the particles are fitted.  
*/
class BoxWithPlanes3D : public AVolume3D
{
 protected:
  Vector3 m_pmin;
  Vector3 m_pmax;
  vector<Plane> m_planes;
  double m_random(double,double)const;

 public:
  BoxWithPlanes3D();
  BoxWithPlanes3D(const Vector3&,const Vector3&);
  virtual ~BoxWithPlanes3D(){};

  void addPlane(const Plane&);
  virtual pair<Vector3,Vector3> getBoundingBox();
  virtual Vector3 getAPoint(int)const;
  virtual bool hasPlane() const{return (m_planes.size()>0);};
  virtual Plane getClosestPlane(const Vector3&);
  virtual const map<double,const AGeometricObject*> getClosestObjects(const Vector3&,int) const;
  virtual bool isIn(const Vector3&) const;
  virtual bool isIn(const Sphere&);
  virtual bool isFullyOutside(const Sphere&);

  friend ostream& operator<< (ostream&, const BoxWithPlanes3D&);
};
#endif // __BOXWITHPLANES3D_H
