# Antora AsciiDoc Loader

The AsciiDoc Loader is a reusable library for handling AsciiDoc content in Antora.
It loads AsciiDoc content into an AsciiDoc Document object (AST) for use in an Antora documentation pipeline.

The AsciiDoc loader wraps [Asciidoctor.js](https://asciidoctor.org/docs/asciidoctor.js/) and adds several extensions that enable AsciiDoc to work in an Antora environment.
These extensions include:

* An include processor that resolves files from the content catalog.
* A cross reference converter that resolves references between pages based on Antora’s page reference system.
* Automatic resolution of paths to images and attachments.
* Implicit document attributes that pass information from the Antora environment.

[Antora](https://antora.org) is a modular static site generator designed for creating documentation sites from AsciiDoc documents.
Its site generator aggregates documents from versioned content repositories and processes them using [Asciidoctor](https://asciidoctor.org).

## Copyright and License

Copyright (C) 2017-present [OpenDevise Inc.](https://opendevise.com) and the [Antora Project](https://antora.org).

Use of this software is granted under the terms of the [Mozilla Public License Version 2.0](https://www.mozilla.org/en-US/MPL/2.0/) (MPL-2.0).
