.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Tue Aug 29 11:06:25 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_IS\\_SIGNAL\\_FRAME" "3libunwind" "29 August 2023" "Programming Library " "Programming Library "
.SH NAME
unw_is_signal_frame
\-\- check if current frame is a signal frame 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_is_signal_frame(unw_cursor_t *cp);
.br
.PP
.SH DESCRIPTION

.PP
The unw_is_signal_frame()
routine returns a positive value 
if the current frame identified by cp
is a signal frame, 
also known as a signal trampoline, 
and a value of 0 otherwise. 
For the purpose of this discussion, 
a signal frame is a frame that was created in response to a potentially 
asynchronous interruption. 
For UNIX and UNIX\-like platforms, 
such frames are normally created by the kernel when delivering a signal. 
In a kernel environment, a signal frame might, for example, correspond 
to a frame created in response to a device interrupt. 
.PP
Signal frames are somewhat unusual because the asynchronous nature of 
the events that create them require storing the contents of registers 
that are normally treated as scratch (``caller\-saved\&'') registers. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_is_signal_frame()
returns a 
positive value if the current frame is a signal frame, or 0 if it is 
not. Otherwise, a negative value of one of the error codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_is_signal_frame()
is thread safe as well as safe to use 
from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_ENOINFO
 Libunwind
is unable to determine 
whether or not the current frame is a signal frame. 
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
unw_get_reg(3libunwind),
unw_set_reg(3libunwind),
unw_get_fpreg(3libunwind),
unw_set_fpreg(3libunwind)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
