/*
 * Copyright (c) 1997 by Procom Technology,Inc.
 *
 * This program can be redistributed or modified under the terms of the 
 * GNU General Public License as published by the Free Software Foundation.
 * This program is distributed without any warranty or implied warranty
 * of merchantability or fitness for a particular purpose.
 *
 * See the GNU General Public License for more details.
 *
 */
 
/* 
 * Station component state transition actions 
 */

#ifndef LLC_ACTN_H
#define LLC_ACTN_H

#define STATION_AC_START_ACK_TIMER                 1
#define STATION_AC_SET_RETRY_COUNT_0               2
#define STATION_AC_INCREMENT_RETRY_COUNT_BY_1      3
#define STATION_AC_SET_XID_R_COUNT_0               4
#define STATION_AC_INCREMENT_XID_R_COUNT_BY_1      5
#define STATION_AC_SEND_NULL_DSAP_XID_C            6
#define STATION_AC_SEND_XID_R                      7
#define STATION_AC_SEND_TEST_R                     8
#define STATION_AC_REPORT_STATUS                   9


/* All station state event action functions look like this */
typedef us16 (*station_action_t)(station_t * station,
                                            station_state_event_t * event);


#ifdef LLC_ACTN_C
#define EXTRN
#else
#define EXTRN extern
#endif /* LLC_ACTN_C */


EXTRN us16     station_ac_start_ack_timer (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_set_retry_count_0 (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_increment_retry_count_by_1 (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_set_xid_r_count_0 (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_increment_xid_r_count_by_1 (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_send_null_dsap_xid_c (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_send_xid_r (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_send_test_r (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_report_status (station_t * station,
                                            station_state_event_t * event);
EXTRN us16     station_ac_report_status (station_t * station,
                                            station_state_event_t * event);

#undef EXTRN
#endif /* LLC_ACTN_H */


