/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.sheets.v4.model;

/**
 * A border along an embedded object.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Sheets API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EmbeddedObjectBorder extends com.google.api.client.json.GenericJson {

  /**
   * The color of the border.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Color color;

  /**
   * The color of the border. If color is also set, this field takes precedence.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ColorStyle colorStyle;

  /**
   * The color of the border.
   * @return value or {@code null} for none
   */
  public Color getColor() {
    return color;
  }

  /**
   * The color of the border.
   * @param color color or {@code null} for none
   */
  public EmbeddedObjectBorder setColor(Color color) {
    this.color = color;
    return this;
  }

  /**
   * The color of the border. If color is also set, this field takes precedence.
   * @return value or {@code null} for none
   */
  public ColorStyle getColorStyle() {
    return colorStyle;
  }

  /**
   * The color of the border. If color is also set, this field takes precedence.
   * @param colorStyle colorStyle or {@code null} for none
   */
  public EmbeddedObjectBorder setColorStyle(ColorStyle colorStyle) {
    this.colorStyle = colorStyle;
    return this;
  }

  @Override
  public EmbeddedObjectBorder set(String fieldName, Object value) {
    return (EmbeddedObjectBorder) super.set(fieldName, value);
  }

  @Override
  public EmbeddedObjectBorder clone() {
    return (EmbeddedObjectBorder) super.clone();
  }

}
