# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.apimanagement.aio import ApiManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestApiManagementDelegationSettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ApiManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delegation_settings_get_entity_tag(self, resource_group):
        response = await self.client.delegation_settings.get_entity_tag(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delegation_settings_get(self, resource_group):
        response = await self.client.delegation_settings.get(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delegation_settings_update(self, resource_group):
        response = await self.client.delegation_settings.update(
            resource_group_name=resource_group.name,
            service_name="str",
            if_match="str",
            parameters={
                "id": "str",
                "name": "str",
                "subscriptions": {"enabled": bool},
                "type": "str",
                "url": "str",
                "userRegistration": {"enabled": bool},
                "validationKey": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delegation_settings_create_or_update(self, resource_group):
        response = await self.client.delegation_settings.create_or_update(
            resource_group_name=resource_group.name,
            service_name="str",
            parameters={
                "id": "str",
                "name": "str",
                "subscriptions": {"enabled": bool},
                "type": "str",
                "url": "str",
                "userRegistration": {"enabled": bool},
                "validationKey": "str",
            },
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_delegation_settings_list_secrets(self, resource_group):
        response = await self.client.delegation_settings.list_secrets(
            resource_group_name=resource_group.name,
            service_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
