# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.paloaltonetworksngfw.aio import PaloAltoNetworksNgfwMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPaloAltoNetworksNgfwMgmtCertificateObjectGlobalRulestackOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PaloAltoNetworksNgfwMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificate_object_global_rulestack_list(self, resource_group):
        response = self.client.certificate_object_global_rulestack.list(
            global_rulestack_name="str",
            api_version="2025-10-08",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificate_object_global_rulestack_get(self, resource_group):
        response = await self.client.certificate_object_global_rulestack.get(
            global_rulestack_name="str",
            name="str",
            api_version="2025-10-08",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificate_object_global_rulestack_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.certificate_object_global_rulestack.begin_create_or_update(
                global_rulestack_name="str",
                name="str",
                resource={
                    "certificateSelfSigned": "str",
                    "auditComment": "str",
                    "certificateSignerResourceId": "str",
                    "description": "str",
                    "etag": "str",
                    "id": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_certificate_object_global_rulestack_begin_delete(self, resource_group):
        response = await (
            await self.client.certificate_object_global_rulestack.begin_delete(
                global_rulestack_name="str",
                name="str",
                api_version="2025-10-08",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
