# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.workloadorchestration.aio import WorkloadOrchestrationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWorkloadOrchestrationMgmtSolutionTemplateVersionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WorkloadOrchestrationMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_template_versions_get(self, resource_group):
        response = await self.client.solution_template_versions.get(
            resource_group_name=resource_group.name,
            solution_template_name="str",
            solution_template_version_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_template_versions_list_by_solution_template(self, resource_group):
        response = self.client.solution_template_versions.list_by_solution_template(
            resource_group_name=resource_group.name,
            solution_template_name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_template_versions_begin_bulk_deploy_solution(self, resource_group):
        response = await (
            await self.client.solution_template_versions.begin_bulk_deploy_solution(
                resource_group_name=resource_group.name,
                solution_template_name="str",
                solution_template_version_name="str",
                body={"targets": [{"solutionVersionId": "str"}]},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_solution_template_versions_begin_bulk_publish_solution(self, resource_group):
        response = await (
            await self.client.solution_template_versions.begin_bulk_publish_solution(
                resource_group_name=resource_group.name,
                solution_template_name="str",
                solution_template_version_name="str",
                body={
                    "targets": [{"targetId": "str", "solutionInstanceName": "str"}],
                    "solutionDependencies": [
                        {
                            "dependencies": [...],
                            "solutionInstanceName": "str",
                            "solutionTemplateId": "str",
                            "solutionTemplateVersion": "str",
                            "solutionVersionId": "str",
                            "targetId": "str",
                        }
                    ],
                    "solutionInstanceName": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
