////////////////////////////////////////////////////////////////////////////////
//
// Copyright 2006 - 2021, Tomas Babej, Paul Beckingham, Federico Hernandez.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
//
// https://www.opensource.org/licenses/mit-license.php
//
////////////////////////////////////////////////////////////////////////////////

#ifndef INCLUDED_COLUDA
#define INCLUDED_COLUDA

#include <ColTypeDate.h>
#include <ColTypeDuration.h>
#include <ColTypeNumeric.h>
#include <ColTypeString.h>
#include <ColUUID.h>

////////////////////////////////////////////////////////////////////////////////
class ColumnUDAString : public ColumnTypeString {
 public:
  ColumnUDAString();
  bool validate(const std::string&) const;
  void measure(Task&, unsigned int&, unsigned int&);
  void render(std::vector<std::string>&, Task&, int, Color&);

 public:
  std::vector<std::string> _values;

 private:
  bool _hyphenate;
};

////////////////////////////////////////////////////////////////////////////////
class ColumnUDANumeric : public ColumnTypeNumeric {
 public:
  ColumnUDANumeric();
  bool validate(const std::string&) const;
  void measure(Task&, unsigned int&, unsigned int&);
  void render(std::vector<std::string>&, Task&, int, Color&);

 public:
  std::vector<std::string> _values;
};

////////////////////////////////////////////////////////////////////////////////
class ColumnUDADate : public ColumnTypeDate {
 public:
  ColumnUDADate();
  bool validate(const std::string&) const;
  void measure(Task&, unsigned int&, unsigned int&);
  void render(std::vector<std::string>&, Task&, int, Color&);

 public:
  std::vector<std::string> _values;
};

////////////////////////////////////////////////////////////////////////////////
class ColumnUDADuration : public ColumnTypeDuration {
 public:
  ColumnUDADuration();
  bool validate(const std::string&) const;
  void measure(Task&, unsigned int&, unsigned int&);
  void render(std::vector<std::string>&, Task&, int, Color&);

 public:
  std::vector<std::string> _values;
};

////////////////////////////////////////////////////////////////////////////////
class ColumnUDAUUID : public ColumnUUID {
 public:
  ColumnUDAUUID();
  bool validate(const std::string&) const;
};

#endif
////////////////////////////////////////////////////////////////////////////////
