#############################################################
#
# coreutils
#
#############################################################
ifneq ($(USE_CVS),true)
COREUTILS_SOURCE:=coreutils.tar.gz
COREUTILS_SITE:=ftp://ftp.gnu.org/gnu/coreutils/
COREUTILS_CAT:=zcat
COREUTILS_DIR:=$(BUILD_DIR)/${shell basename $(COREUTILS_SOURCE) .tar.gz}

else
# using CVS
COREUTILS_DIR:=$(BUILD_DIR)/coreutils
endif

COREUTILS_BINARY:=src/vdir
COREUTILS_TARGET_BINARY:=bin/vdir
BIN_PROGS:=cat chgrp chmod chown cp date dd dir echo false hostname \
	ln ls mkdir mknod mv pwd rm rmdir vdir sleep stty sync touch true uname

ifneq ($(USE_CVS),true)
coreutils-fetch:
	 $(WGET) -P $(DL_DIR) $(COREUTILS_SITE)/$(COREUTILS_SOURCE)

coreutils-source: $(DL_DIR)/$(COREUTILS_SOURCE)
else
coreutils-source:
endif

COREUTILS_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d coreutils $(CVS_TAG) $(CVS_PREFIX)coreutils

coreutils-checkout:
	@$(COREUTILS_CVSCO)

$(COREUTILS_DIR)/.unpacked: $(DL_DIR)/$(COREUTILS_SOURCE)
ifneq ($(USE_CVS),true)
	$(COREUTILS_CAT) $(DL_DIR)/$(COREUTILS_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(COREUTILS_CVSCO)
endif
	touch $(COREUTILS_DIR)/.unpacked

$(COREUTILS_DIR)/.configured: $(COREUTILS_DIR)/.unpacked
	(cd $(COREUTILS_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--disable-rpath \
		--disable-dependency-tracking \
	);
	#Fix up the max number of open files per process, which apparently 
	# is not set when cross compiling
	sed -i -e 's,.*UTILS_OPEN_MAX.*,#define UTILS_OPEN_MAX 1019,g' \
		$(COREUTILS_DIR)/config.h
	# This is undefined when crosscompiling...
	sed -i -e 's,.*HAVE_PROC_UPTIME.*,#define HAVE_PROC_UPTIME 1,g' \
		$(COREUTILS_DIR)/config.h
	touch  $(COREUTILS_DIR)/.configured

$(COREUTILS_DIR)/$(COREUTILS_BINARY): $(COREUTILS_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(COREUTILS_DIR)
	rm -f $(TARGET_DIR)/$(COREUTILS_TARGET_BINARY)

$(TARGET_DIR)/$(COREUTILS_TARGET_BINARY): $(COREUTILS_DIR)/$(COREUTILS_BINARY)
	touch $(TARGET_DIR)/touchme
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(COREUTILS_DIR) install
	@for f in `find $(TARGET_DIR) -type f -newer $(TARGET_DIR)/touchme -exec file {} \; | \
                grep "ELF.*executable.*not stripped" | cut -d : -f 1` ; do \
            $(STRIP) $$f ; \
        done
	rm -f $(TARGET_DIR)/touchme
	# some things go in root rather than usr
	for f in $(BIN_PROGS); do \
		mv $(TARGET_DIR)/usr/bin/$$f $(TARGET_DIR)/bin/$$f; \
	done
	# link for archaic shells
	ln -fs test $(TARGET_DIR)/usr/bin/[
	# gnu thinks chroot is in bin, debian thinks it's in sbin
	mv $(TARGET_DIR)/usr/bin/chroot $(TARGET_DIR)/usr/sbin/chroot
	$(STRIP) $(TARGET_DIR)/usr/sbin/chroot > /dev/null 2>&1
	rm -rf $(TARGET_DIR)/share/locale
	mkdir -p $(DOC_DIR)/doc/coreutils
	for f in COPYING AUTHORS README NEWS ; do \
	    install -m0644 $(COREUTILS_DIR)/$$f $(DOC_DIR)/doc/coreutils/ ; \
	done

coreutils: uclibc $(TARGET_DIR)/$(COREUTILS_TARGET_BINARY)

coreutils-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) CC=$(TARGET_CC) -C $(COREUTILS_DIR) uninstall
	-$(MAKE) -C $(COREUTILS_DIR) clean
	-rm -rf $(DOC_DIR)/doc/coreutils
	-rm -f $(TARGET_DIR)/usr/info/coreutils.info

coreutils-dirclean:
	rm -rf $(COREUTILS_DIR)

