#############################################################
#
# netkitrsh
#
#############################################################
ifneq ($(USE_CVS),true)
NETKITRSH_SOURCE:=netkit-rsh.tar.gz
NETKITRSH_CAT:=zcat
endif

NETKITRSH_DIR:=$(BUILD_DIR)/netkit-rsh
NETKITRSH_BINARY:=rsh/rsh
NETKITRSH_TARGET_BINARY:=usr/bin/rsh
NETKITRSH_PATCH:=$(SOURCE_DIR)/netkitrsh.patch

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(NETKITRSH_SOURCE):
	 $(WGET) -P $(DL_DIR) $(NETKITRSH_SITE)/$(NETKITRSH_SOURCE)

netkitrsh-source: $(DL_DIR)/$(NETKITRSH_SOURCE)
else
netkitrsh-source:
endif

NETKITRSH_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d netkit-rsh $(CVS_TAG) $(CVS_PREFIX)netkit-rsh

netkitrsh-checkout:
	@$(NETKITRSH_CVSCO)

$(NETKITRSH_DIR)/.unpacked: $(DL_DIR)/$(NETKITRSH_SOURCE)
ifneq ($(USE_CVS),true)
	$(NETKITRSH_CAT) $(DL_DIR)/$(NETKITRSH_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETKITRSH_CVSCO)
endif
	touch $(NETKITRSH_DIR)/.unpacked

$(NETKITRSH_DIR)/.configured: $(NETKITRSH_DIR)/.unpacked
	(cd $(NETKITRSH_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(NETKITRSH_DIR)/.configured

$(NETKITRSH_DIR)/$(NETKITRSH_BINARY): $(NETKITRSH_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(NETKITRSH_DIR)

$(TARGET_DIR)/$(NETKITRSH_TARGET_BINARY): $(NETKITRSH_DIR)/$(NETKITRSH_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(NETKITRSH_DIR) install
	$(STRIP) $(TARGET_DIR)/$(NETKITRSH_TARGET_BINARY) \
		$(TARGET_DIR)/usr/bin/rcp \
		$(TARGET_DIR)/usr/bin/rexec \
		$(TARGET_DIR)/usr/bin/rlogin \
		$(TARGET_DIR)/usr/bin/rsh \
		$(TARGET_DIR)/usr/sbin/in.rexecd \
		$(TARGET_DIR)/usr/sbin/in.logind \
		$(TARGET_DIR)/usr/sbin/in.rshd
	sed -i -e 's,^# *shell,shell,;s,^# *login,login,;s,^# *exec,exec,;' \
		-e 's,-L$$,,g;' \
		$(TARGET_DIR)/etc/inetd.conf
	install -m0644 $(NETKITRSH_DIR)/rexecd/rexec.pam \
		$(TARGET_DIR)/etc/pam.d/rexec
	mkdir -p $(DOC_DIR)/doc/netkit-rsh
	for f in BUGS README ; do \
	    install -m0644 $(NETKITRSH_DIR)/$$f $(DOC_DIR)/doc/netkit-rsh/$$f ; \
	done
	install -m0644 $(NETKITRSH_DIR)/rexec/README \
		$(DOC_DIR)/doc/netkit-rsh/README.rexec

netkitrsh: uclibc pam $(TARGET_DIR)/$(NETKITRSH_TARGET_BINARY)

netkitrsh-clean:
	-rm -f $(TARGET_DIR)/$(NETKITRSH_TARGET_BINARY) \
		$(TARGET_DIR)/usr/bin/rcp \
		$(TARGET_DIR)/usr/bin/rexec \
		$(TARGET_DIR)/usr/bin/rlogin \
		$(TARGET_DIR)/usr/bin/rsh \
		$(TARGET_DIR)/usr/sbin/in.rexecd \
		$(TARGET_DIR)/usr/sbin/in.logind \
		$(TARGET_DIR)/usr/sbin/in.rshd \
		$(TARGET_DIR)/usr/man/man1/rcp.1 \
		$(TARGET_DIR)/usr/man/man1/rexec.1 \
		$(TARGET_DIR)/usr/man/man1/rlogin.1 \
		$(TARGET_DIR)/usr/man/man1/rsh.1 \
		$(TARGET_DIR)/usr/man/man8/*rexecd.8 \
		$(TARGET_DIR)/usr/man/man8/*rlogind.8 \
		$(TARGET_DIR)/usr/man/man8/*rshd.8 \
		$(TARGET_DIR)/etc/pamd.d/rexec
	-$(MAKE) -C $(NETKITRSH_DIR) clean
	-rm -rf $(DOC_DIR)/doc/netkit-rsh

netkitrsh-dirclean:
	rm -rf $(NETKITRSH_DIR)

