#############################################################
#
# pcmcia card services
#
#############################################################
# Copyright (C) 2001-2003 by Erik Andersen <andersen@codepoet.org>
# Copyright (C) 2002 by Tim Riker <Tim@Rikers.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
# USA
ifneq ($(USE_CVS),true)
PCMCIA_SOURCE:=pcmcia-cs.tar.gz
PCMCIA_SITE:=http://aleron.dl.sourceforge.net/sourceforge/pcmcia-cs
PCMCIA_CAT:=zcat
endif

PCMCIA_DIR:=$(BUILD_DIR)/pcmcia-cs
PCMCIA_PATCH:=$(SOURCE_DIR)/pcmcia.patch

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(PCMCIA_SOURCE):
	$(WGET) -P $(DL_DIR) $(PCMCIA_SITE)/$(PCMCIA_SOURCE)

pcmcia-source: $(DL_DIR)/$(PCMCIA_SOURCE)
else
pcmcia-source:
endif

PCMCIA_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co $(CVS_TAG) -d pcmcia-cs $(CVS_PREFIX)pcmcia-cs

pcmcia-checkout:
	@$(PCMCIA_CVSCO)

$(PCMCIA_DIR)/.unpacked: $(DL_DIR)/$(PCMCIA_SOURCE)
ifneq ($(USE_CVS),true)
	$(PCMCIA_CAT) $(DL_DIR)/$(PCMCIA_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PCMCIA_CVSCO)
endif
	ln -sf ../../../staging_dir/usr/include/linux/config.h $(PCMCIA_DIR)/include/linux/config.h
	touch $(PCMCIA_DIR)/.unpacked

$(PCMCIA_DIR)/.patched: $(PCMCIA_DIR)/.unpacked
	-(cat $(PCMCIA_PATCH) | patch -d $(PCMCIA_DIR) -p1)
	touch $(PCMCIA_DIR)/.patched

$(PCMCIA_DIR)/.configured: $(PCMCIA_DIR)/.patched
	cat $(SOURCE_DIR)/config-pcmcia-$(ARCH).mk | sed -e "s,@__LINUX__@,$(STAGING_DIR)/usr,g" > $(PCMCIA_DIR)/config.mk
	cat $(SOURCE_DIR)/config-pcmcia-$(ARCH).h | sed -e "s,@__LINUX__@,$(STAGING_DIR)/usr,g" > $(PCMCIA_DIR)/include/pcmcia/config.h
	sed -i -e 's,kcheck$$,,g' $(PCMCIA_DIR)/Makefile
	cat $(PCMCIA_DIR)/config.mk | sed -e "s,^\(CPPFLAGS.*\),#\1,g" > $(PCMCIA_DIR)/config.out
	sed -i -e "s/ide_cs/ide-cs/" $(PCMCIA_DIR)/etc/config
	sed -i -e "s/bind \"wvlan_cs\"/bind \"orinoco_cs\"/g" $(PCMCIA_DIR)/etc/config
	( mkdir $(PCMCIA_DIR)/include/static;\
	  cd $(PCMCIA_DIR)/include/static; \
	  ln -s ../asm .; \
	  ln -s ../linux .; \
	  ln -s ../net .; \
	  mkdir pcmcia && cd pcmcia; \
	  ln -s ../../pcmcia/ciscode.h .; \
	  ln -s ../../pcmcia/version.h .)
	touch $(PCMCIA_DIR)/.prereq.ok
	touch $(PCMCIA_DIR)/.configured

$(PCMCIA_DIR)/cardmgr/cardmgr: $(PCMCIA_DIR)/.configured
	$(MAKE) \
		CC=$(TARGET_CC) \
		UCC=$(TARGET_CC) \
		KCC=$(TARGET_CC) \
		-C $(PCMCIA_DIR) \
		all
	-A=`find $(PCMCIA_DIR) -type f -perm +111` ; \
	for fo in $$A; do \
		file $$fo | grep "ELF" | grep "executable" > /dev/null 2>&1; \
		if [ $$? = 0 ] ; then \
			$(STRIP) $$fo; \
		fi; \
	done
	touch -c $(PCMCIA_DIR)/cardmgr/cardmgr

$(TARGET_DIR)/sbin/cardmgr: $(PCMCIA_DIR)/cardmgr/cardmgr
	rm -rf $(TARGET_DIR)/etc/pcmcia;
	$(MAKE) PREFIX=$(TARGET_DIR) -C $(PCMCIA_DIR) install
	rm -rf $(TARGET_DIR)/usr/X11R6/man;
	rm -f $(TARGET_DIR)/usr/share/pnp.ids $(TARGET_DIR)/sbin/lspnp $(TARGET_DIR)/sbin/setpnp;
	rm -f $(TARGET_DIR)/usr/X11R6/bin/xcardinfo
	#cp -f $(PCMCIA_DIR)/etc/rc.pcmcia $(TARGET_DIR)/etc/init.d/pcmcia
	#chmod a+x $(TARGET_DIR)/etc/init.d/pcmcia
	chmod -R u+w $(TARGET_DIR)/etc/pcmcia/*
	install -d $(DOC_DIR)/doc/pcmcia-cs
	for f in BUGS COPYING LICENSE README README-2.4 SUPPORTED.CARDS \
		 	doc/PCMCIA-HOWTO doc/PCMCIA-PROG ; do \
		install -m0644 $(PCMCIA_DIR)/$$f $(DOC_DIR)/doc/pcmcia-cs/`basename $$f` ; \
	done		

# use busybox depmod.pl so we need the sources unpacked
$(PCMCIA_DIR)/.modules.dep: $(BUSYBOX_DIR)/.configured $(TARGET_DIR)/lib/modules
	[ -d $(TARGET_DIR)/lib/modules/$(LINUX_VERSION) ] && \
	$(BUSYBOX_DIR)/examples/depmod.pl \
		-b $(TARGET_DIR)/lib/modules/$(LINUX_VERSION)/ \
		-k $(LINUX_DIR)/vmlinux \
		-F $(LINUX_DIR)/System.map \
		> $(TARGET_DIR)/lib/modules/$(LINUX_VERSION)/modules.dep
	touch $(PCMCIA_DIR)/.modules.dep

pcmcia: uclibc $(TARGET_DIR)/sbin/cardmgr

pcmcia-cs: pcmcia

pcmcia-clean:
	-rm -f $(TARGET_DIR)/sbin/cardmgr
	-rm -rf $(DOC_DIR)/doc/pcmcia-cs
	-$(MAKE) -C $(PCMCIA_DIR) clean

pcmcia-dirclean:
	rm -rf $(PCMCIA_DIR)
