#############################################################
#
# sox
#
#############################################################

ifneq ($(USE_CVS), true)
SOX_SOURCE:=sox.tar.gz
SOX_CAT:=zcat
endif

SOX_DIR:=$(BUILD_DIR)/sox
SOX_BINARY:=sox
SOX_TARGET_BINARY:=usr/bin/sox

ifneq ($(USE_CVS),true)
$(DL_DIR)/$(SOX_SOURCE):

sox-source: $(DL_DIR)/$(SOX_SOURCE)
else
sox-source:
endif

SOX_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d sox $(CVS_TAG) $(CVS_PREFIX)sox

sox-checkout:
	@$(SOX_CVSCO)

$(SOX_DIR)/.unpacked: $(DL_DIR)/$(SOX_SOURCE)
ifneq ($(USE_CVS), true)
	$(SOX_CAT) $(DL_DIR)/$(SOX_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SOX_CVSCO)
endif
	-cat $(SOURCE_DIR)/sox.patch | patch -d $(SOX_DIR)
	touch  $(SOX_DIR)/.unpacked

$(SOX_DIR)/.configured: $(SOX_DIR)/.unpacked
	cp $(SOURCE_DIR)/config.sub $(SOX_DIR)
	cd $(SOX_DIR); \
        rm -rf config.cache; \
	$(TARGET_CONFIGURE_OPTS) \
	CFLAGS="$(TARGET_CFLAGS)" \
	./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=/usr \
		--exec-prefix=/usr \
		--bindir=/usr/bin \
		--sbindir=/usr/sbin \
		--libexecdir=/usr/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share/misc \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info
	touch $(SOX_DIR)/.configured

$(SOX_DIR)/$(SOX_BINARY): $(SOX_DIR)/.configured
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(SOX_DIR)

$(TARGET_DIR)/$(SOX_TARGET_BINARY): $(SOX_DIR)/$(SOX_BINARY)

sox: uclibc $(TARGET_DIR)/$(SOX_TARGET_BINARY)
	$(MAKE) $(TARGET_CONFIGURE_OPTS) DESTDIR=$(TARGET_DIR) -C $(SOX_DIR) install
	$(MAKE) $(TARGET_CONFIGURE_OPTS) DESTDIR=$(STAGING_DIR) -C $(SOX_DIR) install
sox-clean:
	$(MAKE) DESTDIR=$(TARGET_DIR) -C $(SOX_DIR) uninstall
	-$(MAKE) DESTDIR=$(STAGING_DIR) -C $(SOX_DIR) uninstall
	-$(MAKE) -C $(SOX_DIR) clean

sox-dirclean:
	rm -rf $(SOX_DIR)

