//  GPars (formerly GParallelizer)
//
//  Copyright © 2008-9  The original author or authors
//
//  Licensed under the Apache License, Version 2.0 (the "License");
//  you may not use this file except in compliance with the License.
//  You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License. 

package groovyx.gpars.actor.impl;

/**
 * An exception indicating end of a work chunk (ActorAction) allowing other ActorAction to get scheduled.
 * Implementing singleton pattern, ActorException holds the unique reference.
 *
 * @author Vaclav Pech
 *         Date: Feb 17, 2009
 */
public final class ActorContinuationException extends ActorException {
    private static final long serialVersionUID = -4978264308794524512L;

    ActorContinuationException() {
    }
}
