/*
 * @(#)MousePressedCaptureEvent.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.uicapture.v1.event;

import java.awt.Robot;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;


/**
 * An event object which stores a capture event.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   Jan 4, 2002
 */
public abstract class MouseCaptureEvent extends CaptureEvent
{
    protected static final int BUTTON_MASK =
        InputEvent.BUTTON1_MASK |
        InputEvent.BUTTON2_MASK |
        InputEvent.BUTTON3_MASK;
    
    
    public MouseCaptureEvent( int type, MouseEvent event )
    {
        super( type, (InputEvent)event );
    }
    
    
    public MouseCaptureEvent( int type )
    {
        super( type );
    }
    
    
    public MouseEvent getMouseEvent()
    {
        return (MouseEvent)getInputEvent();
    }
    
    
    /**
     * Ensure the Robot is not null.
     */
    public void performEvent( Robot r )
    {
        if (r == null)
        {
            throw new IllegalArgumentException( "no null args" );
        }
    }
}

