## Primitive values

The [Mozilla docs for "Primitive values"](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Data_structures#Primitive_values) defines specifies six data types that are primitives:

- `Boolean`
- `Null`
- `Undefined`
- `Number`
- `String`
- `Symbol` (new in ECMAScript 6)

## Usage

```js
var isPrimitive = require('{%= name %}');
```

## true

All of the following return `true`:

```js
console.log(isPrimitive(false));
console.log(isPrimitive(true));
console.log(isPrimitive(null));
console.log(isPrimitive());
console.log(isPrimitive(42));
console.log(isPrimitive('abc'));
console.log(isPrimitive(Symbol()));
//=> true
```

## false

Everything else returns `false`:

```js
console.log(isPrimitive({}));
console.log(isPrimitive([]));
console.log(isPrimitive(function(){}));
console.log(isPrimitive(new Date()));
// et cetera...
//=> false
```
