// Chunked File library
var library2commonValue = library2common;

describe("library2", function() {
	var tickExtra, tickEmpty, tickMerged;
	var extraValue, testValue;

	beforeAll(function(done) {
		var asnycOk = false, asnycOk2 = false;
		var sameTick1 = true;
		require.ensure(["./extra"], function(require) {
			asnycOk = true;
			tickExtra = sameTick1;
			var sameTick2 = true;
			require.ensure([], function(require) {
				asnycOk2 = true;
				extraValue = require("./extra");
				tickEmpty = sameTick2;
				require.ensure(["./test.js"], function(require) {
					tickMerged = sameTick2;
					testValue = require("./test.js");
					done();
				});
			});
			Promise.resolve().then(function() {}).then(function() {}).then(function() {
				sameTick2 = false;
			});
		});
		Promise.resolve().then(function() {}).then(function() {}).then(function() {
			sameTick1 = false;
		});
	});


	it("should run after common", function() {
		expect(library2commonValue).toEqual({ok2: true});
	});

	it("should load stuff with require.ensure asynchron", function() {
		expect(tickExtra).toBe(false);
	});

	it("should load not include stuff from parent, remove empty chunks and apply a post loader", function() {
		expect(tickEmpty).toBe(true);
		expect(extraValue).toBe("Lib2 extra2 with post loader");
	});

	it("should merge chunks if maxChunks specified", function() {
		expect(tickEmpty).toBe(true);
		expect(testValue).toBe("test module");
	});

	it("should load require.amd from options", function() {
		expect(require.amd.fromOptions).toBe(true);
	});

	it("should run empty AMD require", function(done) {
		var emptyRequire = false;
		require([], function() {
			emptyRequire = true;
		});
		Promise.resolve().then(function() {}).then(function() {}).then(function() {
			expect(emptyRequire).toBe(true);
			done();
		});
	});

	it("should provide free variables", function() {
		expect(s3()).toBe("submodule3");
	});

	it("should define values", function() {
		expect(CONST_UNDEFINED === undefined).toBe(true);
		expect(CONST_NULL === null).toBe(true);
		expect(CONST_TRUE).toBe(true);
		expect(CONST_FALSE).toBe(false);
		expect(CONST_FUNCTION()).toBe("ok");
		expect(CONST_NUMBER).toBe(123);
		expect(CONST_NUMBER_EXPR).toBe(123);
		expect(typeof CONST_TYPEOF).toBe("typeof");

		var o = CONST_OBJECT;
		expect(CONST_OBJECT.A).toBe(1);
		expect(CONST_OBJECT.B).toBe("B");
		expect(CONST_OBJECT.C()).toBe("C");
		expect(o.A).toBe(1);
		expect(o.B).toBe("B");
		expect(o.C()).toBe("C");
		(function(o) {
			expect(o.A).toBe(1);
			expect(o.B).toBe("B");
			expect(o.C()).toBe("C");
		}(CONST_OBJECT));

		if(CONST_FALSE) require("fail");
		if(!CONST_TRUE) require("fail");
		if(!CONST_NUMBER) require("fail");
		if(!CONST_NUMBER_EXPR) require("fail");
		if(typeof CONST_TYPEOF !== "typeof") require("fail");
		if(typeof CONST_FALSE !== "boolean") require("fail");
		if(typeof CONST_FUNCTION !== "function") require("fail");
		if(typeof CONST_OBJECT !== "object") require("fail");
		if(!CONST_OBJECT.A) require("fail");
		if(typeof CONST_OBJECT.A !== "number") require("fail");
	});
});
exports.library2 = {ok: true};

// it should not fail if comment in last line
