# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VerificationCodeResponseProperties(Model):
    """VerificationCodeResponseProperties.

    :param verification_code: Verification code.
    :type verification_code: str
    :param subject: Certificate subject.
    :type subject: str
    :param expiry: Code expiry.
    :type expiry: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param is_verified: Indicate if the certificate is verified by owner of
     private key.
    :type is_verified: bool
    :param created: Certificate created time.
    :type created: str
    :param updated: Certificate updated time.
    :type updated: str
    """

    _attribute_map = {
        'verification_code': {'key': 'verificationCode', 'type': 'str'},
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'str'},
        'updated': {'key': 'updated', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(VerificationCodeResponseProperties, self).__init__(**kwargs)
        self.verification_code = kwargs.get('verification_code', None)
        self.subject = kwargs.get('subject', None)
        self.expiry = kwargs.get('expiry', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.is_verified = kwargs.get('is_verified', None)
        self.created = kwargs.get('created', None)
        self.updated = kwargs.get('updated', None)
