# Parsl Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as
contributors and maintainers pledge to making participation in our project and
our community a harassment-free and bullying-free experience for everyone, regardless of age, body
size, disability, ethnicity, sex characteristics, gender identity and expression,
level of experience, education, socio-economic status, nationality, personal
appearance, race, religion, or sexual identity and orientation.

Discussions relating to pros/cons of various technologies, programming languages, and so on are welcome,
but these should be done with respect, taking proactive measure to ensure that all participants are heard
and feel confident that they can freely express their opinions.

We pledge to welcome questions and answer them respectfully, paying particular attention to those new to
the community. We pledge to provide respectful criticisms and feedback in forums, especially in discussion
threads resulting from code contributions.

We pledge to be conscientious of the perceptions of the wider community and to respond to criticism respectfully.
We will strive to model behaviors that encourage productive debate and disagreement, both within our community
and where we are criticized. We will treat those outside our community with the same respect as people within
our community.

We pledge to help the entire community follow the code of conduct, and to not remain silent when we see violations
of the code of conduct. We will take action when members of our community violate this code such as contacting
<a href="mailto:parsl-coc@googlegroups.com">parsl-coc@googlegroups.com</a> (all emails sent to this address will be treated with the strictest confidence)
or talking privately with the person.

## Our Standards

Examples of behavior that contributes to creating a positive environment
include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members
* Respecting the work of others by recognizing acknowledgment/citation requests of original authors
* Being explicit about how we want our own work to be cited or acknowledged

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or
 advances
* Sexist, racist, or otherwise exclusionary jokes
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic
 address, without explicit permission
* Other conduct which could reasonably be considered inappropriate in a
 professional setting
 
## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable
behavior and are expected to take appropriate and fair corrective action in
response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or
reject comments, commits, code, wiki edits, issues, and other contributions
that are not aligned to this Code of Conduct, or to ban temporarily or
permanently any contributor for other behaviors that they deem inappropriate,
threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces
when an individual is representing the project or its community. Examples of
representing a project or community include using an official project e-mail
address, posting via an official social media account, or acting as an appointed
representative at an online or offline event. Representation of a project may be
further defined and clarified by project maintainers.

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be
reported by contacting the project team at <a href="mailto:parsl-coc@googlegroups.com">parsl-coc@googlegroups.com</a>. All
complaints will be reviewed and investigated and will result in a response that
is deemed necessary and appropriate to the circumstances. The project team is
obligated to maintain confidentiality with regard to the reporter of an incident.
Further details of specific enforcement policies may be posted separately.

Project maintainers who do not follow or enforce the Code of Conduct in good
faith may face temporary or permanent repercussions as determined by other
members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant](https://www.contributor-covenant.org), version 1.4,
available at https://www.contributor-covenant.org/version/1/4/code-of-conduct.html,
and the [yt-project](https://yt-project.org)'s Code of Conduct.
