/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import javax.swing.tree.TreePath;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.FixedListDetailPane;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.util.ExtendedJLabel;

public class GeneralDetailPane
extends FixedListDetailPane {
    private ExtendedJLabel lblMinorVersion;
    private ExtendedJLabel lblMajorVersion;
    private ExtendedJLabel lblConstantPoolCount;
    private ExtendedJLabel lblAccessFlags;
    private ExtendedJLabel lblAccessFlagsVerbose;
    private ExtendedJLabel lblThisClass;
    private ExtendedJLabel lblThisClassVerbose;
    private ExtendedJLabel lblSuperClass;
    private ExtendedJLabel lblSuperClassVerbose;
    private ExtendedJLabel lblInterfacesCount;
    private ExtendedJLabel lblFieldsCount;
    private ExtendedJLabel lblMethodsCount;
    private ExtendedJLabel lblAttributesCount;

    public GeneralDetailPane(BrowserServices browserServices) {
        super(browserServices);
    }

    protected void setupLabels() {
        this.lblMinorVersion = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Minor version:"), this.lblMinorVersion);
        this.lblMajorVersion = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Major version:"), this.lblMajorVersion);
        this.lblConstantPoolCount = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Constant pool count:"), this.lblConstantPoolCount);
        this.lblAccessFlags = this.highlightLabel();
        this.lblAccessFlagsVerbose = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Access flags:"), this.lblAccessFlags, this.lblAccessFlagsVerbose);
        this.lblThisClass = this.linkLabel();
        this.lblThisClassVerbose = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("This class:"), this.lblThisClass, this.lblThisClassVerbose);
        this.lblSuperClass = this.linkLabel();
        this.lblSuperClassVerbose = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Super class:"), this.lblSuperClass, this.lblSuperClassVerbose);
        this.lblInterfacesCount = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Interfaces count:"), this.lblInterfacesCount);
        this.lblFieldsCount = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Fields count:"), this.lblFieldsCount);
        this.lblMethodsCount = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Methods count:"), this.lblMethodsCount);
        this.lblAttributesCount = this.highlightLabel();
        this.addDetailPaneEntry(this.normalLabel("Attributes count:"), this.lblAttributesCount);
    }

    public void show(TreePath treePath) {
        ClassFile classFile = this.services.getClassFile();
        this.lblMinorVersion.setText(classFile.getMinorVersion());
        this.lblMajorVersion.setText(classFile.getMajorVersion());
        this.lblConstantPoolCount.setText(classFile.getConstantPool().length);
        this.lblAccessFlags.setText(classFile.getFormattedAccessFlags());
        this.lblAccessFlagsVerbose.setText("[" + classFile.getAccessFlagsVerbose() + "]");
        this.constantPoolHyperlink(this.lblThisClass, this.lblThisClassVerbose, classFile.getThisClass());
        this.constantPoolHyperlink(this.lblSuperClass, this.lblSuperClassVerbose, classFile.getSuperClass());
        this.lblInterfacesCount.setText(classFile.getInterfaces().length);
        this.lblFieldsCount.setText(classFile.getFields().length);
        this.lblMethodsCount.setText(classFile.getMethods().length);
        this.lblAttributesCount.setText(classFile.getAttributes().length);
        super.show(treePath);
    }
}

