/*
 * libexplain - Explain errno values returned by libc functions
 * Copyright (C) 2008, 2009 Peter Miller
 * Written by Peter Miller <pmiller@opensource.org.au>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <libexplain/ac/sys/resource.h>

#include <libexplain/buffer/rlimit.h>
#include <libexplain/string_buffer.h>


void
explain_buffer_rlimit(explain_string_buffer_t *sb, const struct rlimit *p)
{
    explain_string_buffer_puts(sb, "{ rlim_cur = ");
    if (p->rlim_cur == RLIM_INFINITY)
        explain_string_buffer_puts(sb, "RLIM_INFINITY");
    else
        explain_string_buffer_printf(sb, "%lld", (long long)p->rlim_cur);
    if (p->rlim_cur != p->rlim_max)
    {
        explain_string_buffer_puts(sb, ", rlim_max = ");
        if (p->rlim_max == RLIM_INFINITY)
            explain_string_buffer_puts(sb, "RLIM_INFINITY");
        else
            explain_string_buffer_printf(sb, "%lld", (long long)p->rlim_max);
    }
    explain_string_buffer_puts(sb, " }");
}
