package de.intarsys.tools.logging;

import java.util.logging.Filter;
import java.util.logging.LogRecord;

/**
 * Only accept log requests within a dedicated thread.
 * 
 */
public class SingleThreadFilter implements Filter {

	final private Thread thread;

	public SingleThreadFilter() {
		this(Thread.currentThread());
	}

	public SingleThreadFilter(Thread thread) {
		super();
		this.thread = thread;
	}

	public boolean isLoggable(LogRecord record) {
		return thread == Thread.currentThread();
	}

}
