/*
 * Copyright (c) 2005-2009 Laf-Widget Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Laf-Widget Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.lafwidget.animation;

/**
 * Callback for the fade tracker. Is used when the application (some UI
 * delegate) wishes to execute some code on the fade.
 * 
 * @author Kirill Grouchnikov
 */
public interface FadeTrackerCallback {
	/**
	 * Indicates that a single cycle of fade has been performed. Can be used in
	 * order to repaint specific portion of the component.
	 * 
	 * @param fadeKind
	 *            Fade animation kind.
	 * @param fadeCycle
	 *            The current fade cycle. Is guaranteed to be in 0.0-1.0 range.
	 */
	public void fadePerformed(FadeKind fadeKind, float fadeCycle);

	/**
	 * Indicates that the fade sequence has ended. Can be used in order to
	 * repaint specific portion of the component.
	 * 
	 * @param fadeKind
	 *            Fade animation kind.
	 */
	public void fadeEnded(FadeKind fadeKind);

	/**
	 * Indicates that the fade sequence has been reversed. This can happen, for
	 * example, when the user moves the mouse over a button (rollover fade) and
	 * then quickly moves the mouse out. In this case, the fade sequence is
	 * reverted halfway.
	 * 
	 * 
	 * @param fadeKind
	 *            Fade animation kind.
	 * @param isFadingIn
	 *            Indicates the <b>new</b> direction of fade.
	 * @param fadeCycle
	 *            Indicates the <b>new</b> value of fade cycle.
	 */
	public void fadeReversed(FadeKind fadeKind, boolean isFadingIn,
			float fadeCycle);
}