/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.Configuration$Visibility;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;

public final class BundleInfoAdapter {
    private static Configuration CONF_DEFAULT = new Configuration("default");
    private static Configuration CONF_OPTIONAL = new Configuration("optional", Configuration$Visibility.PUBLIC, "Optional dependencies", new String[]{"default"}, true, null);
    private static Configuration CONF_TRANSITIVE_OPTIONAL = new Configuration("transitive-optional", Configuration$Visibility.PUBLIC, "Optional dependencies", new String[]{"optional"}, true, null);

    public static DefaultModuleDescriptor toModuleDescriptor$38c3a6(ModuleDescriptorParser moduleDescriptorParser, BundleInfo bundleInfo, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        String[] stringArray;
        Object object;
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleDescriptorParser, null);
        defaultModuleDescriptor.addExtraAttributeNamespace("o", Ivy.getIvyHomeURL() + "osgi");
        Version version = bundleInfo.getVersion();
        String string = bundleInfo.getSymbolicName();
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance("bundle", string, version == null ? null : version.toString());
        defaultModuleDescriptor.setResolvedPublicationDate(new Date());
        defaultModuleDescriptor.setModuleRevisionId(moduleRevisionId);
        defaultModuleDescriptor.addConfiguration(CONF_DEFAULT);
        defaultModuleDescriptor.addConfiguration(CONF_OPTIONAL);
        defaultModuleDescriptor.addConfiguration(CONF_TRANSITIVE_OPTIONAL);
        HashSet<String> hashSet = new HashSet<String>(bundleInfo.getExports().size());
        Iterator iterator = bundleInfo.getExports().iterator();
        while (iterator.hasNext()) {
            object = (ExportPackage)iterator.next();
            defaultModuleDescriptor.getExtraInfo().put("_osgi_export_" + ((BundleCapability)object).getName(), ((ExportPackage)object).getVersion().toString());
            hashSet.add(((BundleCapability)object).getName());
            stringArray = new String[((ExportPackage)object).getUses().size() + 1];
            int n = 0;
            Iterator iterator2 = ((ExportPackage)object).getUses().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                stringArray[n++] = "use_" + string2;
            }
            stringArray[n] = "default";
            defaultModuleDescriptor.addConfiguration(new Configuration("use_" + ((BundleCapability)object).getName(), Configuration$Visibility.PUBLIC, "Exported package " + ((BundleCapability)object).getName(), stringArray, true, null));
        }
        BundleInfoAdapter.requirementAsDependency(defaultModuleDescriptor, bundleInfo, hashSet);
        object = bundleInfo.getUri();
        if (object != null) {
            if ("ivy".equals(((URI)object).getScheme())) {
                stringArray = BundleInfoAdapter.decodeIvyURI((URI)object);
            } else {
                if (!((URI)object).isAbsolute()) {
                    object = ((URI)null).resolve((URI)object);
                }
                try {
                    stringArray = new DefaultArtifact(moduleRevisionId, null, bundleInfo.getSymbolicName(), "jar", "jar", new URL(((URI)object).toString()), null);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException("Unable to make the uri into the url", malformedURLException);
                }
            }
            if (stringArray != null) {
                defaultModuleDescriptor.addArtifact("default", (Artifact)stringArray);
            }
        }
        return defaultModuleDescriptor;
    }

    private static DefaultArtifact decodeIvyURI(URI uRI) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = uRI.getPath();
        if (!string6.startsWith("/")) {
            throw new IllegalArgumentException("An ivy url should be of the form ivy:///org/module but was : " + uRI);
        }
        int n = string6.indexOf(47, 1);
        if (n < 0) {
            throw new IllegalArgumentException("Expecting an organisation in the ivy url: " + uRI);
        }
        String string7 = string6.substring(1, n);
        String string8 = string6.substring(n + 1);
        String[] stringArray = uRI.getQuery().split("&");
        for (int i = 0; i < stringArray.length; ++i) {
            String string9 = stringArray[i];
            if (string9.length() == 0) continue;
            String[] stringArray2 = string9.split("=");
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException("Malformed query string in the ivy url: " + uRI);
            }
            if (stringArray2[0].equals("branch")) {
                string = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals("rev")) {
                string2 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals("art")) {
                string3 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals("type")) {
                string4 = stringArray2[1];
                continue;
            }
            if (stringArray2[0].equals("ext")) {
                string5 = stringArray2[1];
                continue;
            }
            throw new IllegalArgumentException("Unrecognized parameter '" + stringArray2[0] + " in the query string of the ivy url: " + uRI);
        }
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string7, string8, string, string2);
        return new DefaultArtifact(moduleRevisionId, null, string3, string4, string5, 0);
    }

    private static void requirementAsDependency(DefaultModuleDescriptor defaultModuleDescriptor, BundleInfo bundleInfo, Set set) {
        Iterator iterator = bundleInfo.getRequirements().iterator();
        while (iterator.hasNext()) {
            BundleRequirement bundleRequirement = (BundleRequirement)iterator.next();
            String string = bundleRequirement.getType();
            String string2 = bundleRequirement.getName();
            if ("package".equals(string) && set.contains(string2)) continue;
            VersionRange versionRange = bundleRequirement.getVersion();
            String string3 = string2;
            String string4 = string;
            String string5 = versionRange == null ? "[0,)" : versionRange.toIvyRevision();
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string4, string3, string5);
            DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(moduleRevisionId, false, 0);
            String string6 = "default";
            if ("package".equals(string)) {
                string6 = "use_" + string2;
                defaultModuleDescriptor.addConfiguration(new Configuration("use_" + string2, Configuration$Visibility.PUBLIC, "Exported package " + string2, new String[]{"default"}, true, null));
                defaultDependencyDescriptor.addDependencyConfiguration(string6, string6);
            }
            if ("optional".equals(bundleRequirement.getResolution())) {
                defaultDependencyDescriptor.addDependencyConfiguration("optional", string6);
                defaultDependencyDescriptor.addDependencyConfiguration("transitive-optional", "transitive-optional");
            } else {
                defaultDependencyDescriptor.addDependencyConfiguration("default", string6);
            }
            defaultModuleDescriptor.addDependency(defaultDependencyDescriptor);
        }
    }
}

