# RUN: llvm-mc %s -triple=mips64-unknown-linux -show-encoding -mcpu=mips64r2 | \
# RUN:   FileCheck %s
# RUN: llvm-mc %s -triple=mips64-unknown-linux -show-encoding -mcpu=mips64r6 | \
# RUN:   FileCheck %s

bits_32_to_47_0x0000:           # CHECK-LABEL: bits_32_to_47_0x0000:
dli $5, 0x0000000000000001      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
dli $5, 0x0000000000000002      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
dli $5, 0x0000000000004000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
dli $5, 0x0000000000008000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
dli $5, 0x00000000ffff8000      # CHECK: ori $5, $zero, 65535        # encoding: [0x34,0x05,0xff,0xff]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x00000000ffffc000      # CHECK: ori $5, $zero, 65535        # encoding: [0x34,0x05,0xff,0xff]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 49152           # encoding: [0x34,0xa5,0xc0,0x00]
dli $5, 0x00000000fffffffe      # CHECK: ori $5, $zero, 65535        # encoding: [0x34,0x05,0xff,0xff]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 65534           # encoding: [0x34,0xa5,0xff,0xfe]
dli $5, 0x00000000ffffffff      # CHECK: lui $5, 65535               # encoding: [0x3c,0x05,0xff,0xff]
                                # CHECK: dsrl32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3e]
dli $5, 0x0000000000010000      # CHECK: lui $5, 1                   # encoding: [0x3c,0x05,0x00,0x01]
dli $5, 0x0000000000020000      # CHECK: lui $5, 2                   # encoding: [0x3c,0x05,0x00,0x02]
dli $5, 0x0000000040000000      # CHECK: lui $5, 16384               # encoding: [0x3c,0x05,0x40,0x00]
dli $5, 0x0000000080000000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x00000000c0000000      # CHECK: ori $5, $zero, 49152        # encoding: [0x34,0x05,0xc0,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x00000000fffe0000      # CHECK: ori $5, $zero, 65534        # encoding: [0x34,0x05,0xff,0xfe]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x00000000ffff0000      # CHECK: ori $5, $zero, 65535        # encoding: [0x34,0x05,0xff,0xff]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000000000010001      # CHECK: lui $5, 1                   # encoding: [0x3c,0x05,0x00,0x01]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000000020001      # CHECK: lui $5, 2                   # encoding: [0x3c,0x05,0x00,0x02]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000040000001      # CHECK: lui $5, 16384               # encoding: [0x3c,0x05,0x40,0x00]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000080000001      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000000010002      # CHECK: lui $5, 1                   # encoding: [0x3c,0x05,0x00,0x01]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000000020002      # CHECK: lui $5, 2                   # encoding: [0x3c,0x05,0x00,0x02]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000040000002      # CHECK: lui $5, 16384               # encoding: [0x3c,0x05,0x40,0x00]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000080000002      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000000014000      # CHECK: lui $5, 1                   # encoding: [0x3c,0x05,0x00,0x01]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000000024000      # CHECK: lui $5, 2                   # encoding: [0x3c,0x05,0x00,0x02]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000040004000      # CHECK: lui $5, 16384               # encoding: [0x3c,0x05,0x40,0x00]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000080004000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000000018000      # CHECK: lui $5, 1                   # encoding: [0x3c,0x05,0x00,0x01]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000000028000      # CHECK: lui $5, 2                   # encoding: [0x3c,0x05,0x00,0x02]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000040008000      # CHECK: lui $5, 16384               # encoding: [0x3c,0x05,0x40,0x00]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000080008000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x00000000c0008000      # CHECK: ori $5, $zero, 49152        # encoding: [0x34,0x05,0xc0,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x00000000fffe8000      # CHECK: ori $5, $zero, 65534        # encoding: [0x34,0x05,0xff,0xfe]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x00000000ffff8000      # CHECK: ori $5, $zero, 65535        # encoding: [0x34,0x05,0xff,0xff]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
bits_32_to_47_0x0001:           # CHECK-LABEL: bits_32_to_47_0x0001:
dli $5, 0x0000000100000000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 17             # encoding: [0x00,0x05,0x2c,0x78]
dli $5, 0x0000000100000001      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000100000002      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000100004000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000100008000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000100010000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000000100010001      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000100010002      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000100014000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000100018000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000100020000      # CHECK: ori $5, $zero, 32769        # encoding: [0x34,0x05,0x80,0x01]
                                # CHECK: dsll $5, $5, 17             # encoding: [0x00,0x05,0x2c,0x78]
dli $5, 0x0000000100020001      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000100020002      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000100024000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000100028000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000140000000      # CHECK: ori $5, $zero, 40960        # encoding: [0x34,0x05,0xa0,0x00]
                                # CHECK: dsll $5, $5, 17             # encoding: [0x00,0x05,0x2c,0x78]
dli $5, 0x0000000140000001      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000140000002      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000140004000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000140008000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000180000000      # CHECK: ori $5, $zero, 49152        # encoding: [0x34,0x05,0xc0,0x00]
                                # CHECK: dsll $5, $5, 17             # encoding: [0x00,0x05,0x2c,0x78]
dli $5, 0x0000000180000001      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000180000002      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000180004000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000180008000      # CHECK: addiu $5, $zero, 1          # encoding: [0x24,0x05,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
bits_32_to_47_0x0002:           # CHECK-LABEL: bits_32_to_47_0x0002:
dli $5, 0x0000000200000000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 18             # encoding: [0x00,0x05,0x2c,0xb8]
dli $5, 0x0000000200000001      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000200000002      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000200004000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000200008000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000200010000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000000200010001      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000200010002      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000200014000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000200018000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000200020000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000000200020001      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000200020002      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000200024000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000200028000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000240000000      # CHECK: ori $5, $zero, 36864        # encoding: [0x34,0x05,0x90,0x00]
                                # CHECK: dsll $5, $5, 18             # encoding: [0x00,0x05,0x2c,0xb8]
dli $5, 0x0000000240000001      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000240000002      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000240004000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000240008000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000000280000000      # CHECK: ori $5, $zero, 40960        # encoding: [0x34,0x05,0xa0,0x00]
                                # CHECK: dsll $5, $5, 18             # encoding: [0x00,0x05,0x2c,0xb8]
dli $5, 0x0000000280000001      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000000280000002      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000000280004000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000000280008000      # CHECK: addiu $5, $zero, 2          # encoding: [0x24,0x05,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
bits_32_to_47_0x4000:           # CHECK-LABEL: bits_32_to_47_0x4000:
dli $5, 0x0000400000000000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 31             # encoding: [0x00,0x05,0x2f,0xf8]
dli $5, 0x0000400000000001      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000400000000002      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000400000004000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000400000008000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000400000010000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000400000010001      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000400000010002      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000400000014000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000400000018000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000400000020000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000400000020001      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000400000020002      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000400000024000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000400000028000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000400040000000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000400040000001      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000400040000002      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000400040004000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000400040008000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000400080000000      # CHECK: ori $5, $zero, 32769        # encoding: [0x34,0x05,0x80,0x01]
                                # CHECK: dsll $5, $5, 31             # encoding: [0x00,0x05,0x2f,0xf8]
dli $5, 0x0000400080000001      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000400080000002      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000400080004000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000400080008000      # CHECK: addiu $5, $zero, 16384      # encoding: [0x24,0x05,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
bits_32_to_47_0x8000:           # CHECK-LABEL: bits_32_to_47_0x8000:
dli $5, 0x0000800000000000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 32             # encoding: [0x00,0x05,0x28,0x3c]
dli $5, 0x0000800000000001      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000800000000002      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000800000004000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000800000008000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll32 $5, $5, 0            # encoding: [0x00,0x05,0x28,0x3c]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000800000010000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000800000010001      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000800000010002      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000800000014000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000800000018000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000800000020000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000800000020001      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000800000020002      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000800000024000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000800000028000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000800040000000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000800040000001      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000800040000002      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000800040004000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000800040008000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0000800080000000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
dli $5, 0x0000800080000001      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 1               # encoding: [0x34,0xa5,0x00,0x01]
dli $5, 0x0000800080000002      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 2               # encoding: [0x34,0xa5,0x00,0x02]
dli $5, 0x0000800080004000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 16384           # encoding: [0x34,0xa5,0x40,0x00]
dli $5, 0x0000800080008000      # CHECK: ori $5, $zero, 32768        # encoding: [0x34,0x05,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
# Only test a few with bits 48-63 non-zero. It just adds an lui to the cases we've already done.
dli $5, 0x0001800080008000      # CHECK: lui $5, 1                   # encoding: [0x3c,0x05,0x00,0x01]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x0002800080008000      # CHECK: lui $5, 2                   # encoding: [0x3c,0x05,0x00,0x02]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x4000800080008000      # CHECK: lui $5, 16384               # encoding: [0x3c,0x05,0x40,0x00]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
dli $5, 0x8000800080008000      # CHECK: lui $5, 32768               # encoding: [0x3c,0x05,0x80,0x00]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
                                # CHECK: dsll $5, $5, 16             # encoding: [0x00,0x05,0x2c,0x38]
                                # CHECK: ori $5, $5, 32768           # encoding: [0x34,0xa5,0x80,0x00]
