#include "test.h"

#include "match.h"

TEST_CASE("commit match present") {
	Match m(Match::ANCHOR_NONE);
	Match ml(Match::ANCHOR_LEFT);
	Match mr(Match::ANCHOR_RIGHT);
	m.commit_keyword("hello");
	// start
	CHECK(m.is_match("hello there!"));
	// middle
	m.commit_keyword("lo th");
	CHECK(m.is_match("hello there!"));
	// multi
	m.commit_keyword("e");
	CHECK(m.is_match("hello there!"));
	// end
	m.commit_keyword("there!");
	CHECK(m.is_match("hello there!"));

	// anchor present
	ml.commit_keyword("hello");
	CHECK(ml.is_match("hello there!"));
	mr.commit_keyword("here!");
	CHECK(mr.is_match("hello there!"));

	// in middle
	ml.commit_keyword("lo");
	mr.commit_keyword("lo");
	CHECK(!ml.is_match("hello there!"));
	CHECK(!mr.is_match("hello there!"));

	// at other end
	ml.commit_keyword("there!");
	mr.commit_keyword("hello");
	CHECK(!ml.is_match("hello there!"));
	CHECK(!mr.is_match("hello there!"));
}

TEST_CASE("commit case sensitivity") {
	Match m(0);
	Match ml(Match::ANCHOR_LEFT);
	Match mr(Match::ANCHOR_RIGHT);

	m.commit_keyword("heLLo");
	CHECK(m.is_match("hi heLLo there!"));
	m.commit_keyword("HELLO");
	CHECK(!m.is_match("hi heLLo there!"));
	m = Match(0);
	m.commit_keyword("hello");
	CHECK(m.is_match("hi HeLLo there!"));
	CHECK(m.is_match("hi HELLO there!"));
	m.commit_keyword("Hello");
	CHECK(!m.is_match("hi HELLO there!"));
	CHECK(m.is_match("hi Hello there!"));

	ml.commit_keyword("Hello");
	mr.commit_keyword("Hello");
	CHECK(ml.is_match("Hello there!"));
	CHECK(!ml.is_match("HellO there!"));
	CHECK(mr.is_match("a big Hello"));
	CHECK(!mr.is_match("a big HellO"));
}

TEST_CASE("commit match not present") {
	Match m(Match::ANCHOR_NONE);
	Match ml(Match::ANCHOR_LEFT);
	Match mr(Match::ANCHOR_RIGHT);
	m.commit_keyword("hello");
	ml.commit_keyword("hello");
	mr.commit_keyword("hello");
	CHECK(!m.is_match("hi there!"));
	CHECK(!ml.is_match("hi there!"));
	CHECK(!mr.is_match("hi there!"));
}
