macro(summary)
STRING(TOUPPER "${CMAKE_BUILD_TYPE}" buildtype)
IF (CMAKE_C_FLAGS)
  SET(cfsp " ")
ENDIF(CMAKE_C_FLAGS)
IF (CMAKE_CXX_FLAGS)
  SET(cxxfsp " ")
ENDIF(CMAKE_CXX_FLAGS)
MESSAGE(STATUS "")
MESSAGE(STATUS "PfTools Software Suite configuration summary:")
MESSAGE(STATUS "")
MESSAGE(STATUS "  System name ......................: ${CMAKE_SYSTEM_NAME}")
MESSAGE(STATUS "  Build type .......................: ${CMAKE_BUILD_TYPE}")
MESSAGE(STATUS "")
IF(USE_32BIT_INTEGER)
  MESSAGE(STATUS "  Integer format ...................: 32 bits")
ELSE(USE_32BIT_INTEGER)
  MESSAGE(STATUS "  Integer format ...................: 16 bits")
ENDIF(USE_32BIT_INTEGER)
MESSAGE(STATUS "")
MESSAGE(STATUS "  Install prefix .................. : ${CMAKE_INSTALL_PREFIX}")
MESSAGE(STATUS "  C compiler ...................... : ${CMAKE_C_COMPILER}")
#MESSAGE(STATUS "  C++ compiler .................... : ${CMAKE_CXX_COMPILER}")
MESSAGE(STATUS "  Fortran compiler ................ : ${CMAKE_Fortran_COMPILER}")
MESSAGE(STATUS "  C compiler flags ................ : ${CMAKE_C_FLAGS}${cfsp}${CMAKE_C_FLAGS_${buildtype}}")
MESSAGE(STATUS "  C compiler SSE2 flag. ........... : ${CMAKE_C_SSE2_FLAGS}")
MESSAGE(STATUS "  C compiler SSE 4.1 flag.......... : ${CMAKE_C_SSE41_FLAGS}")
#MESSAGE(STATUS "  C++ compiler flags .............. : ${CMAKE_CXX_FLAGS}${cxxfsp}${CMAKE_CXX_FLAGS_${buildtype}}")
MESSAGE(STATUS "  Fortran compiler flags .......... : ${CMAKE_Fortran_FLAGS}${cfsp}${CMAKE_Fortran_FLAGS_${buildtype}}")
MESSAGE(STATUS "")
MESSAGE(STATUS "  Use file memory mapping ..........: ${USE_MMAP}")
MESSAGE(STATUS "  Use thread affinity setting ......: ${USE_AFFINITY}")
MESSAGE(STATUS "")
MESSAGE(STATUS "  Build shared libs ............... : ${BUILD_SHARED_LIBS}")
MESSAGE(STATUS "  Build static libs ............... : ${BUILD_STATIC_LIBS}")
MESSAGE(STATUS "  Build static executables......... : ${STANDALONE}")
MESSAGE(STATUS "")
IF(USE_PDF)
	IF(BUILD_hpdf)
		MESSAGE(STATUS "  Link with hpdf .................. : Internaly built")
	ELSE(BUILD_hpdf)
		MESSAGE(STATUS "  Link with hpdf .................. : ON" )
	ENDIF(BUILD_hpdf)
ENDIF(USE_PDF)

IF(USE_PCRE)
	IF(PCRE_FOUND)
	  MESSAGE(STATUS "  Link with pcre .................. : ${USE_PCRE}")
	ELSE(PCRE_FOUND)
		IF(BUILD_PCRE)
			MESSAGE(STATUS "  Link with pcre .................. : Internaly built" )
		ENDIF(BUILD_PCRE)
	ENDIF(PCRE_FOUND)
ENDIF(USE_PCRE)

IF(USE_HDF5)
	IF(HDF5_FOUND)
	  MESSAGE(STATUS "  Link with hdf5 .................. : ${USE_HDF5}")
	ELSE(HDF5_FOUND)
		IF(BUILD_HDF5)
			MESSAGE(STATUS "  Link with hdf5 .................. : Internaly built" )
		ENDIF(BUILD_HDF5)
	ENDIF(HDF5_FOUND)
ENDIF(USE_HDF5)

IF(USE_GRAPHICS)
	IF(PLplot_FOUND)
		IF(BUILD_PLplot)
			MESSAGE(STATUS "  Link with PLplot................. : Internaly built")
		ELSE(BUILD_PLplot)
			MESSAGE(STATUS "  Link with PLplot................. : ON")
		ENDIF(BUILD_PLplot)
	ELSE(PLplot_FOUND)
		MESSAGE(STATUS "  Link with PLplot................. : Library not found" )
	ENDIF(PLplot_FOUND)
	IF(USE_GD)
		IF(BUILD_GD)
			MESSAGE(STATUS "  Link with GD .................... : Internaly built")
		ELSE(BUILD_GD)
			MESSAGE(STATUS "  Link with GD .................... : ON")
		ENDIF(BUILD_GD)
	ENDIF(USE_GD)
ENDIF(USE_GRAPHICS)
MESSAGE(STATUS "")

IF(NOT USE_MMAP)
  MESSAGE(WARNING "!! File memory mapping is either not found in your system or you choose\n"
                  "!! to disable it. Be advised that this seriously impact performance.")
ENDIF(NOT USE_MMAP)
IF(NOT USE_AFFINITY)
  MESSAGE( "!! CPU thread affinity is disabled, hence performance penalty may apply on many-core architecture.")
ENDIF(NOT USE_AFFINITY)

endmacro(summary)
