/***********************************************************************************************************************************
Wait Handler
***********************************************************************************************************************************/
#ifndef COMMON_WAIT_H
#define COMMON_WAIT_H

/***********************************************************************************************************************************
Wait object
***********************************************************************************************************************************/
#define WAIT_TYPE                                                   Wait
#define WAIT_PREFIX                                                 wait

typedef struct Wait Wait;

#include "common/time.h"

/***********************************************************************************************************************************
Constructors
***********************************************************************************************************************************/
Wait *waitNew(TimeMSec waitTime);

/***********************************************************************************************************************************
Functions
***********************************************************************************************************************************/
// Wait and return whether the caller has more time left
bool waitMore(Wait *this);

/***********************************************************************************************************************************
Getters/Setters
***********************************************************************************************************************************/
// How much time is remaining? Recalculated each time waitMore() is called.
TimeMSec waitRemaining(const Wait *this);

/***********************************************************************************************************************************
Destructor
***********************************************************************************************************************************/
void waitFree(Wait *this);

/***********************************************************************************************************************************
Macros for function logging
***********************************************************************************************************************************/
#define FUNCTION_LOG_WAIT_TYPE                                                                                                     \
    Wait *
#define FUNCTION_LOG_WAIT_FORMAT(value, buffer, bufferSize)                                                                        \
    objToLog(value, "Wait", buffer, bufferSize)

#endif
