# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.appcontainers import ContainerAppsAPIClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-appcontainers
# USAGE
    python managed_environments_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerAppsAPIClient(
        credential=DefaultAzureCredential(),
        subscription_id="34adfa4f-cedf-4dc0-ba29-b6d1a69ab345",
    )

    response = client.managed_environments.begin_create_or_update(
        resource_group_name="examplerg",
        environment_name="testcontainerenv",
        environment_envelope={
            "kind": "serverless",
            "location": "East US",
            "properties": {
                "appLogsConfiguration": {"logAnalyticsConfiguration": {"customerId": "string", "sharedKey": "string"}},
                "customDomainConfiguration": {
                    "certificatePassword": "private key password",
                    "certificateValue": "Y2VydA==",
                    "dnsSuffix": "www.my-name.com",
                },
                "daprAIConnectionString": "InstrumentationKey=00000000-0000-0000-0000-000000000000;IngestionEndpoint=https://northcentralus-0.in.applicationinsights.azure.com/",
                "vnetConfiguration": {
                    "outboundSettings": {
                        "outBoundType": "UserDefinedRouting",
                        "virtualNetworkApplianceIp": "192.168.1.20",
                    }
                },
                "workloadProfiles": [
                    {"maximumCount": 12, "minimumCount": 3, "workloadProfileType": "GeneralPurpose"},
                    {"maximumCount": 6, "minimumCount": 3, "workloadProfileType": "MemoryOptimized"},
                    {"maximumCount": 6, "minimumCount": 3, "workloadProfileType": "ComputeOptimized"},
                ],
                "zoneRedundant": True,
            },
            "sku": {"name": "Premium"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/app/resource-manager/Microsoft.App/stable/2022-10-01/examples/ManagedEnvironments_CreateOrUpdate.json
if __name__ == "__main__":
    main()
