# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.sql import SqlManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-sql
# USAGE
    python create_database_with_encryption_protector_auto_rotation.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SqlManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-1111-2222-3333-444444444444",
    )

    response = client.databases.begin_create_or_update(
        resource_group_name="Default-SQL-SouthEastAsia",
        server_name="testsvr",
        database_name="testdb",
        parameters={
            "identity": {
                "type": "UserAssigned",
                "userAssignedIdentities": {
                    "/subscriptions/00000000-1111-2222-3333-444444444444/resourcegroups/Default-SQL-SouthEastAsia/providers/Microsoft.ManagedIdentity/userAssignedIdentities/umi": {}
                },
            },
            "location": "southeastasia",
            "properties": {
                "collation": "SQL_Latin1_General_CP1_CI_AS",
                "createMode": "Default",
                "encryptionProtector": "https://your-key-vault-name.vault.azure.net/yourKey/yourKeyVersion",
                "encryptionProtectorAutoRotation": True,
                "maxSizeBytes": 1073741824,
            },
            "sku": {"name": "S0", "tier": "Standard"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/sql/resource-manager/Microsoft.Sql/preview/2024-05-01-preview/examples/CreateDatabaseWithEncryptionProtectorAutoRotation.json
if __name__ == "__main__":
    main()
